/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of the model metadata.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelMetadataSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ModelMetadataSummary.Builder, ModelMetadataSummary> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Domain")
            .getter(getter(ModelMetadataSummary::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()).build();

    private static final SdkField<String> FRAMEWORK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Framework").getter(getter(ModelMetadataSummary::framework)).setter(setter(Builder::framework))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Framework").build()).build();

    private static final SdkField<String> TASK_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Task")
            .getter(getter(ModelMetadataSummary::task)).setter(setter(Builder::task))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Task").build()).build();

    private static final SdkField<String> MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Model")
            .getter(getter(ModelMetadataSummary::model)).setter(setter(Builder::model))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Model").build()).build();

    private static final SdkField<String> FRAMEWORK_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FrameworkVersion").getter(getter(ModelMetadataSummary::frameworkVersion))
            .setter(setter(Builder::frameworkVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameworkVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD, FRAMEWORK_FIELD,
            TASK_FIELD, MODEL_FIELD, FRAMEWORK_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String domain;

    private final String framework;

    private final String task;

    private final String model;

    private final String frameworkVersion;

    private ModelMetadataSummary(BuilderImpl builder) {
        this.domain = builder.domain;
        this.framework = builder.framework;
        this.task = builder.task;
        this.model = builder.model;
        this.frameworkVersion = builder.frameworkVersion;
    }

    /**
     * <p>
     * The machine learning domain of the model.
     * </p>
     * 
     * @return The machine learning domain of the model.
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * The machine learning framework of the model.
     * </p>
     * 
     * @return The machine learning framework of the model.
     */
    public final String framework() {
        return framework;
    }

    /**
     * <p>
     * The machine learning task of the model.
     * </p>
     * 
     * @return The machine learning task of the model.
     */
    public final String task() {
        return task;
    }

    /**
     * <p>
     * The name of the model.
     * </p>
     * 
     * @return The name of the model.
     */
    public final String model() {
        return model;
    }

    /**
     * <p>
     * The framework version of the model.
     * </p>
     * 
     * @return The framework version of the model.
     */
    public final String frameworkVersion() {
        return frameworkVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(framework());
        hashCode = 31 * hashCode + Objects.hashCode(task());
        hashCode = 31 * hashCode + Objects.hashCode(model());
        hashCode = 31 * hashCode + Objects.hashCode(frameworkVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelMetadataSummary)) {
            return false;
        }
        ModelMetadataSummary other = (ModelMetadataSummary) obj;
        return Objects.equals(domain(), other.domain()) && Objects.equals(framework(), other.framework())
                && Objects.equals(task(), other.task()) && Objects.equals(model(), other.model())
                && Objects.equals(frameworkVersion(), other.frameworkVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModelMetadataSummary").add("Domain", domain()).add("Framework", framework()).add("Task", task())
                .add("Model", model()).add("FrameworkVersion", frameworkVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "Framework":
            return Optional.ofNullable(clazz.cast(framework()));
        case "Task":
            return Optional.ofNullable(clazz.cast(task()));
        case "Model":
            return Optional.ofNullable(clazz.cast(model()));
        case "FrameworkVersion":
            return Optional.ofNullable(clazz.cast(frameworkVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Domain", DOMAIN_FIELD);
        map.put("Framework", FRAMEWORK_FIELD);
        map.put("Task", TASK_FIELD);
        map.put("Model", MODEL_FIELD);
        map.put("FrameworkVersion", FRAMEWORK_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModelMetadataSummary, T> g) {
        return obj -> g.apply((ModelMetadataSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelMetadataSummary> {
        /**
         * <p>
         * The machine learning domain of the model.
         * </p>
         * 
         * @param domain
         *        The machine learning domain of the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The machine learning framework of the model.
         * </p>
         * 
         * @param framework
         *        The machine learning framework of the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder framework(String framework);

        /**
         * <p>
         * The machine learning task of the model.
         * </p>
         * 
         * @param task
         *        The machine learning task of the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder task(String task);

        /**
         * <p>
         * The name of the model.
         * </p>
         * 
         * @param model
         *        The name of the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder model(String model);

        /**
         * <p>
         * The framework version of the model.
         * </p>
         * 
         * @param frameworkVersion
         *        The framework version of the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameworkVersion(String frameworkVersion);
    }

    static final class BuilderImpl implements Builder {
        private String domain;

        private String framework;

        private String task;

        private String model;

        private String frameworkVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelMetadataSummary model) {
            domain(model.domain);
            framework(model.framework);
            task(model.task);
            model(model.model);
            frameworkVersion(model.frameworkVersion);
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getFramework() {
            return framework;
        }

        public final void setFramework(String framework) {
            this.framework = framework;
        }

        @Override
        public final Builder framework(String framework) {
            this.framework = framework;
            return this;
        }

        public final String getTask() {
            return task;
        }

        public final void setTask(String task) {
            this.task = task;
        }

        @Override
        public final Builder task(String task) {
            this.task = task;
            return this;
        }

        public final String getModel() {
            return model;
        }

        public final void setModel(String model) {
            this.model = model;
        }

        @Override
        public final Builder model(String model) {
            this.model = model;
            return this;
        }

        public final String getFrameworkVersion() {
            return frameworkVersion;
        }

        public final void setFrameworkVersion(String frameworkVersion) {
            this.frameworkVersion = frameworkVersion;
        }

        @Override
        public final Builder frameworkVersion(String frameworkVersion) {
            this.frameworkVersion = frameworkVersion;
            return this;
        }

        @Override
        public ModelMetadataSummary build() {
            return new ModelMetadataSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
