/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies additional configuration for hosting multi-model endpoints.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MultiModelConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<MultiModelConfig.Builder, MultiModelConfig> {
    private static final SdkField<String> MODEL_CACHE_SETTING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelCacheSetting").getter(getter(MultiModelConfig::modelCacheSettingAsString))
            .setter(setter(Builder::modelCacheSetting))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCacheSetting").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_CACHE_SETTING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String modelCacheSetting;

    private MultiModelConfig(BuilderImpl builder) {
        this.modelCacheSetting = builder.modelCacheSetting;
    }

    /**
     * <p>
     * Whether to cache models for a multi-model endpoint. By default, multi-model endpoints cache models so that a
     * model does not have to be loaded into memory each time it is invoked. Some use cases do not benefit from model
     * caching. For example, if an endpoint hosts a large number of models that are each invoked infrequently, the
     * endpoint might perform better if you disable model caching. To disable model caching, set the value of this
     * parameter to <code>Disabled</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modelCacheSetting}
     * will return {@link ModelCacheSetting#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #modelCacheSettingAsString}.
     * </p>
     * 
     * @return Whether to cache models for a multi-model endpoint. By default, multi-model endpoints cache models so
     *         that a model does not have to be loaded into memory each time it is invoked. Some use cases do not
     *         benefit from model caching. For example, if an endpoint hosts a large number of models that are each
     *         invoked infrequently, the endpoint might perform better if you disable model caching. To disable model
     *         caching, set the value of this parameter to <code>Disabled</code>.
     * @see ModelCacheSetting
     */
    public final ModelCacheSetting modelCacheSetting() {
        return ModelCacheSetting.fromValue(modelCacheSetting);
    }

    /**
     * <p>
     * Whether to cache models for a multi-model endpoint. By default, multi-model endpoints cache models so that a
     * model does not have to be loaded into memory each time it is invoked. Some use cases do not benefit from model
     * caching. For example, if an endpoint hosts a large number of models that are each invoked infrequently, the
     * endpoint might perform better if you disable model caching. To disable model caching, set the value of this
     * parameter to <code>Disabled</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modelCacheSetting}
     * will return {@link ModelCacheSetting#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #modelCacheSettingAsString}.
     * </p>
     * 
     * @return Whether to cache models for a multi-model endpoint. By default, multi-model endpoints cache models so
     *         that a model does not have to be loaded into memory each time it is invoked. Some use cases do not
     *         benefit from model caching. For example, if an endpoint hosts a large number of models that are each
     *         invoked infrequently, the endpoint might perform better if you disable model caching. To disable model
     *         caching, set the value of this parameter to <code>Disabled</code>.
     * @see ModelCacheSetting
     */
    public final String modelCacheSettingAsString() {
        return modelCacheSetting;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modelCacheSettingAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultiModelConfig)) {
            return false;
        }
        MultiModelConfig other = (MultiModelConfig) obj;
        return Objects.equals(modelCacheSettingAsString(), other.modelCacheSettingAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MultiModelConfig").add("ModelCacheSetting", modelCacheSettingAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelCacheSetting":
            return Optional.ofNullable(clazz.cast(modelCacheSettingAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ModelCacheSetting", MODEL_CACHE_SETTING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MultiModelConfig, T> g) {
        return obj -> g.apply((MultiModelConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MultiModelConfig> {
        /**
         * <p>
         * Whether to cache models for a multi-model endpoint. By default, multi-model endpoints cache models so that a
         * model does not have to be loaded into memory each time it is invoked. Some use cases do not benefit from
         * model caching. For example, if an endpoint hosts a large number of models that are each invoked infrequently,
         * the endpoint might perform better if you disable model caching. To disable model caching, set the value of
         * this parameter to <code>Disabled</code>.
         * </p>
         * 
         * @param modelCacheSetting
         *        Whether to cache models for a multi-model endpoint. By default, multi-model endpoints cache models so
         *        that a model does not have to be loaded into memory each time it is invoked. Some use cases do not
         *        benefit from model caching. For example, if an endpoint hosts a large number of models that are each
         *        invoked infrequently, the endpoint might perform better if you disable model caching. To disable model
         *        caching, set the value of this parameter to <code>Disabled</code>.
         * @see ModelCacheSetting
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelCacheSetting
         */
        Builder modelCacheSetting(String modelCacheSetting);

        /**
         * <p>
         * Whether to cache models for a multi-model endpoint. By default, multi-model endpoints cache models so that a
         * model does not have to be loaded into memory each time it is invoked. Some use cases do not benefit from
         * model caching. For example, if an endpoint hosts a large number of models that are each invoked infrequently,
         * the endpoint might perform better if you disable model caching. To disable model caching, set the value of
         * this parameter to <code>Disabled</code>.
         * </p>
         * 
         * @param modelCacheSetting
         *        Whether to cache models for a multi-model endpoint. By default, multi-model endpoints cache models so
         *        that a model does not have to be loaded into memory each time it is invoked. Some use cases do not
         *        benefit from model caching. For example, if an endpoint hosts a large number of models that are each
         *        invoked infrequently, the endpoint might perform better if you disable model caching. To disable model
         *        caching, set the value of this parameter to <code>Disabled</code>.
         * @see ModelCacheSetting
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelCacheSetting
         */
        Builder modelCacheSetting(ModelCacheSetting modelCacheSetting);
    }

    static final class BuilderImpl implements Builder {
        private String modelCacheSetting;

        private BuilderImpl() {
        }

        private BuilderImpl(MultiModelConfig model) {
            modelCacheSetting(model.modelCacheSetting);
        }

        public final String getModelCacheSetting() {
            return modelCacheSetting;
        }

        public final void setModelCacheSetting(String modelCacheSetting) {
            this.modelCacheSetting = modelCacheSetting;
        }

        @Override
        public final Builder modelCacheSetting(String modelCacheSetting) {
            this.modelCacheSetting = modelCacheSetting;
            return this;
        }

        @Override
        public final Builder modelCacheSetting(ModelCacheSetting modelCacheSetting) {
            this.modelCacheSetting(modelCacheSetting == null ? null : modelCacheSetting.toString());
            return this;
        }

        @Override
        public MultiModelConfig build() {
            return new MultiModelConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
