/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A collection of settings that configure user interaction with the <code>RStudioServerPro</code> app.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RStudioServerProAppSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<RStudioServerProAppSettings.Builder, RStudioServerProAppSettings> {
    private static final SdkField<String> ACCESS_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessStatus").getter(getter(RStudioServerProAppSettings::accessStatusAsString))
            .setter(setter(Builder::accessStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessStatus").build()).build();

    private static final SdkField<String> USER_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserGroup").getter(getter(RStudioServerProAppSettings::userGroupAsString))
            .setter(setter(Builder::userGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserGroup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_STATUS_FIELD,
            USER_GROUP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String accessStatus;

    private final String userGroup;

    private RStudioServerProAppSettings(BuilderImpl builder) {
        this.accessStatus = builder.accessStatus;
        this.userGroup = builder.userGroup;
    }

    /**
     * <p>
     * Indicates whether the current user has access to the <code>RStudioServerPro</code> app.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accessStatus} will
     * return {@link RStudioServerProAccessStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #accessStatusAsString}.
     * </p>
     * 
     * @return Indicates whether the current user has access to the <code>RStudioServerPro</code> app.
     * @see RStudioServerProAccessStatus
     */
    public final RStudioServerProAccessStatus accessStatus() {
        return RStudioServerProAccessStatus.fromValue(accessStatus);
    }

    /**
     * <p>
     * Indicates whether the current user has access to the <code>RStudioServerPro</code> app.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accessStatus} will
     * return {@link RStudioServerProAccessStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #accessStatusAsString}.
     * </p>
     * 
     * @return Indicates whether the current user has access to the <code>RStudioServerPro</code> app.
     * @see RStudioServerProAccessStatus
     */
    public final String accessStatusAsString() {
        return accessStatus;
    }

    /**
     * <p>
     * The level of permissions that the user has within the <code>RStudioServerPro</code> app. This value defaults to
     * `User`. The `Admin` value allows the user access to the RStudio Administrative Dashboard.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #userGroup} will
     * return {@link RStudioServerProUserGroup#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #userGroupAsString}.
     * </p>
     * 
     * @return The level of permissions that the user has within the <code>RStudioServerPro</code> app. This value
     *         defaults to `User`. The `Admin` value allows the user access to the RStudio Administrative Dashboard.
     * @see RStudioServerProUserGroup
     */
    public final RStudioServerProUserGroup userGroup() {
        return RStudioServerProUserGroup.fromValue(userGroup);
    }

    /**
     * <p>
     * The level of permissions that the user has within the <code>RStudioServerPro</code> app. This value defaults to
     * `User`. The `Admin` value allows the user access to the RStudio Administrative Dashboard.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #userGroup} will
     * return {@link RStudioServerProUserGroup#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #userGroupAsString}.
     * </p>
     * 
     * @return The level of permissions that the user has within the <code>RStudioServerPro</code> app. This value
     *         defaults to `User`. The `Admin` value allows the user access to the RStudio Administrative Dashboard.
     * @see RStudioServerProUserGroup
     */
    public final String userGroupAsString() {
        return userGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(userGroupAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RStudioServerProAppSettings)) {
            return false;
        }
        RStudioServerProAppSettings other = (RStudioServerProAppSettings) obj;
        return Objects.equals(accessStatusAsString(), other.accessStatusAsString())
                && Objects.equals(userGroupAsString(), other.userGroupAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RStudioServerProAppSettings").add("AccessStatus", accessStatusAsString())
                .add("UserGroup", userGroupAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessStatus":
            return Optional.ofNullable(clazz.cast(accessStatusAsString()));
        case "UserGroup":
            return Optional.ofNullable(clazz.cast(userGroupAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AccessStatus", ACCESS_STATUS_FIELD);
        map.put("UserGroup", USER_GROUP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RStudioServerProAppSettings, T> g) {
        return obj -> g.apply((RStudioServerProAppSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RStudioServerProAppSettings> {
        /**
         * <p>
         * Indicates whether the current user has access to the <code>RStudioServerPro</code> app.
         * </p>
         * 
         * @param accessStatus
         *        Indicates whether the current user has access to the <code>RStudioServerPro</code> app.
         * @see RStudioServerProAccessStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RStudioServerProAccessStatus
         */
        Builder accessStatus(String accessStatus);

        /**
         * <p>
         * Indicates whether the current user has access to the <code>RStudioServerPro</code> app.
         * </p>
         * 
         * @param accessStatus
         *        Indicates whether the current user has access to the <code>RStudioServerPro</code> app.
         * @see RStudioServerProAccessStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RStudioServerProAccessStatus
         */
        Builder accessStatus(RStudioServerProAccessStatus accessStatus);

        /**
         * <p>
         * The level of permissions that the user has within the <code>RStudioServerPro</code> app. This value defaults
         * to `User`. The `Admin` value allows the user access to the RStudio Administrative Dashboard.
         * </p>
         * 
         * @param userGroup
         *        The level of permissions that the user has within the <code>RStudioServerPro</code> app. This value
         *        defaults to `User`. The `Admin` value allows the user access to the RStudio Administrative Dashboard.
         * @see RStudioServerProUserGroup
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RStudioServerProUserGroup
         */
        Builder userGroup(String userGroup);

        /**
         * <p>
         * The level of permissions that the user has within the <code>RStudioServerPro</code> app. This value defaults
         * to `User`. The `Admin` value allows the user access to the RStudio Administrative Dashboard.
         * </p>
         * 
         * @param userGroup
         *        The level of permissions that the user has within the <code>RStudioServerPro</code> app. This value
         *        defaults to `User`. The `Admin` value allows the user access to the RStudio Administrative Dashboard.
         * @see RStudioServerProUserGroup
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RStudioServerProUserGroup
         */
        Builder userGroup(RStudioServerProUserGroup userGroup);
    }

    static final class BuilderImpl implements Builder {
        private String accessStatus;

        private String userGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(RStudioServerProAppSettings model) {
            accessStatus(model.accessStatus);
            userGroup(model.userGroup);
        }

        public final String getAccessStatus() {
            return accessStatus;
        }

        public final void setAccessStatus(String accessStatus) {
            this.accessStatus = accessStatus;
        }

        @Override
        public final Builder accessStatus(String accessStatus) {
            this.accessStatus = accessStatus;
            return this;
        }

        @Override
        public final Builder accessStatus(RStudioServerProAccessStatus accessStatus) {
            this.accessStatus(accessStatus == null ? null : accessStatus.toString());
            return this;
        }

        public final String getUserGroup() {
            return userGroup;
        }

        public final void setUserGroup(String userGroup) {
            this.userGroup = userGroup;
        }

        @Override
        public final Builder userGroup(String userGroup) {
            this.userGroup = userGroup;
            return this;
        }

        @Override
        public final Builder userGroup(RStudioServerProUserGroup userGroup) {
            this.userGroup(userGroup == null ? null : userGroup.toString());
            return this;
        }

        @Override
        public RStudioServerProAppSettings build() {
            return new RStudioServerProAppSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
