/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of IP address ranges (<a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">CIDRs</a>).
 * Used to create an allow list of IP addresses for a private workforce. Workers will only be able to log in to their
 * worker portal from an IP address within this range. By default, a workforce isn't restricted to specific IP
 * addresses.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceIpConfig implements SdkPojo, Serializable, ToCopyableBuilder<SourceIpConfig.Builder, SourceIpConfig> {
    private static final SdkField<List<String>> CIDRS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Cidrs")
            .getter(getter(SourceIpConfig::cidrs))
            .setter(setter(Builder::cidrs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cidrs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDRS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> cidrs;

    private SourceIpConfig(BuilderImpl builder) {
        this.cidrs = builder.cidrs;
    }

    /**
     * For responses, this returns true if the service returned a value for the Cidrs property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasCidrs() {
        return cidrs != null && !(cidrs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of one to ten <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">Classless
     * Inter-Domain Routing</a> (CIDR) values.
     * </p>
     * <p>
     * Maximum: Ten CIDR values
     * </p>
     * <note>
     * <p>
     * The following Length Constraints apply to individual CIDR values in the CIDR value list.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCidrs} method.
     * </p>
     * 
     * @return A list of one to ten <a
     *         href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">Classless Inter-Domain
     *         Routing</a> (CIDR) values.</p>
     *         <p>
     *         Maximum: Ten CIDR values
     *         </p>
     *         <note>
     *         <p>
     *         The following Length Constraints apply to individual CIDR values in the CIDR value list.
     *         </p>
     */
    public final List<String> cidrs() {
        return cidrs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCidrs() ? cidrs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceIpConfig)) {
            return false;
        }
        SourceIpConfig other = (SourceIpConfig) obj;
        return hasCidrs() == other.hasCidrs() && Objects.equals(cidrs(), other.cidrs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SourceIpConfig").add("Cidrs", hasCidrs() ? cidrs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Cidrs":
            return Optional.ofNullable(clazz.cast(cidrs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Cidrs", CIDRS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SourceIpConfig, T> g) {
        return obj -> g.apply((SourceIpConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceIpConfig> {
        /**
         * <p>
         * A list of one to ten <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">Classless
         * Inter-Domain Routing</a> (CIDR) values.
         * </p>
         * <p>
         * Maximum: Ten CIDR values
         * </p>
         * <note>
         * <p>
         * The following Length Constraints apply to individual CIDR values in the CIDR value list.
         * </p>
         * </note>
         * 
         * @param cidrs
         *        A list of one to ten <a
         *        href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">Classless Inter-Domain
         *        Routing</a> (CIDR) values.</p>
         *        <p>
         *        Maximum: Ten CIDR values
         *        </p>
         *        <note>
         *        <p>
         *        The following Length Constraints apply to individual CIDR values in the CIDR value list.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrs(Collection<String> cidrs);

        /**
         * <p>
         * A list of one to ten <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">Classless
         * Inter-Domain Routing</a> (CIDR) values.
         * </p>
         * <p>
         * Maximum: Ten CIDR values
         * </p>
         * <note>
         * <p>
         * The following Length Constraints apply to individual CIDR values in the CIDR value list.
         * </p>
         * </note>
         * 
         * @param cidrs
         *        A list of one to ten <a
         *        href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">Classless Inter-Domain
         *        Routing</a> (CIDR) values.</p>
         *        <p>
         *        Maximum: Ten CIDR values
         *        </p>
         *        <note>
         *        <p>
         *        The following Length Constraints apply to individual CIDR values in the CIDR value list.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrs(String... cidrs);
    }

    static final class BuilderImpl implements Builder {
        private List<String> cidrs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SourceIpConfig model) {
            cidrs(model.cidrs);
        }

        public final Collection<String> getCidrs() {
            if (cidrs instanceof SdkAutoConstructList) {
                return null;
            }
            return cidrs;
        }

        public final void setCidrs(Collection<String> cidrs) {
            this.cidrs = CidrsCopier.copy(cidrs);
        }

        @Override
        public final Builder cidrs(Collection<String> cidrs) {
            this.cidrs = CidrsCopier.copy(cidrs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrs(String... cidrs) {
            cidrs(Arrays.asList(cidrs));
            return this;
        }

        @Override
        public SourceIpConfig build() {
            return new SourceIpConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
