/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The space's details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SpaceDetails implements SdkPojo, Serializable, ToCopyableBuilder<SpaceDetails.Builder, SpaceDetails> {
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainId").getter(getter(SpaceDetails::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()).build();

    private static final SdkField<String> SPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SpaceName").getter(getter(SpaceDetails::spaceName)).setter(setter(Builder::spaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpaceName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(SpaceDetails::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(SpaceDetails::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(SpaceDetails::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<SpaceSettingsSummary> SPACE_SETTINGS_SUMMARY_FIELD = SdkField
            .<SpaceSettingsSummary> builder(MarshallingType.SDK_POJO).memberName("SpaceSettingsSummary")
            .getter(getter(SpaceDetails::spaceSettingsSummary)).setter(setter(Builder::spaceSettingsSummary))
            .constructor(SpaceSettingsSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpaceSettingsSummary").build())
            .build();

    private static final SdkField<SpaceSharingSettingsSummary> SPACE_SHARING_SETTINGS_SUMMARY_FIELD = SdkField
            .<SpaceSharingSettingsSummary> builder(MarshallingType.SDK_POJO)
            .memberName("SpaceSharingSettingsSummary")
            .getter(getter(SpaceDetails::spaceSharingSettingsSummary))
            .setter(setter(Builder::spaceSharingSettingsSummary))
            .constructor(SpaceSharingSettingsSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpaceSharingSettingsSummary")
                    .build()).build();

    private static final SdkField<OwnershipSettingsSummary> OWNERSHIP_SETTINGS_SUMMARY_FIELD = SdkField
            .<OwnershipSettingsSummary> builder(MarshallingType.SDK_POJO).memberName("OwnershipSettingsSummary")
            .getter(getter(SpaceDetails::ownershipSettingsSummary)).setter(setter(Builder::ownershipSettingsSummary))
            .constructor(OwnershipSettingsSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnershipSettingsSummary").build())
            .build();

    private static final SdkField<String> SPACE_DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SpaceDisplayName").getter(getter(SpaceDetails::spaceDisplayName))
            .setter(setter(Builder::spaceDisplayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpaceDisplayName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ID_FIELD,
            SPACE_NAME_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, SPACE_SETTINGS_SUMMARY_FIELD,
            SPACE_SHARING_SETTINGS_SUMMARY_FIELD, OWNERSHIP_SETTINGS_SUMMARY_FIELD, SPACE_DISPLAY_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String domainId;

    private final String spaceName;

    private final String status;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private final SpaceSettingsSummary spaceSettingsSummary;

    private final SpaceSharingSettingsSummary spaceSharingSettingsSummary;

    private final OwnershipSettingsSummary ownershipSettingsSummary;

    private final String spaceDisplayName;

    private SpaceDetails(BuilderImpl builder) {
        this.domainId = builder.domainId;
        this.spaceName = builder.spaceName;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.spaceSettingsSummary = builder.spaceSettingsSummary;
        this.spaceSharingSettingsSummary = builder.spaceSharingSettingsSummary;
        this.ownershipSettingsSummary = builder.ownershipSettingsSummary;
        this.spaceDisplayName = builder.spaceDisplayName;
    }

    /**
     * <p>
     * The ID of the associated domain.
     * </p>
     * 
     * @return The ID of the associated domain.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The name of the space.
     * </p>
     * 
     * @return The name of the space.
     */
    public final String spaceName() {
        return spaceName;
    }

    /**
     * <p>
     * The status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SpaceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status.
     * @see SpaceStatus
     */
    public final SpaceStatus status() {
        return SpaceStatus.fromValue(status);
    }

    /**
     * <p>
     * The status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SpaceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status.
     * @see SpaceStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The creation time.
     * </p>
     * 
     * @return The creation time.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The last modified time.
     * </p>
     * 
     * @return The last modified time.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * Specifies summary information about the space settings.
     * </p>
     * 
     * @return Specifies summary information about the space settings.
     */
    public final SpaceSettingsSummary spaceSettingsSummary() {
        return spaceSettingsSummary;
    }

    /**
     * <p>
     * Specifies summary information about the space sharing settings.
     * </p>
     * 
     * @return Specifies summary information about the space sharing settings.
     */
    public final SpaceSharingSettingsSummary spaceSharingSettingsSummary() {
        return spaceSharingSettingsSummary;
    }

    /**
     * <p>
     * Specifies summary information about the ownership settings.
     * </p>
     * 
     * @return Specifies summary information about the ownership settings.
     */
    public final OwnershipSettingsSummary ownershipSettingsSummary() {
        return ownershipSettingsSummary;
    }

    /**
     * <p>
     * The name of the space that appears in the Studio UI.
     * </p>
     * 
     * @return The name of the space that appears in the Studio UI.
     */
    public final String spaceDisplayName() {
        return spaceDisplayName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(spaceName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(spaceSettingsSummary());
        hashCode = 31 * hashCode + Objects.hashCode(spaceSharingSettingsSummary());
        hashCode = 31 * hashCode + Objects.hashCode(ownershipSettingsSummary());
        hashCode = 31 * hashCode + Objects.hashCode(spaceDisplayName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpaceDetails)) {
            return false;
        }
        SpaceDetails other = (SpaceDetails) obj;
        return Objects.equals(domainId(), other.domainId()) && Objects.equals(spaceName(), other.spaceName())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(spaceSettingsSummary(), other.spaceSettingsSummary())
                && Objects.equals(spaceSharingSettingsSummary(), other.spaceSharingSettingsSummary())
                && Objects.equals(ownershipSettingsSummary(), other.ownershipSettingsSummary())
                && Objects.equals(spaceDisplayName(), other.spaceDisplayName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SpaceDetails").add("DomainId", domainId()).add("SpaceName", spaceName())
                .add("Status", statusAsString()).add("CreationTime", creationTime()).add("LastModifiedTime", lastModifiedTime())
                .add("SpaceSettingsSummary", spaceSettingsSummary())
                .add("SpaceSharingSettingsSummary", spaceSharingSettingsSummary())
                .add("OwnershipSettingsSummary", ownershipSettingsSummary()).add("SpaceDisplayName", spaceDisplayName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "SpaceName":
            return Optional.ofNullable(clazz.cast(spaceName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "SpaceSettingsSummary":
            return Optional.ofNullable(clazz.cast(spaceSettingsSummary()));
        case "SpaceSharingSettingsSummary":
            return Optional.ofNullable(clazz.cast(spaceSharingSettingsSummary()));
        case "OwnershipSettingsSummary":
            return Optional.ofNullable(clazz.cast(ownershipSettingsSummary()));
        case "SpaceDisplayName":
            return Optional.ofNullable(clazz.cast(spaceDisplayName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DomainId", DOMAIN_ID_FIELD);
        map.put("SpaceName", SPACE_NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("SpaceSettingsSummary", SPACE_SETTINGS_SUMMARY_FIELD);
        map.put("SpaceSharingSettingsSummary", SPACE_SHARING_SETTINGS_SUMMARY_FIELD);
        map.put("OwnershipSettingsSummary", OWNERSHIP_SETTINGS_SUMMARY_FIELD);
        map.put("SpaceDisplayName", SPACE_DISPLAY_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SpaceDetails, T> g) {
        return obj -> g.apply((SpaceDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SpaceDetails> {
        /**
         * <p>
         * The ID of the associated domain.
         * </p>
         * 
         * @param domainId
         *        The ID of the associated domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The name of the space.
         * </p>
         * 
         * @param spaceName
         *        The name of the space.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spaceName(String spaceName);

        /**
         * <p>
         * The status.
         * </p>
         * 
         * @param status
         *        The status.
         * @see SpaceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SpaceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status.
         * </p>
         * 
         * @param status
         *        The status.
         * @see SpaceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SpaceStatus
         */
        Builder status(SpaceStatus status);

        /**
         * <p>
         * The creation time.
         * </p>
         * 
         * @param creationTime
         *        The creation time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The last modified time.
         * </p>
         * 
         * @param lastModifiedTime
         *        The last modified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * Specifies summary information about the space settings.
         * </p>
         * 
         * @param spaceSettingsSummary
         *        Specifies summary information about the space settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spaceSettingsSummary(SpaceSettingsSummary spaceSettingsSummary);

        /**
         * <p>
         * Specifies summary information about the space settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link SpaceSettingsSummary.Builder} avoiding
         * the need to create one manually via {@link SpaceSettingsSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SpaceSettingsSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #spaceSettingsSummary(SpaceSettingsSummary)}.
         * 
         * @param spaceSettingsSummary
         *        a consumer that will call methods on {@link SpaceSettingsSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spaceSettingsSummary(SpaceSettingsSummary)
         */
        default Builder spaceSettingsSummary(Consumer<SpaceSettingsSummary.Builder> spaceSettingsSummary) {
            return spaceSettingsSummary(SpaceSettingsSummary.builder().applyMutation(spaceSettingsSummary).build());
        }

        /**
         * <p>
         * Specifies summary information about the space sharing settings.
         * </p>
         * 
         * @param spaceSharingSettingsSummary
         *        Specifies summary information about the space sharing settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spaceSharingSettingsSummary(SpaceSharingSettingsSummary spaceSharingSettingsSummary);

        /**
         * <p>
         * Specifies summary information about the space sharing settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link SpaceSharingSettingsSummary.Builder}
         * avoiding the need to create one manually via {@link SpaceSharingSettingsSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SpaceSharingSettingsSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #spaceSharingSettingsSummary(SpaceSharingSettingsSummary)}.
         * 
         * @param spaceSharingSettingsSummary
         *        a consumer that will call methods on {@link SpaceSharingSettingsSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spaceSharingSettingsSummary(SpaceSharingSettingsSummary)
         */
        default Builder spaceSharingSettingsSummary(Consumer<SpaceSharingSettingsSummary.Builder> spaceSharingSettingsSummary) {
            return spaceSharingSettingsSummary(SpaceSharingSettingsSummary.builder().applyMutation(spaceSharingSettingsSummary)
                    .build());
        }

        /**
         * <p>
         * Specifies summary information about the ownership settings.
         * </p>
         * 
         * @param ownershipSettingsSummary
         *        Specifies summary information about the ownership settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownershipSettingsSummary(OwnershipSettingsSummary ownershipSettingsSummary);

        /**
         * <p>
         * Specifies summary information about the ownership settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link OwnershipSettingsSummary.Builder}
         * avoiding the need to create one manually via {@link OwnershipSettingsSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OwnershipSettingsSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #ownershipSettingsSummary(OwnershipSettingsSummary)}.
         * 
         * @param ownershipSettingsSummary
         *        a consumer that will call methods on {@link OwnershipSettingsSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ownershipSettingsSummary(OwnershipSettingsSummary)
         */
        default Builder ownershipSettingsSummary(Consumer<OwnershipSettingsSummary.Builder> ownershipSettingsSummary) {
            return ownershipSettingsSummary(OwnershipSettingsSummary.builder().applyMutation(ownershipSettingsSummary).build());
        }

        /**
         * <p>
         * The name of the space that appears in the Studio UI.
         * </p>
         * 
         * @param spaceDisplayName
         *        The name of the space that appears in the Studio UI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spaceDisplayName(String spaceDisplayName);
    }

    static final class BuilderImpl implements Builder {
        private String domainId;

        private String spaceName;

        private String status;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private SpaceSettingsSummary spaceSettingsSummary;

        private SpaceSharingSettingsSummary spaceSharingSettingsSummary;

        private OwnershipSettingsSummary ownershipSettingsSummary;

        private String spaceDisplayName;

        private BuilderImpl() {
        }

        private BuilderImpl(SpaceDetails model) {
            domainId(model.domainId);
            spaceName(model.spaceName);
            status(model.status);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
            spaceSettingsSummary(model.spaceSettingsSummary);
            spaceSharingSettingsSummary(model.spaceSharingSettingsSummary);
            ownershipSettingsSummary(model.ownershipSettingsSummary);
            spaceDisplayName(model.spaceDisplayName);
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getSpaceName() {
            return spaceName;
        }

        public final void setSpaceName(String spaceName) {
            this.spaceName = spaceName;
        }

        @Override
        public final Builder spaceName(String spaceName) {
            this.spaceName = spaceName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SpaceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final SpaceSettingsSummary.Builder getSpaceSettingsSummary() {
            return spaceSettingsSummary != null ? spaceSettingsSummary.toBuilder() : null;
        }

        public final void setSpaceSettingsSummary(SpaceSettingsSummary.BuilderImpl spaceSettingsSummary) {
            this.spaceSettingsSummary = spaceSettingsSummary != null ? spaceSettingsSummary.build() : null;
        }

        @Override
        public final Builder spaceSettingsSummary(SpaceSettingsSummary spaceSettingsSummary) {
            this.spaceSettingsSummary = spaceSettingsSummary;
            return this;
        }

        public final SpaceSharingSettingsSummary.Builder getSpaceSharingSettingsSummary() {
            return spaceSharingSettingsSummary != null ? spaceSharingSettingsSummary.toBuilder() : null;
        }

        public final void setSpaceSharingSettingsSummary(SpaceSharingSettingsSummary.BuilderImpl spaceSharingSettingsSummary) {
            this.spaceSharingSettingsSummary = spaceSharingSettingsSummary != null ? spaceSharingSettingsSummary.build() : null;
        }

        @Override
        public final Builder spaceSharingSettingsSummary(SpaceSharingSettingsSummary spaceSharingSettingsSummary) {
            this.spaceSharingSettingsSummary = spaceSharingSettingsSummary;
            return this;
        }

        public final OwnershipSettingsSummary.Builder getOwnershipSettingsSummary() {
            return ownershipSettingsSummary != null ? ownershipSettingsSummary.toBuilder() : null;
        }

        public final void setOwnershipSettingsSummary(OwnershipSettingsSummary.BuilderImpl ownershipSettingsSummary) {
            this.ownershipSettingsSummary = ownershipSettingsSummary != null ? ownershipSettingsSummary.build() : null;
        }

        @Override
        public final Builder ownershipSettingsSummary(OwnershipSettingsSummary ownershipSettingsSummary) {
            this.ownershipSettingsSummary = ownershipSettingsSummary;
            return this;
        }

        public final String getSpaceDisplayName() {
            return spaceDisplayName;
        }

        public final void setSpaceDisplayName(String spaceDisplayName) {
            this.spaceDisplayName = spaceDisplayName;
        }

        @Override
        public final Builder spaceDisplayName(String spaceDisplayName) {
            this.spaceDisplayName = spaceDisplayName;
            return this;
        }

        @Override
        public SpaceDetails build() {
            return new SpaceDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
