/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a summary of a transform job. Multiple <code>TransformJobSummary</code> objects are returned as a list after
 * in response to a <a
 * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListTransformJobs.html">ListTransformJobs</a>
 * call.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransformJobSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<TransformJobSummary.Builder, TransformJobSummary> {
    private static final SdkField<String> TRANSFORM_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TransformJobName").getter(getter(TransformJobSummary::transformJobName))
            .setter(setter(Builder::transformJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformJobName").build()).build();

    private static final SdkField<String> TRANSFORM_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TransformJobArn").getter(getter(TransformJobSummary::transformJobArn))
            .setter(setter(Builder::transformJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformJobArn").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(TransformJobSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> TRANSFORM_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("TransformEndTime").getter(getter(TransformJobSummary::transformEndTime))
            .setter(setter(Builder::transformEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformEndTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(TransformJobSummary::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> TRANSFORM_JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TransformJobStatus").getter(getter(TransformJobSummary::transformJobStatusAsString))
            .setter(setter(Builder::transformJobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformJobStatus").build())
            .build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(TransformJobSummary::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSFORM_JOB_NAME_FIELD,
            TRANSFORM_JOB_ARN_FIELD, CREATION_TIME_FIELD, TRANSFORM_END_TIME_FIELD, LAST_MODIFIED_TIME_FIELD,
            TRANSFORM_JOB_STATUS_FIELD, FAILURE_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String transformJobName;

    private final String transformJobArn;

    private final Instant creationTime;

    private final Instant transformEndTime;

    private final Instant lastModifiedTime;

    private final String transformJobStatus;

    private final String failureReason;

    private TransformJobSummary(BuilderImpl builder) {
        this.transformJobName = builder.transformJobName;
        this.transformJobArn = builder.transformJobArn;
        this.creationTime = builder.creationTime;
        this.transformEndTime = builder.transformEndTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.transformJobStatus = builder.transformJobStatus;
        this.failureReason = builder.failureReason;
    }

    /**
     * <p>
     * The name of the transform job.
     * </p>
     * 
     * @return The name of the transform job.
     */
    public final String transformJobName() {
        return transformJobName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the transform job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the transform job.
     */
    public final String transformJobArn() {
        return transformJobArn;
    }

    /**
     * <p>
     * A timestamp that shows when the transform Job was created.
     * </p>
     * 
     * @return A timestamp that shows when the transform Job was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * Indicates when the transform job ends on compute instances. For successful jobs and stopped jobs, this is the
     * exact time recorded after the results are uploaded. For failed jobs, this is when Amazon SageMaker detected that
     * the job failed.
     * </p>
     * 
     * @return Indicates when the transform job ends on compute instances. For successful jobs and stopped jobs, this is
     *         the exact time recorded after the results are uploaded. For failed jobs, this is when Amazon SageMaker
     *         detected that the job failed.
     */
    public final Instant transformEndTime() {
        return transformEndTime;
    }

    /**
     * <p>
     * Indicates when the transform job was last modified.
     * </p>
     * 
     * @return Indicates when the transform job was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The status of the transform job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #transformJobStatus} will return {@link TransformJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #transformJobStatusAsString}.
     * </p>
     * 
     * @return The status of the transform job.
     * @see TransformJobStatus
     */
    public final TransformJobStatus transformJobStatus() {
        return TransformJobStatus.fromValue(transformJobStatus);
    }

    /**
     * <p>
     * The status of the transform job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #transformJobStatus} will return {@link TransformJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #transformJobStatusAsString}.
     * </p>
     * 
     * @return The status of the transform job.
     * @see TransformJobStatus
     */
    public final String transformJobStatusAsString() {
        return transformJobStatus;
    }

    /**
     * <p>
     * If the transform job failed, the reason it failed.
     * </p>
     * 
     * @return If the transform job failed, the reason it failed.
     */
    public final String failureReason() {
        return failureReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transformJobName());
        hashCode = 31 * hashCode + Objects.hashCode(transformJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(transformEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(transformJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransformJobSummary)) {
            return false;
        }
        TransformJobSummary other = (TransformJobSummary) obj;
        return Objects.equals(transformJobName(), other.transformJobName())
                && Objects.equals(transformJobArn(), other.transformJobArn())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(transformEndTime(), other.transformEndTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(transformJobStatusAsString(), other.transformJobStatusAsString())
                && Objects.equals(failureReason(), other.failureReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TransformJobSummary").add("TransformJobName", transformJobName())
                .add("TransformJobArn", transformJobArn()).add("CreationTime", creationTime())
                .add("TransformEndTime", transformEndTime()).add("LastModifiedTime", lastModifiedTime())
                .add("TransformJobStatus", transformJobStatusAsString()).add("FailureReason", failureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransformJobName":
            return Optional.ofNullable(clazz.cast(transformJobName()));
        case "TransformJobArn":
            return Optional.ofNullable(clazz.cast(transformJobArn()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "TransformEndTime":
            return Optional.ofNullable(clazz.cast(transformEndTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "TransformJobStatus":
            return Optional.ofNullable(clazz.cast(transformJobStatusAsString()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TransformJobName", TRANSFORM_JOB_NAME_FIELD);
        map.put("TransformJobArn", TRANSFORM_JOB_ARN_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("TransformEndTime", TRANSFORM_END_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("TransformJobStatus", TRANSFORM_JOB_STATUS_FIELD);
        map.put("FailureReason", FAILURE_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TransformJobSummary, T> g) {
        return obj -> g.apply((TransformJobSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransformJobSummary> {
        /**
         * <p>
         * The name of the transform job.
         * </p>
         * 
         * @param transformJobName
         *        The name of the transform job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformJobName(String transformJobName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the transform job.
         * </p>
         * 
         * @param transformJobArn
         *        The Amazon Resource Name (ARN) of the transform job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformJobArn(String transformJobArn);

        /**
         * <p>
         * A timestamp that shows when the transform Job was created.
         * </p>
         * 
         * @param creationTime
         *        A timestamp that shows when the transform Job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * Indicates when the transform job ends on compute instances. For successful jobs and stopped jobs, this is the
         * exact time recorded after the results are uploaded. For failed jobs, this is when Amazon SageMaker detected
         * that the job failed.
         * </p>
         * 
         * @param transformEndTime
         *        Indicates when the transform job ends on compute instances. For successful jobs and stopped jobs, this
         *        is the exact time recorded after the results are uploaded. For failed jobs, this is when Amazon
         *        SageMaker detected that the job failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformEndTime(Instant transformEndTime);

        /**
         * <p>
         * Indicates when the transform job was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        Indicates when the transform job was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The status of the transform job.
         * </p>
         * 
         * @param transformJobStatus
         *        The status of the transform job.
         * @see TransformJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransformJobStatus
         */
        Builder transformJobStatus(String transformJobStatus);

        /**
         * <p>
         * The status of the transform job.
         * </p>
         * 
         * @param transformJobStatus
         *        The status of the transform job.
         * @see TransformJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransformJobStatus
         */
        Builder transformJobStatus(TransformJobStatus transformJobStatus);

        /**
         * <p>
         * If the transform job failed, the reason it failed.
         * </p>
         * 
         * @param failureReason
         *        If the transform job failed, the reason it failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);
    }

    static final class BuilderImpl implements Builder {
        private String transformJobName;

        private String transformJobArn;

        private Instant creationTime;

        private Instant transformEndTime;

        private Instant lastModifiedTime;

        private String transformJobStatus;

        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(TransformJobSummary model) {
            transformJobName(model.transformJobName);
            transformJobArn(model.transformJobArn);
            creationTime(model.creationTime);
            transformEndTime(model.transformEndTime);
            lastModifiedTime(model.lastModifiedTime);
            transformJobStatus(model.transformJobStatus);
            failureReason(model.failureReason);
        }

        public final String getTransformJobName() {
            return transformJobName;
        }

        public final void setTransformJobName(String transformJobName) {
            this.transformJobName = transformJobName;
        }

        @Override
        public final Builder transformJobName(String transformJobName) {
            this.transformJobName = transformJobName;
            return this;
        }

        public final String getTransformJobArn() {
            return transformJobArn;
        }

        public final void setTransformJobArn(String transformJobArn) {
            this.transformJobArn = transformJobArn;
        }

        @Override
        public final Builder transformJobArn(String transformJobArn) {
            this.transformJobArn = transformJobArn;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getTransformEndTime() {
            return transformEndTime;
        }

        public final void setTransformEndTime(Instant transformEndTime) {
            this.transformEndTime = transformEndTime;
        }

        @Override
        public final Builder transformEndTime(Instant transformEndTime) {
            this.transformEndTime = transformEndTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getTransformJobStatus() {
            return transformJobStatus;
        }

        public final void setTransformJobStatus(String transformJobStatus) {
            this.transformJobStatus = transformJobStatus;
        }

        @Override
        public final Builder transformJobStatus(String transformJobStatus) {
            this.transformJobStatus = transformJobStatus;
            return this;
        }

        @Override
        public final Builder transformJobStatus(TransformJobStatus transformJobStatus) {
            this.transformJobStatus(transformJobStatus == null ? null : transformJobStatus.toString());
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        @Override
        public TransformJobSummary build() {
            return new TransformJobSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
