/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The job completion criteria.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TuningJobCompletionCriteria implements SdkPojo, Serializable,
        ToCopyableBuilder<TuningJobCompletionCriteria.Builder, TuningJobCompletionCriteria> {
    private static final SdkField<Float> TARGET_OBJECTIVE_METRIC_VALUE_FIELD = SdkField
            .<Float> builder(MarshallingType.FLOAT)
            .memberName("TargetObjectiveMetricValue")
            .getter(getter(TuningJobCompletionCriteria::targetObjectiveMetricValue))
            .setter(setter(Builder::targetObjectiveMetricValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetObjectiveMetricValue").build())
            .build();

    private static final SdkField<BestObjectiveNotImproving> BEST_OBJECTIVE_NOT_IMPROVING_FIELD = SdkField
            .<BestObjectiveNotImproving> builder(MarshallingType.SDK_POJO).memberName("BestObjectiveNotImproving")
            .getter(getter(TuningJobCompletionCriteria::bestObjectiveNotImproving))
            .setter(setter(Builder::bestObjectiveNotImproving)).constructor(BestObjectiveNotImproving::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BestObjectiveNotImproving").build())
            .build();

    private static final SdkField<ConvergenceDetected> CONVERGENCE_DETECTED_FIELD = SdkField
            .<ConvergenceDetected> builder(MarshallingType.SDK_POJO).memberName("ConvergenceDetected")
            .getter(getter(TuningJobCompletionCriteria::convergenceDetected)).setter(setter(Builder::convergenceDetected))
            .constructor(ConvergenceDetected::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConvergenceDetected").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TARGET_OBJECTIVE_METRIC_VALUE_FIELD, BEST_OBJECTIVE_NOT_IMPROVING_FIELD, CONVERGENCE_DETECTED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Float targetObjectiveMetricValue;

    private final BestObjectiveNotImproving bestObjectiveNotImproving;

    private final ConvergenceDetected convergenceDetected;

    private TuningJobCompletionCriteria(BuilderImpl builder) {
        this.targetObjectiveMetricValue = builder.targetObjectiveMetricValue;
        this.bestObjectiveNotImproving = builder.bestObjectiveNotImproving;
        this.convergenceDetected = builder.convergenceDetected;
    }

    /**
     * <p>
     * The value of the objective metric.
     * </p>
     * 
     * @return The value of the objective metric.
     */
    public final Float targetObjectiveMetricValue() {
        return targetObjectiveMetricValue;
    }

    /**
     * <p>
     * A flag to stop your hyperparameter tuning job if model performance fails to improve as evaluated against an
     * objective function.
     * </p>
     * 
     * @return A flag to stop your hyperparameter tuning job if model performance fails to improve as evaluated against
     *         an objective function.
     */
    public final BestObjectiveNotImproving bestObjectiveNotImproving() {
        return bestObjectiveNotImproving;
    }

    /**
     * <p>
     * A flag to top your hyperparameter tuning job if automatic model tuning (AMT) has detected that your model has
     * converged as evaluated against your objective function.
     * </p>
     * 
     * @return A flag to top your hyperparameter tuning job if automatic model tuning (AMT) has detected that your model
     *         has converged as evaluated against your objective function.
     */
    public final ConvergenceDetected convergenceDetected() {
        return convergenceDetected;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetObjectiveMetricValue());
        hashCode = 31 * hashCode + Objects.hashCode(bestObjectiveNotImproving());
        hashCode = 31 * hashCode + Objects.hashCode(convergenceDetected());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TuningJobCompletionCriteria)) {
            return false;
        }
        TuningJobCompletionCriteria other = (TuningJobCompletionCriteria) obj;
        return Objects.equals(targetObjectiveMetricValue(), other.targetObjectiveMetricValue())
                && Objects.equals(bestObjectiveNotImproving(), other.bestObjectiveNotImproving())
                && Objects.equals(convergenceDetected(), other.convergenceDetected());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TuningJobCompletionCriteria").add("TargetObjectiveMetricValue", targetObjectiveMetricValue())
                .add("BestObjectiveNotImproving", bestObjectiveNotImproving()).add("ConvergenceDetected", convergenceDetected())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetObjectiveMetricValue":
            return Optional.ofNullable(clazz.cast(targetObjectiveMetricValue()));
        case "BestObjectiveNotImproving":
            return Optional.ofNullable(clazz.cast(bestObjectiveNotImproving()));
        case "ConvergenceDetected":
            return Optional.ofNullable(clazz.cast(convergenceDetected()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TargetObjectiveMetricValue", TARGET_OBJECTIVE_METRIC_VALUE_FIELD);
        map.put("BestObjectiveNotImproving", BEST_OBJECTIVE_NOT_IMPROVING_FIELD);
        map.put("ConvergenceDetected", CONVERGENCE_DETECTED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TuningJobCompletionCriteria, T> g) {
        return obj -> g.apply((TuningJobCompletionCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TuningJobCompletionCriteria> {
        /**
         * <p>
         * The value of the objective metric.
         * </p>
         * 
         * @param targetObjectiveMetricValue
         *        The value of the objective metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetObjectiveMetricValue(Float targetObjectiveMetricValue);

        /**
         * <p>
         * A flag to stop your hyperparameter tuning job if model performance fails to improve as evaluated against an
         * objective function.
         * </p>
         * 
         * @param bestObjectiveNotImproving
         *        A flag to stop your hyperparameter tuning job if model performance fails to improve as evaluated
         *        against an objective function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bestObjectiveNotImproving(BestObjectiveNotImproving bestObjectiveNotImproving);

        /**
         * <p>
         * A flag to stop your hyperparameter tuning job if model performance fails to improve as evaluated against an
         * objective function.
         * </p>
         * This is a convenience method that creates an instance of the {@link BestObjectiveNotImproving.Builder}
         * avoiding the need to create one manually via {@link BestObjectiveNotImproving#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BestObjectiveNotImproving.Builder#build()} is called immediately
         * and its result is passed to {@link #bestObjectiveNotImproving(BestObjectiveNotImproving)}.
         * 
         * @param bestObjectiveNotImproving
         *        a consumer that will call methods on {@link BestObjectiveNotImproving.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bestObjectiveNotImproving(BestObjectiveNotImproving)
         */
        default Builder bestObjectiveNotImproving(Consumer<BestObjectiveNotImproving.Builder> bestObjectiveNotImproving) {
            return bestObjectiveNotImproving(BestObjectiveNotImproving.builder().applyMutation(bestObjectiveNotImproving).build());
        }

        /**
         * <p>
         * A flag to top your hyperparameter tuning job if automatic model tuning (AMT) has detected that your model has
         * converged as evaluated against your objective function.
         * </p>
         * 
         * @param convergenceDetected
         *        A flag to top your hyperparameter tuning job if automatic model tuning (AMT) has detected that your
         *        model has converged as evaluated against your objective function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder convergenceDetected(ConvergenceDetected convergenceDetected);

        /**
         * <p>
         * A flag to top your hyperparameter tuning job if automatic model tuning (AMT) has detected that your model has
         * converged as evaluated against your objective function.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConvergenceDetected.Builder} avoiding the
         * need to create one manually via {@link ConvergenceDetected#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConvergenceDetected.Builder#build()} is called immediately and
         * its result is passed to {@link #convergenceDetected(ConvergenceDetected)}.
         * 
         * @param convergenceDetected
         *        a consumer that will call methods on {@link ConvergenceDetected.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #convergenceDetected(ConvergenceDetected)
         */
        default Builder convergenceDetected(Consumer<ConvergenceDetected.Builder> convergenceDetected) {
            return convergenceDetected(ConvergenceDetected.builder().applyMutation(convergenceDetected).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Float targetObjectiveMetricValue;

        private BestObjectiveNotImproving bestObjectiveNotImproving;

        private ConvergenceDetected convergenceDetected;

        private BuilderImpl() {
        }

        private BuilderImpl(TuningJobCompletionCriteria model) {
            targetObjectiveMetricValue(model.targetObjectiveMetricValue);
            bestObjectiveNotImproving(model.bestObjectiveNotImproving);
            convergenceDetected(model.convergenceDetected);
        }

        public final Float getTargetObjectiveMetricValue() {
            return targetObjectiveMetricValue;
        }

        public final void setTargetObjectiveMetricValue(Float targetObjectiveMetricValue) {
            this.targetObjectiveMetricValue = targetObjectiveMetricValue;
        }

        @Override
        public final Builder targetObjectiveMetricValue(Float targetObjectiveMetricValue) {
            this.targetObjectiveMetricValue = targetObjectiveMetricValue;
            return this;
        }

        public final BestObjectiveNotImproving.Builder getBestObjectiveNotImproving() {
            return bestObjectiveNotImproving != null ? bestObjectiveNotImproving.toBuilder() : null;
        }

        public final void setBestObjectiveNotImproving(BestObjectiveNotImproving.BuilderImpl bestObjectiveNotImproving) {
            this.bestObjectiveNotImproving = bestObjectiveNotImproving != null ? bestObjectiveNotImproving.build() : null;
        }

        @Override
        public final Builder bestObjectiveNotImproving(BestObjectiveNotImproving bestObjectiveNotImproving) {
            this.bestObjectiveNotImproving = bestObjectiveNotImproving;
            return this;
        }

        public final ConvergenceDetected.Builder getConvergenceDetected() {
            return convergenceDetected != null ? convergenceDetected.toBuilder() : null;
        }

        public final void setConvergenceDetected(ConvergenceDetected.BuilderImpl convergenceDetected) {
            this.convergenceDetected = convergenceDetected != null ? convergenceDetected.build() : null;
        }

        @Override
        public final Builder convergenceDetected(ConvergenceDetected convergenceDetected) {
            this.convergenceDetected = convergenceDetected;
            return this;
        }

        @Override
        public TuningJobCompletionCriteria build() {
            return new TuningJobCompletionCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
