/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateClusterSchedulerConfigResponse extends SageMakerResponse implements
        ToCopyableBuilder<UpdateClusterSchedulerConfigResponse.Builder, UpdateClusterSchedulerConfigResponse> {
    private static final SdkField<String> CLUSTER_SCHEDULER_CONFIG_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterSchedulerConfigArn")
            .getter(getter(UpdateClusterSchedulerConfigResponse::clusterSchedulerConfigArn))
            .setter(setter(Builder::clusterSchedulerConfigArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSchedulerConfigArn").build())
            .build();

    private static final SdkField<Integer> CLUSTER_SCHEDULER_CONFIG_VERSION_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("ClusterSchedulerConfigVersion")
            .getter(getter(UpdateClusterSchedulerConfigResponse::clusterSchedulerConfigVersion))
            .setter(setter(Builder::clusterSchedulerConfigVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSchedulerConfigVersion")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CLUSTER_SCHEDULER_CONFIG_ARN_FIELD, CLUSTER_SCHEDULER_CONFIG_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clusterSchedulerConfigArn;

    private final Integer clusterSchedulerConfigVersion;

    private UpdateClusterSchedulerConfigResponse(BuilderImpl builder) {
        super(builder);
        this.clusterSchedulerConfigArn = builder.clusterSchedulerConfigArn;
        this.clusterSchedulerConfigVersion = builder.clusterSchedulerConfigVersion;
    }

    /**
     * <p>
     * ARN of the cluster policy.
     * </p>
     * 
     * @return ARN of the cluster policy.
     */
    public final String clusterSchedulerConfigArn() {
        return clusterSchedulerConfigArn;
    }

    /**
     * <p>
     * Version of the cluster policy.
     * </p>
     * 
     * @return Version of the cluster policy.
     */
    public final Integer clusterSchedulerConfigVersion() {
        return clusterSchedulerConfigVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterSchedulerConfigArn());
        hashCode = 31 * hashCode + Objects.hashCode(clusterSchedulerConfigVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateClusterSchedulerConfigResponse)) {
            return false;
        }
        UpdateClusterSchedulerConfigResponse other = (UpdateClusterSchedulerConfigResponse) obj;
        return Objects.equals(clusterSchedulerConfigArn(), other.clusterSchedulerConfigArn())
                && Objects.equals(clusterSchedulerConfigVersion(), other.clusterSchedulerConfigVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateClusterSchedulerConfigResponse")
                .add("ClusterSchedulerConfigArn", clusterSchedulerConfigArn())
                .add("ClusterSchedulerConfigVersion", clusterSchedulerConfigVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterSchedulerConfigArn":
            return Optional.ofNullable(clazz.cast(clusterSchedulerConfigArn()));
        case "ClusterSchedulerConfigVersion":
            return Optional.ofNullable(clazz.cast(clusterSchedulerConfigVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClusterSchedulerConfigArn", CLUSTER_SCHEDULER_CONFIG_ARN_FIELD);
        map.put("ClusterSchedulerConfigVersion", CLUSTER_SCHEDULER_CONFIG_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateClusterSchedulerConfigResponse, T> g) {
        return obj -> g.apply((UpdateClusterSchedulerConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateClusterSchedulerConfigResponse> {
        /**
         * <p>
         * ARN of the cluster policy.
         * </p>
         * 
         * @param clusterSchedulerConfigArn
         *        ARN of the cluster policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterSchedulerConfigArn(String clusterSchedulerConfigArn);

        /**
         * <p>
         * Version of the cluster policy.
         * </p>
         * 
         * @param clusterSchedulerConfigVersion
         *        Version of the cluster policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterSchedulerConfigVersion(Integer clusterSchedulerConfigVersion);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String clusterSchedulerConfigArn;

        private Integer clusterSchedulerConfigVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateClusterSchedulerConfigResponse model) {
            super(model);
            clusterSchedulerConfigArn(model.clusterSchedulerConfigArn);
            clusterSchedulerConfigVersion(model.clusterSchedulerConfigVersion);
        }

        public final String getClusterSchedulerConfigArn() {
            return clusterSchedulerConfigArn;
        }

        public final void setClusterSchedulerConfigArn(String clusterSchedulerConfigArn) {
            this.clusterSchedulerConfigArn = clusterSchedulerConfigArn;
        }

        @Override
        public final Builder clusterSchedulerConfigArn(String clusterSchedulerConfigArn) {
            this.clusterSchedulerConfigArn = clusterSchedulerConfigArn;
            return this;
        }

        public final Integer getClusterSchedulerConfigVersion() {
            return clusterSchedulerConfigVersion;
        }

        public final void setClusterSchedulerConfigVersion(Integer clusterSchedulerConfigVersion) {
            this.clusterSchedulerConfigVersion = clusterSchedulerConfigVersion;
        }

        @Override
        public final Builder clusterSchedulerConfigVersion(Integer clusterSchedulerConfigVersion) {
            this.clusterSchedulerConfigVersion = clusterSchedulerConfigVersion;
            return this;
        }

        @Override
        public UpdateClusterSchedulerConfigResponse build() {
            return new UpdateClusterSchedulerConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
