/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddAssociationRequest extends SageMakerRequest implements
        ToCopyableBuilder<AddAssociationRequest.Builder, AddAssociationRequest> {
    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceArn").getter(getter(AddAssociationRequest::sourceArn)).setter(setter(Builder::sourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceArn").build()).build();

    private static final SdkField<String> DESTINATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationArn").getter(getter(AddAssociationRequest::destinationArn))
            .setter(setter(Builder::destinationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationArn").build()).build();

    private static final SdkField<String> ASSOCIATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssociationType").getter(getter(AddAssociationRequest::associationTypeAsString))
            .setter(setter(Builder::associationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_ARN_FIELD,
            DESTINATION_ARN_FIELD, ASSOCIATION_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String sourceArn;

    private final String destinationArn;

    private final String associationType;

    private AddAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.sourceArn = builder.sourceArn;
        this.destinationArn = builder.destinationArn;
        this.associationType = builder.associationType;
    }

    /**
     * <p>
     * The ARN of the source.
     * </p>
     * 
     * @return The ARN of the source.
     */
    public final String sourceArn() {
        return sourceArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the destination.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the destination.
     */
    public final String destinationArn() {
        return destinationArn;
    }

    /**
     * <p>
     * The type of association. The following are suggested uses for each type. Amazon SageMaker places no restrictions
     * on their use.
     * </p>
     * <ul>
     * <li>
     * <p>
     * ContributedTo - The source contributed to the destination or had a part in enabling the destination. For example,
     * the training data contributed to the training job.
     * </p>
     * </li>
     * <li>
     * <p>
     * AssociatedWith - The source is connected to the destination. For example, an approval workflow is associated with
     * a model deployment.
     * </p>
     * </li>
     * <li>
     * <p>
     * DerivedFrom - The destination is a modification of the source. For example, a digest output of a channel input
     * for a processing job is derived from the original inputs.
     * </p>
     * </li>
     * <li>
     * <p>
     * Produced - The source generated the destination. For example, a training job produced a model artifact.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #associationType}
     * will return {@link AssociationEdgeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #associationTypeAsString}.
     * </p>
     * 
     * @return The type of association. The following are suggested uses for each type. Amazon SageMaker places no
     *         restrictions on their use.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         ContributedTo - The source contributed to the destination or had a part in enabling the destination. For
     *         example, the training data contributed to the training job.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AssociatedWith - The source is connected to the destination. For example, an approval workflow is
     *         associated with a model deployment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DerivedFrom - The destination is a modification of the source. For example, a digest output of a channel
     *         input for a processing job is derived from the original inputs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Produced - The source generated the destination. For example, a training job produced a model artifact.
     *         </p>
     *         </li>
     * @see AssociationEdgeType
     */
    public final AssociationEdgeType associationType() {
        return AssociationEdgeType.fromValue(associationType);
    }

    /**
     * <p>
     * The type of association. The following are suggested uses for each type. Amazon SageMaker places no restrictions
     * on their use.
     * </p>
     * <ul>
     * <li>
     * <p>
     * ContributedTo - The source contributed to the destination or had a part in enabling the destination. For example,
     * the training data contributed to the training job.
     * </p>
     * </li>
     * <li>
     * <p>
     * AssociatedWith - The source is connected to the destination. For example, an approval workflow is associated with
     * a model deployment.
     * </p>
     * </li>
     * <li>
     * <p>
     * DerivedFrom - The destination is a modification of the source. For example, a digest output of a channel input
     * for a processing job is derived from the original inputs.
     * </p>
     * </li>
     * <li>
     * <p>
     * Produced - The source generated the destination. For example, a training job produced a model artifact.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #associationType}
     * will return {@link AssociationEdgeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #associationTypeAsString}.
     * </p>
     * 
     * @return The type of association. The following are suggested uses for each type. Amazon SageMaker places no
     *         restrictions on their use.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         ContributedTo - The source contributed to the destination or had a part in enabling the destination. For
     *         example, the training data contributed to the training job.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AssociatedWith - The source is connected to the destination. For example, an approval workflow is
     *         associated with a model deployment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DerivedFrom - The destination is a modification of the source. For example, a digest output of a channel
     *         input for a processing job is derived from the original inputs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Produced - The source generated the destination. For example, a training job produced a model artifact.
     *         </p>
     *         </li>
     * @see AssociationEdgeType
     */
    public final String associationTypeAsString() {
        return associationType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(destinationArn());
        hashCode = 31 * hashCode + Objects.hashCode(associationTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddAssociationRequest)) {
            return false;
        }
        AddAssociationRequest other = (AddAssociationRequest) obj;
        return Objects.equals(sourceArn(), other.sourceArn()) && Objects.equals(destinationArn(), other.destinationArn())
                && Objects.equals(associationTypeAsString(), other.associationTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddAssociationRequest").add("SourceArn", sourceArn()).add("DestinationArn", destinationArn())
                .add("AssociationType", associationTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceArn":
            return Optional.ofNullable(clazz.cast(sourceArn()));
        case "DestinationArn":
            return Optional.ofNullable(clazz.cast(destinationArn()));
        case "AssociationType":
            return Optional.ofNullable(clazz.cast(associationTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SourceArn", SOURCE_ARN_FIELD);
        map.put("DestinationArn", DESTINATION_ARN_FIELD);
        map.put("AssociationType", ASSOCIATION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AddAssociationRequest, T> g) {
        return obj -> g.apply((AddAssociationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, AddAssociationRequest> {
        /**
         * <p>
         * The ARN of the source.
         * </p>
         * 
         * @param sourceArn
         *        The ARN of the source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceArn(String sourceArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the destination.
         * </p>
         * 
         * @param destinationArn
         *        The Amazon Resource Name (ARN) of the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationArn(String destinationArn);

        /**
         * <p>
         * The type of association. The following are suggested uses for each type. Amazon SageMaker places no
         * restrictions on their use.
         * </p>
         * <ul>
         * <li>
         * <p>
         * ContributedTo - The source contributed to the destination or had a part in enabling the destination. For
         * example, the training data contributed to the training job.
         * </p>
         * </li>
         * <li>
         * <p>
         * AssociatedWith - The source is connected to the destination. For example, an approval workflow is associated
         * with a model deployment.
         * </p>
         * </li>
         * <li>
         * <p>
         * DerivedFrom - The destination is a modification of the source. For example, a digest output of a channel
         * input for a processing job is derived from the original inputs.
         * </p>
         * </li>
         * <li>
         * <p>
         * Produced - The source generated the destination. For example, a training job produced a model artifact.
         * </p>
         * </li>
         * </ul>
         * 
         * @param associationType
         *        The type of association. The following are suggested uses for each type. Amazon SageMaker places no
         *        restrictions on their use.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        ContributedTo - The source contributed to the destination or had a part in enabling the destination.
         *        For example, the training data contributed to the training job.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        AssociatedWith - The source is connected to the destination. For example, an approval workflow is
         *        associated with a model deployment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DerivedFrom - The destination is a modification of the source. For example, a digest output of a
         *        channel input for a processing job is derived from the original inputs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Produced - The source generated the destination. For example, a training job produced a model
         *        artifact.
         *        </p>
         *        </li>
         * @see AssociationEdgeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssociationEdgeType
         */
        Builder associationType(String associationType);

        /**
         * <p>
         * The type of association. The following are suggested uses for each type. Amazon SageMaker places no
         * restrictions on their use.
         * </p>
         * <ul>
         * <li>
         * <p>
         * ContributedTo - The source contributed to the destination or had a part in enabling the destination. For
         * example, the training data contributed to the training job.
         * </p>
         * </li>
         * <li>
         * <p>
         * AssociatedWith - The source is connected to the destination. For example, an approval workflow is associated
         * with a model deployment.
         * </p>
         * </li>
         * <li>
         * <p>
         * DerivedFrom - The destination is a modification of the source. For example, a digest output of a channel
         * input for a processing job is derived from the original inputs.
         * </p>
         * </li>
         * <li>
         * <p>
         * Produced - The source generated the destination. For example, a training job produced a model artifact.
         * </p>
         * </li>
         * </ul>
         * 
         * @param associationType
         *        The type of association. The following are suggested uses for each type. Amazon SageMaker places no
         *        restrictions on their use.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        ContributedTo - The source contributed to the destination or had a part in enabling the destination.
         *        For example, the training data contributed to the training job.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        AssociatedWith - The source is connected to the destination. For example, an approval workflow is
         *        associated with a model deployment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DerivedFrom - The destination is a modification of the source. For example, a digest output of a
         *        channel input for a processing job is derived from the original inputs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Produced - The source generated the destination. For example, a training job produced a model
         *        artifact.
         *        </p>
         *        </li>
         * @see AssociationEdgeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssociationEdgeType
         */
        Builder associationType(AssociationEdgeType associationType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String sourceArn;

        private String destinationArn;

        private String associationType;

        private BuilderImpl() {
        }

        private BuilderImpl(AddAssociationRequest model) {
            super(model);
            sourceArn(model.sourceArn);
            destinationArn(model.destinationArn);
            associationType(model.associationType);
        }

        public final String getSourceArn() {
            return sourceArn;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final String getDestinationArn() {
            return destinationArn;
        }

        public final void setDestinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
        }

        @Override
        public final Builder destinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
            return this;
        }

        public final String getAssociationType() {
            return associationType;
        }

        public final void setAssociationType(String associationType) {
            this.associationType = associationType;
        }

        @Override
        public final Builder associationType(String associationType) {
            this.associationType = associationType;
            return this;
        }

        @Override
        public final Builder associationType(AssociationEdgeType associationType) {
            this.associationType(associationType == null ? null : associationType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddAssociationRequest build() {
            return new AddAssociationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
