/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A data source used for training or inference that is in addition to the input dataset or model data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AdditionalS3DataSource implements SdkPojo, Serializable,
        ToCopyableBuilder<AdditionalS3DataSource.Builder, AdditionalS3DataSource> {
    private static final SdkField<String> S3_DATA_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3DataType").getter(getter(AdditionalS3DataSource::s3DataTypeAsString))
            .setter(setter(Builder::s3DataType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3DataType").build()).build();

    private static final SdkField<String> S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("S3Uri")
            .getter(getter(AdditionalS3DataSource::s3Uri)).setter(setter(Builder::s3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Uri").build()).build();

    private static final SdkField<String> COMPRESSION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CompressionType").getter(getter(AdditionalS3DataSource::compressionTypeAsString))
            .setter(setter(Builder::compressionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompressionType").build()).build();

    private static final SdkField<String> E_TAG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ETag")
            .getter(getter(AdditionalS3DataSource::eTag)).setter(setter(Builder::eTag))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ETag").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_DATA_TYPE_FIELD,
            S3_URI_FIELD, COMPRESSION_TYPE_FIELD, E_TAG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String s3DataType;

    private final String s3Uri;

    private final String compressionType;

    private final String eTag;

    private AdditionalS3DataSource(BuilderImpl builder) {
        this.s3DataType = builder.s3DataType;
        this.s3Uri = builder.s3Uri;
        this.compressionType = builder.compressionType;
        this.eTag = builder.eTag;
    }

    /**
     * <p>
     * The data type of the additional data source that you specify for use in inference or training.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3DataType} will
     * return {@link AdditionalS3DataSourceDataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #s3DataTypeAsString}.
     * </p>
     * 
     * @return The data type of the additional data source that you specify for use in inference or training.
     * @see AdditionalS3DataSourceDataType
     */
    public final AdditionalS3DataSourceDataType s3DataType() {
        return AdditionalS3DataSourceDataType.fromValue(s3DataType);
    }

    /**
     * <p>
     * The data type of the additional data source that you specify for use in inference or training.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3DataType} will
     * return {@link AdditionalS3DataSourceDataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #s3DataTypeAsString}.
     * </p>
     * 
     * @return The data type of the additional data source that you specify for use in inference or training.
     * @see AdditionalS3DataSourceDataType
     */
    public final String s3DataTypeAsString() {
        return s3DataType;
    }

    /**
     * <p>
     * The uniform resource identifier (URI) used to identify an additional data source used in inference or training.
     * </p>
     * 
     * @return The uniform resource identifier (URI) used to identify an additional data source used in inference or
     *         training.
     */
    public final String s3Uri() {
        return s3Uri;
    }

    /**
     * <p>
     * The type of compression used for an additional data source used in inference or training. Specify
     * <code>None</code> if your additional data source is not compressed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #compressionType}
     * will return {@link CompressionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #compressionTypeAsString}.
     * </p>
     * 
     * @return The type of compression used for an additional data source used in inference or training. Specify
     *         <code>None</code> if your additional data source is not compressed.
     * @see CompressionType
     */
    public final CompressionType compressionType() {
        return CompressionType.fromValue(compressionType);
    }

    /**
     * <p>
     * The type of compression used for an additional data source used in inference or training. Specify
     * <code>None</code> if your additional data source is not compressed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #compressionType}
     * will return {@link CompressionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #compressionTypeAsString}.
     * </p>
     * 
     * @return The type of compression used for an additional data source used in inference or training. Specify
     *         <code>None</code> if your additional data source is not compressed.
     * @see CompressionType
     */
    public final String compressionTypeAsString() {
        return compressionType;
    }

    /**
     * <p>
     * The ETag associated with S3 URI.
     * </p>
     * 
     * @return The ETag associated with S3 URI.
     */
    public final String eTag() {
        return eTag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3DataTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(compressionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(eTag());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdditionalS3DataSource)) {
            return false;
        }
        AdditionalS3DataSource other = (AdditionalS3DataSource) obj;
        return Objects.equals(s3DataTypeAsString(), other.s3DataTypeAsString()) && Objects.equals(s3Uri(), other.s3Uri())
                && Objects.equals(compressionTypeAsString(), other.compressionTypeAsString())
                && Objects.equals(eTag(), other.eTag());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AdditionalS3DataSource").add("S3DataType", s3DataTypeAsString()).add("S3Uri", s3Uri())
                .add("CompressionType", compressionTypeAsString()).add("ETag", eTag()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3DataType":
            return Optional.ofNullable(clazz.cast(s3DataTypeAsString()));
        case "S3Uri":
            return Optional.ofNullable(clazz.cast(s3Uri()));
        case "CompressionType":
            return Optional.ofNullable(clazz.cast(compressionTypeAsString()));
        case "ETag":
            return Optional.ofNullable(clazz.cast(eTag()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("S3DataType", S3_DATA_TYPE_FIELD);
        map.put("S3Uri", S3_URI_FIELD);
        map.put("CompressionType", COMPRESSION_TYPE_FIELD);
        map.put("ETag", E_TAG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AdditionalS3DataSource, T> g) {
        return obj -> g.apply((AdditionalS3DataSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AdditionalS3DataSource> {
        /**
         * <p>
         * The data type of the additional data source that you specify for use in inference or training.
         * </p>
         * 
         * @param s3DataType
         *        The data type of the additional data source that you specify for use in inference or training.
         * @see AdditionalS3DataSourceDataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AdditionalS3DataSourceDataType
         */
        Builder s3DataType(String s3DataType);

        /**
         * <p>
         * The data type of the additional data source that you specify for use in inference or training.
         * </p>
         * 
         * @param s3DataType
         *        The data type of the additional data source that you specify for use in inference or training.
         * @see AdditionalS3DataSourceDataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AdditionalS3DataSourceDataType
         */
        Builder s3DataType(AdditionalS3DataSourceDataType s3DataType);

        /**
         * <p>
         * The uniform resource identifier (URI) used to identify an additional data source used in inference or
         * training.
         * </p>
         * 
         * @param s3Uri
         *        The uniform resource identifier (URI) used to identify an additional data source used in inference or
         *        training.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Uri(String s3Uri);

        /**
         * <p>
         * The type of compression used for an additional data source used in inference or training. Specify
         * <code>None</code> if your additional data source is not compressed.
         * </p>
         * 
         * @param compressionType
         *        The type of compression used for an additional data source used in inference or training. Specify
         *        <code>None</code> if your additional data source is not compressed.
         * @see CompressionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CompressionType
         */
        Builder compressionType(String compressionType);

        /**
         * <p>
         * The type of compression used for an additional data source used in inference or training. Specify
         * <code>None</code> if your additional data source is not compressed.
         * </p>
         * 
         * @param compressionType
         *        The type of compression used for an additional data source used in inference or training. Specify
         *        <code>None</code> if your additional data source is not compressed.
         * @see CompressionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CompressionType
         */
        Builder compressionType(CompressionType compressionType);

        /**
         * <p>
         * The ETag associated with S3 URI.
         * </p>
         * 
         * @param eTag
         *        The ETag associated with S3 URI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);
    }

    static final class BuilderImpl implements Builder {
        private String s3DataType;

        private String s3Uri;

        private String compressionType;

        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(AdditionalS3DataSource model) {
            s3DataType(model.s3DataType);
            s3Uri(model.s3Uri);
            compressionType(model.compressionType);
            eTag(model.eTag);
        }

        public final String getS3DataType() {
            return s3DataType;
        }

        public final void setS3DataType(String s3DataType) {
            this.s3DataType = s3DataType;
        }

        @Override
        public final Builder s3DataType(String s3DataType) {
            this.s3DataType = s3DataType;
            return this;
        }

        @Override
        public final Builder s3DataType(AdditionalS3DataSourceDataType s3DataType) {
            this.s3DataType(s3DataType == null ? null : s3DataType.toString());
            return this;
        }

        public final String getS3Uri() {
            return s3Uri;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final String getCompressionType() {
            return compressionType;
        }

        public final void setCompressionType(String compressionType) {
            this.compressionType = compressionType;
        }

        @Override
        public final Builder compressionType(String compressionType) {
            this.compressionType = compressionType;
            return this;
        }

        @Override
        public final Builder compressionType(CompressionType compressionType) {
            this.compressionType(compressionType == null ? null : compressionType.toString());
            return this;
        }

        public final String getETag() {
            return eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        @Override
        public AdditionalS3DataSource build() {
            return new AdditionalS3DataSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
