/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that keeps track of which training jobs launched by your hyperparameter tuning job are not improving
 * model performance as evaluated against an objective function.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BestObjectiveNotImproving implements SdkPojo, Serializable,
        ToCopyableBuilder<BestObjectiveNotImproving.Builder, BestObjectiveNotImproving> {
    private static final SdkField<Integer> MAX_NUMBER_OF_TRAINING_JOBS_NOT_IMPROVING_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxNumberOfTrainingJobsNotImproving")
            .getter(getter(BestObjectiveNotImproving::maxNumberOfTrainingJobsNotImproving))
            .setter(setter(Builder::maxNumberOfTrainingJobsNotImproving))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("MaxNumberOfTrainingJobsNotImproving").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(MAX_NUMBER_OF_TRAINING_JOBS_NOT_IMPROVING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer maxNumberOfTrainingJobsNotImproving;

    private BestObjectiveNotImproving(BuilderImpl builder) {
        this.maxNumberOfTrainingJobsNotImproving = builder.maxNumberOfTrainingJobsNotImproving;
    }

    /**
     * <p>
     * The number of training jobs that have failed to improve model performance by 1% or greater over prior training
     * jobs as evaluated against an objective function.
     * </p>
     * 
     * @return The number of training jobs that have failed to improve model performance by 1% or greater over prior
     *         training jobs as evaluated against an objective function.
     */
    public final Integer maxNumberOfTrainingJobsNotImproving() {
        return maxNumberOfTrainingJobsNotImproving;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxNumberOfTrainingJobsNotImproving());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BestObjectiveNotImproving)) {
            return false;
        }
        BestObjectiveNotImproving other = (BestObjectiveNotImproving) obj;
        return Objects.equals(maxNumberOfTrainingJobsNotImproving(), other.maxNumberOfTrainingJobsNotImproving());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BestObjectiveNotImproving")
                .add("MaxNumberOfTrainingJobsNotImproving", maxNumberOfTrainingJobsNotImproving()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxNumberOfTrainingJobsNotImproving":
            return Optional.ofNullable(clazz.cast(maxNumberOfTrainingJobsNotImproving()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MaxNumberOfTrainingJobsNotImproving", MAX_NUMBER_OF_TRAINING_JOBS_NOT_IMPROVING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BestObjectiveNotImproving, T> g) {
        return obj -> g.apply((BestObjectiveNotImproving) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BestObjectiveNotImproving> {
        /**
         * <p>
         * The number of training jobs that have failed to improve model performance by 1% or greater over prior
         * training jobs as evaluated against an objective function.
         * </p>
         * 
         * @param maxNumberOfTrainingJobsNotImproving
         *        The number of training jobs that have failed to improve model performance by 1% or greater over prior
         *        training jobs as evaluated against an objective function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxNumberOfTrainingJobsNotImproving(Integer maxNumberOfTrainingJobsNotImproving);
    }

    static final class BuilderImpl implements Builder {
        private Integer maxNumberOfTrainingJobsNotImproving;

        private BuilderImpl() {
        }

        private BuilderImpl(BestObjectiveNotImproving model) {
            maxNumberOfTrainingJobsNotImproving(model.maxNumberOfTrainingJobsNotImproving);
        }

        public final Integer getMaxNumberOfTrainingJobsNotImproving() {
            return maxNumberOfTrainingJobsNotImproving;
        }

        public final void setMaxNumberOfTrainingJobsNotImproving(Integer maxNumberOfTrainingJobsNotImproving) {
            this.maxNumberOfTrainingJobsNotImproving = maxNumberOfTrainingJobsNotImproving;
        }

        @Override
        public final Builder maxNumberOfTrainingJobsNotImproving(Integer maxNumberOfTrainingJobsNotImproving) {
            this.maxNumberOfTrainingJobsNotImproving = maxNumberOfTrainingJobsNotImproving;
            return this;
        }

        @Override
        public BestObjectiveNotImproving build() {
            return new BestObjectiveNotImproving(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
