/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateNotebookInstanceLifecycleConfigRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreateNotebookInstanceLifecycleConfigRequest.Builder, CreateNotebookInstanceLifecycleConfigRequest> {
    private static final SdkField<String> NOTEBOOK_INSTANCE_LIFECYCLE_CONFIG_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NotebookInstanceLifecycleConfigName")
            .getter(getter(CreateNotebookInstanceLifecycleConfigRequest::notebookInstanceLifecycleConfigName))
            .setter(setter(Builder::notebookInstanceLifecycleConfigName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("NotebookInstanceLifecycleConfigName").build()).build();

    private static final SdkField<List<NotebookInstanceLifecycleHook>> ON_CREATE_FIELD = SdkField
            .<List<NotebookInstanceLifecycleHook>> builder(MarshallingType.LIST)
            .memberName("OnCreate")
            .getter(getter(CreateNotebookInstanceLifecycleConfigRequest::onCreate))
            .setter(setter(Builder::onCreate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnCreate").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NotebookInstanceLifecycleHook> builder(MarshallingType.SDK_POJO)
                                            .constructor(NotebookInstanceLifecycleHook::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<NotebookInstanceLifecycleHook>> ON_START_FIELD = SdkField
            .<List<NotebookInstanceLifecycleHook>> builder(MarshallingType.LIST)
            .memberName("OnStart")
            .getter(getter(CreateNotebookInstanceLifecycleConfigRequest::onStart))
            .setter(setter(Builder::onStart))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnStart").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NotebookInstanceLifecycleHook> builder(MarshallingType.SDK_POJO)
                                            .constructor(NotebookInstanceLifecycleHook::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateNotebookInstanceLifecycleConfigRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            NOTEBOOK_INSTANCE_LIFECYCLE_CONFIG_NAME_FIELD, ON_CREATE_FIELD, ON_START_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String notebookInstanceLifecycleConfigName;

    private final List<NotebookInstanceLifecycleHook> onCreate;

    private final List<NotebookInstanceLifecycleHook> onStart;

    private final List<Tag> tags;

    private CreateNotebookInstanceLifecycleConfigRequest(BuilderImpl builder) {
        super(builder);
        this.notebookInstanceLifecycleConfigName = builder.notebookInstanceLifecycleConfigName;
        this.onCreate = builder.onCreate;
        this.onStart = builder.onStart;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the lifecycle configuration.
     * </p>
     * 
     * @return The name of the lifecycle configuration.
     */
    public final String notebookInstanceLifecycleConfigName() {
        return notebookInstanceLifecycleConfigName;
    }

    /**
     * For responses, this returns true if the service returned a value for the OnCreate property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOnCreate() {
        return onCreate != null && !(onCreate instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A shell script that runs only once, when you create a notebook instance. The shell script must be a
     * base64-encoded string.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOnCreate} method.
     * </p>
     * 
     * @return A shell script that runs only once, when you create a notebook instance. The shell script must be a
     *         base64-encoded string.
     */
    public final List<NotebookInstanceLifecycleHook> onCreate() {
        return onCreate;
    }

    /**
     * For responses, this returns true if the service returned a value for the OnStart property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOnStart() {
        return onStart != null && !(onStart instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A shell script that runs every time you start a notebook instance, including when you create the notebook
     * instance. The shell script must be a base64-encoded string.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOnStart} method.
     * </p>
     * 
     * @return A shell script that runs every time you start a notebook instance, including when you create the notebook
     *         instance. The shell script must be a base64-encoded string.
     */
    public final List<NotebookInstanceLifecycleHook> onStart() {
        return onStart;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways,
     * for example, by purpose, owner, or environment. For more information, see <a
     * href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html">Tagging Amazon Web Services
     * Resources</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
     *         different ways, for example, by purpose, owner, or environment. For more information, see <a
     *         href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html">Tagging Amazon Web Services
     *         Resources</a>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(notebookInstanceLifecycleConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(hasOnCreate() ? onCreate() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOnStart() ? onStart() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNotebookInstanceLifecycleConfigRequest)) {
            return false;
        }
        CreateNotebookInstanceLifecycleConfigRequest other = (CreateNotebookInstanceLifecycleConfigRequest) obj;
        return Objects.equals(notebookInstanceLifecycleConfigName(), other.notebookInstanceLifecycleConfigName())
                && hasOnCreate() == other.hasOnCreate() && Objects.equals(onCreate(), other.onCreate())
                && hasOnStart() == other.hasOnStart() && Objects.equals(onStart(), other.onStart())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateNotebookInstanceLifecycleConfigRequest")
                .add("NotebookInstanceLifecycleConfigName", notebookInstanceLifecycleConfigName())
                .add("OnCreate", hasOnCreate() ? onCreate() : null).add("OnStart", hasOnStart() ? onStart() : null)
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NotebookInstanceLifecycleConfigName":
            return Optional.ofNullable(clazz.cast(notebookInstanceLifecycleConfigName()));
        case "OnCreate":
            return Optional.ofNullable(clazz.cast(onCreate()));
        case "OnStart":
            return Optional.ofNullable(clazz.cast(onStart()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NotebookInstanceLifecycleConfigName", NOTEBOOK_INSTANCE_LIFECYCLE_CONFIG_NAME_FIELD);
        map.put("OnCreate", ON_CREATE_FIELD);
        map.put("OnStart", ON_START_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateNotebookInstanceLifecycleConfigRequest, T> g) {
        return obj -> g.apply((CreateNotebookInstanceLifecycleConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateNotebookInstanceLifecycleConfigRequest> {
        /**
         * <p>
         * The name of the lifecycle configuration.
         * </p>
         * 
         * @param notebookInstanceLifecycleConfigName
         *        The name of the lifecycle configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notebookInstanceLifecycleConfigName(String notebookInstanceLifecycleConfigName);

        /**
         * <p>
         * A shell script that runs only once, when you create a notebook instance. The shell script must be a
         * base64-encoded string.
         * </p>
         * 
         * @param onCreate
         *        A shell script that runs only once, when you create a notebook instance. The shell script must be a
         *        base64-encoded string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onCreate(Collection<NotebookInstanceLifecycleHook> onCreate);

        /**
         * <p>
         * A shell script that runs only once, when you create a notebook instance. The shell script must be a
         * base64-encoded string.
         * </p>
         * 
         * @param onCreate
         *        A shell script that runs only once, when you create a notebook instance. The shell script must be a
         *        base64-encoded string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onCreate(NotebookInstanceLifecycleHook... onCreate);

        /**
         * <p>
         * A shell script that runs only once, when you create a notebook instance. The shell script must be a
         * base64-encoded string.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.NotebookInstanceLifecycleHook.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.NotebookInstanceLifecycleHook#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.NotebookInstanceLifecycleHook.Builder#build()} is
         * called immediately and its result is passed to {@link #onCreate(List<NotebookInstanceLifecycleHook>)}.
         * 
         * @param onCreate
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.NotebookInstanceLifecycleHook.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #onCreate(java.util.Collection<NotebookInstanceLifecycleHook>)
         */
        Builder onCreate(Consumer<NotebookInstanceLifecycleHook.Builder>... onCreate);

        /**
         * <p>
         * A shell script that runs every time you start a notebook instance, including when you create the notebook
         * instance. The shell script must be a base64-encoded string.
         * </p>
         * 
         * @param onStart
         *        A shell script that runs every time you start a notebook instance, including when you create the
         *        notebook instance. The shell script must be a base64-encoded string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onStart(Collection<NotebookInstanceLifecycleHook> onStart);

        /**
         * <p>
         * A shell script that runs every time you start a notebook instance, including when you create the notebook
         * instance. The shell script must be a base64-encoded string.
         * </p>
         * 
         * @param onStart
         *        A shell script that runs every time you start a notebook instance, including when you create the
         *        notebook instance. The shell script must be a base64-encoded string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onStart(NotebookInstanceLifecycleHook... onStart);

        /**
         * <p>
         * A shell script that runs every time you start a notebook instance, including when you create the notebook
         * instance. The shell script must be a base64-encoded string.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.NotebookInstanceLifecycleHook.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.NotebookInstanceLifecycleHook#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.NotebookInstanceLifecycleHook.Builder#build()} is
         * called immediately and its result is passed to {@link #onStart(List<NotebookInstanceLifecycleHook>)}.
         * 
         * @param onStart
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.NotebookInstanceLifecycleHook.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #onStart(java.util.Collection<NotebookInstanceLifecycleHook>)
         */
        Builder onStart(Consumer<NotebookInstanceLifecycleHook.Builder>... onStart);

        /**
         * <p>
         * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different
         * ways, for example, by purpose, owner, or environment. For more information, see <a
         * href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html">Tagging Amazon Web Services
         * Resources</a>.
         * </p>
         * 
         * @param tags
         *        An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
         *        different ways, for example, by purpose, owner, or environment. For more information, see <a
         *        href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html">Tagging Amazon Web
         *        Services Resources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different
         * ways, for example, by purpose, owner, or environment. For more information, see <a
         * href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html">Tagging Amazon Web Services
         * Resources</a>.
         * </p>
         * 
         * @param tags
         *        An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
         *        different ways, for example, by purpose, owner, or environment. For more information, see <a
         *        href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html">Tagging Amazon Web
         *        Services Resources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different
         * ways, for example, by purpose, owner, or environment. For more information, see <a
         * href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html">Tagging Amazon Web Services
         * Resources</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.sagemaker.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String notebookInstanceLifecycleConfigName;

        private List<NotebookInstanceLifecycleHook> onCreate = DefaultSdkAutoConstructList.getInstance();

        private List<NotebookInstanceLifecycleHook> onStart = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNotebookInstanceLifecycleConfigRequest model) {
            super(model);
            notebookInstanceLifecycleConfigName(model.notebookInstanceLifecycleConfigName);
            onCreate(model.onCreate);
            onStart(model.onStart);
            tags(model.tags);
        }

        public final String getNotebookInstanceLifecycleConfigName() {
            return notebookInstanceLifecycleConfigName;
        }

        public final void setNotebookInstanceLifecycleConfigName(String notebookInstanceLifecycleConfigName) {
            this.notebookInstanceLifecycleConfigName = notebookInstanceLifecycleConfigName;
        }

        @Override
        public final Builder notebookInstanceLifecycleConfigName(String notebookInstanceLifecycleConfigName) {
            this.notebookInstanceLifecycleConfigName = notebookInstanceLifecycleConfigName;
            return this;
        }

        public final List<NotebookInstanceLifecycleHook.Builder> getOnCreate() {
            List<NotebookInstanceLifecycleHook.Builder> result = NotebookInstanceLifecycleConfigListCopier
                    .copyToBuilder(this.onCreate);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOnCreate(Collection<NotebookInstanceLifecycleHook.BuilderImpl> onCreate) {
            this.onCreate = NotebookInstanceLifecycleConfigListCopier.copyFromBuilder(onCreate);
        }

        @Override
        public final Builder onCreate(Collection<NotebookInstanceLifecycleHook> onCreate) {
            this.onCreate = NotebookInstanceLifecycleConfigListCopier.copy(onCreate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onCreate(NotebookInstanceLifecycleHook... onCreate) {
            onCreate(Arrays.asList(onCreate));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onCreate(Consumer<NotebookInstanceLifecycleHook.Builder>... onCreate) {
            onCreate(Stream.of(onCreate).map(c -> NotebookInstanceLifecycleHook.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<NotebookInstanceLifecycleHook.Builder> getOnStart() {
            List<NotebookInstanceLifecycleHook.Builder> result = NotebookInstanceLifecycleConfigListCopier
                    .copyToBuilder(this.onStart);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOnStart(Collection<NotebookInstanceLifecycleHook.BuilderImpl> onStart) {
            this.onStart = NotebookInstanceLifecycleConfigListCopier.copyFromBuilder(onStart);
        }

        @Override
        public final Builder onStart(Collection<NotebookInstanceLifecycleHook> onStart) {
            this.onStart = NotebookInstanceLifecycleConfigListCopier.copy(onStart);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onStart(NotebookInstanceLifecycleHook... onStart) {
            onStart(Arrays.asList(onStart));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onStart(Consumer<NotebookInstanceLifecycleHook.Builder>... onStart) {
            onStart(Stream.of(onStart).map(c -> NotebookInstanceLifecycleHook.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateNotebookInstanceLifecycleConfigRequest build() {
            return new CreateNotebookInstanceLifecycleConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
