/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the POSIX identity that is used for file system operations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomPosixUserConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomPosixUserConfig.Builder, CustomPosixUserConfig> {
    private static final SdkField<Long> UID_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Uid")
            .getter(getter(CustomPosixUserConfig::uid)).setter(setter(Builder::uid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Uid").build()).build();

    private static final SdkField<Long> GID_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Gid")
            .getter(getter(CustomPosixUserConfig::gid)).setter(setter(Builder::gid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Gid").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UID_FIELD, GID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long uid;

    private final Long gid;

    private CustomPosixUserConfig(BuilderImpl builder) {
        this.uid = builder.uid;
        this.gid = builder.gid;
    }

    /**
     * <p>
     * The POSIX user ID.
     * </p>
     * 
     * @return The POSIX user ID.
     */
    public final Long uid() {
        return uid;
    }

    /**
     * <p>
     * The POSIX group ID.
     * </p>
     * 
     * @return The POSIX group ID.
     */
    public final Long gid() {
        return gid;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(uid());
        hashCode = 31 * hashCode + Objects.hashCode(gid());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomPosixUserConfig)) {
            return false;
        }
        CustomPosixUserConfig other = (CustomPosixUserConfig) obj;
        return Objects.equals(uid(), other.uid()) && Objects.equals(gid(), other.gid());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomPosixUserConfig").add("Uid", uid()).add("Gid", gid()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Uid":
            return Optional.ofNullable(clazz.cast(uid()));
        case "Gid":
            return Optional.ofNullable(clazz.cast(gid()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Uid", UID_FIELD);
        map.put("Gid", GID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomPosixUserConfig, T> g) {
        return obj -> g.apply((CustomPosixUserConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomPosixUserConfig> {
        /**
         * <p>
         * The POSIX user ID.
         * </p>
         * 
         * @param uid
         *        The POSIX user ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uid(Long uid);

        /**
         * <p>
         * The POSIX group ID.
         * </p>
         * 
         * @param gid
         *        The POSIX group ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gid(Long gid);
    }

    static final class BuilderImpl implements Builder {
        private Long uid;

        private Long gid;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomPosixUserConfig model) {
            uid(model.uid);
            gid(model.gid);
        }

        public final Long getUid() {
            return uid;
        }

        public final void setUid(Long uid) {
            this.uid = uid;
        }

        @Override
        public final Builder uid(Long uid) {
            this.uid = uid;
            return this;
        }

        public final Long getGid() {
            return gid;
        }

        public final void setGid(Long gid) {
            this.gid = gid;
        }

        @Override
        public final Builder gid(Long gid) {
            this.gid = gid;
            return this;
        }

        @Override
        public CustomPosixUserConfig build() {
            return new CustomPosixUserConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
