/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTrainingPlanResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeTrainingPlanResponse.Builder, DescribeTrainingPlanResponse> {
    private static final SdkField<String> TRAINING_PLAN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrainingPlanArn").getter(getter(DescribeTrainingPlanResponse::trainingPlanArn))
            .setter(setter(Builder::trainingPlanArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingPlanArn").build()).build();

    private static final SdkField<String> TRAINING_PLAN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrainingPlanName").getter(getter(DescribeTrainingPlanResponse::trainingPlanName))
            .setter(setter(Builder::trainingPlanName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingPlanName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeTrainingPlanResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(DescribeTrainingPlanResponse::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<Long> DURATION_HOURS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("DurationHours").getter(getter(DescribeTrainingPlanResponse::durationHours))
            .setter(setter(Builder::durationHours))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationHours").build()).build();

    private static final SdkField<Long> DURATION_MINUTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("DurationMinutes").getter(getter(DescribeTrainingPlanResponse::durationMinutes))
            .setter(setter(Builder::durationMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationMinutes").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(DescribeTrainingPlanResponse::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(DescribeTrainingPlanResponse::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<String> UPFRONT_FEE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpfrontFee").getter(getter(DescribeTrainingPlanResponse::upfrontFee))
            .setter(setter(Builder::upfrontFee))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpfrontFee").build()).build();

    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrencyCode").getter(getter(DescribeTrainingPlanResponse::currencyCode))
            .setter(setter(Builder::currencyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode").build()).build();

    private static final SdkField<Integer> TOTAL_INSTANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalInstanceCount").getter(getter(DescribeTrainingPlanResponse::totalInstanceCount))
            .setter(setter(Builder::totalInstanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalInstanceCount").build())
            .build();

    private static final SdkField<Integer> AVAILABLE_INSTANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AvailableInstanceCount").getter(getter(DescribeTrainingPlanResponse::availableInstanceCount))
            .setter(setter(Builder::availableInstanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableInstanceCount").build())
            .build();

    private static final SdkField<Integer> IN_USE_INSTANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("InUseInstanceCount").getter(getter(DescribeTrainingPlanResponse::inUseInstanceCount))
            .setter(setter(Builder::inUseInstanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InUseInstanceCount").build())
            .build();

    private static final SdkField<List<String>> TARGET_RESOURCES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TargetResources")
            .getter(getter(DescribeTrainingPlanResponse::targetResourcesAsStrings))
            .setter(setter(Builder::targetResourcesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetResources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ReservedCapacitySummary>> RESERVED_CAPACITY_SUMMARIES_FIELD = SdkField
            .<List<ReservedCapacitySummary>> builder(MarshallingType.LIST)
            .memberName("ReservedCapacitySummaries")
            .getter(getter(DescribeTrainingPlanResponse::reservedCapacitySummaries))
            .setter(setter(Builder::reservedCapacitySummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedCapacitySummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReservedCapacitySummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReservedCapacitySummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAINING_PLAN_ARN_FIELD,
            TRAINING_PLAN_NAME_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, DURATION_HOURS_FIELD, DURATION_MINUTES_FIELD,
            START_TIME_FIELD, END_TIME_FIELD, UPFRONT_FEE_FIELD, CURRENCY_CODE_FIELD, TOTAL_INSTANCE_COUNT_FIELD,
            AVAILABLE_INSTANCE_COUNT_FIELD, IN_USE_INSTANCE_COUNT_FIELD, TARGET_RESOURCES_FIELD,
            RESERVED_CAPACITY_SUMMARIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String trainingPlanArn;

    private final String trainingPlanName;

    private final String status;

    private final String statusMessage;

    private final Long durationHours;

    private final Long durationMinutes;

    private final Instant startTime;

    private final Instant endTime;

    private final String upfrontFee;

    private final String currencyCode;

    private final Integer totalInstanceCount;

    private final Integer availableInstanceCount;

    private final Integer inUseInstanceCount;

    private final List<String> targetResources;

    private final List<ReservedCapacitySummary> reservedCapacitySummaries;

    private DescribeTrainingPlanResponse(BuilderImpl builder) {
        super(builder);
        this.trainingPlanArn = builder.trainingPlanArn;
        this.trainingPlanName = builder.trainingPlanName;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.durationHours = builder.durationHours;
        this.durationMinutes = builder.durationMinutes;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.upfrontFee = builder.upfrontFee;
        this.currencyCode = builder.currencyCode;
        this.totalInstanceCount = builder.totalInstanceCount;
        this.availableInstanceCount = builder.availableInstanceCount;
        this.inUseInstanceCount = builder.inUseInstanceCount;
        this.targetResources = builder.targetResources;
        this.reservedCapacitySummaries = builder.reservedCapacitySummaries;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN); of the training plan.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN); of the training plan.
     */
    public final String trainingPlanArn() {
        return trainingPlanArn;
    }

    /**
     * <p>
     * The name of the training plan.
     * </p>
     * 
     * @return The name of the training plan.
     */
    public final String trainingPlanName() {
        return trainingPlanName;
    }

    /**
     * <p>
     * The current status of the training plan (e.g., Pending, Active, Expired). To see the complete list of status
     * values available for a training plan, refer to the <code>Status</code> attribute within the
     * <code> <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_TrainingPlanSummary.html">TrainingPlanSummary</a> </code>
     * object.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TrainingPlanStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the training plan (e.g., Pending, Active, Expired). To see the complete list of
     *         status values available for a training plan, refer to the <code>Status</code> attribute within the
     *         <code> <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_TrainingPlanSummary.html">TrainingPlanSummary</a> </code>
     *         object.
     * @see TrainingPlanStatus
     */
    public final TrainingPlanStatus status() {
        return TrainingPlanStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the training plan (e.g., Pending, Active, Expired). To see the complete list of status
     * values available for a training plan, refer to the <code>Status</code> attribute within the
     * <code> <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_TrainingPlanSummary.html">TrainingPlanSummary</a> </code>
     * object.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TrainingPlanStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the training plan (e.g., Pending, Active, Expired). To see the complete list of
     *         status values available for a training plan, refer to the <code>Status</code> attribute within the
     *         <code> <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_TrainingPlanSummary.html">TrainingPlanSummary</a> </code>
     *         object.
     * @see TrainingPlanStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A message providing additional information about the current status of the training plan.
     * </p>
     * 
     * @return A message providing additional information about the current status of the training plan.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The number of whole hours in the total duration for this training plan.
     * </p>
     * 
     * @return The number of whole hours in the total duration for this training plan.
     */
    public final Long durationHours() {
        return durationHours;
    }

    /**
     * <p>
     * The additional minutes beyond whole hours in the total duration for this training plan.
     * </p>
     * 
     * @return The additional minutes beyond whole hours in the total duration for this training plan.
     */
    public final Long durationMinutes() {
        return durationMinutes;
    }

    /**
     * <p>
     * The start time of the training plan.
     * </p>
     * 
     * @return The start time of the training plan.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end time of the training plan.
     * </p>
     * 
     * @return The end time of the training plan.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The upfront fee for the training plan.
     * </p>
     * 
     * @return The upfront fee for the training plan.
     */
    public final String upfrontFee() {
        return upfrontFee;
    }

    /**
     * <p>
     * The currency code for the upfront fee (e.g., USD).
     * </p>
     * 
     * @return The currency code for the upfront fee (e.g., USD).
     */
    public final String currencyCode() {
        return currencyCode;
    }

    /**
     * <p>
     * The total number of instances reserved in this training plan.
     * </p>
     * 
     * @return The total number of instances reserved in this training plan.
     */
    public final Integer totalInstanceCount() {
        return totalInstanceCount;
    }

    /**
     * <p>
     * The number of instances currently available for use in this training plan.
     * </p>
     * 
     * @return The number of instances currently available for use in this training plan.
     */
    public final Integer availableInstanceCount() {
        return availableInstanceCount;
    }

    /**
     * <p>
     * The number of instances currently in use from this training plan.
     * </p>
     * 
     * @return The number of instances currently in use from this training plan.
     */
    public final Integer inUseInstanceCount() {
        return inUseInstanceCount;
    }

    /**
     * <p>
     * The target resources (e.g., SageMaker Training Jobs, SageMaker HyperPod) that can use this training plan.
     * </p>
     * <p>
     * Training plans are specific to their target resource.
     * </p>
     * <ul>
     * <li>
     * <p>
     * A training plan designed for SageMaker training jobs can only be used to schedule and run training jobs.
     * </p>
     * </li>
     * <li>
     * <p>
     * A training plan for HyperPod clusters can be used exclusively to provide compute resources to a cluster's
     * instance group.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetResources} method.
     * </p>
     * 
     * @return The target resources (e.g., SageMaker Training Jobs, SageMaker HyperPod) that can use this training
     *         plan.</p>
     *         <p>
     *         Training plans are specific to their target resource.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A training plan designed for SageMaker training jobs can only be used to schedule and run training jobs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A training plan for HyperPod clusters can be used exclusively to provide compute resources to a cluster's
     *         instance group.
     *         </p>
     *         </li>
     */
    public final List<SageMakerResourceName> targetResources() {
        return SageMakerResourceNamesCopier.copyStringToEnum(targetResources);
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetResources property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTargetResources() {
        return targetResources != null && !(targetResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The target resources (e.g., SageMaker Training Jobs, SageMaker HyperPod) that can use this training plan.
     * </p>
     * <p>
     * Training plans are specific to their target resource.
     * </p>
     * <ul>
     * <li>
     * <p>
     * A training plan designed for SageMaker training jobs can only be used to schedule and run training jobs.
     * </p>
     * </li>
     * <li>
     * <p>
     * A training plan for HyperPod clusters can be used exclusively to provide compute resources to a cluster's
     * instance group.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetResources} method.
     * </p>
     * 
     * @return The target resources (e.g., SageMaker Training Jobs, SageMaker HyperPod) that can use this training
     *         plan.</p>
     *         <p>
     *         Training plans are specific to their target resource.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A training plan designed for SageMaker training jobs can only be used to schedule and run training jobs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A training plan for HyperPod clusters can be used exclusively to provide compute resources to a cluster's
     *         instance group.
     *         </p>
     *         </li>
     */
    public final List<String> targetResourcesAsStrings() {
        return targetResources;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReservedCapacitySummaries property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasReservedCapacitySummaries() {
        return reservedCapacitySummaries != null && !(reservedCapacitySummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of Reserved Capacity providing the underlying compute resources of the plan.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReservedCapacitySummaries} method.
     * </p>
     * 
     * @return The list of Reserved Capacity providing the underlying compute resources of the plan.
     */
    public final List<ReservedCapacitySummary> reservedCapacitySummaries() {
        return reservedCapacitySummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trainingPlanArn());
        hashCode = 31 * hashCode + Objects.hashCode(trainingPlanName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(durationHours());
        hashCode = 31 * hashCode + Objects.hashCode(durationMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(upfrontFee());
        hashCode = 31 * hashCode + Objects.hashCode(currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(totalInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(availableInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(inUseInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetResources() ? targetResourcesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasReservedCapacitySummaries() ? reservedCapacitySummaries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTrainingPlanResponse)) {
            return false;
        }
        DescribeTrainingPlanResponse other = (DescribeTrainingPlanResponse) obj;
        return Objects.equals(trainingPlanArn(), other.trainingPlanArn())
                && Objects.equals(trainingPlanName(), other.trainingPlanName())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(durationHours(), other.durationHours())
                && Objects.equals(durationMinutes(), other.durationMinutes()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(upfrontFee(), other.upfrontFee())
                && Objects.equals(currencyCode(), other.currencyCode())
                && Objects.equals(totalInstanceCount(), other.totalInstanceCount())
                && Objects.equals(availableInstanceCount(), other.availableInstanceCount())
                && Objects.equals(inUseInstanceCount(), other.inUseInstanceCount())
                && hasTargetResources() == other.hasTargetResources()
                && Objects.equals(targetResourcesAsStrings(), other.targetResourcesAsStrings())
                && hasReservedCapacitySummaries() == other.hasReservedCapacitySummaries()
                && Objects.equals(reservedCapacitySummaries(), other.reservedCapacitySummaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeTrainingPlanResponse").add("TrainingPlanArn", trainingPlanArn())
                .add("TrainingPlanName", trainingPlanName()).add("Status", statusAsString())
                .add("StatusMessage", statusMessage()).add("DurationHours", durationHours())
                .add("DurationMinutes", durationMinutes()).add("StartTime", startTime()).add("EndTime", endTime())
                .add("UpfrontFee", upfrontFee()).add("CurrencyCode", currencyCode())
                .add("TotalInstanceCount", totalInstanceCount()).add("AvailableInstanceCount", availableInstanceCount())
                .add("InUseInstanceCount", inUseInstanceCount())
                .add("TargetResources", hasTargetResources() ? targetResourcesAsStrings() : null)
                .add("ReservedCapacitySummaries", hasReservedCapacitySummaries() ? reservedCapacitySummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrainingPlanArn":
            return Optional.ofNullable(clazz.cast(trainingPlanArn()));
        case "TrainingPlanName":
            return Optional.ofNullable(clazz.cast(trainingPlanName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "DurationHours":
            return Optional.ofNullable(clazz.cast(durationHours()));
        case "DurationMinutes":
            return Optional.ofNullable(clazz.cast(durationMinutes()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "UpfrontFee":
            return Optional.ofNullable(clazz.cast(upfrontFee()));
        case "CurrencyCode":
            return Optional.ofNullable(clazz.cast(currencyCode()));
        case "TotalInstanceCount":
            return Optional.ofNullable(clazz.cast(totalInstanceCount()));
        case "AvailableInstanceCount":
            return Optional.ofNullable(clazz.cast(availableInstanceCount()));
        case "InUseInstanceCount":
            return Optional.ofNullable(clazz.cast(inUseInstanceCount()));
        case "TargetResources":
            return Optional.ofNullable(clazz.cast(targetResourcesAsStrings()));
        case "ReservedCapacitySummaries":
            return Optional.ofNullable(clazz.cast(reservedCapacitySummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TrainingPlanArn", TRAINING_PLAN_ARN_FIELD);
        map.put("TrainingPlanName", TRAINING_PLAN_NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("DurationHours", DURATION_HOURS_FIELD);
        map.put("DurationMinutes", DURATION_MINUTES_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("UpfrontFee", UPFRONT_FEE_FIELD);
        map.put("CurrencyCode", CURRENCY_CODE_FIELD);
        map.put("TotalInstanceCount", TOTAL_INSTANCE_COUNT_FIELD);
        map.put("AvailableInstanceCount", AVAILABLE_INSTANCE_COUNT_FIELD);
        map.put("InUseInstanceCount", IN_USE_INSTANCE_COUNT_FIELD);
        map.put("TargetResources", TARGET_RESOURCES_FIELD);
        map.put("ReservedCapacitySummaries", RESERVED_CAPACITY_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeTrainingPlanResponse, T> g) {
        return obj -> g.apply((DescribeTrainingPlanResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeTrainingPlanResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN); of the training plan.
         * </p>
         * 
         * @param trainingPlanArn
         *        The Amazon Resource Name (ARN); of the training plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingPlanArn(String trainingPlanArn);

        /**
         * <p>
         * The name of the training plan.
         * </p>
         * 
         * @param trainingPlanName
         *        The name of the training plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingPlanName(String trainingPlanName);

        /**
         * <p>
         * The current status of the training plan (e.g., Pending, Active, Expired). To see the complete list of status
         * values available for a training plan, refer to the <code>Status</code> attribute within the
         * <code> <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_TrainingPlanSummary.html">TrainingPlanSummary</a> </code>
         * object.
         * </p>
         * 
         * @param status
         *        The current status of the training plan (e.g., Pending, Active, Expired). To see the complete list of
         *        status values available for a training plan, refer to the <code>Status</code> attribute within the
         *        <code> <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_TrainingPlanSummary.html">TrainingPlanSummary</a> </code>
         *        object.
         * @see TrainingPlanStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainingPlanStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the training plan (e.g., Pending, Active, Expired). To see the complete list of status
         * values available for a training plan, refer to the <code>Status</code> attribute within the
         * <code> <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_TrainingPlanSummary.html">TrainingPlanSummary</a> </code>
         * object.
         * </p>
         * 
         * @param status
         *        The current status of the training plan (e.g., Pending, Active, Expired). To see the complete list of
         *        status values available for a training plan, refer to the <code>Status</code> attribute within the
         *        <code> <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_TrainingPlanSummary.html">TrainingPlanSummary</a> </code>
         *        object.
         * @see TrainingPlanStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainingPlanStatus
         */
        Builder status(TrainingPlanStatus status);

        /**
         * <p>
         * A message providing additional information about the current status of the training plan.
         * </p>
         * 
         * @param statusMessage
         *        A message providing additional information about the current status of the training plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The number of whole hours in the total duration for this training plan.
         * </p>
         * 
         * @param durationHours
         *        The number of whole hours in the total duration for this training plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationHours(Long durationHours);

        /**
         * <p>
         * The additional minutes beyond whole hours in the total duration for this training plan.
         * </p>
         * 
         * @param durationMinutes
         *        The additional minutes beyond whole hours in the total duration for this training plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationMinutes(Long durationMinutes);

        /**
         * <p>
         * The start time of the training plan.
         * </p>
         * 
         * @param startTime
         *        The start time of the training plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The end time of the training plan.
         * </p>
         * 
         * @param endTime
         *        The end time of the training plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The upfront fee for the training plan.
         * </p>
         * 
         * @param upfrontFee
         *        The upfront fee for the training plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upfrontFee(String upfrontFee);

        /**
         * <p>
         * The currency code for the upfront fee (e.g., USD).
         * </p>
         * 
         * @param currencyCode
         *        The currency code for the upfront fee (e.g., USD).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * The total number of instances reserved in this training plan.
         * </p>
         * 
         * @param totalInstanceCount
         *        The total number of instances reserved in this training plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalInstanceCount(Integer totalInstanceCount);

        /**
         * <p>
         * The number of instances currently available for use in this training plan.
         * </p>
         * 
         * @param availableInstanceCount
         *        The number of instances currently available for use in this training plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableInstanceCount(Integer availableInstanceCount);

        /**
         * <p>
         * The number of instances currently in use from this training plan.
         * </p>
         * 
         * @param inUseInstanceCount
         *        The number of instances currently in use from this training plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inUseInstanceCount(Integer inUseInstanceCount);

        /**
         * <p>
         * The target resources (e.g., SageMaker Training Jobs, SageMaker HyperPod) that can use this training plan.
         * </p>
         * <p>
         * Training plans are specific to their target resource.
         * </p>
         * <ul>
         * <li>
         * <p>
         * A training plan designed for SageMaker training jobs can only be used to schedule and run training jobs.
         * </p>
         * </li>
         * <li>
         * <p>
         * A training plan for HyperPod clusters can be used exclusively to provide compute resources to a cluster's
         * instance group.
         * </p>
         * </li>
         * </ul>
         * 
         * @param targetResources
         *        The target resources (e.g., SageMaker Training Jobs, SageMaker HyperPod) that can use this training
         *        plan.</p>
         *        <p>
         *        Training plans are specific to their target resource.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A training plan designed for SageMaker training jobs can only be used to schedule and run training
         *        jobs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A training plan for HyperPod clusters can be used exclusively to provide compute resources to a
         *        cluster's instance group.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetResourcesWithStrings(Collection<String> targetResources);

        /**
         * <p>
         * The target resources (e.g., SageMaker Training Jobs, SageMaker HyperPod) that can use this training plan.
         * </p>
         * <p>
         * Training plans are specific to their target resource.
         * </p>
         * <ul>
         * <li>
         * <p>
         * A training plan designed for SageMaker training jobs can only be used to schedule and run training jobs.
         * </p>
         * </li>
         * <li>
         * <p>
         * A training plan for HyperPod clusters can be used exclusively to provide compute resources to a cluster's
         * instance group.
         * </p>
         * </li>
         * </ul>
         * 
         * @param targetResources
         *        The target resources (e.g., SageMaker Training Jobs, SageMaker HyperPod) that can use this training
         *        plan.</p>
         *        <p>
         *        Training plans are specific to their target resource.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A training plan designed for SageMaker training jobs can only be used to schedule and run training
         *        jobs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A training plan for HyperPod clusters can be used exclusively to provide compute resources to a
         *        cluster's instance group.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetResourcesWithStrings(String... targetResources);

        /**
         * <p>
         * The target resources (e.g., SageMaker Training Jobs, SageMaker HyperPod) that can use this training plan.
         * </p>
         * <p>
         * Training plans are specific to their target resource.
         * </p>
         * <ul>
         * <li>
         * <p>
         * A training plan designed for SageMaker training jobs can only be used to schedule and run training jobs.
         * </p>
         * </li>
         * <li>
         * <p>
         * A training plan for HyperPod clusters can be used exclusively to provide compute resources to a cluster's
         * instance group.
         * </p>
         * </li>
         * </ul>
         * 
         * @param targetResources
         *        The target resources (e.g., SageMaker Training Jobs, SageMaker HyperPod) that can use this training
         *        plan.</p>
         *        <p>
         *        Training plans are specific to their target resource.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A training plan designed for SageMaker training jobs can only be used to schedule and run training
         *        jobs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A training plan for HyperPod clusters can be used exclusively to provide compute resources to a
         *        cluster's instance group.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetResources(Collection<SageMakerResourceName> targetResources);

        /**
         * <p>
         * The target resources (e.g., SageMaker Training Jobs, SageMaker HyperPod) that can use this training plan.
         * </p>
         * <p>
         * Training plans are specific to their target resource.
         * </p>
         * <ul>
         * <li>
         * <p>
         * A training plan designed for SageMaker training jobs can only be used to schedule and run training jobs.
         * </p>
         * </li>
         * <li>
         * <p>
         * A training plan for HyperPod clusters can be used exclusively to provide compute resources to a cluster's
         * instance group.
         * </p>
         * </li>
         * </ul>
         * 
         * @param targetResources
         *        The target resources (e.g., SageMaker Training Jobs, SageMaker HyperPod) that can use this training
         *        plan.</p>
         *        <p>
         *        Training plans are specific to their target resource.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A training plan designed for SageMaker training jobs can only be used to schedule and run training
         *        jobs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A training plan for HyperPod clusters can be used exclusively to provide compute resources to a
         *        cluster's instance group.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetResources(SageMakerResourceName... targetResources);

        /**
         * <p>
         * The list of Reserved Capacity providing the underlying compute resources of the plan.
         * </p>
         * 
         * @param reservedCapacitySummaries
         *        The list of Reserved Capacity providing the underlying compute resources of the plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedCapacitySummaries(Collection<ReservedCapacitySummary> reservedCapacitySummaries);

        /**
         * <p>
         * The list of Reserved Capacity providing the underlying compute resources of the plan.
         * </p>
         * 
         * @param reservedCapacitySummaries
         *        The list of Reserved Capacity providing the underlying compute resources of the plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedCapacitySummaries(ReservedCapacitySummary... reservedCapacitySummaries);

        /**
         * <p>
         * The list of Reserved Capacity providing the underlying compute resources of the plan.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.ReservedCapacitySummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.ReservedCapacitySummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.ReservedCapacitySummary.Builder#build()} is called
         * immediately and its result is passed to {@link #reservedCapacitySummaries(List<ReservedCapacitySummary>)}.
         * 
         * @param reservedCapacitySummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.ReservedCapacitySummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reservedCapacitySummaries(java.util.Collection<ReservedCapacitySummary>)
         */
        Builder reservedCapacitySummaries(Consumer<ReservedCapacitySummary.Builder>... reservedCapacitySummaries);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String trainingPlanArn;

        private String trainingPlanName;

        private String status;

        private String statusMessage;

        private Long durationHours;

        private Long durationMinutes;

        private Instant startTime;

        private Instant endTime;

        private String upfrontFee;

        private String currencyCode;

        private Integer totalInstanceCount;

        private Integer availableInstanceCount;

        private Integer inUseInstanceCount;

        private List<String> targetResources = DefaultSdkAutoConstructList.getInstance();

        private List<ReservedCapacitySummary> reservedCapacitySummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTrainingPlanResponse model) {
            super(model);
            trainingPlanArn(model.trainingPlanArn);
            trainingPlanName(model.trainingPlanName);
            status(model.status);
            statusMessage(model.statusMessage);
            durationHours(model.durationHours);
            durationMinutes(model.durationMinutes);
            startTime(model.startTime);
            endTime(model.endTime);
            upfrontFee(model.upfrontFee);
            currencyCode(model.currencyCode);
            totalInstanceCount(model.totalInstanceCount);
            availableInstanceCount(model.availableInstanceCount);
            inUseInstanceCount(model.inUseInstanceCount);
            targetResourcesWithStrings(model.targetResources);
            reservedCapacitySummaries(model.reservedCapacitySummaries);
        }

        public final String getTrainingPlanArn() {
            return trainingPlanArn;
        }

        public final void setTrainingPlanArn(String trainingPlanArn) {
            this.trainingPlanArn = trainingPlanArn;
        }

        @Override
        public final Builder trainingPlanArn(String trainingPlanArn) {
            this.trainingPlanArn = trainingPlanArn;
            return this;
        }

        public final String getTrainingPlanName() {
            return trainingPlanName;
        }

        public final void setTrainingPlanName(String trainingPlanName) {
            this.trainingPlanName = trainingPlanName;
        }

        @Override
        public final Builder trainingPlanName(String trainingPlanName) {
            this.trainingPlanName = trainingPlanName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TrainingPlanStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Long getDurationHours() {
            return durationHours;
        }

        public final void setDurationHours(Long durationHours) {
            this.durationHours = durationHours;
        }

        @Override
        public final Builder durationHours(Long durationHours) {
            this.durationHours = durationHours;
            return this;
        }

        public final Long getDurationMinutes() {
            return durationMinutes;
        }

        public final void setDurationMinutes(Long durationMinutes) {
            this.durationMinutes = durationMinutes;
        }

        @Override
        public final Builder durationMinutes(Long durationMinutes) {
            this.durationMinutes = durationMinutes;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getUpfrontFee() {
            return upfrontFee;
        }

        public final void setUpfrontFee(String upfrontFee) {
            this.upfrontFee = upfrontFee;
        }

        @Override
        public final Builder upfrontFee(String upfrontFee) {
            this.upfrontFee = upfrontFee;
            return this;
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final Integer getTotalInstanceCount() {
            return totalInstanceCount;
        }

        public final void setTotalInstanceCount(Integer totalInstanceCount) {
            this.totalInstanceCount = totalInstanceCount;
        }

        @Override
        public final Builder totalInstanceCount(Integer totalInstanceCount) {
            this.totalInstanceCount = totalInstanceCount;
            return this;
        }

        public final Integer getAvailableInstanceCount() {
            return availableInstanceCount;
        }

        public final void setAvailableInstanceCount(Integer availableInstanceCount) {
            this.availableInstanceCount = availableInstanceCount;
        }

        @Override
        public final Builder availableInstanceCount(Integer availableInstanceCount) {
            this.availableInstanceCount = availableInstanceCount;
            return this;
        }

        public final Integer getInUseInstanceCount() {
            return inUseInstanceCount;
        }

        public final void setInUseInstanceCount(Integer inUseInstanceCount) {
            this.inUseInstanceCount = inUseInstanceCount;
        }

        @Override
        public final Builder inUseInstanceCount(Integer inUseInstanceCount) {
            this.inUseInstanceCount = inUseInstanceCount;
            return this;
        }

        public final Collection<String> getTargetResources() {
            if (targetResources instanceof SdkAutoConstructList) {
                return null;
            }
            return targetResources;
        }

        public final void setTargetResources(Collection<String> targetResources) {
            this.targetResources = SageMakerResourceNamesCopier.copy(targetResources);
        }

        @Override
        public final Builder targetResourcesWithStrings(Collection<String> targetResources) {
            this.targetResources = SageMakerResourceNamesCopier.copy(targetResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetResourcesWithStrings(String... targetResources) {
            targetResourcesWithStrings(Arrays.asList(targetResources));
            return this;
        }

        @Override
        public final Builder targetResources(Collection<SageMakerResourceName> targetResources) {
            this.targetResources = SageMakerResourceNamesCopier.copyEnumToString(targetResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetResources(SageMakerResourceName... targetResources) {
            targetResources(Arrays.asList(targetResources));
            return this;
        }

        public final List<ReservedCapacitySummary.Builder> getReservedCapacitySummaries() {
            List<ReservedCapacitySummary.Builder> result = ReservedCapacitySummariesCopier
                    .copyToBuilder(this.reservedCapacitySummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReservedCapacitySummaries(Collection<ReservedCapacitySummary.BuilderImpl> reservedCapacitySummaries) {
            this.reservedCapacitySummaries = ReservedCapacitySummariesCopier.copyFromBuilder(reservedCapacitySummaries);
        }

        @Override
        public final Builder reservedCapacitySummaries(Collection<ReservedCapacitySummary> reservedCapacitySummaries) {
            this.reservedCapacitySummaries = ReservedCapacitySummariesCopier.copy(reservedCapacitySummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedCapacitySummaries(ReservedCapacitySummary... reservedCapacitySummaries) {
            reservedCapacitySummaries(Arrays.asList(reservedCapacitySummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedCapacitySummaries(Consumer<ReservedCapacitySummary.Builder>... reservedCapacitySummaries) {
            reservedCapacitySummaries(Stream.of(reservedCapacitySummaries)
                    .map(c -> ReservedCapacitySummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeTrainingPlanResponse build() {
            return new DescribeTrainingPlanResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
