/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The settings for assigning a custom Amazon EFS file system to a user profile or space for an Amazon SageMaker AI
 * Domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EFSFileSystemConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<EFSFileSystemConfig.Builder, EFSFileSystemConfig> {
    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileSystemId").getter(getter(EFSFileSystemConfig::fileSystemId)).setter(setter(Builder::fileSystemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemId").build()).build();

    private static final SdkField<String> FILE_SYSTEM_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileSystemPath").getter(getter(EFSFileSystemConfig::fileSystemPath))
            .setter(setter(Builder::fileSystemPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemPath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SYSTEM_ID_FIELD,
            FILE_SYSTEM_PATH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String fileSystemId;

    private final String fileSystemPath;

    private EFSFileSystemConfig(BuilderImpl builder) {
        this.fileSystemId = builder.fileSystemId;
        this.fileSystemPath = builder.fileSystemPath;
    }

    /**
     * <p>
     * The ID of your Amazon EFS file system.
     * </p>
     * 
     * @return The ID of your Amazon EFS file system.
     */
    public final String fileSystemId() {
        return fileSystemId;
    }

    /**
     * <p>
     * The path to the file system directory that is accessible in Amazon SageMaker AI Studio. Permitted users can
     * access only this directory and below.
     * </p>
     * 
     * @return The path to the file system directory that is accessible in Amazon SageMaker AI Studio. Permitted users
     *         can access only this directory and below.
     */
    public final String fileSystemPath() {
        return fileSystemPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemPath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EFSFileSystemConfig)) {
            return false;
        }
        EFSFileSystemConfig other = (EFSFileSystemConfig) obj;
        return Objects.equals(fileSystemId(), other.fileSystemId()) && Objects.equals(fileSystemPath(), other.fileSystemPath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EFSFileSystemConfig").add("FileSystemId", fileSystemId())
                .add("FileSystemPath", fileSystemPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileSystemId":
            return Optional.ofNullable(clazz.cast(fileSystemId()));
        case "FileSystemPath":
            return Optional.ofNullable(clazz.cast(fileSystemPath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FileSystemId", FILE_SYSTEM_ID_FIELD);
        map.put("FileSystemPath", FILE_SYSTEM_PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EFSFileSystemConfig, T> g) {
        return obj -> g.apply((EFSFileSystemConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EFSFileSystemConfig> {
        /**
         * <p>
         * The ID of your Amazon EFS file system.
         * </p>
         * 
         * @param fileSystemId
         *        The ID of your Amazon EFS file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemId(String fileSystemId);

        /**
         * <p>
         * The path to the file system directory that is accessible in Amazon SageMaker AI Studio. Permitted users can
         * access only this directory and below.
         * </p>
         * 
         * @param fileSystemPath
         *        The path to the file system directory that is accessible in Amazon SageMaker AI Studio. Permitted
         *        users can access only this directory and below.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemPath(String fileSystemPath);
    }

    static final class BuilderImpl implements Builder {
        private String fileSystemId;

        private String fileSystemPath;

        private BuilderImpl() {
        }

        private BuilderImpl(EFSFileSystemConfig model) {
            fileSystemId(model.fileSystemId);
            fileSystemPath(model.fileSystemPath);
        }

        public final String getFileSystemId() {
            return fileSystemId;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final String getFileSystemPath() {
            return fileSystemPath;
        }

        public final void setFileSystemPath(String fileSystemPath) {
            this.fileSystemPath = fileSystemPath;
        }

        @Override
        public final Builder fileSystemPath(String fileSystemPath) {
            this.fileSystemPath = fileSystemPath;
            return this;
        }

        @Override
        public EFSFileSystemConfig build() {
            return new EFSFileSystemConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
