/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration information for the infrastructure health check of a training job. A SageMaker-provided health check
 * tests the health of instance hardware and cluster network connectivity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InfraCheckConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<InfraCheckConfig.Builder, InfraCheckConfig> {
    private static final SdkField<Boolean> ENABLE_INFRA_CHECK_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableInfraCheck").getter(getter(InfraCheckConfig::enableInfraCheck))
            .setter(setter(Builder::enableInfraCheck))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableInfraCheck").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLE_INFRA_CHECK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean enableInfraCheck;

    private InfraCheckConfig(BuilderImpl builder) {
        this.enableInfraCheck = builder.enableInfraCheck;
    }

    /**
     * <p>
     * Enables an infrastructure health check.
     * </p>
     * 
     * @return Enables an infrastructure health check.
     */
    public final Boolean enableInfraCheck() {
        return enableInfraCheck;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enableInfraCheck());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InfraCheckConfig)) {
            return false;
        }
        InfraCheckConfig other = (InfraCheckConfig) obj;
        return Objects.equals(enableInfraCheck(), other.enableInfraCheck());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InfraCheckConfig").add("EnableInfraCheck", enableInfraCheck()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnableInfraCheck":
            return Optional.ofNullable(clazz.cast(enableInfraCheck()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EnableInfraCheck", ENABLE_INFRA_CHECK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InfraCheckConfig, T> g) {
        return obj -> g.apply((InfraCheckConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InfraCheckConfig> {
        /**
         * <p>
         * Enables an infrastructure health check.
         * </p>
         * 
         * @param enableInfraCheck
         *        Enables an infrastructure health check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableInfraCheck(Boolean enableInfraCheck);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enableInfraCheck;

        private BuilderImpl() {
        }

        private BuilderImpl(InfraCheckConfig model) {
            enableInfraCheck(model.enableInfraCheck);
        }

        public final Boolean getEnableInfraCheck() {
            return enableInfraCheck;
        }

        public final void setEnableInfraCheck(Boolean enableInfraCheck) {
            this.enableInfraCheck = enableInfraCheck;
        }

        @Override
        public final Builder enableInfraCheck(Boolean enableInfraCheck) {
            this.enableInfraCheck = enableInfraCheck;
            return this;
        }

        @Override
        public InfraCheckConfig build() {
            return new InfraCheckConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
