/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides summary information about a labeling job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LabelingJobSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<LabelingJobSummary.Builder, LabelingJobSummary> {
    private static final SdkField<String> LABELING_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LabelingJobName").getter(getter(LabelingJobSummary::labelingJobName))
            .setter(setter(Builder::labelingJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelingJobName").build()).build();

    private static final SdkField<String> LABELING_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LabelingJobArn").getter(getter(LabelingJobSummary::labelingJobArn))
            .setter(setter(Builder::labelingJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelingJobArn").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(LabelingJobSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(LabelingJobSummary::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> LABELING_JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LabelingJobStatus").getter(getter(LabelingJobSummary::labelingJobStatusAsString))
            .setter(setter(Builder::labelingJobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelingJobStatus").build()).build();

    private static final SdkField<LabelCounters> LABEL_COUNTERS_FIELD = SdkField
            .<LabelCounters> builder(MarshallingType.SDK_POJO).memberName("LabelCounters")
            .getter(getter(LabelingJobSummary::labelCounters)).setter(setter(Builder::labelCounters))
            .constructor(LabelCounters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelCounters").build()).build();

    private static final SdkField<String> WORKTEAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkteamArn").getter(getter(LabelingJobSummary::workteamArn)).setter(setter(Builder::workteamArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkteamArn").build()).build();

    private static final SdkField<String> PRE_HUMAN_TASK_LAMBDA_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PreHumanTaskLambdaArn").getter(getter(LabelingJobSummary::preHumanTaskLambdaArn))
            .setter(setter(Builder::preHumanTaskLambdaArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreHumanTaskLambdaArn").build())
            .build();

    private static final SdkField<String> ANNOTATION_CONSOLIDATION_LAMBDA_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AnnotationConsolidationLambdaArn")
            .getter(getter(LabelingJobSummary::annotationConsolidationLambdaArn))
            .setter(setter(Builder::annotationConsolidationLambdaArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnnotationConsolidationLambdaArn")
                    .build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(LabelingJobSummary::failureReason)).setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<LabelingJobOutput> LABELING_JOB_OUTPUT_FIELD = SdkField
            .<LabelingJobOutput> builder(MarshallingType.SDK_POJO).memberName("LabelingJobOutput")
            .getter(getter(LabelingJobSummary::labelingJobOutput)).setter(setter(Builder::labelingJobOutput))
            .constructor(LabelingJobOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelingJobOutput").build()).build();

    private static final SdkField<LabelingJobInputConfig> INPUT_CONFIG_FIELD = SdkField
            .<LabelingJobInputConfig> builder(MarshallingType.SDK_POJO).memberName("InputConfig")
            .getter(getter(LabelingJobSummary::inputConfig)).setter(setter(Builder::inputConfig))
            .constructor(LabelingJobInputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABELING_JOB_NAME_FIELD,
            LABELING_JOB_ARN_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, LABELING_JOB_STATUS_FIELD,
            LABEL_COUNTERS_FIELD, WORKTEAM_ARN_FIELD, PRE_HUMAN_TASK_LAMBDA_ARN_FIELD, ANNOTATION_CONSOLIDATION_LAMBDA_ARN_FIELD,
            FAILURE_REASON_FIELD, LABELING_JOB_OUTPUT_FIELD, INPUT_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String labelingJobName;

    private final String labelingJobArn;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private final String labelingJobStatus;

    private final LabelCounters labelCounters;

    private final String workteamArn;

    private final String preHumanTaskLambdaArn;

    private final String annotationConsolidationLambdaArn;

    private final String failureReason;

    private final LabelingJobOutput labelingJobOutput;

    private final LabelingJobInputConfig inputConfig;

    private LabelingJobSummary(BuilderImpl builder) {
        this.labelingJobName = builder.labelingJobName;
        this.labelingJobArn = builder.labelingJobArn;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.labelingJobStatus = builder.labelingJobStatus;
        this.labelCounters = builder.labelCounters;
        this.workteamArn = builder.workteamArn;
        this.preHumanTaskLambdaArn = builder.preHumanTaskLambdaArn;
        this.annotationConsolidationLambdaArn = builder.annotationConsolidationLambdaArn;
        this.failureReason = builder.failureReason;
        this.labelingJobOutput = builder.labelingJobOutput;
        this.inputConfig = builder.inputConfig;
    }

    /**
     * <p>
     * The name of the labeling job.
     * </p>
     * 
     * @return The name of the labeling job.
     */
    public final String labelingJobName() {
        return labelingJobName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) assigned to the labeling job when it was created.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) assigned to the labeling job when it was created.
     */
    public final String labelingJobArn() {
        return labelingJobArn;
    }

    /**
     * <p>
     * The date and time that the job was created (timestamp).
     * </p>
     * 
     * @return The date and time that the job was created (timestamp).
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The date and time that the job was last modified (timestamp).
     * </p>
     * 
     * @return The date and time that the job was last modified (timestamp).
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The current status of the labeling job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #labelingJobStatus}
     * will return {@link LabelingJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #labelingJobStatusAsString}.
     * </p>
     * 
     * @return The current status of the labeling job.
     * @see LabelingJobStatus
     */
    public final LabelingJobStatus labelingJobStatus() {
        return LabelingJobStatus.fromValue(labelingJobStatus);
    }

    /**
     * <p>
     * The current status of the labeling job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #labelingJobStatus}
     * will return {@link LabelingJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #labelingJobStatusAsString}.
     * </p>
     * 
     * @return The current status of the labeling job.
     * @see LabelingJobStatus
     */
    public final String labelingJobStatusAsString() {
        return labelingJobStatus;
    }

    /**
     * <p>
     * Counts showing the progress of the labeling job.
     * </p>
     * 
     * @return Counts showing the progress of the labeling job.
     */
    public final LabelCounters labelCounters() {
        return labelCounters;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the work team assigned to the job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the work team assigned to the job.
     */
    public final String workteamArn() {
        return workteamArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a Lambda function. The function is run before each data object is sent to a
     * worker.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a Lambda function. The function is run before each data object is sent
     *         to a worker.
     */
    public final String preHumanTaskLambdaArn() {
        return preHumanTaskLambdaArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Lambda function used to consolidate the annotations from individual workers
     * into a label for a data object. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-annotation-consolidation.html">Annotation
     * Consolidation</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Lambda function used to consolidate the annotations from individual
     *         workers into a label for a data object. For more information, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-annotation-consolidation.html">Annotation
     *         Consolidation</a>.
     */
    public final String annotationConsolidationLambdaArn() {
        return annotationConsolidationLambdaArn;
    }

    /**
     * <p>
     * If the <code>LabelingJobStatus</code> field is <code>Failed</code>, this field contains a description of the
     * error.
     * </p>
     * 
     * @return If the <code>LabelingJobStatus</code> field is <code>Failed</code>, this field contains a description of
     *         the error.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The location of the output produced by the labeling job.
     * </p>
     * 
     * @return The location of the output produced by the labeling job.
     */
    public final LabelingJobOutput labelingJobOutput() {
        return labelingJobOutput;
    }

    /**
     * <p>
     * Input configuration for the labeling job.
     * </p>
     * 
     * @return Input configuration for the labeling job.
     */
    public final LabelingJobInputConfig inputConfig() {
        return inputConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(labelingJobName());
        hashCode = 31 * hashCode + Objects.hashCode(labelingJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(labelingJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(labelCounters());
        hashCode = 31 * hashCode + Objects.hashCode(workteamArn());
        hashCode = 31 * hashCode + Objects.hashCode(preHumanTaskLambdaArn());
        hashCode = 31 * hashCode + Objects.hashCode(annotationConsolidationLambdaArn());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(labelingJobOutput());
        hashCode = 31 * hashCode + Objects.hashCode(inputConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LabelingJobSummary)) {
            return false;
        }
        LabelingJobSummary other = (LabelingJobSummary) obj;
        return Objects.equals(labelingJobName(), other.labelingJobName())
                && Objects.equals(labelingJobArn(), other.labelingJobArn())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(labelingJobStatusAsString(), other.labelingJobStatusAsString())
                && Objects.equals(labelCounters(), other.labelCounters()) && Objects.equals(workteamArn(), other.workteamArn())
                && Objects.equals(preHumanTaskLambdaArn(), other.preHumanTaskLambdaArn())
                && Objects.equals(annotationConsolidationLambdaArn(), other.annotationConsolidationLambdaArn())
                && Objects.equals(failureReason(), other.failureReason())
                && Objects.equals(labelingJobOutput(), other.labelingJobOutput())
                && Objects.equals(inputConfig(), other.inputConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LabelingJobSummary").add("LabelingJobName", labelingJobName())
                .add("LabelingJobArn", labelingJobArn()).add("CreationTime", creationTime())
                .add("LastModifiedTime", lastModifiedTime()).add("LabelingJobStatus", labelingJobStatusAsString())
                .add("LabelCounters", labelCounters()).add("WorkteamArn", workteamArn())
                .add("PreHumanTaskLambdaArn", preHumanTaskLambdaArn())
                .add("AnnotationConsolidationLambdaArn", annotationConsolidationLambdaArn())
                .add("FailureReason", failureReason()).add("LabelingJobOutput", labelingJobOutput())
                .add("InputConfig", inputConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LabelingJobName":
            return Optional.ofNullable(clazz.cast(labelingJobName()));
        case "LabelingJobArn":
            return Optional.ofNullable(clazz.cast(labelingJobArn()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "LabelingJobStatus":
            return Optional.ofNullable(clazz.cast(labelingJobStatusAsString()));
        case "LabelCounters":
            return Optional.ofNullable(clazz.cast(labelCounters()));
        case "WorkteamArn":
            return Optional.ofNullable(clazz.cast(workteamArn()));
        case "PreHumanTaskLambdaArn":
            return Optional.ofNullable(clazz.cast(preHumanTaskLambdaArn()));
        case "AnnotationConsolidationLambdaArn":
            return Optional.ofNullable(clazz.cast(annotationConsolidationLambdaArn()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "LabelingJobOutput":
            return Optional.ofNullable(clazz.cast(labelingJobOutput()));
        case "InputConfig":
            return Optional.ofNullable(clazz.cast(inputConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LabelingJobName", LABELING_JOB_NAME_FIELD);
        map.put("LabelingJobArn", LABELING_JOB_ARN_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("LabelingJobStatus", LABELING_JOB_STATUS_FIELD);
        map.put("LabelCounters", LABEL_COUNTERS_FIELD);
        map.put("WorkteamArn", WORKTEAM_ARN_FIELD);
        map.put("PreHumanTaskLambdaArn", PRE_HUMAN_TASK_LAMBDA_ARN_FIELD);
        map.put("AnnotationConsolidationLambdaArn", ANNOTATION_CONSOLIDATION_LAMBDA_ARN_FIELD);
        map.put("FailureReason", FAILURE_REASON_FIELD);
        map.put("LabelingJobOutput", LABELING_JOB_OUTPUT_FIELD);
        map.put("InputConfig", INPUT_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LabelingJobSummary, T> g) {
        return obj -> g.apply((LabelingJobSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LabelingJobSummary> {
        /**
         * <p>
         * The name of the labeling job.
         * </p>
         * 
         * @param labelingJobName
         *        The name of the labeling job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelingJobName(String labelingJobName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) assigned to the labeling job when it was created.
         * </p>
         * 
         * @param labelingJobArn
         *        The Amazon Resource Name (ARN) assigned to the labeling job when it was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelingJobArn(String labelingJobArn);

        /**
         * <p>
         * The date and time that the job was created (timestamp).
         * </p>
         * 
         * @param creationTime
         *        The date and time that the job was created (timestamp).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The date and time that the job was last modified (timestamp).
         * </p>
         * 
         * @param lastModifiedTime
         *        The date and time that the job was last modified (timestamp).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The current status of the labeling job.
         * </p>
         * 
         * @param labelingJobStatus
         *        The current status of the labeling job.
         * @see LabelingJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LabelingJobStatus
         */
        Builder labelingJobStatus(String labelingJobStatus);

        /**
         * <p>
         * The current status of the labeling job.
         * </p>
         * 
         * @param labelingJobStatus
         *        The current status of the labeling job.
         * @see LabelingJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LabelingJobStatus
         */
        Builder labelingJobStatus(LabelingJobStatus labelingJobStatus);

        /**
         * <p>
         * Counts showing the progress of the labeling job.
         * </p>
         * 
         * @param labelCounters
         *        Counts showing the progress of the labeling job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelCounters(LabelCounters labelCounters);

        /**
         * <p>
         * Counts showing the progress of the labeling job.
         * </p>
         * This is a convenience method that creates an instance of the {@link LabelCounters.Builder} avoiding the need
         * to create one manually via {@link LabelCounters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LabelCounters.Builder#build()} is called immediately and its
         * result is passed to {@link #labelCounters(LabelCounters)}.
         * 
         * @param labelCounters
         *        a consumer that will call methods on {@link LabelCounters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #labelCounters(LabelCounters)
         */
        default Builder labelCounters(Consumer<LabelCounters.Builder> labelCounters) {
            return labelCounters(LabelCounters.builder().applyMutation(labelCounters).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the work team assigned to the job.
         * </p>
         * 
         * @param workteamArn
         *        The Amazon Resource Name (ARN) of the work team assigned to the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workteamArn(String workteamArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a Lambda function. The function is run before each data object is sent to a
         * worker.
         * </p>
         * 
         * @param preHumanTaskLambdaArn
         *        The Amazon Resource Name (ARN) of a Lambda function. The function is run before each data object is
         *        sent to a worker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preHumanTaskLambdaArn(String preHumanTaskLambdaArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Lambda function used to consolidate the annotations from individual
         * workers into a label for a data object. For more information, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-annotation-consolidation.html">Annotation
         * Consolidation</a>.
         * </p>
         * 
         * @param annotationConsolidationLambdaArn
         *        The Amazon Resource Name (ARN) of the Lambda function used to consolidate the annotations from
         *        individual workers into a label for a data object. For more information, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-annotation-consolidation.html">Annotation
         *        Consolidation</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder annotationConsolidationLambdaArn(String annotationConsolidationLambdaArn);

        /**
         * <p>
         * If the <code>LabelingJobStatus</code> field is <code>Failed</code>, this field contains a description of the
         * error.
         * </p>
         * 
         * @param failureReason
         *        If the <code>LabelingJobStatus</code> field is <code>Failed</code>, this field contains a description
         *        of the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The location of the output produced by the labeling job.
         * </p>
         * 
         * @param labelingJobOutput
         *        The location of the output produced by the labeling job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelingJobOutput(LabelingJobOutput labelingJobOutput);

        /**
         * <p>
         * The location of the output produced by the labeling job.
         * </p>
         * This is a convenience method that creates an instance of the {@link LabelingJobOutput.Builder} avoiding the
         * need to create one manually via {@link LabelingJobOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LabelingJobOutput.Builder#build()} is called immediately and its
         * result is passed to {@link #labelingJobOutput(LabelingJobOutput)}.
         * 
         * @param labelingJobOutput
         *        a consumer that will call methods on {@link LabelingJobOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #labelingJobOutput(LabelingJobOutput)
         */
        default Builder labelingJobOutput(Consumer<LabelingJobOutput.Builder> labelingJobOutput) {
            return labelingJobOutput(LabelingJobOutput.builder().applyMutation(labelingJobOutput).build());
        }

        /**
         * <p>
         * Input configuration for the labeling job.
         * </p>
         * 
         * @param inputConfig
         *        Input configuration for the labeling job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputConfig(LabelingJobInputConfig inputConfig);

        /**
         * <p>
         * Input configuration for the labeling job.
         * </p>
         * This is a convenience method that creates an instance of the {@link LabelingJobInputConfig.Builder} avoiding
         * the need to create one manually via {@link LabelingJobInputConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LabelingJobInputConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #inputConfig(LabelingJobInputConfig)}.
         * 
         * @param inputConfig
         *        a consumer that will call methods on {@link LabelingJobInputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputConfig(LabelingJobInputConfig)
         */
        default Builder inputConfig(Consumer<LabelingJobInputConfig.Builder> inputConfig) {
            return inputConfig(LabelingJobInputConfig.builder().applyMutation(inputConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String labelingJobName;

        private String labelingJobArn;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private String labelingJobStatus;

        private LabelCounters labelCounters;

        private String workteamArn;

        private String preHumanTaskLambdaArn;

        private String annotationConsolidationLambdaArn;

        private String failureReason;

        private LabelingJobOutput labelingJobOutput;

        private LabelingJobInputConfig inputConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(LabelingJobSummary model) {
            labelingJobName(model.labelingJobName);
            labelingJobArn(model.labelingJobArn);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
            labelingJobStatus(model.labelingJobStatus);
            labelCounters(model.labelCounters);
            workteamArn(model.workteamArn);
            preHumanTaskLambdaArn(model.preHumanTaskLambdaArn);
            annotationConsolidationLambdaArn(model.annotationConsolidationLambdaArn);
            failureReason(model.failureReason);
            labelingJobOutput(model.labelingJobOutput);
            inputConfig(model.inputConfig);
        }

        public final String getLabelingJobName() {
            return labelingJobName;
        }

        public final void setLabelingJobName(String labelingJobName) {
            this.labelingJobName = labelingJobName;
        }

        @Override
        public final Builder labelingJobName(String labelingJobName) {
            this.labelingJobName = labelingJobName;
            return this;
        }

        public final String getLabelingJobArn() {
            return labelingJobArn;
        }

        public final void setLabelingJobArn(String labelingJobArn) {
            this.labelingJobArn = labelingJobArn;
        }

        @Override
        public final Builder labelingJobArn(String labelingJobArn) {
            this.labelingJobArn = labelingJobArn;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getLabelingJobStatus() {
            return labelingJobStatus;
        }

        public final void setLabelingJobStatus(String labelingJobStatus) {
            this.labelingJobStatus = labelingJobStatus;
        }

        @Override
        public final Builder labelingJobStatus(String labelingJobStatus) {
            this.labelingJobStatus = labelingJobStatus;
            return this;
        }

        @Override
        public final Builder labelingJobStatus(LabelingJobStatus labelingJobStatus) {
            this.labelingJobStatus(labelingJobStatus == null ? null : labelingJobStatus.toString());
            return this;
        }

        public final LabelCounters.Builder getLabelCounters() {
            return labelCounters != null ? labelCounters.toBuilder() : null;
        }

        public final void setLabelCounters(LabelCounters.BuilderImpl labelCounters) {
            this.labelCounters = labelCounters != null ? labelCounters.build() : null;
        }

        @Override
        public final Builder labelCounters(LabelCounters labelCounters) {
            this.labelCounters = labelCounters;
            return this;
        }

        public final String getWorkteamArn() {
            return workteamArn;
        }

        public final void setWorkteamArn(String workteamArn) {
            this.workteamArn = workteamArn;
        }

        @Override
        public final Builder workteamArn(String workteamArn) {
            this.workteamArn = workteamArn;
            return this;
        }

        public final String getPreHumanTaskLambdaArn() {
            return preHumanTaskLambdaArn;
        }

        public final void setPreHumanTaskLambdaArn(String preHumanTaskLambdaArn) {
            this.preHumanTaskLambdaArn = preHumanTaskLambdaArn;
        }

        @Override
        public final Builder preHumanTaskLambdaArn(String preHumanTaskLambdaArn) {
            this.preHumanTaskLambdaArn = preHumanTaskLambdaArn;
            return this;
        }

        public final String getAnnotationConsolidationLambdaArn() {
            return annotationConsolidationLambdaArn;
        }

        public final void setAnnotationConsolidationLambdaArn(String annotationConsolidationLambdaArn) {
            this.annotationConsolidationLambdaArn = annotationConsolidationLambdaArn;
        }

        @Override
        public final Builder annotationConsolidationLambdaArn(String annotationConsolidationLambdaArn) {
            this.annotationConsolidationLambdaArn = annotationConsolidationLambdaArn;
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final LabelingJobOutput.Builder getLabelingJobOutput() {
            return labelingJobOutput != null ? labelingJobOutput.toBuilder() : null;
        }

        public final void setLabelingJobOutput(LabelingJobOutput.BuilderImpl labelingJobOutput) {
            this.labelingJobOutput = labelingJobOutput != null ? labelingJobOutput.build() : null;
        }

        @Override
        public final Builder labelingJobOutput(LabelingJobOutput labelingJobOutput) {
            this.labelingJobOutput = labelingJobOutput;
            return this;
        }

        public final LabelingJobInputConfig.Builder getInputConfig() {
            return inputConfig != null ? inputConfig.toBuilder() : null;
        }

        public final void setInputConfig(LabelingJobInputConfig.BuilderImpl inputConfig) {
            this.inputConfig = inputConfig != null ? inputConfig.build() : null;
        }

        @Override
        public final Builder inputConfig(LabelingJobInputConfig inputConfig) {
            this.inputConfig = inputConfig;
            return this;
        }

        @Override
        public LabelingJobSummary build() {
            return new LabelingJobSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
