/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListClusterNodesResponse extends SageMakerResponse implements
        ToCopyableBuilder<ListClusterNodesResponse.Builder, ListClusterNodesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListClusterNodesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<ClusterNodeSummary>> CLUSTER_NODE_SUMMARIES_FIELD = SdkField
            .<List<ClusterNodeSummary>> builder(MarshallingType.LIST)
            .memberName("ClusterNodeSummaries")
            .getter(getter(ListClusterNodesResponse::clusterNodeSummaries))
            .setter(setter(Builder::clusterNodeSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterNodeSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ClusterNodeSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ClusterNodeSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            CLUSTER_NODE_SUMMARIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<ClusterNodeSummary> clusterNodeSummaries;

    private ListClusterNodesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.clusterNodeSummaries = builder.clusterNodeSummaries;
    }

    /**
     * <p>
     * The next token specified for listing instances in a SageMaker HyperPod cluster.
     * </p>
     * 
     * @return The next token specified for listing instances in a SageMaker HyperPod cluster.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ClusterNodeSummaries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasClusterNodeSummaries() {
        return clusterNodeSummaries != null && !(clusterNodeSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The summaries of listed instances in a SageMaker HyperPod cluster
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClusterNodeSummaries} method.
     * </p>
     * 
     * @return The summaries of listed instances in a SageMaker HyperPod cluster
     */
    public final List<ClusterNodeSummary> clusterNodeSummaries() {
        return clusterNodeSummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasClusterNodeSummaries() ? clusterNodeSummaries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClusterNodesResponse)) {
            return false;
        }
        ListClusterNodesResponse other = (ListClusterNodesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasClusterNodeSummaries() == other.hasClusterNodeSummaries()
                && Objects.equals(clusterNodeSummaries(), other.clusterNodeSummaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListClusterNodesResponse").add("NextToken", nextToken())
                .add("ClusterNodeSummaries", hasClusterNodeSummaries() ? clusterNodeSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ClusterNodeSummaries":
            return Optional.ofNullable(clazz.cast(clusterNodeSummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("ClusterNodeSummaries", CLUSTER_NODE_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListClusterNodesResponse, T> g) {
        return obj -> g.apply((ListClusterNodesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListClusterNodesResponse> {
        /**
         * <p>
         * The next token specified for listing instances in a SageMaker HyperPod cluster.
         * </p>
         * 
         * @param nextToken
         *        The next token specified for listing instances in a SageMaker HyperPod cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The summaries of listed instances in a SageMaker HyperPod cluster
         * </p>
         * 
         * @param clusterNodeSummaries
         *        The summaries of listed instances in a SageMaker HyperPod cluster
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterNodeSummaries(Collection<ClusterNodeSummary> clusterNodeSummaries);

        /**
         * <p>
         * The summaries of listed instances in a SageMaker HyperPod cluster
         * </p>
         * 
         * @param clusterNodeSummaries
         *        The summaries of listed instances in a SageMaker HyperPod cluster
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterNodeSummaries(ClusterNodeSummary... clusterNodeSummaries);

        /**
         * <p>
         * The summaries of listed instances in a SageMaker HyperPod cluster
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.ClusterNodeSummary.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.sagemaker.model.ClusterNodeSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.ClusterNodeSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #clusterNodeSummaries(List<ClusterNodeSummary>)}.
         * 
         * @param clusterNodeSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.ClusterNodeSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clusterNodeSummaries(java.util.Collection<ClusterNodeSummary>)
         */
        Builder clusterNodeSummaries(Consumer<ClusterNodeSummary.Builder>... clusterNodeSummaries);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ClusterNodeSummary> clusterNodeSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListClusterNodesResponse model) {
            super(model);
            nextToken(model.nextToken);
            clusterNodeSummaries(model.clusterNodeSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ClusterNodeSummary.Builder> getClusterNodeSummaries() {
            List<ClusterNodeSummary.Builder> result = ClusterNodeSummariesCopier.copyToBuilder(this.clusterNodeSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClusterNodeSummaries(Collection<ClusterNodeSummary.BuilderImpl> clusterNodeSummaries) {
            this.clusterNodeSummaries = ClusterNodeSummariesCopier.copyFromBuilder(clusterNodeSummaries);
        }

        @Override
        public final Builder clusterNodeSummaries(Collection<ClusterNodeSummary> clusterNodeSummaries) {
            this.clusterNodeSummaries = ClusterNodeSummariesCopier.copy(clusterNodeSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterNodeSummaries(ClusterNodeSummary... clusterNodeSummaries) {
            clusterNodeSummaries(Arrays.asList(clusterNodeSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterNodeSummaries(Consumer<ClusterNodeSummary.Builder>... clusterNodeSummaries) {
            clusterNodeSummaries(Stream.of(clusterNodeSummaries).map(c -> ClusterNodeSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListClusterNodesResponse build() {
            return new ListClusterNodesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
