/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListModelMetadataRequest extends SageMakerRequest implements
        ToCopyableBuilder<ListModelMetadataRequest.Builder, ListModelMetadataRequest> {
    private static final SdkField<ModelMetadataSearchExpression> SEARCH_EXPRESSION_FIELD = SdkField
            .<ModelMetadataSearchExpression> builder(MarshallingType.SDK_POJO).memberName("SearchExpression")
            .getter(getter(ListModelMetadataRequest::searchExpression)).setter(setter(Builder::searchExpression))
            .constructor(ModelMetadataSearchExpression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchExpression").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListModelMetadataRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListModelMetadataRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEARCH_EXPRESSION_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ModelMetadataSearchExpression searchExpression;

    private final String nextToken;

    private final Integer maxResults;

    private ListModelMetadataRequest(BuilderImpl builder) {
        super(builder);
        this.searchExpression = builder.searchExpression;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * One or more filters that searches for the specified resource or resources in a search. All resource objects that
     * satisfy the expression's condition are included in the search results. Specify the Framework, FrameworkVersion,
     * Domain or Task to filter supported. Filter names and values are case-sensitive.
     * </p>
     * 
     * @return One or more filters that searches for the specified resource or resources in a search. All resource
     *         objects that satisfy the expression's condition are included in the search results. Specify the
     *         Framework, FrameworkVersion, Domain or Task to filter supported. Filter names and values are
     *         case-sensitive.
     */
    public final ModelMetadataSearchExpression searchExpression() {
        return searchExpression;
    }

    /**
     * <p>
     * If the response to a previous <code>ListModelMetadataResponse</code> request was truncated, the response includes
     * a NextToken. To retrieve the next set of model metadata, use the token in the next request.
     * </p>
     * 
     * @return If the response to a previous <code>ListModelMetadataResponse</code> request was truncated, the response
     *         includes a NextToken. To retrieve the next set of model metadata, use the token in the next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of models to return in the response.
     * </p>
     * 
     * @return The maximum number of models to return in the response.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(searchExpression());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListModelMetadataRequest)) {
            return false;
        }
        ListModelMetadataRequest other = (ListModelMetadataRequest) obj;
        return Objects.equals(searchExpression(), other.searchExpression()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListModelMetadataRequest").add("SearchExpression", searchExpression())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SearchExpression":
            return Optional.ofNullable(clazz.cast(searchExpression()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SearchExpression", SEARCH_EXPRESSION_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListModelMetadataRequest, T> g) {
        return obj -> g.apply((ListModelMetadataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListModelMetadataRequest> {
        /**
         * <p>
         * One or more filters that searches for the specified resource or resources in a search. All resource objects
         * that satisfy the expression's condition are included in the search results. Specify the Framework,
         * FrameworkVersion, Domain or Task to filter supported. Filter names and values are case-sensitive.
         * </p>
         * 
         * @param searchExpression
         *        One or more filters that searches for the specified resource or resources in a search. All resource
         *        objects that satisfy the expression's condition are included in the search results. Specify the
         *        Framework, FrameworkVersion, Domain or Task to filter supported. Filter names and values are
         *        case-sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchExpression(ModelMetadataSearchExpression searchExpression);

        /**
         * <p>
         * One or more filters that searches for the specified resource or resources in a search. All resource objects
         * that satisfy the expression's condition are included in the search results. Specify the Framework,
         * FrameworkVersion, Domain or Task to filter supported. Filter names and values are case-sensitive.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModelMetadataSearchExpression.Builder}
         * avoiding the need to create one manually via {@link ModelMetadataSearchExpression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModelMetadataSearchExpression.Builder#build()} is called
         * immediately and its result is passed to {@link #searchExpression(ModelMetadataSearchExpression)}.
         * 
         * @param searchExpression
         *        a consumer that will call methods on {@link ModelMetadataSearchExpression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #searchExpression(ModelMetadataSearchExpression)
         */
        default Builder searchExpression(Consumer<ModelMetadataSearchExpression.Builder> searchExpression) {
            return searchExpression(ModelMetadataSearchExpression.builder().applyMutation(searchExpression).build());
        }

        /**
         * <p>
         * If the response to a previous <code>ListModelMetadataResponse</code> request was truncated, the response
         * includes a NextToken. To retrieve the next set of model metadata, use the token in the next request.
         * </p>
         * 
         * @param nextToken
         *        If the response to a previous <code>ListModelMetadataResponse</code> request was truncated, the
         *        response includes a NextToken. To retrieve the next set of model metadata, use the token in the next
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of models to return in the response.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of models to return in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private ModelMetadataSearchExpression searchExpression;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListModelMetadataRequest model) {
            super(model);
            searchExpression(model.searchExpression);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final ModelMetadataSearchExpression.Builder getSearchExpression() {
            return searchExpression != null ? searchExpression.toBuilder() : null;
        }

        public final void setSearchExpression(ModelMetadataSearchExpression.BuilderImpl searchExpression) {
            this.searchExpression = searchExpression != null ? searchExpression.build() : null;
        }

        @Override
        public final Builder searchExpression(ModelMetadataSearchExpression searchExpression) {
            this.searchExpression = searchExpression;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListModelMetadataRequest build() {
            return new ListModelMetadataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
