/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMonitoringAlertHistoryRequest extends SageMakerRequest implements
        ToCopyableBuilder<ListMonitoringAlertHistoryRequest.Builder, ListMonitoringAlertHistoryRequest> {
    private static final SdkField<String> MONITORING_SCHEDULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonitoringScheduleName").getter(getter(ListMonitoringAlertHistoryRequest::monitoringScheduleName))
            .setter(setter(Builder::monitoringScheduleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringScheduleName").build())
            .build();

    private static final SdkField<String> MONITORING_ALERT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonitoringAlertName").getter(getter(ListMonitoringAlertHistoryRequest::monitoringAlertName))
            .setter(setter(Builder::monitoringAlertName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringAlertName").build())
            .build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SortBy")
            .getter(getter(ListMonitoringAlertHistoryRequest::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SortOrder").getter(getter(ListMonitoringAlertHistoryRequest::sortOrderAsString))
            .setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListMonitoringAlertHistoryRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListMonitoringAlertHistoryRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<Instant> CREATION_TIME_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTimeBefore").getter(getter(ListMonitoringAlertHistoryRequest::creationTimeBefore))
            .setter(setter(Builder::creationTimeBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeBefore").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTimeAfter").getter(getter(ListMonitoringAlertHistoryRequest::creationTimeAfter))
            .setter(setter(Builder::creationTimeAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeAfter").build()).build();

    private static final SdkField<String> STATUS_EQUALS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusEquals").getter(getter(ListMonitoringAlertHistoryRequest::statusEqualsAsString))
            .setter(setter(Builder::statusEquals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusEquals").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MONITORING_SCHEDULE_NAME_FIELD, MONITORING_ALERT_NAME_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD, NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, CREATION_TIME_BEFORE_FIELD, CREATION_TIME_AFTER_FIELD, STATUS_EQUALS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String monitoringScheduleName;

    private final String monitoringAlertName;

    private final String sortBy;

    private final String sortOrder;

    private final String nextToken;

    private final Integer maxResults;

    private final Instant creationTimeBefore;

    private final Instant creationTimeAfter;

    private final String statusEquals;

    private ListMonitoringAlertHistoryRequest(BuilderImpl builder) {
        super(builder);
        this.monitoringScheduleName = builder.monitoringScheduleName;
        this.monitoringAlertName = builder.monitoringAlertName;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.creationTimeBefore = builder.creationTimeBefore;
        this.creationTimeAfter = builder.creationTimeAfter;
        this.statusEquals = builder.statusEquals;
    }

    /**
     * <p>
     * The name of a monitoring schedule.
     * </p>
     * 
     * @return The name of a monitoring schedule.
     */
    public final String monitoringScheduleName() {
        return monitoringScheduleName;
    }

    /**
     * <p>
     * The name of a monitoring alert.
     * </p>
     * 
     * @return The name of a monitoring alert.
     */
    public final String monitoringAlertName() {
        return monitoringAlertName;
    }

    /**
     * <p>
     * The field used to sort results. The default is <code>CreationTime</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link MonitoringAlertHistorySortKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sortByAsString}.
     * </p>
     * 
     * @return The field used to sort results. The default is <code>CreationTime</code>.
     * @see MonitoringAlertHistorySortKey
     */
    public final MonitoringAlertHistorySortKey sortBy() {
        return MonitoringAlertHistorySortKey.fromValue(sortBy);
    }

    /**
     * <p>
     * The field used to sort results. The default is <code>CreationTime</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link MonitoringAlertHistorySortKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sortByAsString}.
     * </p>
     * 
     * @return The field used to sort results. The default is <code>CreationTime</code>.
     * @see MonitoringAlertHistorySortKey
     */
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * The sort order, whether <code>Ascending</code> or <code>Descending</code>, of the alert history. The default is
     * <code>Descending</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sort order, whether <code>Ascending</code> or <code>Descending</code>, of the alert history. The
     *         default is <code>Descending</code>.
     * @see SortOrder
     */
    public final SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * The sort order, whether <code>Ascending</code> or <code>Descending</code>, of the alert history. The default is
     * <code>Descending</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sort order, whether <code>Ascending</code> or <code>Descending</code>, of the alert history. The
     *         default is <code>Descending</code>.
     * @see SortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    /**
     * <p>
     * If the result of the previous <code>ListMonitoringAlertHistory</code> request was truncated, the response
     * includes a <code>NextToken</code>. To retrieve the next set of alerts in the history, use the token in the next
     * request.
     * </p>
     * 
     * @return If the result of the previous <code>ListMonitoringAlertHistory</code> request was truncated, the response
     *         includes a <code>NextToken</code>. To retrieve the next set of alerts in the history, use the token in
     *         the next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to display. The default is 100.
     * </p>
     * 
     * @return The maximum number of results to display. The default is 100.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A filter that returns only alerts created on or before the specified time.
     * </p>
     * 
     * @return A filter that returns only alerts created on or before the specified time.
     */
    public final Instant creationTimeBefore() {
        return creationTimeBefore;
    }

    /**
     * <p>
     * A filter that returns only alerts created on or after the specified time.
     * </p>
     * 
     * @return A filter that returns only alerts created on or after the specified time.
     */
    public final Instant creationTimeAfter() {
        return creationTimeAfter;
    }

    /**
     * <p>
     * A filter that retrieves only alerts with a specific status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusEquals} will
     * return {@link MonitoringAlertStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusEqualsAsString}.
     * </p>
     * 
     * @return A filter that retrieves only alerts with a specific status.
     * @see MonitoringAlertStatus
     */
    public final MonitoringAlertStatus statusEquals() {
        return MonitoringAlertStatus.fromValue(statusEquals);
    }

    /**
     * <p>
     * A filter that retrieves only alerts with a specific status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusEquals} will
     * return {@link MonitoringAlertStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusEqualsAsString}.
     * </p>
     * 
     * @return A filter that retrieves only alerts with a specific status.
     * @see MonitoringAlertStatus
     */
    public final String statusEqualsAsString() {
        return statusEquals;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(monitoringScheduleName());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringAlertName());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(statusEqualsAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMonitoringAlertHistoryRequest)) {
            return false;
        }
        ListMonitoringAlertHistoryRequest other = (ListMonitoringAlertHistoryRequest) obj;
        return Objects.equals(monitoringScheduleName(), other.monitoringScheduleName())
                && Objects.equals(monitoringAlertName(), other.monitoringAlertName())
                && Objects.equals(sortByAsString(), other.sortByAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(creationTimeBefore(), other.creationTimeBefore())
                && Objects.equals(creationTimeAfter(), other.creationTimeAfter())
                && Objects.equals(statusEqualsAsString(), other.statusEqualsAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListMonitoringAlertHistoryRequest").add("MonitoringScheduleName", monitoringScheduleName())
                .add("MonitoringAlertName", monitoringAlertName()).add("SortBy", sortByAsString())
                .add("SortOrder", sortOrderAsString()).add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("CreationTimeBefore", creationTimeBefore()).add("CreationTimeAfter", creationTimeAfter())
                .add("StatusEquals", statusEqualsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MonitoringScheduleName":
            return Optional.ofNullable(clazz.cast(monitoringScheduleName()));
        case "MonitoringAlertName":
            return Optional.ofNullable(clazz.cast(monitoringAlertName()));
        case "SortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "SortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "CreationTimeBefore":
            return Optional.ofNullable(clazz.cast(creationTimeBefore()));
        case "CreationTimeAfter":
            return Optional.ofNullable(clazz.cast(creationTimeAfter()));
        case "StatusEquals":
            return Optional.ofNullable(clazz.cast(statusEqualsAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MonitoringScheduleName", MONITORING_SCHEDULE_NAME_FIELD);
        map.put("MonitoringAlertName", MONITORING_ALERT_NAME_FIELD);
        map.put("SortBy", SORT_BY_FIELD);
        map.put("SortOrder", SORT_ORDER_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("CreationTimeBefore", CREATION_TIME_BEFORE_FIELD);
        map.put("CreationTimeAfter", CREATION_TIME_AFTER_FIELD);
        map.put("StatusEquals", STATUS_EQUALS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListMonitoringAlertHistoryRequest, T> g) {
        return obj -> g.apply((ListMonitoringAlertHistoryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListMonitoringAlertHistoryRequest> {
        /**
         * <p>
         * The name of a monitoring schedule.
         * </p>
         * 
         * @param monitoringScheduleName
         *        The name of a monitoring schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringScheduleName(String monitoringScheduleName);

        /**
         * <p>
         * The name of a monitoring alert.
         * </p>
         * 
         * @param monitoringAlertName
         *        The name of a monitoring alert.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringAlertName(String monitoringAlertName);

        /**
         * <p>
         * The field used to sort results. The default is <code>CreationTime</code>.
         * </p>
         * 
         * @param sortBy
         *        The field used to sort results. The default is <code>CreationTime</code>.
         * @see MonitoringAlertHistorySortKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MonitoringAlertHistorySortKey
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * The field used to sort results. The default is <code>CreationTime</code>.
         * </p>
         * 
         * @param sortBy
         *        The field used to sort results. The default is <code>CreationTime</code>.
         * @see MonitoringAlertHistorySortKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MonitoringAlertHistorySortKey
         */
        Builder sortBy(MonitoringAlertHistorySortKey sortBy);

        /**
         * <p>
         * The sort order, whether <code>Ascending</code> or <code>Descending</code>, of the alert history. The default
         * is <code>Descending</code>.
         * </p>
         * 
         * @param sortOrder
         *        The sort order, whether <code>Ascending</code> or <code>Descending</code>, of the alert history. The
         *        default is <code>Descending</code>.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * The sort order, whether <code>Ascending</code> or <code>Descending</code>, of the alert history. The default
         * is <code>Descending</code>.
         * </p>
         * 
         * @param sortOrder
         *        The sort order, whether <code>Ascending</code> or <code>Descending</code>, of the alert history. The
         *        default is <code>Descending</code>.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);

        /**
         * <p>
         * If the result of the previous <code>ListMonitoringAlertHistory</code> request was truncated, the response
         * includes a <code>NextToken</code>. To retrieve the next set of alerts in the history, use the token in the
         * next request.
         * </p>
         * 
         * @param nextToken
         *        If the result of the previous <code>ListMonitoringAlertHistory</code> request was truncated, the
         *        response includes a <code>NextToken</code>. To retrieve the next set of alerts in the history, use the
         *        token in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to display. The default is 100.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to display. The default is 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A filter that returns only alerts created on or before the specified time.
         * </p>
         * 
         * @param creationTimeBefore
         *        A filter that returns only alerts created on or before the specified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimeBefore(Instant creationTimeBefore);

        /**
         * <p>
         * A filter that returns only alerts created on or after the specified time.
         * </p>
         * 
         * @param creationTimeAfter
         *        A filter that returns only alerts created on or after the specified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimeAfter(Instant creationTimeAfter);

        /**
         * <p>
         * A filter that retrieves only alerts with a specific status.
         * </p>
         * 
         * @param statusEquals
         *        A filter that retrieves only alerts with a specific status.
         * @see MonitoringAlertStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MonitoringAlertStatus
         */
        Builder statusEquals(String statusEquals);

        /**
         * <p>
         * A filter that retrieves only alerts with a specific status.
         * </p>
         * 
         * @param statusEquals
         *        A filter that retrieves only alerts with a specific status.
         * @see MonitoringAlertStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MonitoringAlertStatus
         */
        Builder statusEquals(MonitoringAlertStatus statusEquals);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String monitoringScheduleName;

        private String monitoringAlertName;

        private String sortBy;

        private String sortOrder;

        private String nextToken;

        private Integer maxResults;

        private Instant creationTimeBefore;

        private Instant creationTimeAfter;

        private String statusEquals;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMonitoringAlertHistoryRequest model) {
            super(model);
            monitoringScheduleName(model.monitoringScheduleName);
            monitoringAlertName(model.monitoringAlertName);
            sortBy(model.sortBy);
            sortOrder(model.sortOrder);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            creationTimeBefore(model.creationTimeBefore);
            creationTimeAfter(model.creationTimeAfter);
            statusEquals(model.statusEquals);
        }

        public final String getMonitoringScheduleName() {
            return monitoringScheduleName;
        }

        public final void setMonitoringScheduleName(String monitoringScheduleName) {
            this.monitoringScheduleName = monitoringScheduleName;
        }

        @Override
        public final Builder monitoringScheduleName(String monitoringScheduleName) {
            this.monitoringScheduleName = monitoringScheduleName;
            return this;
        }

        public final String getMonitoringAlertName() {
            return monitoringAlertName;
        }

        public final void setMonitoringAlertName(String monitoringAlertName) {
            this.monitoringAlertName = monitoringAlertName;
        }

        @Override
        public final Builder monitoringAlertName(String monitoringAlertName) {
            this.monitoringAlertName = monitoringAlertName;
            return this;
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(MonitoringAlertHistorySortKey sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Instant getCreationTimeBefore() {
            return creationTimeBefore;
        }

        public final void setCreationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
        }

        @Override
        public final Builder creationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
            return this;
        }

        public final Instant getCreationTimeAfter() {
            return creationTimeAfter;
        }

        public final void setCreationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
        }

        @Override
        public final Builder creationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
            return this;
        }

        public final String getStatusEquals() {
            return statusEquals;
        }

        public final void setStatusEquals(String statusEquals) {
            this.statusEquals = statusEquals;
        }

        @Override
        public final Builder statusEquals(String statusEquals) {
            this.statusEquals = statusEquals;
            return this;
        }

        @Override
        public final Builder statusEquals(MonitoringAlertStatus statusEquals) {
            this.statusEquals(statusEquals == null ? null : statusEquals.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListMonitoringAlertHistoryRequest build() {
            return new ListMonitoringAlertHistoryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
