/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListResourceCatalogsRequest extends SageMakerRequest implements
        ToCopyableBuilder<ListResourceCatalogsRequest.Builder, ListResourceCatalogsRequest> {
    private static final SdkField<String> NAME_CONTAINS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NameContains").getter(getter(ListResourceCatalogsRequest::nameContains))
            .setter(setter(Builder::nameContains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NameContains").build()).build();

    private static final SdkField<Instant> CREATION_TIME_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTimeAfter").getter(getter(ListResourceCatalogsRequest::creationTimeAfter))
            .setter(setter(Builder::creationTimeAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeAfter").build()).build();

    private static final SdkField<Instant> CREATION_TIME_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTimeBefore").getter(getter(ListResourceCatalogsRequest::creationTimeBefore))
            .setter(setter(Builder::creationTimeBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeBefore").build())
            .build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SortOrder").getter(getter(ListResourceCatalogsRequest::sortOrderAsString))
            .setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SortBy")
            .getter(getter(ListResourceCatalogsRequest::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListResourceCatalogsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListResourceCatalogsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_CONTAINS_FIELD,
            CREATION_TIME_AFTER_FIELD, CREATION_TIME_BEFORE_FIELD, SORT_ORDER_FIELD, SORT_BY_FIELD, MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nameContains;

    private final Instant creationTimeAfter;

    private final Instant creationTimeBefore;

    private final String sortOrder;

    private final String sortBy;

    private final Integer maxResults;

    private final String nextToken;

    private ListResourceCatalogsRequest(BuilderImpl builder) {
        super(builder);
        this.nameContains = builder.nameContains;
        this.creationTimeAfter = builder.creationTimeAfter;
        this.creationTimeBefore = builder.creationTimeBefore;
        this.sortOrder = builder.sortOrder;
        this.sortBy = builder.sortBy;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A string that partially matches one or more <code>ResourceCatalog</code>s names. Filters
     * <code>ResourceCatalog</code> by name.
     * </p>
     * 
     * @return A string that partially matches one or more <code>ResourceCatalog</code>s names. Filters
     *         <code>ResourceCatalog</code> by name.
     */
    public final String nameContains() {
        return nameContains;
    }

    /**
     * <p>
     * Use this parameter to search for <code>ResourceCatalog</code>s created after a specific date and time.
     * </p>
     * 
     * @return Use this parameter to search for <code>ResourceCatalog</code>s created after a specific date and time.
     */
    public final Instant creationTimeAfter() {
        return creationTimeAfter;
    }

    /**
     * <p>
     * Use this parameter to search for <code>ResourceCatalog</code>s created before a specific date and time.
     * </p>
     * 
     * @return Use this parameter to search for <code>ResourceCatalog</code>s created before a specific date and time.
     */
    public final Instant creationTimeBefore() {
        return creationTimeBefore;
    }

    /**
     * <p>
     * The order in which the resource catalogs are listed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link ResourceCatalogSortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The order in which the resource catalogs are listed.
     * @see ResourceCatalogSortOrder
     */
    public final ResourceCatalogSortOrder sortOrder() {
        return ResourceCatalogSortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * The order in which the resource catalogs are listed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link ResourceCatalogSortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The order in which the resource catalogs are listed.
     * @see ResourceCatalogSortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    /**
     * <p>
     * The value on which the resource catalog list is sorted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link ResourceCatalogSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sortByAsString}.
     * </p>
     * 
     * @return The value on which the resource catalog list is sorted.
     * @see ResourceCatalogSortBy
     */
    public final ResourceCatalogSortBy sortBy() {
        return ResourceCatalogSortBy.fromValue(sortBy);
    }

    /**
     * <p>
     * The value on which the resource catalog list is sorted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link ResourceCatalogSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sortByAsString}.
     * </p>
     * 
     * @return The value on which the resource catalog list is sorted.
     * @see ResourceCatalogSortBy
     */
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * The maximum number of results returned by <code>ListResourceCatalogs</code>.
     * </p>
     * 
     * @return The maximum number of results returned by <code>ListResourceCatalogs</code>.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A token to resume pagination of <code>ListResourceCatalogs</code> results.
     * </p>
     * 
     * @return A token to resume pagination of <code>ListResourceCatalogs</code> results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nameContains());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceCatalogsRequest)) {
            return false;
        }
        ListResourceCatalogsRequest other = (ListResourceCatalogsRequest) obj;
        return Objects.equals(nameContains(), other.nameContains())
                && Objects.equals(creationTimeAfter(), other.creationTimeAfter())
                && Objects.equals(creationTimeBefore(), other.creationTimeBefore())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString())
                && Objects.equals(sortByAsString(), other.sortByAsString()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListResourceCatalogsRequest").add("NameContains", nameContains())
                .add("CreationTimeAfter", creationTimeAfter()).add("CreationTimeBefore", creationTimeBefore())
                .add("SortOrder", sortOrderAsString()).add("SortBy", sortByAsString()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NameContains":
            return Optional.ofNullable(clazz.cast(nameContains()));
        case "CreationTimeAfter":
            return Optional.ofNullable(clazz.cast(creationTimeAfter()));
        case "CreationTimeBefore":
            return Optional.ofNullable(clazz.cast(creationTimeBefore()));
        case "SortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        case "SortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NameContains", NAME_CONTAINS_FIELD);
        map.put("CreationTimeAfter", CREATION_TIME_AFTER_FIELD);
        map.put("CreationTimeBefore", CREATION_TIME_BEFORE_FIELD);
        map.put("SortOrder", SORT_ORDER_FIELD);
        map.put("SortBy", SORT_BY_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListResourceCatalogsRequest, T> g) {
        return obj -> g.apply((ListResourceCatalogsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListResourceCatalogsRequest> {
        /**
         * <p>
         * A string that partially matches one or more <code>ResourceCatalog</code>s names. Filters
         * <code>ResourceCatalog</code> by name.
         * </p>
         * 
         * @param nameContains
         *        A string that partially matches one or more <code>ResourceCatalog</code>s names. Filters
         *        <code>ResourceCatalog</code> by name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameContains(String nameContains);

        /**
         * <p>
         * Use this parameter to search for <code>ResourceCatalog</code>s created after a specific date and time.
         * </p>
         * 
         * @param creationTimeAfter
         *        Use this parameter to search for <code>ResourceCatalog</code>s created after a specific date and time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimeAfter(Instant creationTimeAfter);

        /**
         * <p>
         * Use this parameter to search for <code>ResourceCatalog</code>s created before a specific date and time.
         * </p>
         * 
         * @param creationTimeBefore
         *        Use this parameter to search for <code>ResourceCatalog</code>s created before a specific date and
         *        time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimeBefore(Instant creationTimeBefore);

        /**
         * <p>
         * The order in which the resource catalogs are listed.
         * </p>
         * 
         * @param sortOrder
         *        The order in which the resource catalogs are listed.
         * @see ResourceCatalogSortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceCatalogSortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * The order in which the resource catalogs are listed.
         * </p>
         * 
         * @param sortOrder
         *        The order in which the resource catalogs are listed.
         * @see ResourceCatalogSortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceCatalogSortOrder
         */
        Builder sortOrder(ResourceCatalogSortOrder sortOrder);

        /**
         * <p>
         * The value on which the resource catalog list is sorted.
         * </p>
         * 
         * @param sortBy
         *        The value on which the resource catalog list is sorted.
         * @see ResourceCatalogSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceCatalogSortBy
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * The value on which the resource catalog list is sorted.
         * </p>
         * 
         * @param sortBy
         *        The value on which the resource catalog list is sorted.
         * @see ResourceCatalogSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceCatalogSortBy
         */
        Builder sortBy(ResourceCatalogSortBy sortBy);

        /**
         * <p>
         * The maximum number of results returned by <code>ListResourceCatalogs</code>.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results returned by <code>ListResourceCatalogs</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A token to resume pagination of <code>ListResourceCatalogs</code> results.
         * </p>
         * 
         * @param nextToken
         *        A token to resume pagination of <code>ListResourceCatalogs</code> results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String nameContains;

        private Instant creationTimeAfter;

        private Instant creationTimeBefore;

        private String sortOrder;

        private String sortBy;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceCatalogsRequest model) {
            super(model);
            nameContains(model.nameContains);
            creationTimeAfter(model.creationTimeAfter);
            creationTimeBefore(model.creationTimeBefore);
            sortOrder(model.sortOrder);
            sortBy(model.sortBy);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getNameContains() {
            return nameContains;
        }

        public final void setNameContains(String nameContains) {
            this.nameContains = nameContains;
        }

        @Override
        public final Builder nameContains(String nameContains) {
            this.nameContains = nameContains;
            return this;
        }

        public final Instant getCreationTimeAfter() {
            return creationTimeAfter;
        }

        public final void setCreationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
        }

        @Override
        public final Builder creationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
            return this;
        }

        public final Instant getCreationTimeBefore() {
            return creationTimeBefore;
        }

        public final void setCreationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
        }

        @Override
        public final Builder creationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(ResourceCatalogSortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(ResourceCatalogSortBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListResourceCatalogsRequest build() {
            return new ListResourceCatalogsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
