/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTrialComponentsRequest extends SageMakerRequest implements
        ToCopyableBuilder<ListTrialComponentsRequest.Builder, ListTrialComponentsRequest> {
    private static final SdkField<String> EXPERIMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExperimentName").getter(getter(ListTrialComponentsRequest::experimentName))
            .setter(setter(Builder::experimentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExperimentName").build()).build();

    private static final SdkField<String> TRIAL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrialName").getter(getter(ListTrialComponentsRequest::trialName)).setter(setter(Builder::trialName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialName").build()).build();

    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceArn").getter(getter(ListTrialComponentsRequest::sourceArn)).setter(setter(Builder::sourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceArn").build()).build();

    private static final SdkField<Instant> CREATED_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAfter").getter(getter(ListTrialComponentsRequest::createdAfter))
            .setter(setter(Builder::createdAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAfter").build()).build();

    private static final SdkField<Instant> CREATED_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedBefore").getter(getter(ListTrialComponentsRequest::createdBefore))
            .setter(setter(Builder::createdBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBefore").build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SortBy")
            .getter(getter(ListTrialComponentsRequest::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SortOrder").getter(getter(ListTrialComponentsRequest::sortOrderAsString))
            .setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListTrialComponentsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListTrialComponentsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPERIMENT_NAME_FIELD,
            TRIAL_NAME_FIELD, SOURCE_ARN_FIELD, CREATED_AFTER_FIELD, CREATED_BEFORE_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String experimentName;

    private final String trialName;

    private final String sourceArn;

    private final Instant createdAfter;

    private final Instant createdBefore;

    private final String sortBy;

    private final String sortOrder;

    private final Integer maxResults;

    private final String nextToken;

    private ListTrialComponentsRequest(BuilderImpl builder) {
        super(builder);
        this.experimentName = builder.experimentName;
        this.trialName = builder.trialName;
        this.sourceArn = builder.sourceArn;
        this.createdAfter = builder.createdAfter;
        this.createdBefore = builder.createdBefore;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A filter that returns only components that are part of the specified experiment. If you specify
     * <code>ExperimentName</code>, you can't filter by <code>SourceArn</code> or <code>TrialName</code>.
     * </p>
     * 
     * @return A filter that returns only components that are part of the specified experiment. If you specify
     *         <code>ExperimentName</code>, you can't filter by <code>SourceArn</code> or <code>TrialName</code>.
     */
    public final String experimentName() {
        return experimentName;
    }

    /**
     * <p>
     * A filter that returns only components that are part of the specified trial. If you specify <code>TrialName</code>
     * , you can't filter by <code>ExperimentName</code> or <code>SourceArn</code>.
     * </p>
     * 
     * @return A filter that returns only components that are part of the specified trial. If you specify
     *         <code>TrialName</code>, you can't filter by <code>ExperimentName</code> or <code>SourceArn</code>.
     */
    public final String trialName() {
        return trialName;
    }

    /**
     * <p>
     * A filter that returns only components that have the specified source Amazon Resource Name (ARN). If you specify
     * <code>SourceArn</code>, you can't filter by <code>ExperimentName</code> or <code>TrialName</code>.
     * </p>
     * 
     * @return A filter that returns only components that have the specified source Amazon Resource Name (ARN). If you
     *         specify <code>SourceArn</code>, you can't filter by <code>ExperimentName</code> or <code>TrialName</code>
     *         .
     */
    public final String sourceArn() {
        return sourceArn;
    }

    /**
     * <p>
     * A filter that returns only components created after the specified time.
     * </p>
     * 
     * @return A filter that returns only components created after the specified time.
     */
    public final Instant createdAfter() {
        return createdAfter;
    }

    /**
     * <p>
     * A filter that returns only components created before the specified time.
     * </p>
     * 
     * @return A filter that returns only components created before the specified time.
     */
    public final Instant createdBefore() {
        return createdBefore;
    }

    /**
     * <p>
     * The property used to sort results. The default value is <code>CreationTime</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link SortTrialComponentsBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sortByAsString}.
     * </p>
     * 
     * @return The property used to sort results. The default value is <code>CreationTime</code>.
     * @see SortTrialComponentsBy
     */
    public final SortTrialComponentsBy sortBy() {
        return SortTrialComponentsBy.fromValue(sortBy);
    }

    /**
     * <p>
     * The property used to sort results. The default value is <code>CreationTime</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link SortTrialComponentsBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sortByAsString}.
     * </p>
     * 
     * @return The property used to sort results. The default value is <code>CreationTime</code>.
     * @see SortTrialComponentsBy
     */
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * The sort order. The default value is <code>Descending</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sort order. The default value is <code>Descending</code>.
     * @see SortOrder
     */
    public final SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * The sort order. The default value is <code>Descending</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sort order. The default value is <code>Descending</code>.
     * @see SortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    /**
     * <p>
     * The maximum number of components to return in the response. The default value is 10.
     * </p>
     * 
     * @return The maximum number of components to return in the response. The default value is 10.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * If the previous call to <code>ListTrialComponents</code> didn't return the full set of components, the call
     * returns a token for getting the next set of components.
     * </p>
     * 
     * @return If the previous call to <code>ListTrialComponents</code> didn't return the full set of components, the
     *         call returns a token for getting the next set of components.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(experimentName());
        hashCode = 31 * hashCode + Objects.hashCode(trialName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAfter());
        hashCode = 31 * hashCode + Objects.hashCode(createdBefore());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrialComponentsRequest)) {
            return false;
        }
        ListTrialComponentsRequest other = (ListTrialComponentsRequest) obj;
        return Objects.equals(experimentName(), other.experimentName()) && Objects.equals(trialName(), other.trialName())
                && Objects.equals(sourceArn(), other.sourceArn()) && Objects.equals(createdAfter(), other.createdAfter())
                && Objects.equals(createdBefore(), other.createdBefore())
                && Objects.equals(sortByAsString(), other.sortByAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTrialComponentsRequest").add("ExperimentName", experimentName())
                .add("TrialName", trialName()).add("SourceArn", sourceArn()).add("CreatedAfter", createdAfter())
                .add("CreatedBefore", createdBefore()).add("SortBy", sortByAsString()).add("SortOrder", sortOrderAsString())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExperimentName":
            return Optional.ofNullable(clazz.cast(experimentName()));
        case "TrialName":
            return Optional.ofNullable(clazz.cast(trialName()));
        case "SourceArn":
            return Optional.ofNullable(clazz.cast(sourceArn()));
        case "CreatedAfter":
            return Optional.ofNullable(clazz.cast(createdAfter()));
        case "CreatedBefore":
            return Optional.ofNullable(clazz.cast(createdBefore()));
        case "SortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "SortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ExperimentName", EXPERIMENT_NAME_FIELD);
        map.put("TrialName", TRIAL_NAME_FIELD);
        map.put("SourceArn", SOURCE_ARN_FIELD);
        map.put("CreatedAfter", CREATED_AFTER_FIELD);
        map.put("CreatedBefore", CREATED_BEFORE_FIELD);
        map.put("SortBy", SORT_BY_FIELD);
        map.put("SortOrder", SORT_ORDER_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTrialComponentsRequest, T> g) {
        return obj -> g.apply((ListTrialComponentsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListTrialComponentsRequest> {
        /**
         * <p>
         * A filter that returns only components that are part of the specified experiment. If you specify
         * <code>ExperimentName</code>, you can't filter by <code>SourceArn</code> or <code>TrialName</code>.
         * </p>
         * 
         * @param experimentName
         *        A filter that returns only components that are part of the specified experiment. If you specify
         *        <code>ExperimentName</code>, you can't filter by <code>SourceArn</code> or <code>TrialName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder experimentName(String experimentName);

        /**
         * <p>
         * A filter that returns only components that are part of the specified trial. If you specify
         * <code>TrialName</code>, you can't filter by <code>ExperimentName</code> or <code>SourceArn</code>.
         * </p>
         * 
         * @param trialName
         *        A filter that returns only components that are part of the specified trial. If you specify
         *        <code>TrialName</code>, you can't filter by <code>ExperimentName</code> or <code>SourceArn</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trialName(String trialName);

        /**
         * <p>
         * A filter that returns only components that have the specified source Amazon Resource Name (ARN). If you
         * specify <code>SourceArn</code>, you can't filter by <code>ExperimentName</code> or <code>TrialName</code>.
         * </p>
         * 
         * @param sourceArn
         *        A filter that returns only components that have the specified source Amazon Resource Name (ARN). If
         *        you specify <code>SourceArn</code>, you can't filter by <code>ExperimentName</code> or
         *        <code>TrialName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceArn(String sourceArn);

        /**
         * <p>
         * A filter that returns only components created after the specified time.
         * </p>
         * 
         * @param createdAfter
         *        A filter that returns only components created after the specified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAfter(Instant createdAfter);

        /**
         * <p>
         * A filter that returns only components created before the specified time.
         * </p>
         * 
         * @param createdBefore
         *        A filter that returns only components created before the specified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBefore(Instant createdBefore);

        /**
         * <p>
         * The property used to sort results. The default value is <code>CreationTime</code>.
         * </p>
         * 
         * @param sortBy
         *        The property used to sort results. The default value is <code>CreationTime</code>.
         * @see SortTrialComponentsBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortTrialComponentsBy
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * The property used to sort results. The default value is <code>CreationTime</code>.
         * </p>
         * 
         * @param sortBy
         *        The property used to sort results. The default value is <code>CreationTime</code>.
         * @see SortTrialComponentsBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortTrialComponentsBy
         */
        Builder sortBy(SortTrialComponentsBy sortBy);

        /**
         * <p>
         * The sort order. The default value is <code>Descending</code>.
         * </p>
         * 
         * @param sortOrder
         *        The sort order. The default value is <code>Descending</code>.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * The sort order. The default value is <code>Descending</code>.
         * </p>
         * 
         * @param sortOrder
         *        The sort order. The default value is <code>Descending</code>.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);

        /**
         * <p>
         * The maximum number of components to return in the response. The default value is 10.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of components to return in the response. The default value is 10.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * If the previous call to <code>ListTrialComponents</code> didn't return the full set of components, the call
         * returns a token for getting the next set of components.
         * </p>
         * 
         * @param nextToken
         *        If the previous call to <code>ListTrialComponents</code> didn't return the full set of components, the
         *        call returns a token for getting the next set of components.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String experimentName;

        private String trialName;

        private String sourceArn;

        private Instant createdAfter;

        private Instant createdBefore;

        private String sortBy;

        private String sortOrder;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrialComponentsRequest model) {
            super(model);
            experimentName(model.experimentName);
            trialName(model.trialName);
            sourceArn(model.sourceArn);
            createdAfter(model.createdAfter);
            createdBefore(model.createdBefore);
            sortBy(model.sortBy);
            sortOrder(model.sortOrder);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getExperimentName() {
            return experimentName;
        }

        public final void setExperimentName(String experimentName) {
            this.experimentName = experimentName;
        }

        @Override
        public final Builder experimentName(String experimentName) {
            this.experimentName = experimentName;
            return this;
        }

        public final String getTrialName() {
            return trialName;
        }

        public final void setTrialName(String trialName) {
            this.trialName = trialName;
        }

        @Override
        public final Builder trialName(String trialName) {
            this.trialName = trialName;
            return this;
        }

        public final String getSourceArn() {
            return sourceArn;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final Instant getCreatedAfter() {
            return createdAfter;
        }

        public final void setCreatedAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
        }

        @Override
        public final Builder createdAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
            return this;
        }

        public final Instant getCreatedBefore() {
            return createdBefore;
        }

        public final void setCreatedBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
        }

        @Override
        public final Builder createdBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
            return this;
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(SortTrialComponentsBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTrialComponentsRequest build() {
            return new ListTrialComponentsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
