/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ModelDashboardMonitoringSchedulesCopier {
    static List<ModelDashboardMonitoringSchedule> copy(
            Collection<? extends ModelDashboardMonitoringSchedule> modelDashboardMonitoringSchedulesParam) {
        List<ModelDashboardMonitoringSchedule> list;
        if (modelDashboardMonitoringSchedulesParam == null
                || modelDashboardMonitoringSchedulesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ModelDashboardMonitoringSchedule> modifiableList = new ArrayList<>(modelDashboardMonitoringSchedulesParam.size());
            modelDashboardMonitoringSchedulesParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ModelDashboardMonitoringSchedule> copyFromBuilder(
            Collection<? extends ModelDashboardMonitoringSchedule.Builder> modelDashboardMonitoringSchedulesParam) {
        List<ModelDashboardMonitoringSchedule> list;
        if (modelDashboardMonitoringSchedulesParam == null
                || modelDashboardMonitoringSchedulesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ModelDashboardMonitoringSchedule> modifiableList = new ArrayList<>(modelDashboardMonitoringSchedulesParam.size());
            modelDashboardMonitoringSchedulesParam.forEach(entry -> {
                ModelDashboardMonitoringSchedule member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ModelDashboardMonitoringSchedule.Builder> copyToBuilder(
            Collection<? extends ModelDashboardMonitoringSchedule> modelDashboardMonitoringSchedulesParam) {
        List<ModelDashboardMonitoringSchedule.Builder> list;
        if (modelDashboardMonitoringSchedulesParam == null
                || modelDashboardMonitoringSchedulesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ModelDashboardMonitoringSchedule.Builder> modifiableList = new ArrayList<>(
                    modelDashboardMonitoringSchedulesParam.size());
            modelDashboardMonitoringSchedulesParam.forEach(entry -> {
                ModelDashboardMonitoringSchedule.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
