/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum OptimizationJobDeploymentInstanceType {
    ML_P4_D_24_XLARGE("ml.p4d.24xlarge"),

    ML_P4_DE_24_XLARGE("ml.p4de.24xlarge"),

    ML_P5_48_XLARGE("ml.p5.48xlarge"),

    ML_G5_XLARGE("ml.g5.xlarge"),

    ML_G5_2_XLARGE("ml.g5.2xlarge"),

    ML_G5_4_XLARGE("ml.g5.4xlarge"),

    ML_G5_8_XLARGE("ml.g5.8xlarge"),

    ML_G5_12_XLARGE("ml.g5.12xlarge"),

    ML_G5_16_XLARGE("ml.g5.16xlarge"),

    ML_G5_24_XLARGE("ml.g5.24xlarge"),

    ML_G5_48_XLARGE("ml.g5.48xlarge"),

    ML_G6_XLARGE("ml.g6.xlarge"),

    ML_G6_2_XLARGE("ml.g6.2xlarge"),

    ML_G6_4_XLARGE("ml.g6.4xlarge"),

    ML_G6_8_XLARGE("ml.g6.8xlarge"),

    ML_G6_12_XLARGE("ml.g6.12xlarge"),

    ML_G6_16_XLARGE("ml.g6.16xlarge"),

    ML_G6_24_XLARGE("ml.g6.24xlarge"),

    ML_G6_48_XLARGE("ml.g6.48xlarge"),

    ML_G6_E_XLARGE("ml.g6e.xlarge"),

    ML_G6_E_2_XLARGE("ml.g6e.2xlarge"),

    ML_G6_E_4_XLARGE("ml.g6e.4xlarge"),

    ML_G6_E_8_XLARGE("ml.g6e.8xlarge"),

    ML_G6_E_12_XLARGE("ml.g6e.12xlarge"),

    ML_G6_E_16_XLARGE("ml.g6e.16xlarge"),

    ML_G6_E_24_XLARGE("ml.g6e.24xlarge"),

    ML_G6_E_48_XLARGE("ml.g6e.48xlarge"),

    ML_INF2_XLARGE("ml.inf2.xlarge"),

    ML_INF2_8_XLARGE("ml.inf2.8xlarge"),

    ML_INF2_24_XLARGE("ml.inf2.24xlarge"),

    ML_INF2_48_XLARGE("ml.inf2.48xlarge"),

    ML_TRN1_2_XLARGE("ml.trn1.2xlarge"),

    ML_TRN1_32_XLARGE("ml.trn1.32xlarge"),

    ML_TRN1_N_32_XLARGE("ml.trn1n.32xlarge"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OptimizationJobDeploymentInstanceType> VALUE_MAP = EnumUtils.uniqueIndex(
            OptimizationJobDeploymentInstanceType.class, OptimizationJobDeploymentInstanceType::toString);

    private final String value;

    private OptimizationJobDeploymentInstanceType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return OptimizationJobDeploymentInstanceType corresponding to the value
     */
    public static OptimizationJobDeploymentInstanceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link OptimizationJobDeploymentInstanceType}s
     */
    public static Set<OptimizationJobDeploymentInstanceType> knownValues() {
        Set<OptimizationJobDeploymentInstanceType> knownValues = EnumSet.allOf(OptimizationJobDeploymentInstanceType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
