/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A specification for a predefined metric.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PredefinedMetricSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<PredefinedMetricSpecification.Builder, PredefinedMetricSpecification> {
    private static final SdkField<String> PREDEFINED_METRIC_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PredefinedMetricType").getter(getter(PredefinedMetricSpecification::predefinedMetricType))
            .setter(setter(Builder::predefinedMetricType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredefinedMetricType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREDEFINED_METRIC_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String predefinedMetricType;

    private PredefinedMetricSpecification(BuilderImpl builder) {
        this.predefinedMetricType = builder.predefinedMetricType;
    }

    /**
     * <p>
     * The metric type. You can only apply SageMaker metric types to SageMaker endpoints.
     * </p>
     * 
     * @return The metric type. You can only apply SageMaker metric types to SageMaker endpoints.
     */
    public final String predefinedMetricType() {
        return predefinedMetricType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(predefinedMetricType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredefinedMetricSpecification)) {
            return false;
        }
        PredefinedMetricSpecification other = (PredefinedMetricSpecification) obj;
        return Objects.equals(predefinedMetricType(), other.predefinedMetricType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PredefinedMetricSpecification").add("PredefinedMetricType", predefinedMetricType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PredefinedMetricType":
            return Optional.ofNullable(clazz.cast(predefinedMetricType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PredefinedMetricType", PREDEFINED_METRIC_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PredefinedMetricSpecification, T> g) {
        return obj -> g.apply((PredefinedMetricSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PredefinedMetricSpecification> {
        /**
         * <p>
         * The metric type. You can only apply SageMaker metric types to SageMaker endpoints.
         * </p>
         * 
         * @param predefinedMetricType
         *        The metric type. You can only apply SageMaker metric types to SageMaker endpoints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predefinedMetricType(String predefinedMetricType);
    }

    static final class BuilderImpl implements Builder {
        private String predefinedMetricType;

        private BuilderImpl() {
        }

        private BuilderImpl(PredefinedMetricSpecification model) {
            predefinedMetricType(model.predefinedMetricType);
        }

        public final String getPredefinedMetricType() {
            return predefinedMetricType;
        }

        public final void setPredefinedMetricType(String predefinedMetricType) {
            this.predefinedMetricType = predefinedMetricType;
        }

        @Override
        public final Builder predefinedMetricType(String predefinedMetricType) {
            this.predefinedMetricType = predefinedMetricType;
            return this;
        }

        @Override
        public PredefinedMetricSpecification build() {
            return new PredefinedMetricSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
