/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for Redshift Dataset Definition input.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RedshiftDatasetDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<RedshiftDatasetDefinition.Builder, RedshiftDatasetDefinition> {
    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterId").getter(getter(RedshiftDatasetDefinition::clusterId)).setter(setter(Builder::clusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterId").build()).build();

    private static final SdkField<String> DATABASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Database").getter(getter(RedshiftDatasetDefinition::database)).setter(setter(Builder::database))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()).build();

    private static final SdkField<String> DB_USER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("DbUser")
            .getter(getter(RedshiftDatasetDefinition::dbUser)).setter(setter(Builder::dbUser))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbUser").build()).build();

    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryString").getter(getter(RedshiftDatasetDefinition::queryString))
            .setter(setter(Builder::queryString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryString").build()).build();

    private static final SdkField<String> CLUSTER_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterRoleArn").getter(getter(RedshiftDatasetDefinition::clusterRoleArn))
            .setter(setter(Builder::clusterRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterRoleArn").build()).build();

    private static final SdkField<String> OUTPUT_S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputS3Uri").getter(getter(RedshiftDatasetDefinition::outputS3Uri))
            .setter(setter(Builder::outputS3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputS3Uri").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(RedshiftDatasetDefinition::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<String> OUTPUT_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputFormat").getter(getter(RedshiftDatasetDefinition::outputFormatAsString))
            .setter(setter(Builder::outputFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputFormat").build()).build();

    private static final SdkField<String> OUTPUT_COMPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputCompression").getter(getter(RedshiftDatasetDefinition::outputCompressionAsString))
            .setter(setter(Builder::outputCompression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputCompression").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ID_FIELD,
            DATABASE_FIELD, DB_USER_FIELD, QUERY_STRING_FIELD, CLUSTER_ROLE_ARN_FIELD, OUTPUT_S3_URI_FIELD, KMS_KEY_ID_FIELD,
            OUTPUT_FORMAT_FIELD, OUTPUT_COMPRESSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String clusterId;

    private final String database;

    private final String dbUser;

    private final String queryString;

    private final String clusterRoleArn;

    private final String outputS3Uri;

    private final String kmsKeyId;

    private final String outputFormat;

    private final String outputCompression;

    private RedshiftDatasetDefinition(BuilderImpl builder) {
        this.clusterId = builder.clusterId;
        this.database = builder.database;
        this.dbUser = builder.dbUser;
        this.queryString = builder.queryString;
        this.clusterRoleArn = builder.clusterRoleArn;
        this.outputS3Uri = builder.outputS3Uri;
        this.kmsKeyId = builder.kmsKeyId;
        this.outputFormat = builder.outputFormat;
        this.outputCompression = builder.outputCompression;
    }

    /**
     * Returns the value of the ClusterId property for this object.
     * 
     * @return The value of the ClusterId property for this object.
     */
    public final String clusterId() {
        return clusterId;
    }

    /**
     * Returns the value of the Database property for this object.
     * 
     * @return The value of the Database property for this object.
     */
    public final String database() {
        return database;
    }

    /**
     * Returns the value of the DbUser property for this object.
     * 
     * @return The value of the DbUser property for this object.
     */
    public final String dbUser() {
        return dbUser;
    }

    /**
     * Returns the value of the QueryString property for this object.
     * 
     * @return The value of the QueryString property for this object.
     */
    public final String queryString() {
        return queryString;
    }

    /**
     * <p>
     * The IAM role attached to your Redshift cluster that Amazon SageMaker uses to generate datasets.
     * </p>
     * 
     * @return The IAM role attached to your Redshift cluster that Amazon SageMaker uses to generate datasets.
     */
    public final String clusterRoleArn() {
        return clusterRoleArn;
    }

    /**
     * <p>
     * The location in Amazon S3 where the Redshift query results are stored.
     * </p>
     * 
     * @return The location in Amazon S3 where the Redshift query results are stored.
     */
    public final String outputS3Uri() {
        return outputS3Uri;
    }

    /**
     * <p>
     * The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to
     * encrypt data from a Redshift execution.
     * </p>
     * 
     * @return The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses
     *         to encrypt data from a Redshift execution.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * Returns the value of the OutputFormat property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputFormat} will
     * return {@link RedshiftResultFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #outputFormatAsString}.
     * </p>
     * 
     * @return The value of the OutputFormat property for this object.
     * @see RedshiftResultFormat
     */
    public final RedshiftResultFormat outputFormat() {
        return RedshiftResultFormat.fromValue(outputFormat);
    }

    /**
     * Returns the value of the OutputFormat property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputFormat} will
     * return {@link RedshiftResultFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #outputFormatAsString}.
     * </p>
     * 
     * @return The value of the OutputFormat property for this object.
     * @see RedshiftResultFormat
     */
    public final String outputFormatAsString() {
        return outputFormat;
    }

    /**
     * Returns the value of the OutputCompression property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputCompression}
     * will return {@link RedshiftResultCompressionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #outputCompressionAsString}.
     * </p>
     * 
     * @return The value of the OutputCompression property for this object.
     * @see RedshiftResultCompressionType
     */
    public final RedshiftResultCompressionType outputCompression() {
        return RedshiftResultCompressionType.fromValue(outputCompression);
    }

    /**
     * Returns the value of the OutputCompression property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputCompression}
     * will return {@link RedshiftResultCompressionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #outputCompressionAsString}.
     * </p>
     * 
     * @return The value of the OutputCompression property for this object.
     * @see RedshiftResultCompressionType
     */
    public final String outputCompressionAsString() {
        return outputCompression;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(database());
        hashCode = 31 * hashCode + Objects.hashCode(dbUser());
        hashCode = 31 * hashCode + Objects.hashCode(queryString());
        hashCode = 31 * hashCode + Objects.hashCode(clusterRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(outputS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(outputFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(outputCompressionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftDatasetDefinition)) {
            return false;
        }
        RedshiftDatasetDefinition other = (RedshiftDatasetDefinition) obj;
        return Objects.equals(clusterId(), other.clusterId()) && Objects.equals(database(), other.database())
                && Objects.equals(dbUser(), other.dbUser()) && Objects.equals(queryString(), other.queryString())
                && Objects.equals(clusterRoleArn(), other.clusterRoleArn()) && Objects.equals(outputS3Uri(), other.outputS3Uri())
                && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(outputFormatAsString(), other.outputFormatAsString())
                && Objects.equals(outputCompressionAsString(), other.outputCompressionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RedshiftDatasetDefinition").add("ClusterId", clusterId()).add("Database", database())
                .add("DbUser", dbUser()).add("QueryString", queryString()).add("ClusterRoleArn", clusterRoleArn())
                .add("OutputS3Uri", outputS3Uri()).add("KmsKeyId", kmsKeyId()).add("OutputFormat", outputFormatAsString())
                .add("OutputCompression", outputCompressionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterId":
            return Optional.ofNullable(clazz.cast(clusterId()));
        case "Database":
            return Optional.ofNullable(clazz.cast(database()));
        case "DbUser":
            return Optional.ofNullable(clazz.cast(dbUser()));
        case "QueryString":
            return Optional.ofNullable(clazz.cast(queryString()));
        case "ClusterRoleArn":
            return Optional.ofNullable(clazz.cast(clusterRoleArn()));
        case "OutputS3Uri":
            return Optional.ofNullable(clazz.cast(outputS3Uri()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "OutputFormat":
            return Optional.ofNullable(clazz.cast(outputFormatAsString()));
        case "OutputCompression":
            return Optional.ofNullable(clazz.cast(outputCompressionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClusterId", CLUSTER_ID_FIELD);
        map.put("Database", DATABASE_FIELD);
        map.put("DbUser", DB_USER_FIELD);
        map.put("QueryString", QUERY_STRING_FIELD);
        map.put("ClusterRoleArn", CLUSTER_ROLE_ARN_FIELD);
        map.put("OutputS3Uri", OUTPUT_S3_URI_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("OutputFormat", OUTPUT_FORMAT_FIELD);
        map.put("OutputCompression", OUTPUT_COMPRESSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RedshiftDatasetDefinition, T> g) {
        return obj -> g.apply((RedshiftDatasetDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RedshiftDatasetDefinition> {
        /**
         * Sets the value of the ClusterId property for this object.
         *
         * @param clusterId
         *        The new value for the ClusterId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterId(String clusterId);

        /**
         * Sets the value of the Database property for this object.
         *
         * @param database
         *        The new value for the Database property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder database(String database);

        /**
         * Sets the value of the DbUser property for this object.
         *
         * @param dbUser
         *        The new value for the DbUser property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbUser(String dbUser);

        /**
         * Sets the value of the QueryString property for this object.
         *
         * @param queryString
         *        The new value for the QueryString property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryString(String queryString);

        /**
         * <p>
         * The IAM role attached to your Redshift cluster that Amazon SageMaker uses to generate datasets.
         * </p>
         * 
         * @param clusterRoleArn
         *        The IAM role attached to your Redshift cluster that Amazon SageMaker uses to generate datasets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterRoleArn(String clusterRoleArn);

        /**
         * <p>
         * The location in Amazon S3 where the Redshift query results are stored.
         * </p>
         * 
         * @param outputS3Uri
         *        The location in Amazon S3 where the Redshift query results are stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputS3Uri(String outputS3Uri);

        /**
         * <p>
         * The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to
         * encrypt data from a Redshift execution.
         * </p>
         * 
         * @param kmsKeyId
         *        The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker
         *        uses to encrypt data from a Redshift execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * Sets the value of the OutputFormat property for this object.
         *
         * @param outputFormat
         *        The new value for the OutputFormat property for this object.
         * @see RedshiftResultFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RedshiftResultFormat
         */
        Builder outputFormat(String outputFormat);

        /**
         * Sets the value of the OutputFormat property for this object.
         *
         * @param outputFormat
         *        The new value for the OutputFormat property for this object.
         * @see RedshiftResultFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RedshiftResultFormat
         */
        Builder outputFormat(RedshiftResultFormat outputFormat);

        /**
         * Sets the value of the OutputCompression property for this object.
         *
         * @param outputCompression
         *        The new value for the OutputCompression property for this object.
         * @see RedshiftResultCompressionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RedshiftResultCompressionType
         */
        Builder outputCompression(String outputCompression);

        /**
         * Sets the value of the OutputCompression property for this object.
         *
         * @param outputCompression
         *        The new value for the OutputCompression property for this object.
         * @see RedshiftResultCompressionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RedshiftResultCompressionType
         */
        Builder outputCompression(RedshiftResultCompressionType outputCompression);
    }

    static final class BuilderImpl implements Builder {
        private String clusterId;

        private String database;

        private String dbUser;

        private String queryString;

        private String clusterRoleArn;

        private String outputS3Uri;

        private String kmsKeyId;

        private String outputFormat;

        private String outputCompression;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftDatasetDefinition model) {
            clusterId(model.clusterId);
            database(model.database);
            dbUser(model.dbUser);
            queryString(model.queryString);
            clusterRoleArn(model.clusterRoleArn);
            outputS3Uri(model.outputS3Uri);
            kmsKeyId(model.kmsKeyId);
            outputFormat(model.outputFormat);
            outputCompression(model.outputCompression);
        }

        public final String getClusterId() {
            return clusterId;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final String getDatabase() {
            return database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final String getDbUser() {
            return dbUser;
        }

        public final void setDbUser(String dbUser) {
            this.dbUser = dbUser;
        }

        @Override
        public final Builder dbUser(String dbUser) {
            this.dbUser = dbUser;
            return this;
        }

        public final String getQueryString() {
            return queryString;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final String getClusterRoleArn() {
            return clusterRoleArn;
        }

        public final void setClusterRoleArn(String clusterRoleArn) {
            this.clusterRoleArn = clusterRoleArn;
        }

        @Override
        public final Builder clusterRoleArn(String clusterRoleArn) {
            this.clusterRoleArn = clusterRoleArn;
            return this;
        }

        public final String getOutputS3Uri() {
            return outputS3Uri;
        }

        public final void setOutputS3Uri(String outputS3Uri) {
            this.outputS3Uri = outputS3Uri;
        }

        @Override
        public final Builder outputS3Uri(String outputS3Uri) {
            this.outputS3Uri = outputS3Uri;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getOutputFormat() {
            return outputFormat;
        }

        public final void setOutputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
        }

        @Override
        public final Builder outputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
            return this;
        }

        @Override
        public final Builder outputFormat(RedshiftResultFormat outputFormat) {
            this.outputFormat(outputFormat == null ? null : outputFormat.toString());
            return this;
        }

        public final String getOutputCompression() {
            return outputCompression;
        }

        public final void setOutputCompression(String outputCompression) {
            this.outputCompression = outputCompression;
        }

        @Override
        public final Builder outputCompression(String outputCompression) {
            this.outputCompression = outputCompression;
            return this;
        }

        @Override
        public final Builder outputCompression(RedshiftResultCompressionType outputCompression) {
            this.outputCompression(outputCompression == null ? null : outputCompression.toString());
            return this;
        }

        @Override
        public RedshiftDatasetDefinition build() {
            return new RedshiftDatasetDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
