/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies an authentication configuration for the private docker registry where your model image is hosted. Specify a
 * value for this property only if you specified <code>Vpc</code> as the value for the <code>RepositoryAccessMode</code>
 * field of the <code>ImageConfig</code> object that you passed to a call to <code>CreateModel</code> and the private
 * Docker registry where the model image is hosted requires authentication.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RepositoryAuthConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<RepositoryAuthConfig.Builder, RepositoryAuthConfig> {
    private static final SdkField<String> REPOSITORY_CREDENTIALS_PROVIDER_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RepositoryCredentialsProviderArn")
            .getter(getter(RepositoryAuthConfig::repositoryCredentialsProviderArn))
            .setter(setter(Builder::repositoryCredentialsProviderArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryCredentialsProviderArn")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(REPOSITORY_CREDENTIALS_PROVIDER_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String repositoryCredentialsProviderArn;

    private RepositoryAuthConfig(BuilderImpl builder) {
        this.repositoryCredentialsProviderArn = builder.repositoryCredentialsProviderArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an Amazon Web Services Lambda function that provides credentials to
     * authenticate to the private Docker registry where your model image is hosted. For information about how to create
     * an Amazon Web Services Lambda function, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/getting-started-create-function.html">Create a Lambda function
     * with the console</a> in the <i>Amazon Web Services Lambda Developer Guide</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an Amazon Web Services Lambda function that provides credentials to
     *         authenticate to the private Docker registry where your model image is hosted. For information about how
     *         to create an Amazon Web Services Lambda function, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/getting-started-create-function.html">Create a Lambda
     *         function with the console</a> in the <i>Amazon Web Services Lambda Developer Guide</i>.
     */
    public final String repositoryCredentialsProviderArn() {
        return repositoryCredentialsProviderArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(repositoryCredentialsProviderArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RepositoryAuthConfig)) {
            return false;
        }
        RepositoryAuthConfig other = (RepositoryAuthConfig) obj;
        return Objects.equals(repositoryCredentialsProviderArn(), other.repositoryCredentialsProviderArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RepositoryAuthConfig")
                .add("RepositoryCredentialsProviderArn", repositoryCredentialsProviderArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RepositoryCredentialsProviderArn":
            return Optional.ofNullable(clazz.cast(repositoryCredentialsProviderArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RepositoryCredentialsProviderArn", REPOSITORY_CREDENTIALS_PROVIDER_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RepositoryAuthConfig, T> g) {
        return obj -> g.apply((RepositoryAuthConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RepositoryAuthConfig> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of an Amazon Web Services Lambda function that provides credentials to
         * authenticate to the private Docker registry where your model image is hosted. For information about how to
         * create an Amazon Web Services Lambda function, see <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/getting-started-create-function.html">Create a Lambda
         * function with the console</a> in the <i>Amazon Web Services Lambda Developer Guide</i>.
         * </p>
         * 
         * @param repositoryCredentialsProviderArn
         *        The Amazon Resource Name (ARN) of an Amazon Web Services Lambda function that provides credentials to
         *        authenticate to the private Docker registry where your model image is hosted. For information about
         *        how to create an Amazon Web Services Lambda function, see <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/getting-started-create-function.html">Create a
         *        Lambda function with the console</a> in the <i>Amazon Web Services Lambda Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryCredentialsProviderArn(String repositoryCredentialsProviderArn);
    }

    static final class BuilderImpl implements Builder {
        private String repositoryCredentialsProviderArn;

        private BuilderImpl() {
        }

        private BuilderImpl(RepositoryAuthConfig model) {
            repositoryCredentialsProviderArn(model.repositoryCredentialsProviderArn);
        }

        public final String getRepositoryCredentialsProviderArn() {
            return repositoryCredentialsProviderArn;
        }

        public final void setRepositoryCredentialsProviderArn(String repositoryCredentialsProviderArn) {
            this.repositoryCredentialsProviderArn = repositoryCredentialsProviderArn;
        }

        @Override
        public final Builder repositoryCredentialsProviderArn(String repositoryCredentialsProviderArn) {
            this.repositoryCredentialsProviderArn = repositoryCredentialsProviderArn;
            return this;
        }

        @Override
        public RepositoryAuthConfig build() {
            return new RepositoryAuthConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
