/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A collection of space settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SpaceSettings implements SdkPojo, Serializable, ToCopyableBuilder<SpaceSettings.Builder, SpaceSettings> {
    private static final SdkField<JupyterServerAppSettings> JUPYTER_SERVER_APP_SETTINGS_FIELD = SdkField
            .<JupyterServerAppSettings> builder(MarshallingType.SDK_POJO).memberName("JupyterServerAppSettings")
            .getter(getter(SpaceSettings::jupyterServerAppSettings)).setter(setter(Builder::jupyterServerAppSettings))
            .constructor(JupyterServerAppSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JupyterServerAppSettings").build())
            .build();

    private static final SdkField<KernelGatewayAppSettings> KERNEL_GATEWAY_APP_SETTINGS_FIELD = SdkField
            .<KernelGatewayAppSettings> builder(MarshallingType.SDK_POJO).memberName("KernelGatewayAppSettings")
            .getter(getter(SpaceSettings::kernelGatewayAppSettings)).setter(setter(Builder::kernelGatewayAppSettings))
            .constructor(KernelGatewayAppSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KernelGatewayAppSettings").build())
            .build();

    private static final SdkField<SpaceCodeEditorAppSettings> CODE_EDITOR_APP_SETTINGS_FIELD = SdkField
            .<SpaceCodeEditorAppSettings> builder(MarshallingType.SDK_POJO).memberName("CodeEditorAppSettings")
            .getter(getter(SpaceSettings::codeEditorAppSettings)).setter(setter(Builder::codeEditorAppSettings))
            .constructor(SpaceCodeEditorAppSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeEditorAppSettings").build())
            .build();

    private static final SdkField<SpaceJupyterLabAppSettings> JUPYTER_LAB_APP_SETTINGS_FIELD = SdkField
            .<SpaceJupyterLabAppSettings> builder(MarshallingType.SDK_POJO).memberName("JupyterLabAppSettings")
            .getter(getter(SpaceSettings::jupyterLabAppSettings)).setter(setter(Builder::jupyterLabAppSettings))
            .constructor(SpaceJupyterLabAppSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JupyterLabAppSettings").build())
            .build();

    private static final SdkField<String> APP_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppType").getter(getter(SpaceSettings::appTypeAsString)).setter(setter(Builder::appType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppType").build()).build();

    private static final SdkField<SpaceStorageSettings> SPACE_STORAGE_SETTINGS_FIELD = SdkField
            .<SpaceStorageSettings> builder(MarshallingType.SDK_POJO).memberName("SpaceStorageSettings")
            .getter(getter(SpaceSettings::spaceStorageSettings)).setter(setter(Builder::spaceStorageSettings))
            .constructor(SpaceStorageSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpaceStorageSettings").build())
            .build();

    private static final SdkField<String> SPACE_MANAGED_RESOURCES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SpaceManagedResources").getter(getter(SpaceSettings::spaceManagedResourcesAsString))
            .setter(setter(Builder::spaceManagedResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpaceManagedResources").build())
            .build();

    private static final SdkField<List<CustomFileSystem>> CUSTOM_FILE_SYSTEMS_FIELD = SdkField
            .<List<CustomFileSystem>> builder(MarshallingType.LIST)
            .memberName("CustomFileSystems")
            .getter(getter(SpaceSettings::customFileSystems))
            .setter(setter(Builder::customFileSystems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomFileSystems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CustomFileSystem> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomFileSystem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            JUPYTER_SERVER_APP_SETTINGS_FIELD, KERNEL_GATEWAY_APP_SETTINGS_FIELD, CODE_EDITOR_APP_SETTINGS_FIELD,
            JUPYTER_LAB_APP_SETTINGS_FIELD, APP_TYPE_FIELD, SPACE_STORAGE_SETTINGS_FIELD, SPACE_MANAGED_RESOURCES_FIELD,
            CUSTOM_FILE_SYSTEMS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final JupyterServerAppSettings jupyterServerAppSettings;

    private final KernelGatewayAppSettings kernelGatewayAppSettings;

    private final SpaceCodeEditorAppSettings codeEditorAppSettings;

    private final SpaceJupyterLabAppSettings jupyterLabAppSettings;

    private final String appType;

    private final SpaceStorageSettings spaceStorageSettings;

    private final String spaceManagedResources;

    private final List<CustomFileSystem> customFileSystems;

    private SpaceSettings(BuilderImpl builder) {
        this.jupyterServerAppSettings = builder.jupyterServerAppSettings;
        this.kernelGatewayAppSettings = builder.kernelGatewayAppSettings;
        this.codeEditorAppSettings = builder.codeEditorAppSettings;
        this.jupyterLabAppSettings = builder.jupyterLabAppSettings;
        this.appType = builder.appType;
        this.spaceStorageSettings = builder.spaceStorageSettings;
        this.spaceManagedResources = builder.spaceManagedResources;
        this.customFileSystems = builder.customFileSystems;
    }

    /**
     * Returns the value of the JupyterServerAppSettings property for this object.
     * 
     * @return The value of the JupyterServerAppSettings property for this object.
     */
    public final JupyterServerAppSettings jupyterServerAppSettings() {
        return jupyterServerAppSettings;
    }

    /**
     * Returns the value of the KernelGatewayAppSettings property for this object.
     * 
     * @return The value of the KernelGatewayAppSettings property for this object.
     */
    public final KernelGatewayAppSettings kernelGatewayAppSettings() {
        return kernelGatewayAppSettings;
    }

    /**
     * <p>
     * The Code Editor application settings.
     * </p>
     * 
     * @return The Code Editor application settings.
     */
    public final SpaceCodeEditorAppSettings codeEditorAppSettings() {
        return codeEditorAppSettings;
    }

    /**
     * <p>
     * The settings for the JupyterLab application.
     * </p>
     * 
     * @return The settings for the JupyterLab application.
     */
    public final SpaceJupyterLabAppSettings jupyterLabAppSettings() {
        return jupyterLabAppSettings;
    }

    /**
     * <p>
     * The type of app created within the space.
     * </p>
     * <p>
     * If using the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateSpace.html">
     * UpdateSpace</a> API, you can't change the app type of your space by specifying a different value for this field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #appType} will
     * return {@link AppType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #appTypeAsString}.
     * </p>
     * 
     * @return The type of app created within the space.</p>
     *         <p>
     *         If using the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateSpace.html">
     *         UpdateSpace</a> API, you can't change the app type of your space by specifying a different value for this
     *         field.
     * @see AppType
     */
    public final AppType appType() {
        return AppType.fromValue(appType);
    }

    /**
     * <p>
     * The type of app created within the space.
     * </p>
     * <p>
     * If using the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateSpace.html">
     * UpdateSpace</a> API, you can't change the app type of your space by specifying a different value for this field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #appType} will
     * return {@link AppType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #appTypeAsString}.
     * </p>
     * 
     * @return The type of app created within the space.</p>
     *         <p>
     *         If using the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateSpace.html">
     *         UpdateSpace</a> API, you can't change the app type of your space by specifying a different value for this
     *         field.
     * @see AppType
     */
    public final String appTypeAsString() {
        return appType;
    }

    /**
     * <p>
     * The storage settings for a space.
     * </p>
     * 
     * @return The storage settings for a space.
     */
    public final SpaceStorageSettings spaceStorageSettings() {
        return spaceStorageSettings;
    }

    /**
     * <p>
     * If you enable this option, SageMaker AI creates the following resources on your behalf when you create the space:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The user profile that possesses the space.
     * </p>
     * </li>
     * <li>
     * <p>
     * The app that the space contains.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #spaceManagedResources} will return {@link FeatureStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #spaceManagedResourcesAsString}.
     * </p>
     * 
     * @return If you enable this option, SageMaker AI creates the following resources on your behalf when you create
     *         the space:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The user profile that possesses the space.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The app that the space contains.
     *         </p>
     *         </li>
     * @see FeatureStatus
     */
    public final FeatureStatus spaceManagedResources() {
        return FeatureStatus.fromValue(spaceManagedResources);
    }

    /**
     * <p>
     * If you enable this option, SageMaker AI creates the following resources on your behalf when you create the space:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The user profile that possesses the space.
     * </p>
     * </li>
     * <li>
     * <p>
     * The app that the space contains.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #spaceManagedResources} will return {@link FeatureStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #spaceManagedResourcesAsString}.
     * </p>
     * 
     * @return If you enable this option, SageMaker AI creates the following resources on your behalf when you create
     *         the space:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The user profile that possesses the space.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The app that the space contains.
     *         </p>
     *         </li>
     * @see FeatureStatus
     */
    public final String spaceManagedResourcesAsString() {
        return spaceManagedResources;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomFileSystems property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCustomFileSystems() {
        return customFileSystems != null && !(customFileSystems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A file system, created by you, that you assign to a space for an Amazon SageMaker AI Domain. Permitted users can
     * access this file system in Amazon SageMaker AI Studio.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomFileSystems} method.
     * </p>
     * 
     * @return A file system, created by you, that you assign to a space for an Amazon SageMaker AI Domain. Permitted
     *         users can access this file system in Amazon SageMaker AI Studio.
     */
    public final List<CustomFileSystem> customFileSystems() {
        return customFileSystems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jupyterServerAppSettings());
        hashCode = 31 * hashCode + Objects.hashCode(kernelGatewayAppSettings());
        hashCode = 31 * hashCode + Objects.hashCode(codeEditorAppSettings());
        hashCode = 31 * hashCode + Objects.hashCode(jupyterLabAppSettings());
        hashCode = 31 * hashCode + Objects.hashCode(appTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(spaceStorageSettings());
        hashCode = 31 * hashCode + Objects.hashCode(spaceManagedResourcesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomFileSystems() ? customFileSystems() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpaceSettings)) {
            return false;
        }
        SpaceSettings other = (SpaceSettings) obj;
        return Objects.equals(jupyterServerAppSettings(), other.jupyterServerAppSettings())
                && Objects.equals(kernelGatewayAppSettings(), other.kernelGatewayAppSettings())
                && Objects.equals(codeEditorAppSettings(), other.codeEditorAppSettings())
                && Objects.equals(jupyterLabAppSettings(), other.jupyterLabAppSettings())
                && Objects.equals(appTypeAsString(), other.appTypeAsString())
                && Objects.equals(spaceStorageSettings(), other.spaceStorageSettings())
                && Objects.equals(spaceManagedResourcesAsString(), other.spaceManagedResourcesAsString())
                && hasCustomFileSystems() == other.hasCustomFileSystems()
                && Objects.equals(customFileSystems(), other.customFileSystems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SpaceSettings").add("JupyterServerAppSettings", jupyterServerAppSettings())
                .add("KernelGatewayAppSettings", kernelGatewayAppSettings())
                .add("CodeEditorAppSettings", codeEditorAppSettings()).add("JupyterLabAppSettings", jupyterLabAppSettings())
                .add("AppType", appTypeAsString()).add("SpaceStorageSettings", spaceStorageSettings())
                .add("SpaceManagedResources", spaceManagedResourcesAsString())
                .add("CustomFileSystems", hasCustomFileSystems() ? customFileSystems() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JupyterServerAppSettings":
            return Optional.ofNullable(clazz.cast(jupyterServerAppSettings()));
        case "KernelGatewayAppSettings":
            return Optional.ofNullable(clazz.cast(kernelGatewayAppSettings()));
        case "CodeEditorAppSettings":
            return Optional.ofNullable(clazz.cast(codeEditorAppSettings()));
        case "JupyterLabAppSettings":
            return Optional.ofNullable(clazz.cast(jupyterLabAppSettings()));
        case "AppType":
            return Optional.ofNullable(clazz.cast(appTypeAsString()));
        case "SpaceStorageSettings":
            return Optional.ofNullable(clazz.cast(spaceStorageSettings()));
        case "SpaceManagedResources":
            return Optional.ofNullable(clazz.cast(spaceManagedResourcesAsString()));
        case "CustomFileSystems":
            return Optional.ofNullable(clazz.cast(customFileSystems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("JupyterServerAppSettings", JUPYTER_SERVER_APP_SETTINGS_FIELD);
        map.put("KernelGatewayAppSettings", KERNEL_GATEWAY_APP_SETTINGS_FIELD);
        map.put("CodeEditorAppSettings", CODE_EDITOR_APP_SETTINGS_FIELD);
        map.put("JupyterLabAppSettings", JUPYTER_LAB_APP_SETTINGS_FIELD);
        map.put("AppType", APP_TYPE_FIELD);
        map.put("SpaceStorageSettings", SPACE_STORAGE_SETTINGS_FIELD);
        map.put("SpaceManagedResources", SPACE_MANAGED_RESOURCES_FIELD);
        map.put("CustomFileSystems", CUSTOM_FILE_SYSTEMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SpaceSettings, T> g) {
        return obj -> g.apply((SpaceSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SpaceSettings> {
        /**
         * Sets the value of the JupyterServerAppSettings property for this object.
         *
         * @param jupyterServerAppSettings
         *        The new value for the JupyterServerAppSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jupyterServerAppSettings(JupyterServerAppSettings jupyterServerAppSettings);

        /**
         * Sets the value of the JupyterServerAppSettings property for this object.
         *
         * This is a convenience method that creates an instance of the {@link JupyterServerAppSettings.Builder}
         * avoiding the need to create one manually via {@link JupyterServerAppSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JupyterServerAppSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #jupyterServerAppSettings(JupyterServerAppSettings)}.
         * 
         * @param jupyterServerAppSettings
         *        a consumer that will call methods on {@link JupyterServerAppSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jupyterServerAppSettings(JupyterServerAppSettings)
         */
        default Builder jupyterServerAppSettings(Consumer<JupyterServerAppSettings.Builder> jupyterServerAppSettings) {
            return jupyterServerAppSettings(JupyterServerAppSettings.builder().applyMutation(jupyterServerAppSettings).build());
        }

        /**
         * Sets the value of the KernelGatewayAppSettings property for this object.
         *
         * @param kernelGatewayAppSettings
         *        The new value for the KernelGatewayAppSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kernelGatewayAppSettings(KernelGatewayAppSettings kernelGatewayAppSettings);

        /**
         * Sets the value of the KernelGatewayAppSettings property for this object.
         *
         * This is a convenience method that creates an instance of the {@link KernelGatewayAppSettings.Builder}
         * avoiding the need to create one manually via {@link KernelGatewayAppSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KernelGatewayAppSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #kernelGatewayAppSettings(KernelGatewayAppSettings)}.
         * 
         * @param kernelGatewayAppSettings
         *        a consumer that will call methods on {@link KernelGatewayAppSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kernelGatewayAppSettings(KernelGatewayAppSettings)
         */
        default Builder kernelGatewayAppSettings(Consumer<KernelGatewayAppSettings.Builder> kernelGatewayAppSettings) {
            return kernelGatewayAppSettings(KernelGatewayAppSettings.builder().applyMutation(kernelGatewayAppSettings).build());
        }

        /**
         * <p>
         * The Code Editor application settings.
         * </p>
         * 
         * @param codeEditorAppSettings
         *        The Code Editor application settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeEditorAppSettings(SpaceCodeEditorAppSettings codeEditorAppSettings);

        /**
         * <p>
         * The Code Editor application settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link SpaceCodeEditorAppSettings.Builder}
         * avoiding the need to create one manually via {@link SpaceCodeEditorAppSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SpaceCodeEditorAppSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #codeEditorAppSettings(SpaceCodeEditorAppSettings)}.
         * 
         * @param codeEditorAppSettings
         *        a consumer that will call methods on {@link SpaceCodeEditorAppSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #codeEditorAppSettings(SpaceCodeEditorAppSettings)
         */
        default Builder codeEditorAppSettings(Consumer<SpaceCodeEditorAppSettings.Builder> codeEditorAppSettings) {
            return codeEditorAppSettings(SpaceCodeEditorAppSettings.builder().applyMutation(codeEditorAppSettings).build());
        }

        /**
         * <p>
         * The settings for the JupyterLab application.
         * </p>
         * 
         * @param jupyterLabAppSettings
         *        The settings for the JupyterLab application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jupyterLabAppSettings(SpaceJupyterLabAppSettings jupyterLabAppSettings);

        /**
         * <p>
         * The settings for the JupyterLab application.
         * </p>
         * This is a convenience method that creates an instance of the {@link SpaceJupyterLabAppSettings.Builder}
         * avoiding the need to create one manually via {@link SpaceJupyterLabAppSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SpaceJupyterLabAppSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #jupyterLabAppSettings(SpaceJupyterLabAppSettings)}.
         * 
         * @param jupyterLabAppSettings
         *        a consumer that will call methods on {@link SpaceJupyterLabAppSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jupyterLabAppSettings(SpaceJupyterLabAppSettings)
         */
        default Builder jupyterLabAppSettings(Consumer<SpaceJupyterLabAppSettings.Builder> jupyterLabAppSettings) {
            return jupyterLabAppSettings(SpaceJupyterLabAppSettings.builder().applyMutation(jupyterLabAppSettings).build());
        }

        /**
         * <p>
         * The type of app created within the space.
         * </p>
         * <p>
         * If using the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateSpace.html">
         * UpdateSpace</a> API, you can't change the app type of your space by specifying a different value for this
         * field.
         * </p>
         * 
         * @param appType
         *        The type of app created within the space.</p>
         *        <p>
         *        If using the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateSpace.html">
         *        UpdateSpace</a> API, you can't change the app type of your space by specifying a different value for
         *        this field.
         * @see AppType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppType
         */
        Builder appType(String appType);

        /**
         * <p>
         * The type of app created within the space.
         * </p>
         * <p>
         * If using the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateSpace.html">
         * UpdateSpace</a> API, you can't change the app type of your space by specifying a different value for this
         * field.
         * </p>
         * 
         * @param appType
         *        The type of app created within the space.</p>
         *        <p>
         *        If using the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateSpace.html">
         *        UpdateSpace</a> API, you can't change the app type of your space by specifying a different value for
         *        this field.
         * @see AppType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppType
         */
        Builder appType(AppType appType);

        /**
         * <p>
         * The storage settings for a space.
         * </p>
         * 
         * @param spaceStorageSettings
         *        The storage settings for a space.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spaceStorageSettings(SpaceStorageSettings spaceStorageSettings);

        /**
         * <p>
         * The storage settings for a space.
         * </p>
         * This is a convenience method that creates an instance of the {@link SpaceStorageSettings.Builder} avoiding
         * the need to create one manually via {@link SpaceStorageSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SpaceStorageSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #spaceStorageSettings(SpaceStorageSettings)}.
         * 
         * @param spaceStorageSettings
         *        a consumer that will call methods on {@link SpaceStorageSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spaceStorageSettings(SpaceStorageSettings)
         */
        default Builder spaceStorageSettings(Consumer<SpaceStorageSettings.Builder> spaceStorageSettings) {
            return spaceStorageSettings(SpaceStorageSettings.builder().applyMutation(spaceStorageSettings).build());
        }

        /**
         * <p>
         * If you enable this option, SageMaker AI creates the following resources on your behalf when you create the
         * space:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The user profile that possesses the space.
         * </p>
         * </li>
         * <li>
         * <p>
         * The app that the space contains.
         * </p>
         * </li>
         * </ul>
         * 
         * @param spaceManagedResources
         *        If you enable this option, SageMaker AI creates the following resources on your behalf when you create
         *        the space:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The user profile that possesses the space.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The app that the space contains.
         *        </p>
         *        </li>
         * @see FeatureStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeatureStatus
         */
        Builder spaceManagedResources(String spaceManagedResources);

        /**
         * <p>
         * If you enable this option, SageMaker AI creates the following resources on your behalf when you create the
         * space:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The user profile that possesses the space.
         * </p>
         * </li>
         * <li>
         * <p>
         * The app that the space contains.
         * </p>
         * </li>
         * </ul>
         * 
         * @param spaceManagedResources
         *        If you enable this option, SageMaker AI creates the following resources on your behalf when you create
         *        the space:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The user profile that possesses the space.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The app that the space contains.
         *        </p>
         *        </li>
         * @see FeatureStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeatureStatus
         */
        Builder spaceManagedResources(FeatureStatus spaceManagedResources);

        /**
         * <p>
         * A file system, created by you, that you assign to a space for an Amazon SageMaker AI Domain. Permitted users
         * can access this file system in Amazon SageMaker AI Studio.
         * </p>
         * 
         * @param customFileSystems
         *        A file system, created by you, that you assign to a space for an Amazon SageMaker AI Domain. Permitted
         *        users can access this file system in Amazon SageMaker AI Studio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customFileSystems(Collection<CustomFileSystem> customFileSystems);

        /**
         * <p>
         * A file system, created by you, that you assign to a space for an Amazon SageMaker AI Domain. Permitted users
         * can access this file system in Amazon SageMaker AI Studio.
         * </p>
         * 
         * @param customFileSystems
         *        A file system, created by you, that you assign to a space for an Amazon SageMaker AI Domain. Permitted
         *        users can access this file system in Amazon SageMaker AI Studio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customFileSystems(CustomFileSystem... customFileSystems);

        /**
         * <p>
         * A file system, created by you, that you assign to a space for an Amazon SageMaker AI Domain. Permitted users
         * can access this file system in Amazon SageMaker AI Studio.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.CustomFileSystem.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.sagemaker.model.CustomFileSystem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.CustomFileSystem.Builder#build()} is called
         * immediately and its result is passed to {@link #customFileSystems(List<CustomFileSystem>)}.
         * 
         * @param customFileSystems
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.CustomFileSystem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customFileSystems(java.util.Collection<CustomFileSystem>)
         */
        Builder customFileSystems(Consumer<CustomFileSystem.Builder>... customFileSystems);
    }

    static final class BuilderImpl implements Builder {
        private JupyterServerAppSettings jupyterServerAppSettings;

        private KernelGatewayAppSettings kernelGatewayAppSettings;

        private SpaceCodeEditorAppSettings codeEditorAppSettings;

        private SpaceJupyterLabAppSettings jupyterLabAppSettings;

        private String appType;

        private SpaceStorageSettings spaceStorageSettings;

        private String spaceManagedResources;

        private List<CustomFileSystem> customFileSystems = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SpaceSettings model) {
            jupyterServerAppSettings(model.jupyterServerAppSettings);
            kernelGatewayAppSettings(model.kernelGatewayAppSettings);
            codeEditorAppSettings(model.codeEditorAppSettings);
            jupyterLabAppSettings(model.jupyterLabAppSettings);
            appType(model.appType);
            spaceStorageSettings(model.spaceStorageSettings);
            spaceManagedResources(model.spaceManagedResources);
            customFileSystems(model.customFileSystems);
        }

        public final JupyterServerAppSettings.Builder getJupyterServerAppSettings() {
            return jupyterServerAppSettings != null ? jupyterServerAppSettings.toBuilder() : null;
        }

        public final void setJupyterServerAppSettings(JupyterServerAppSettings.BuilderImpl jupyterServerAppSettings) {
            this.jupyterServerAppSettings = jupyterServerAppSettings != null ? jupyterServerAppSettings.build() : null;
        }

        @Override
        public final Builder jupyterServerAppSettings(JupyterServerAppSettings jupyterServerAppSettings) {
            this.jupyterServerAppSettings = jupyterServerAppSettings;
            return this;
        }

        public final KernelGatewayAppSettings.Builder getKernelGatewayAppSettings() {
            return kernelGatewayAppSettings != null ? kernelGatewayAppSettings.toBuilder() : null;
        }

        public final void setKernelGatewayAppSettings(KernelGatewayAppSettings.BuilderImpl kernelGatewayAppSettings) {
            this.kernelGatewayAppSettings = kernelGatewayAppSettings != null ? kernelGatewayAppSettings.build() : null;
        }

        @Override
        public final Builder kernelGatewayAppSettings(KernelGatewayAppSettings kernelGatewayAppSettings) {
            this.kernelGatewayAppSettings = kernelGatewayAppSettings;
            return this;
        }

        public final SpaceCodeEditorAppSettings.Builder getCodeEditorAppSettings() {
            return codeEditorAppSettings != null ? codeEditorAppSettings.toBuilder() : null;
        }

        public final void setCodeEditorAppSettings(SpaceCodeEditorAppSettings.BuilderImpl codeEditorAppSettings) {
            this.codeEditorAppSettings = codeEditorAppSettings != null ? codeEditorAppSettings.build() : null;
        }

        @Override
        public final Builder codeEditorAppSettings(SpaceCodeEditorAppSettings codeEditorAppSettings) {
            this.codeEditorAppSettings = codeEditorAppSettings;
            return this;
        }

        public final SpaceJupyterLabAppSettings.Builder getJupyterLabAppSettings() {
            return jupyterLabAppSettings != null ? jupyterLabAppSettings.toBuilder() : null;
        }

        public final void setJupyterLabAppSettings(SpaceJupyterLabAppSettings.BuilderImpl jupyterLabAppSettings) {
            this.jupyterLabAppSettings = jupyterLabAppSettings != null ? jupyterLabAppSettings.build() : null;
        }

        @Override
        public final Builder jupyterLabAppSettings(SpaceJupyterLabAppSettings jupyterLabAppSettings) {
            this.jupyterLabAppSettings = jupyterLabAppSettings;
            return this;
        }

        public final String getAppType() {
            return appType;
        }

        public final void setAppType(String appType) {
            this.appType = appType;
        }

        @Override
        public final Builder appType(String appType) {
            this.appType = appType;
            return this;
        }

        @Override
        public final Builder appType(AppType appType) {
            this.appType(appType == null ? null : appType.toString());
            return this;
        }

        public final SpaceStorageSettings.Builder getSpaceStorageSettings() {
            return spaceStorageSettings != null ? spaceStorageSettings.toBuilder() : null;
        }

        public final void setSpaceStorageSettings(SpaceStorageSettings.BuilderImpl spaceStorageSettings) {
            this.spaceStorageSettings = spaceStorageSettings != null ? spaceStorageSettings.build() : null;
        }

        @Override
        public final Builder spaceStorageSettings(SpaceStorageSettings spaceStorageSettings) {
            this.spaceStorageSettings = spaceStorageSettings;
            return this;
        }

        public final String getSpaceManagedResources() {
            return spaceManagedResources;
        }

        public final void setSpaceManagedResources(String spaceManagedResources) {
            this.spaceManagedResources = spaceManagedResources;
        }

        @Override
        public final Builder spaceManagedResources(String spaceManagedResources) {
            this.spaceManagedResources = spaceManagedResources;
            return this;
        }

        @Override
        public final Builder spaceManagedResources(FeatureStatus spaceManagedResources) {
            this.spaceManagedResources(spaceManagedResources == null ? null : spaceManagedResources.toString());
            return this;
        }

        public final List<CustomFileSystem.Builder> getCustomFileSystems() {
            List<CustomFileSystem.Builder> result = CustomFileSystemsCopier.copyToBuilder(this.customFileSystems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomFileSystems(Collection<CustomFileSystem.BuilderImpl> customFileSystems) {
            this.customFileSystems = CustomFileSystemsCopier.copyFromBuilder(customFileSystems);
        }

        @Override
        public final Builder customFileSystems(Collection<CustomFileSystem> customFileSystems) {
            this.customFileSystems = CustomFileSystemsCopier.copy(customFileSystems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customFileSystems(CustomFileSystem... customFileSystems) {
            customFileSystems(Arrays.asList(customFileSystems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customFileSystems(Consumer<CustomFileSystem.Builder>... customFileSystems) {
            customFileSystems(Stream.of(customFileSystems).map(c -> CustomFileSystem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public SpaceSettings build() {
            return new SpaceSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
