/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateClusterSoftwareRequest extends SageMakerRequest implements
        ToCopyableBuilder<UpdateClusterSoftwareRequest.Builder, UpdateClusterSoftwareRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterName").getter(getter(UpdateClusterSoftwareRequest::clusterName))
            .setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterName").build()).build();

    private static final SdkField<List<UpdateClusterSoftwareInstanceGroupSpecification>> INSTANCE_GROUPS_FIELD = SdkField
            .<List<UpdateClusterSoftwareInstanceGroupSpecification>> builder(MarshallingType.LIST)
            .memberName("InstanceGroups")
            .getter(getter(UpdateClusterSoftwareRequest::instanceGroups))
            .setter(setter(Builder::instanceGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UpdateClusterSoftwareInstanceGroupSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(UpdateClusterSoftwareInstanceGroupSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DeploymentConfiguration> DEPLOYMENT_CONFIG_FIELD = SdkField
            .<DeploymentConfiguration> builder(MarshallingType.SDK_POJO).memberName("DeploymentConfig")
            .getter(getter(UpdateClusterSoftwareRequest::deploymentConfig)).setter(setter(Builder::deploymentConfig))
            .constructor(DeploymentConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD,
            INSTANCE_GROUPS_FIELD, DEPLOYMENT_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clusterName;

    private final List<UpdateClusterSoftwareInstanceGroupSpecification> instanceGroups;

    private final DeploymentConfiguration deploymentConfig;

    private UpdateClusterSoftwareRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.instanceGroups = builder.instanceGroups;
        this.deploymentConfig = builder.deploymentConfig;
    }

    /**
     * <p>
     * Specify the name or the Amazon Resource Name (ARN) of the SageMaker HyperPod cluster you want to update for
     * security patching.
     * </p>
     * 
     * @return Specify the name or the Amazon Resource Name (ARN) of the SageMaker HyperPod cluster you want to update
     *         for security patching.
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInstanceGroups() {
        return instanceGroups != null && !(instanceGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The array of instance groups for which to update AMI versions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceGroups} method.
     * </p>
     * 
     * @return The array of instance groups for which to update AMI versions.
     */
    public final List<UpdateClusterSoftwareInstanceGroupSpecification> instanceGroups() {
        return instanceGroups;
    }

    /**
     * <p>
     * The configuration to use when updating the AMI versions.
     * </p>
     * 
     * @return The configuration to use when updating the AMI versions.
     */
    public final DeploymentConfiguration deploymentConfig() {
        return deploymentConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceGroups() ? instanceGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(deploymentConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateClusterSoftwareRequest)) {
            return false;
        }
        UpdateClusterSoftwareRequest other = (UpdateClusterSoftwareRequest) obj;
        return Objects.equals(clusterName(), other.clusterName()) && hasInstanceGroups() == other.hasInstanceGroups()
                && Objects.equals(instanceGroups(), other.instanceGroups())
                && Objects.equals(deploymentConfig(), other.deploymentConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateClusterSoftwareRequest").add("ClusterName", clusterName())
                .add("InstanceGroups", hasInstanceGroups() ? instanceGroups() : null).add("DeploymentConfig", deploymentConfig())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "InstanceGroups":
            return Optional.ofNullable(clazz.cast(instanceGroups()));
        case "DeploymentConfig":
            return Optional.ofNullable(clazz.cast(deploymentConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClusterName", CLUSTER_NAME_FIELD);
        map.put("InstanceGroups", INSTANCE_GROUPS_FIELD);
        map.put("DeploymentConfig", DEPLOYMENT_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateClusterSoftwareRequest, T> g) {
        return obj -> g.apply((UpdateClusterSoftwareRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateClusterSoftwareRequest> {
        /**
         * <p>
         * Specify the name or the Amazon Resource Name (ARN) of the SageMaker HyperPod cluster you want to update for
         * security patching.
         * </p>
         * 
         * @param clusterName
         *        Specify the name or the Amazon Resource Name (ARN) of the SageMaker HyperPod cluster you want to
         *        update for security patching.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * The array of instance groups for which to update AMI versions.
         * </p>
         * 
         * @param instanceGroups
         *        The array of instance groups for which to update AMI versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceGroups(Collection<UpdateClusterSoftwareInstanceGroupSpecification> instanceGroups);

        /**
         * <p>
         * The array of instance groups for which to update AMI versions.
         * </p>
         * 
         * @param instanceGroups
         *        The array of instance groups for which to update AMI versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceGroups(UpdateClusterSoftwareInstanceGroupSpecification... instanceGroups);

        /**
         * <p>
         * The array of instance groups for which to update AMI versions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.UpdateClusterSoftwareInstanceGroupSpecification.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.UpdateClusterSoftwareInstanceGroupSpecification#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.UpdateClusterSoftwareInstanceGroupSpecification.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #instanceGroups(List<UpdateClusterSoftwareInstanceGroupSpecification>)}.
         * 
         * @param instanceGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.UpdateClusterSoftwareInstanceGroupSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceGroups(java.util.Collection<UpdateClusterSoftwareInstanceGroupSpecification>)
         */
        Builder instanceGroups(Consumer<UpdateClusterSoftwareInstanceGroupSpecification.Builder>... instanceGroups);

        /**
         * <p>
         * The configuration to use when updating the AMI versions.
         * </p>
         * 
         * @param deploymentConfig
         *        The configuration to use when updating the AMI versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentConfig(DeploymentConfiguration deploymentConfig);

        /**
         * <p>
         * The configuration to use when updating the AMI versions.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeploymentConfiguration.Builder} avoiding
         * the need to create one manually via {@link DeploymentConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeploymentConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #deploymentConfig(DeploymentConfiguration)}.
         * 
         * @param deploymentConfig
         *        a consumer that will call methods on {@link DeploymentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentConfig(DeploymentConfiguration)
         */
        default Builder deploymentConfig(Consumer<DeploymentConfiguration.Builder> deploymentConfig) {
            return deploymentConfig(DeploymentConfiguration.builder().applyMutation(deploymentConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String clusterName;

        private List<UpdateClusterSoftwareInstanceGroupSpecification> instanceGroups = DefaultSdkAutoConstructList.getInstance();

        private DeploymentConfiguration deploymentConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateClusterSoftwareRequest model) {
            super(model);
            clusterName(model.clusterName);
            instanceGroups(model.instanceGroups);
            deploymentConfig(model.deploymentConfig);
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final List<UpdateClusterSoftwareInstanceGroupSpecification.Builder> getInstanceGroups() {
            List<UpdateClusterSoftwareInstanceGroupSpecification.Builder> result = UpdateClusterSoftwareInstanceGroupsCopier
                    .copyToBuilder(this.instanceGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceGroups(Collection<UpdateClusterSoftwareInstanceGroupSpecification.BuilderImpl> instanceGroups) {
            this.instanceGroups = UpdateClusterSoftwareInstanceGroupsCopier.copyFromBuilder(instanceGroups);
        }

        @Override
        public final Builder instanceGroups(Collection<UpdateClusterSoftwareInstanceGroupSpecification> instanceGroups) {
            this.instanceGroups = UpdateClusterSoftwareInstanceGroupsCopier.copy(instanceGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroups(UpdateClusterSoftwareInstanceGroupSpecification... instanceGroups) {
            instanceGroups(Arrays.asList(instanceGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroups(Consumer<UpdateClusterSoftwareInstanceGroupSpecification.Builder>... instanceGroups) {
            instanceGroups(Stream.of(instanceGroups)
                    .map(c -> UpdateClusterSoftwareInstanceGroupSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final DeploymentConfiguration.Builder getDeploymentConfig() {
            return deploymentConfig != null ? deploymentConfig.toBuilder() : null;
        }

        public final void setDeploymentConfig(DeploymentConfiguration.BuilderImpl deploymentConfig) {
            this.deploymentConfig = deploymentConfig != null ? deploymentConfig.build() : null;
        }

        @Override
        public final Builder deploymentConfig(DeploymentConfiguration deploymentConfig) {
            this.deploymentConfig = deploymentConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateClusterSoftwareRequest build() {
            return new UpdateClusterSoftwareRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
