/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateMlflowTrackingServerResponse extends SageMakerResponse implements
        ToCopyableBuilder<UpdateMlflowTrackingServerResponse.Builder, UpdateMlflowTrackingServerResponse> {
    private static final SdkField<String> TRACKING_SERVER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrackingServerArn").getter(getter(UpdateMlflowTrackingServerResponse::trackingServerArn))
            .setter(setter(Builder::trackingServerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackingServerArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACKING_SERVER_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String trackingServerArn;

    private UpdateMlflowTrackingServerResponse(BuilderImpl builder) {
        super(builder);
        this.trackingServerArn = builder.trackingServerArn;
    }

    /**
     * <p>
     * The ARN of the updated MLflow Tracking Server.
     * </p>
     * 
     * @return The ARN of the updated MLflow Tracking Server.
     */
    public final String trackingServerArn() {
        return trackingServerArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trackingServerArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMlflowTrackingServerResponse)) {
            return false;
        }
        UpdateMlflowTrackingServerResponse other = (UpdateMlflowTrackingServerResponse) obj;
        return Objects.equals(trackingServerArn(), other.trackingServerArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateMlflowTrackingServerResponse").add("TrackingServerArn", trackingServerArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrackingServerArn":
            return Optional.ofNullable(clazz.cast(trackingServerArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TrackingServerArn", TRACKING_SERVER_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateMlflowTrackingServerResponse, T> g) {
        return obj -> g.apply((UpdateMlflowTrackingServerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateMlflowTrackingServerResponse> {
        /**
         * <p>
         * The ARN of the updated MLflow Tracking Server.
         * </p>
         * 
         * @param trackingServerArn
         *        The ARN of the updated MLflow Tracking Server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackingServerArn(String trackingServerArn);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String trackingServerArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMlflowTrackingServerResponse model) {
            super(model);
            trackingServerArn(model.trackingServerArn);
        }

        public final String getTrackingServerArn() {
            return trackingServerArn;
        }

        public final void setTrackingServerArn(String trackingServerArn) {
            this.trackingServerArn = trackingServerArn;
        }

        @Override
        public final Builder trackingServerArn(String trackingServerArn) {
            this.trackingServerArn = trackingServerArn;
            return this;
        }

        @Override
        public UpdateMlflowTrackingServerResponse build() {
            return new UpdateMlflowTrackingServerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
