/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateUserProfileRequest extends SageMakerRequest implements
        ToCopyableBuilder<UpdateUserProfileRequest.Builder, UpdateUserProfileRequest> {
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainId").getter(getter(UpdateUserProfileRequest::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()).build();

    private static final SdkField<String> USER_PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserProfileName").getter(getter(UpdateUserProfileRequest::userProfileName))
            .setter(setter(Builder::userProfileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserProfileName").build()).build();

    private static final SdkField<UserSettings> USER_SETTINGS_FIELD = SdkField.<UserSettings> builder(MarshallingType.SDK_POJO)
            .memberName("UserSettings").getter(getter(UpdateUserProfileRequest::userSettings))
            .setter(setter(Builder::userSettings)).constructor(UserSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ID_FIELD,
            USER_PROFILE_NAME_FIELD, USER_SETTINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String domainId;

    private final String userProfileName;

    private final UserSettings userSettings;

    private UpdateUserProfileRequest(BuilderImpl builder) {
        super(builder);
        this.domainId = builder.domainId;
        this.userProfileName = builder.userProfileName;
        this.userSettings = builder.userSettings;
    }

    /**
     * <p>
     * The domain ID.
     * </p>
     * 
     * @return The domain ID.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The user profile name.
     * </p>
     * 
     * @return The user profile name.
     */
    public final String userProfileName() {
        return userProfileName;
    }

    /**
     * <p>
     * A collection of settings.
     * </p>
     * 
     * @return A collection of settings.
     */
    public final UserSettings userSettings() {
        return userSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(userProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(userSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserProfileRequest)) {
            return false;
        }
        UpdateUserProfileRequest other = (UpdateUserProfileRequest) obj;
        return Objects.equals(domainId(), other.domainId()) && Objects.equals(userProfileName(), other.userProfileName())
                && Objects.equals(userSettings(), other.userSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateUserProfileRequest").add("DomainId", domainId()).add("UserProfileName", userProfileName())
                .add("UserSettings", userSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "UserProfileName":
            return Optional.ofNullable(clazz.cast(userProfileName()));
        case "UserSettings":
            return Optional.ofNullable(clazz.cast(userSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DomainId", DOMAIN_ID_FIELD);
        map.put("UserProfileName", USER_PROFILE_NAME_FIELD);
        map.put("UserSettings", USER_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateUserProfileRequest, T> g) {
        return obj -> g.apply((UpdateUserProfileRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateUserProfileRequest> {
        /**
         * <p>
         * The domain ID.
         * </p>
         * 
         * @param domainId
         *        The domain ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The user profile name.
         * </p>
         * 
         * @param userProfileName
         *        The user profile name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userProfileName(String userProfileName);

        /**
         * <p>
         * A collection of settings.
         * </p>
         * 
         * @param userSettings
         *        A collection of settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userSettings(UserSettings userSettings);

        /**
         * <p>
         * A collection of settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserSettings.Builder} avoiding the need
         * to create one manually via {@link UserSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #userSettings(UserSettings)}.
         * 
         * @param userSettings
         *        a consumer that will call methods on {@link UserSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userSettings(UserSettings)
         */
        default Builder userSettings(Consumer<UserSettings.Builder> userSettings) {
            return userSettings(UserSettings.builder().applyMutation(userSettings).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String domainId;

        private String userProfileName;

        private UserSettings userSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserProfileRequest model) {
            super(model);
            domainId(model.domainId);
            userProfileName(model.userProfileName);
            userSettings(model.userSettings);
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getUserProfileName() {
            return userProfileName;
        }

        public final void setUserProfileName(String userProfileName) {
            this.userProfileName = userProfileName;
        }

        @Override
        public final Builder userProfileName(String userProfileName) {
            this.userProfileName = userProfileName;
            return this;
        }

        public final UserSettings.Builder getUserSettings() {
            return userSettings != null ? userSettings.toBuilder() : null;
        }

        public final void setUserSettings(UserSettings.BuilderImpl userSettings) {
            this.userSettings = userSettings != null ? userSettings.build() : null;
        }

        @Override
        public final Builder userSettings(UserSettings userSettings) {
            this.userSettings = userSettings;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateUserProfileRequest build() {
            return new UpdateUserProfileRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
