/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the user who created or modified an experiment, trial, trial component, lineage group, project, or
 * model card.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserContext implements SdkPojo, Serializable, ToCopyableBuilder<UserContext.Builder, UserContext> {
    private static final SdkField<String> USER_PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserProfileArn").getter(getter(UserContext::userProfileArn)).setter(setter(Builder::userProfileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserProfileArn").build()).build();

    private static final SdkField<String> USER_PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserProfileName").getter(getter(UserContext::userProfileName)).setter(setter(Builder::userProfileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserProfileName").build()).build();

    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainId").getter(getter(UserContext::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()).build();

    private static final SdkField<IamIdentity> IAM_IDENTITY_FIELD = SdkField.<IamIdentity> builder(MarshallingType.SDK_POJO)
            .memberName("IamIdentity").getter(getter(UserContext::iamIdentity)).setter(setter(Builder::iamIdentity))
            .constructor(IamIdentity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamIdentity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_PROFILE_ARN_FIELD,
            USER_PROFILE_NAME_FIELD, DOMAIN_ID_FIELD, IAM_IDENTITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String userProfileArn;

    private final String userProfileName;

    private final String domainId;

    private final IamIdentity iamIdentity;

    private UserContext(BuilderImpl builder) {
        this.userProfileArn = builder.userProfileArn;
        this.userProfileName = builder.userProfileName;
        this.domainId = builder.domainId;
        this.iamIdentity = builder.iamIdentity;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the user's profile.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the user's profile.
     */
    public final String userProfileArn() {
        return userProfileArn;
    }

    /**
     * <p>
     * The name of the user's profile.
     * </p>
     * 
     * @return The name of the user's profile.
     */
    public final String userProfileName() {
        return userProfileName;
    }

    /**
     * <p>
     * The domain associated with the user.
     * </p>
     * 
     * @return The domain associated with the user.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The IAM Identity details associated with the user. These details are associated with model package groups, model
     * packages, and project entities only.
     * </p>
     * 
     * @return The IAM Identity details associated with the user. These details are associated with model package
     *         groups, model packages, and project entities only.
     */
    public final IamIdentity iamIdentity() {
        return iamIdentity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(userProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(iamIdentity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserContext)) {
            return false;
        }
        UserContext other = (UserContext) obj;
        return Objects.equals(userProfileArn(), other.userProfileArn())
                && Objects.equals(userProfileName(), other.userProfileName()) && Objects.equals(domainId(), other.domainId())
                && Objects.equals(iamIdentity(), other.iamIdentity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserContext").add("UserProfileArn", userProfileArn()).add("UserProfileName", userProfileName())
                .add("DomainId", domainId()).add("IamIdentity", iamIdentity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserProfileArn":
            return Optional.ofNullable(clazz.cast(userProfileArn()));
        case "UserProfileName":
            return Optional.ofNullable(clazz.cast(userProfileName()));
        case "DomainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "IamIdentity":
            return Optional.ofNullable(clazz.cast(iamIdentity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("UserProfileArn", USER_PROFILE_ARN_FIELD);
        map.put("UserProfileName", USER_PROFILE_NAME_FIELD);
        map.put("DomainId", DOMAIN_ID_FIELD);
        map.put("IamIdentity", IAM_IDENTITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UserContext, T> g) {
        return obj -> g.apply((UserContext) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserContext> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the user's profile.
         * </p>
         * 
         * @param userProfileArn
         *        The Amazon Resource Name (ARN) of the user's profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userProfileArn(String userProfileArn);

        /**
         * <p>
         * The name of the user's profile.
         * </p>
         * 
         * @param userProfileName
         *        The name of the user's profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userProfileName(String userProfileName);

        /**
         * <p>
         * The domain associated with the user.
         * </p>
         * 
         * @param domainId
         *        The domain associated with the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The IAM Identity details associated with the user. These details are associated with model package groups,
         * model packages, and project entities only.
         * </p>
         * 
         * @param iamIdentity
         *        The IAM Identity details associated with the user. These details are associated with model package
         *        groups, model packages, and project entities only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamIdentity(IamIdentity iamIdentity);

        /**
         * <p>
         * The IAM Identity details associated with the user. These details are associated with model package groups,
         * model packages, and project entities only.
         * </p>
         * This is a convenience method that creates an instance of the {@link IamIdentity.Builder} avoiding the need to
         * create one manually via {@link IamIdentity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IamIdentity.Builder#build()} is called immediately and its result
         * is passed to {@link #iamIdentity(IamIdentity)}.
         * 
         * @param iamIdentity
         *        a consumer that will call methods on {@link IamIdentity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iamIdentity(IamIdentity)
         */
        default Builder iamIdentity(Consumer<IamIdentity.Builder> iamIdentity) {
            return iamIdentity(IamIdentity.builder().applyMutation(iamIdentity).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String userProfileArn;

        private String userProfileName;

        private String domainId;

        private IamIdentity iamIdentity;

        private BuilderImpl() {
        }

        private BuilderImpl(UserContext model) {
            userProfileArn(model.userProfileArn);
            userProfileName(model.userProfileName);
            domainId(model.domainId);
            iamIdentity(model.iamIdentity);
        }

        public final String getUserProfileArn() {
            return userProfileArn;
        }

        public final void setUserProfileArn(String userProfileArn) {
            this.userProfileArn = userProfileArn;
        }

        @Override
        public final Builder userProfileArn(String userProfileArn) {
            this.userProfileArn = userProfileArn;
            return this;
        }

        public final String getUserProfileName() {
            return userProfileName;
        }

        public final void setUserProfileName(String userProfileName) {
            this.userProfileName = userProfileName;
        }

        @Override
        public final Builder userProfileName(String userProfileName) {
            this.userProfileName = userProfileName;
            return this;
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final IamIdentity.Builder getIamIdentity() {
            return iamIdentity != null ? iamIdentity.toBuilder() : null;
        }

        public final void setIamIdentity(IamIdentity.BuilderImpl iamIdentity) {
            this.iamIdentity = iamIdentity != null ? iamIdentity.build() : null;
        }

        @Override
        public final Builder iamIdentity(IamIdentity iamIdentity) {
            this.iamIdentity = iamIdentity;
            return this;
        }

        @Override
        public UserContext build() {
            return new UserContext(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
