/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ExperimentSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExperimentSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExperimentSummary> {
    private static final SdkField<String> EXPERIMENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExperimentArn").getter(ExperimentSummary.getter(ExperimentSummary::experimentArn)).setter(ExperimentSummary.setter(Builder::experimentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExperimentArn").build()}).build();
    private static final SdkField<String> EXPERIMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExperimentName").getter(ExperimentSummary.getter(ExperimentSummary::experimentName)).setter(ExperimentSummary.setter(Builder::experimentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExperimentName").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(ExperimentSummary.getter(ExperimentSummary::displayName)).setter(ExperimentSummary.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<ExperimentSource> EXPERIMENT_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExperimentSource").getter(ExperimentSummary.getter(ExperimentSummary::experimentSource)).setter(ExperimentSummary.setter(Builder::experimentSource)).constructor(ExperimentSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExperimentSource").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(ExperimentSummary.getter(ExperimentSummary::creationTime)).setter(ExperimentSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(ExperimentSummary.getter(ExperimentSummary::lastModifiedTime)).setter(ExperimentSummary.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPERIMENT_ARN_FIELD, EXPERIMENT_NAME_FIELD, DISPLAY_NAME_FIELD, EXPERIMENT_SOURCE_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExperimentSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String experimentArn;
    private final String experimentName;
    private final String displayName;
    private final ExperimentSource experimentSource;
    private final Instant creationTime;
    private final Instant lastModifiedTime;

    private ExperimentSummary(BuilderImpl builder) {
        this.experimentArn = builder.experimentArn;
        this.experimentName = builder.experimentName;
        this.displayName = builder.displayName;
        this.experimentSource = builder.experimentSource;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    public final String experimentArn() {
        return this.experimentArn;
    }

    public final String experimentName() {
        return this.experimentName;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final ExperimentSource experimentSource() {
        return this.experimentSource;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.experimentArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.experimentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.experimentSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExperimentSummary)) {
            return false;
        }
        ExperimentSummary other = (ExperimentSummary)obj;
        return Objects.equals(this.experimentArn(), other.experimentArn()) && Objects.equals(this.experimentName(), other.experimentName()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.experimentSource(), other.experimentSource()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime());
    }

    public final String toString() {
        return ToString.builder((String)"ExperimentSummary").add("ExperimentArn", (Object)this.experimentArn()).add("ExperimentName", (Object)this.experimentName()).add("DisplayName", (Object)this.displayName()).add("ExperimentSource", (Object)this.experimentSource()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExperimentArn": {
                return Optional.ofNullable(clazz.cast(this.experimentArn()));
            }
            case "ExperimentName": {
                return Optional.ofNullable(clazz.cast(this.experimentName()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "ExperimentSource": {
                return Optional.ofNullable(clazz.cast(this.experimentSource()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ExperimentArn", EXPERIMENT_ARN_FIELD);
        map.put("ExperimentName", EXPERIMENT_NAME_FIELD);
        map.put("DisplayName", DISPLAY_NAME_FIELD);
        map.put("ExperimentSource", EXPERIMENT_SOURCE_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExperimentSummary, T> g) {
        return obj -> g.apply((ExperimentSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String experimentArn;
        private String experimentName;
        private String displayName;
        private ExperimentSource experimentSource;
        private Instant creationTime;
        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ExperimentSummary model) {
            this.experimentArn(model.experimentArn);
            this.experimentName(model.experimentName);
            this.displayName(model.displayName);
            this.experimentSource(model.experimentSource);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
        }

        public final String getExperimentArn() {
            return this.experimentArn;
        }

        public final void setExperimentArn(String experimentArn) {
            this.experimentArn = experimentArn;
        }

        @Override
        public final Builder experimentArn(String experimentArn) {
            this.experimentArn = experimentArn;
            return this;
        }

        public final String getExperimentName() {
            return this.experimentName;
        }

        public final void setExperimentName(String experimentName) {
            this.experimentName = experimentName;
        }

        @Override
        public final Builder experimentName(String experimentName) {
            this.experimentName = experimentName;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final ExperimentSource.Builder getExperimentSource() {
            return this.experimentSource != null ? this.experimentSource.toBuilder() : null;
        }

        public final void setExperimentSource(ExperimentSource.BuilderImpl experimentSource) {
            this.experimentSource = experimentSource != null ? experimentSource.build() : null;
        }

        @Override
        public final Builder experimentSource(ExperimentSource experimentSource) {
            this.experimentSource = experimentSource;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public ExperimentSummary build() {
            return new ExperimentSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExperimentSummary> {
        public Builder experimentArn(String var1);

        public Builder experimentName(String var1);

        public Builder displayName(String var1);

        public Builder experimentSource(ExperimentSource var1);

        default public Builder experimentSource(Consumer<ExperimentSource.Builder> experimentSource) {
            return this.experimentSource((ExperimentSource)((ExperimentSource.Builder)ExperimentSource.builder().applyMutation(experimentSource)).build());
        }

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);
    }
}

