/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.OwnershipSettings;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.services.sagemaker.model.SpaceSettings;
import software.amazon.awssdk.services.sagemaker.model.SpaceSharingSettings;
import software.amazon.awssdk.services.sagemaker.model.SpaceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSpaceResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeSpaceResponse> {
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainId").getter(DescribeSpaceResponse.getter(DescribeSpaceResponse::domainId)).setter(DescribeSpaceResponse.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()}).build();
    private static final SdkField<String> SPACE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SpaceArn").getter(DescribeSpaceResponse.getter(DescribeSpaceResponse::spaceArn)).setter(DescribeSpaceResponse.setter(Builder::spaceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpaceArn").build()}).build();
    private static final SdkField<String> SPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SpaceName").getter(DescribeSpaceResponse.getter(DescribeSpaceResponse::spaceName)).setter(DescribeSpaceResponse.setter(Builder::spaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpaceName").build()}).build();
    private static final SdkField<String> HOME_EFS_FILE_SYSTEM_UID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HomeEfsFileSystemUid").getter(DescribeSpaceResponse.getter(DescribeSpaceResponse::homeEfsFileSystemUid)).setter(DescribeSpaceResponse.setter(Builder::homeEfsFileSystemUid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeEfsFileSystemUid").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeSpaceResponse.getter(DescribeSpaceResponse::statusAsString)).setter(DescribeSpaceResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(DescribeSpaceResponse.getter(DescribeSpaceResponse::lastModifiedTime)).setter(DescribeSpaceResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeSpaceResponse.getter(DescribeSpaceResponse::creationTime)).setter(DescribeSpaceResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(DescribeSpaceResponse.getter(DescribeSpaceResponse::failureReason)).setter(DescribeSpaceResponse.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<SpaceSettings> SPACE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SpaceSettings").getter(DescribeSpaceResponse.getter(DescribeSpaceResponse::spaceSettings)).setter(DescribeSpaceResponse.setter(Builder::spaceSettings)).constructor(SpaceSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpaceSettings").build()}).build();
    private static final SdkField<OwnershipSettings> OWNERSHIP_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OwnershipSettings").getter(DescribeSpaceResponse.getter(DescribeSpaceResponse::ownershipSettings)).setter(DescribeSpaceResponse.setter(Builder::ownershipSettings)).constructor(OwnershipSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnershipSettings").build()}).build();
    private static final SdkField<SpaceSharingSettings> SPACE_SHARING_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SpaceSharingSettings").getter(DescribeSpaceResponse.getter(DescribeSpaceResponse::spaceSharingSettings)).setter(DescribeSpaceResponse.setter(Builder::spaceSharingSettings)).constructor(SpaceSharingSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpaceSharingSettings").build()}).build();
    private static final SdkField<String> SPACE_DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SpaceDisplayName").getter(DescribeSpaceResponse.getter(DescribeSpaceResponse::spaceDisplayName)).setter(DescribeSpaceResponse.setter(Builder::spaceDisplayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpaceDisplayName").build()}).build();
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Url").getter(DescribeSpaceResponse.getter(DescribeSpaceResponse::url)).setter(DescribeSpaceResponse.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ID_FIELD, SPACE_ARN_FIELD, SPACE_NAME_FIELD, HOME_EFS_FILE_SYSTEM_UID_FIELD, STATUS_FIELD, LAST_MODIFIED_TIME_FIELD, CREATION_TIME_FIELD, FAILURE_REASON_FIELD, SPACE_SETTINGS_FIELD, OWNERSHIP_SETTINGS_FIELD, SPACE_SHARING_SETTINGS_FIELD, SPACE_DISPLAY_NAME_FIELD, URL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeSpaceResponse.memberNameToFieldInitializer();
    private final String domainId;
    private final String spaceArn;
    private final String spaceName;
    private final String homeEfsFileSystemUid;
    private final String status;
    private final Instant lastModifiedTime;
    private final Instant creationTime;
    private final String failureReason;
    private final SpaceSettings spaceSettings;
    private final OwnershipSettings ownershipSettings;
    private final SpaceSharingSettings spaceSharingSettings;
    private final String spaceDisplayName;
    private final String url;

    private DescribeSpaceResponse(BuilderImpl builder) {
        super(builder);
        this.domainId = builder.domainId;
        this.spaceArn = builder.spaceArn;
        this.spaceName = builder.spaceName;
        this.homeEfsFileSystemUid = builder.homeEfsFileSystemUid;
        this.status = builder.status;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.creationTime = builder.creationTime;
        this.failureReason = builder.failureReason;
        this.spaceSettings = builder.spaceSettings;
        this.ownershipSettings = builder.ownershipSettings;
        this.spaceSharingSettings = builder.spaceSharingSettings;
        this.spaceDisplayName = builder.spaceDisplayName;
        this.url = builder.url;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final String spaceArn() {
        return this.spaceArn;
    }

    public final String spaceName() {
        return this.spaceName;
    }

    public final String homeEfsFileSystemUid() {
        return this.homeEfsFileSystemUid;
    }

    public final SpaceStatus status() {
        return SpaceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final SpaceSettings spaceSettings() {
        return this.spaceSettings;
    }

    public final OwnershipSettings ownershipSettings() {
        return this.ownershipSettings;
    }

    public final SpaceSharingSettings spaceSharingSettings() {
        return this.spaceSharingSettings;
    }

    public final String spaceDisplayName() {
        return this.spaceDisplayName;
    }

    public final String url() {
        return this.url;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.spaceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.spaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.homeEfsFileSystemUid());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.spaceSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownershipSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.spaceSharingSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.spaceDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSpaceResponse)) {
            return false;
        }
        DescribeSpaceResponse other = (DescribeSpaceResponse)((Object)obj);
        return Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.spaceArn(), other.spaceArn()) && Objects.equals(this.spaceName(), other.spaceName()) && Objects.equals(this.homeEfsFileSystemUid(), other.homeEfsFileSystemUid()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.spaceSettings(), other.spaceSettings()) && Objects.equals(this.ownershipSettings(), other.ownershipSettings()) && Objects.equals(this.spaceSharingSettings(), other.spaceSharingSettings()) && Objects.equals(this.spaceDisplayName(), other.spaceDisplayName()) && Objects.equals(this.url(), other.url());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeSpaceResponse").add("DomainId", (Object)this.domainId()).add("SpaceArn", (Object)this.spaceArn()).add("SpaceName", (Object)this.spaceName()).add("HomeEfsFileSystemUid", (Object)this.homeEfsFileSystemUid()).add("Status", (Object)this.statusAsString()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("CreationTime", (Object)this.creationTime()).add("FailureReason", (Object)this.failureReason()).add("SpaceSettings", (Object)this.spaceSettings()).add("OwnershipSettings", (Object)this.ownershipSettings()).add("SpaceSharingSettings", (Object)this.spaceSharingSettings()).add("SpaceDisplayName", (Object)this.spaceDisplayName()).add("Url", (Object)this.url()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "SpaceArn": {
                return Optional.ofNullable(clazz.cast(this.spaceArn()));
            }
            case "SpaceName": {
                return Optional.ofNullable(clazz.cast(this.spaceName()));
            }
            case "HomeEfsFileSystemUid": {
                return Optional.ofNullable(clazz.cast(this.homeEfsFileSystemUid()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "SpaceSettings": {
                return Optional.ofNullable(clazz.cast(this.spaceSettings()));
            }
            case "OwnershipSettings": {
                return Optional.ofNullable(clazz.cast(this.ownershipSettings()));
            }
            case "SpaceSharingSettings": {
                return Optional.ofNullable(clazz.cast(this.spaceSharingSettings()));
            }
            case "SpaceDisplayName": {
                return Optional.ofNullable(clazz.cast(this.spaceDisplayName()));
            }
            case "Url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DomainId", DOMAIN_ID_FIELD);
        map.put("SpaceArn", SPACE_ARN_FIELD);
        map.put("SpaceName", SPACE_NAME_FIELD);
        map.put("HomeEfsFileSystemUid", HOME_EFS_FILE_SYSTEM_UID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("FailureReason", FAILURE_REASON_FIELD);
        map.put("SpaceSettings", SPACE_SETTINGS_FIELD);
        map.put("OwnershipSettings", OWNERSHIP_SETTINGS_FIELD);
        map.put("SpaceSharingSettings", SPACE_SHARING_SETTINGS_FIELD);
        map.put("SpaceDisplayName", SPACE_DISPLAY_NAME_FIELD);
        map.put("Url", URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeSpaceResponse, T> g) {
        return obj -> g.apply((DescribeSpaceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String domainId;
        private String spaceArn;
        private String spaceName;
        private String homeEfsFileSystemUid;
        private String status;
        private Instant lastModifiedTime;
        private Instant creationTime;
        private String failureReason;
        private SpaceSettings spaceSettings;
        private OwnershipSettings ownershipSettings;
        private SpaceSharingSettings spaceSharingSettings;
        private String spaceDisplayName;
        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSpaceResponse model) {
            super(model);
            this.domainId(model.domainId);
            this.spaceArn(model.spaceArn);
            this.spaceName(model.spaceName);
            this.homeEfsFileSystemUid(model.homeEfsFileSystemUid);
            this.status(model.status);
            this.lastModifiedTime(model.lastModifiedTime);
            this.creationTime(model.creationTime);
            this.failureReason(model.failureReason);
            this.spaceSettings(model.spaceSettings);
            this.ownershipSettings(model.ownershipSettings);
            this.spaceSharingSettings(model.spaceSharingSettings);
            this.spaceDisplayName(model.spaceDisplayName);
            this.url(model.url);
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getSpaceArn() {
            return this.spaceArn;
        }

        public final void setSpaceArn(String spaceArn) {
            this.spaceArn = spaceArn;
        }

        @Override
        public final Builder spaceArn(String spaceArn) {
            this.spaceArn = spaceArn;
            return this;
        }

        public final String getSpaceName() {
            return this.spaceName;
        }

        public final void setSpaceName(String spaceName) {
            this.spaceName = spaceName;
        }

        @Override
        public final Builder spaceName(String spaceName) {
            this.spaceName = spaceName;
            return this;
        }

        public final String getHomeEfsFileSystemUid() {
            return this.homeEfsFileSystemUid;
        }

        public final void setHomeEfsFileSystemUid(String homeEfsFileSystemUid) {
            this.homeEfsFileSystemUid = homeEfsFileSystemUid;
        }

        @Override
        public final Builder homeEfsFileSystemUid(String homeEfsFileSystemUid) {
            this.homeEfsFileSystemUid = homeEfsFileSystemUid;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SpaceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final SpaceSettings.Builder getSpaceSettings() {
            return this.spaceSettings != null ? this.spaceSettings.toBuilder() : null;
        }

        public final void setSpaceSettings(SpaceSettings.BuilderImpl spaceSettings) {
            this.spaceSettings = spaceSettings != null ? spaceSettings.build() : null;
        }

        @Override
        public final Builder spaceSettings(SpaceSettings spaceSettings) {
            this.spaceSettings = spaceSettings;
            return this;
        }

        public final OwnershipSettings.Builder getOwnershipSettings() {
            return this.ownershipSettings != null ? this.ownershipSettings.toBuilder() : null;
        }

        public final void setOwnershipSettings(OwnershipSettings.BuilderImpl ownershipSettings) {
            this.ownershipSettings = ownershipSettings != null ? ownershipSettings.build() : null;
        }

        @Override
        public final Builder ownershipSettings(OwnershipSettings ownershipSettings) {
            this.ownershipSettings = ownershipSettings;
            return this;
        }

        public final SpaceSharingSettings.Builder getSpaceSharingSettings() {
            return this.spaceSharingSettings != null ? this.spaceSharingSettings.toBuilder() : null;
        }

        public final void setSpaceSharingSettings(SpaceSharingSettings.BuilderImpl spaceSharingSettings) {
            this.spaceSharingSettings = spaceSharingSettings != null ? spaceSharingSettings.build() : null;
        }

        @Override
        public final Builder spaceSharingSettings(SpaceSharingSettings spaceSharingSettings) {
            this.spaceSharingSettings = spaceSharingSettings;
            return this;
        }

        public final String getSpaceDisplayName() {
            return this.spaceDisplayName;
        }

        public final void setSpaceDisplayName(String spaceDisplayName) {
            this.spaceDisplayName = spaceDisplayName;
        }

        @Override
        public final Builder spaceDisplayName(String spaceDisplayName) {
            this.spaceDisplayName = spaceDisplayName;
            return this;
        }

        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        @Override
        public DescribeSpaceResponse build() {
            return new DescribeSpaceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeSpaceResponse> {
        public Builder domainId(String var1);

        public Builder spaceArn(String var1);

        public Builder spaceName(String var1);

        public Builder homeEfsFileSystemUid(String var1);

        public Builder status(String var1);

        public Builder status(SpaceStatus var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder creationTime(Instant var1);

        public Builder failureReason(String var1);

        public Builder spaceSettings(SpaceSettings var1);

        default public Builder spaceSettings(Consumer<SpaceSettings.Builder> spaceSettings) {
            return this.spaceSettings((SpaceSettings)((SpaceSettings.Builder)SpaceSettings.builder().applyMutation(spaceSettings)).build());
        }

        public Builder ownershipSettings(OwnershipSettings var1);

        default public Builder ownershipSettings(Consumer<OwnershipSettings.Builder> ownershipSettings) {
            return this.ownershipSettings((OwnershipSettings)((OwnershipSettings.Builder)OwnershipSettings.builder().applyMutation(ownershipSettings)).build());
        }

        public Builder spaceSharingSettings(SpaceSharingSettings var1);

        default public Builder spaceSharingSettings(Consumer<SpaceSharingSettings.Builder> spaceSharingSettings) {
            return this.spaceSharingSettings((SpaceSharingSettings)((SpaceSharingSettings.Builder)SpaceSharingSettings.builder().applyMutation(spaceSharingSettings)).build());
        }

        public Builder spaceDisplayName(String var1);

        public Builder url(String var1);
    }
}

