/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.PartnerAppSummariesCopier;
import software.amazon.awssdk.services.sagemaker.model.PartnerAppSummary;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPartnerAppsResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListPartnerAppsResponse> {
    private static final SdkField<List<PartnerAppSummary>> SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Summaries").getter(ListPartnerAppsResponse.getter(ListPartnerAppsResponse::summaries)).setter(ListPartnerAppsResponse.setter(Builder::summaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Summaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PartnerAppSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListPartnerAppsResponse.getter(ListPartnerAppsResponse::nextToken)).setter(ListPartnerAppsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListPartnerAppsResponse.memberNameToFieldInitializer();
    private final List<PartnerAppSummary> summaries;
    private final String nextToken;

    private ListPartnerAppsResponse(BuilderImpl builder) {
        super(builder);
        this.summaries = builder.summaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSummaries() {
        return this.summaries != null && !(this.summaries instanceof SdkAutoConstructList);
    }

    public final List<PartnerAppSummary> summaries() {
        return this.summaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSummaries() ? this.summaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPartnerAppsResponse)) {
            return false;
        }
        ListPartnerAppsResponse other = (ListPartnerAppsResponse)((Object)obj);
        return this.hasSummaries() == other.hasSummaries() && Objects.equals(this.summaries(), other.summaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListPartnerAppsResponse").add("Summaries", this.hasSummaries() ? this.summaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Summaries": {
                return Optional.ofNullable(clazz.cast(this.summaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Summaries", SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPartnerAppsResponse, T> g) {
        return obj -> g.apply((ListPartnerAppsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<PartnerAppSummary> summaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPartnerAppsResponse model) {
            super(model);
            this.summaries(model.summaries);
            this.nextToken(model.nextToken);
        }

        public final List<PartnerAppSummary.Builder> getSummaries() {
            List<PartnerAppSummary.Builder> result = PartnerAppSummariesCopier.copyToBuilder(this.summaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSummaries(Collection<PartnerAppSummary.BuilderImpl> summaries) {
            this.summaries = PartnerAppSummariesCopier.copyFromBuilder(summaries);
        }

        @Override
        public final Builder summaries(Collection<PartnerAppSummary> summaries) {
            this.summaries = PartnerAppSummariesCopier.copy(summaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaries(PartnerAppSummary ... summaries) {
            this.summaries(Arrays.asList(summaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaries(Consumer<PartnerAppSummary.Builder> ... summaries) {
            this.summaries(Stream.of(summaries).map(c -> (PartnerAppSummary)((PartnerAppSummary.Builder)PartnerAppSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPartnerAppsResponse build() {
            return new ListPartnerAppsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPartnerAppsResponse> {
        public Builder summaries(Collection<PartnerAppSummary> var1);

        public Builder summaries(PartnerAppSummary ... var1);

        public Builder summaries(Consumer<PartnerAppSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

