/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.sagemaker.model.AddAssociationRequest;
import software.amazon.awssdk.services.sagemaker.model.AddAssociationResponse;
import software.amazon.awssdk.services.sagemaker.model.AddTagsRequest;
import software.amazon.awssdk.services.sagemaker.model.AddTagsResponse;
import software.amazon.awssdk.services.sagemaker.model.AssociateTrialComponentRequest;
import software.amazon.awssdk.services.sagemaker.model.AssociateTrialComponentResponse;
import software.amazon.awssdk.services.sagemaker.model.BatchDeleteClusterNodesRequest;
import software.amazon.awssdk.services.sagemaker.model.BatchDeleteClusterNodesResponse;
import software.amazon.awssdk.services.sagemaker.model.BatchDescribeModelPackageRequest;
import software.amazon.awssdk.services.sagemaker.model.BatchDescribeModelPackageResponse;
import software.amazon.awssdk.services.sagemaker.model.ConflictException;
import software.amazon.awssdk.services.sagemaker.model.CreateActionRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateActionResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateAlgorithmRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateAlgorithmResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateAppImageConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateAppImageConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateAppRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateAppResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateArtifactRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateArtifactResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateAutoMlJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateAutoMlJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateAutoMlJobV2Request;
import software.amazon.awssdk.services.sagemaker.model.CreateAutoMlJobV2Response;
import software.amazon.awssdk.services.sagemaker.model.CreateClusterRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateClusterResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateClusterSchedulerConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateClusterSchedulerConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateCodeRepositoryRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateCodeRepositoryResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateCompilationJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateCompilationJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateComputeQuotaRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateComputeQuotaResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateContextRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateContextResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateDataQualityJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateDataQualityJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateDeviceFleetRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateDeviceFleetResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateDomainRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateDomainResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateEdgeDeploymentPlanRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateEdgeDeploymentPlanResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateEdgeDeploymentStageRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateEdgeDeploymentStageResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateEdgePackagingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateEdgePackagingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateEndpointConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateEndpointConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateEndpointRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateEndpointResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateExperimentRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateExperimentResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateFeatureGroupRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateFeatureGroupResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateFlowDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateFlowDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateHubContentReferenceRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateHubContentReferenceResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateHubRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateHubResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateHumanTaskUiRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateHumanTaskUiResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateHyperParameterTuningJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateHyperParameterTuningJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateImageRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateImageResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateImageVersionRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateImageVersionResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateInferenceComponentRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateInferenceComponentResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateInferenceExperimentRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateInferenceExperimentResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateInferenceRecommendationsJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateInferenceRecommendationsJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateLabelingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateLabelingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateMlflowTrackingServerRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateMlflowTrackingServerResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateModelBiasJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateModelBiasJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateModelCardExportJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateModelCardExportJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateModelCardRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateModelCardResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateModelExplainabilityJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateModelExplainabilityJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateModelPackageGroupRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateModelPackageGroupResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateModelPackageRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateModelPackageResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateModelQualityJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateModelQualityJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateModelRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateModelResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateMonitoringScheduleRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateMonitoringScheduleResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceLifecycleConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceLifecycleConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateOptimizationJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateOptimizationJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreatePartnerAppPresignedUrlRequest;
import software.amazon.awssdk.services.sagemaker.model.CreatePartnerAppPresignedUrlResponse;
import software.amazon.awssdk.services.sagemaker.model.CreatePartnerAppRequest;
import software.amazon.awssdk.services.sagemaker.model.CreatePartnerAppResponse;
import software.amazon.awssdk.services.sagemaker.model.CreatePipelineRequest;
import software.amazon.awssdk.services.sagemaker.model.CreatePipelineResponse;
import software.amazon.awssdk.services.sagemaker.model.CreatePresignedDomainUrlRequest;
import software.amazon.awssdk.services.sagemaker.model.CreatePresignedDomainUrlResponse;
import software.amazon.awssdk.services.sagemaker.model.CreatePresignedMlflowTrackingServerUrlRequest;
import software.amazon.awssdk.services.sagemaker.model.CreatePresignedMlflowTrackingServerUrlResponse;
import software.amazon.awssdk.services.sagemaker.model.CreatePresignedNotebookInstanceUrlRequest;
import software.amazon.awssdk.services.sagemaker.model.CreatePresignedNotebookInstanceUrlResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateProcessingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateProcessingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateProjectRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateProjectResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateSpaceRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateSpaceResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateStudioLifecycleConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateStudioLifecycleConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateTrainingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateTrainingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateTrainingPlanRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateTrainingPlanResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateTransformJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateTransformJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateTrialComponentRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateTrialComponentResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateTrialRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateTrialResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateUserProfileRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateUserProfileResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateWorkforceRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateWorkforceResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateWorkteamRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateWorkteamResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteActionRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteActionResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteAlgorithmRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteAlgorithmResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteAppImageConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteAppImageConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteAppRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteAppResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteArtifactRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteArtifactResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteAssociationRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteAssociationResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteClusterRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteClusterResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteClusterSchedulerConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteClusterSchedulerConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteCodeRepositoryRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteCodeRepositoryResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteCompilationJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteCompilationJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteComputeQuotaRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteComputeQuotaResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteContextRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteContextResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteDataQualityJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteDataQualityJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteDeviceFleetRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteDeviceFleetResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteDomainRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteDomainResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteEdgeDeploymentPlanRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteEdgeDeploymentPlanResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteEdgeDeploymentStageRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteEdgeDeploymentStageResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteEndpointConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteEndpointConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteEndpointRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteEndpointResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteExperimentRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteExperimentResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteFeatureGroupRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteFeatureGroupResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteFlowDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteFlowDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteHubContentReferenceRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteHubContentReferenceResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteHubContentRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteHubContentResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteHubRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteHubResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteHumanTaskUiRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteHumanTaskUiResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteHyperParameterTuningJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteHyperParameterTuningJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteImageRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteImageResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteImageVersionRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteImageVersionResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteInferenceComponentRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteInferenceComponentResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteInferenceExperimentRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteInferenceExperimentResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteMlflowTrackingServerRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteMlflowTrackingServerResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelBiasJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelBiasJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelCardRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelCardResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelExplainabilityJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelExplainabilityJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageGroupPolicyRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageGroupPolicyResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageGroupRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageGroupResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelQualityJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelQualityJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteMonitoringScheduleRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteMonitoringScheduleResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteNotebookInstanceLifecycleConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteNotebookInstanceLifecycleConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteNotebookInstanceRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteNotebookInstanceResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteOptimizationJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteOptimizationJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DeletePartnerAppRequest;
import software.amazon.awssdk.services.sagemaker.model.DeletePartnerAppResponse;
import software.amazon.awssdk.services.sagemaker.model.DeletePipelineRequest;
import software.amazon.awssdk.services.sagemaker.model.DeletePipelineResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteProjectRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteProjectResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteSpaceRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteSpaceResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteStudioLifecycleConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteStudioLifecycleConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteTagsRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteTagsResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteTrialComponentRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteTrialComponentResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteTrialRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteTrialResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteUserProfileRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteUserProfileResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteWorkforceRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteWorkforceResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteWorkteamRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteWorkteamResponse;
import software.amazon.awssdk.services.sagemaker.model.DeregisterDevicesRequest;
import software.amazon.awssdk.services.sagemaker.model.DeregisterDevicesResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeActionRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeActionResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeAlgorithmRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeAlgorithmResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeAppImageConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeAppImageConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeAppRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeAppResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeArtifactRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeArtifactResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeAutoMlJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeAutoMlJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeAutoMlJobV2Request;
import software.amazon.awssdk.services.sagemaker.model.DescribeAutoMlJobV2Response;
import software.amazon.awssdk.services.sagemaker.model.DescribeClusterNodeRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeClusterNodeResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeClusterRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeClusterResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeClusterSchedulerConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeClusterSchedulerConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeCodeRepositoryRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeCodeRepositoryResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeCompilationJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeCompilationJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeComputeQuotaRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeComputeQuotaResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeContextRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeContextResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeDataQualityJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeDataQualityJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeDeviceFleetRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeDeviceFleetResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeDeviceRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeDeviceResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeDomainRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeDomainResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeEdgeDeploymentPlanRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeEdgeDeploymentPlanResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeEdgePackagingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeEdgePackagingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeEndpointConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeEndpointConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeEndpointRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeEndpointResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeExperimentRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeExperimentResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeFeatureGroupRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeFeatureGroupResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeFeatureMetadataRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeFeatureMetadataResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeFlowDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeFlowDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeHubContentRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeHubContentResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeHubRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeHubResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeHumanTaskUiRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeHumanTaskUiResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeHyperParameterTuningJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeHyperParameterTuningJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeImageRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeImageResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeImageVersionRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeImageVersionResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeInferenceComponentRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeInferenceComponentResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeInferenceExperimentRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeInferenceExperimentResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeInferenceRecommendationsJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeInferenceRecommendationsJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeLabelingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeLabelingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeLineageGroupRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeLineageGroupResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeMlflowTrackingServerRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeMlflowTrackingServerResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelBiasJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelBiasJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelCardExportJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelCardExportJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelCardRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelCardResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelExplainabilityJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelExplainabilityJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelPackageGroupRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelPackageGroupResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelPackageRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelPackageResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelQualityJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelQualityJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeMonitoringScheduleRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeMonitoringScheduleResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceLifecycleConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceLifecycleConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeOptimizationJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeOptimizationJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribePartnerAppRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribePartnerAppResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribePipelineDefinitionForExecutionRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribePipelineDefinitionForExecutionResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribePipelineExecutionRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribePipelineExecutionResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribePipelineRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribePipelineResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeProcessingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeProcessingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeProjectRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeProjectResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeSpaceRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeSpaceResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeStudioLifecycleConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeStudioLifecycleConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeSubscribedWorkteamRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeSubscribedWorkteamResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeTrainingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeTrainingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeTrainingPlanRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeTrainingPlanResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeTransformJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeTransformJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeTrialComponentRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeTrialComponentResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeTrialRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeTrialResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeUserProfileRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeUserProfileResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeWorkforceRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeWorkforceResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeWorkteamRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeWorkteamResponse;
import software.amazon.awssdk.services.sagemaker.model.DisableSagemakerServicecatalogPortfolioRequest;
import software.amazon.awssdk.services.sagemaker.model.DisableSagemakerServicecatalogPortfolioResponse;
import software.amazon.awssdk.services.sagemaker.model.DisassociateTrialComponentRequest;
import software.amazon.awssdk.services.sagemaker.model.DisassociateTrialComponentResponse;
import software.amazon.awssdk.services.sagemaker.model.EnableSagemakerServicecatalogPortfolioRequest;
import software.amazon.awssdk.services.sagemaker.model.EnableSagemakerServicecatalogPortfolioResponse;
import software.amazon.awssdk.services.sagemaker.model.GetDeviceFleetReportRequest;
import software.amazon.awssdk.services.sagemaker.model.GetDeviceFleetReportResponse;
import software.amazon.awssdk.services.sagemaker.model.GetLineageGroupPolicyRequest;
import software.amazon.awssdk.services.sagemaker.model.GetLineageGroupPolicyResponse;
import software.amazon.awssdk.services.sagemaker.model.GetModelPackageGroupPolicyRequest;
import software.amazon.awssdk.services.sagemaker.model.GetModelPackageGroupPolicyResponse;
import software.amazon.awssdk.services.sagemaker.model.GetSagemakerServicecatalogPortfolioStatusRequest;
import software.amazon.awssdk.services.sagemaker.model.GetSagemakerServicecatalogPortfolioStatusResponse;
import software.amazon.awssdk.services.sagemaker.model.GetScalingConfigurationRecommendationRequest;
import software.amazon.awssdk.services.sagemaker.model.GetScalingConfigurationRecommendationResponse;
import software.amazon.awssdk.services.sagemaker.model.GetSearchSuggestionsRequest;
import software.amazon.awssdk.services.sagemaker.model.GetSearchSuggestionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ImportHubContentRequest;
import software.amazon.awssdk.services.sagemaker.model.ImportHubContentResponse;
import software.amazon.awssdk.services.sagemaker.model.ListActionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListActionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListAlgorithmsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListAlgorithmsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListAliasesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListAliasesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListAppImageConfigsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListAppImageConfigsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListAppsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListAppsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListArtifactsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListArtifactsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListAssociationsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListAssociationsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListAutoMlJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListAutoMlJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListCandidatesForAutoMlJobRequest;
import software.amazon.awssdk.services.sagemaker.model.ListCandidatesForAutoMlJobResponse;
import software.amazon.awssdk.services.sagemaker.model.ListClusterNodesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListClusterNodesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListClusterSchedulerConfigsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListClusterSchedulerConfigsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListClustersRequest;
import software.amazon.awssdk.services.sagemaker.model.ListClustersResponse;
import software.amazon.awssdk.services.sagemaker.model.ListCodeRepositoriesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListCodeRepositoriesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListCompilationJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListCompilationJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListComputeQuotasRequest;
import software.amazon.awssdk.services.sagemaker.model.ListComputeQuotasResponse;
import software.amazon.awssdk.services.sagemaker.model.ListContextsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListContextsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListDataQualityJobDefinitionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListDataQualityJobDefinitionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListDeviceFleetsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListDeviceFleetsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListDevicesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListDevicesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListDomainsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListDomainsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListEdgeDeploymentPlansRequest;
import software.amazon.awssdk.services.sagemaker.model.ListEdgeDeploymentPlansResponse;
import software.amazon.awssdk.services.sagemaker.model.ListEdgePackagingJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListEdgePackagingJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListEndpointConfigsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListEndpointConfigsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListEndpointsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListEndpointsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListExperimentsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListExperimentsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListFeatureGroupsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListFeatureGroupsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListFlowDefinitionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListFlowDefinitionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListHubContentVersionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListHubContentVersionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListHubContentsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListHubContentsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListHubsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListHubsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListHumanTaskUisRequest;
import software.amazon.awssdk.services.sagemaker.model.ListHumanTaskUisResponse;
import software.amazon.awssdk.services.sagemaker.model.ListHyperParameterTuningJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListHyperParameterTuningJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListImageVersionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListImageVersionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListImagesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListImagesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListInferenceComponentsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListInferenceComponentsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListInferenceExperimentsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListInferenceExperimentsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListInferenceRecommendationsJobStepsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListInferenceRecommendationsJobStepsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListInferenceRecommendationsJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListInferenceRecommendationsJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsForWorkteamRequest;
import software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsForWorkteamResponse;
import software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListLineageGroupsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListLineageGroupsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListMlflowTrackingServersRequest;
import software.amazon.awssdk.services.sagemaker.model.ListMlflowTrackingServersResponse;
import software.amazon.awssdk.services.sagemaker.model.ListModelBiasJobDefinitionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelBiasJobDefinitionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListModelCardExportJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelCardExportJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListModelCardVersionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelCardVersionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListModelCardsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelCardsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListModelExplainabilityJobDefinitionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelExplainabilityJobDefinitionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListModelMetadataRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelMetadataResponse;
import software.amazon.awssdk.services.sagemaker.model.ListModelPackageGroupsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelPackageGroupsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListModelPackagesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelPackagesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListModelQualityJobDefinitionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelQualityJobDefinitionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListModelsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListMonitoringAlertHistoryRequest;
import software.amazon.awssdk.services.sagemaker.model.ListMonitoringAlertHistoryResponse;
import software.amazon.awssdk.services.sagemaker.model.ListMonitoringAlertsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListMonitoringAlertsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListMonitoringExecutionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListMonitoringExecutionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListMonitoringSchedulesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListMonitoringSchedulesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListNotebookInstanceLifecycleConfigsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListNotebookInstanceLifecycleConfigsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListNotebookInstancesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListNotebookInstancesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListOptimizationJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListOptimizationJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListPartnerAppsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListPartnerAppsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionStepsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionStepsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListPipelineParametersForExecutionRequest;
import software.amazon.awssdk.services.sagemaker.model.ListPipelineParametersForExecutionResponse;
import software.amazon.awssdk.services.sagemaker.model.ListPipelinesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListPipelinesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListProcessingJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListProcessingJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListProjectsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListProjectsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListResourceCatalogsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListResourceCatalogsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListSpacesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListSpacesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListStageDevicesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListStageDevicesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListStudioLifecycleConfigsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListStudioLifecycleConfigsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListSubscribedWorkteamsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListSubscribedWorkteamsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListTagsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListTagsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsForHyperParameterTuningJobRequest;
import software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsForHyperParameterTuningJobResponse;
import software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListTrainingPlansRequest;
import software.amazon.awssdk.services.sagemaker.model.ListTrainingPlansResponse;
import software.amazon.awssdk.services.sagemaker.model.ListTransformJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListTransformJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListTrialComponentsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListTrialComponentsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListTrialsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListTrialsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListUserProfilesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListUserProfilesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListWorkforcesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListWorkforcesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListWorkteamsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListWorkteamsResponse;
import software.amazon.awssdk.services.sagemaker.model.PutModelPackageGroupPolicyRequest;
import software.amazon.awssdk.services.sagemaker.model.PutModelPackageGroupPolicyResponse;
import software.amazon.awssdk.services.sagemaker.model.QueryLineageRequest;
import software.amazon.awssdk.services.sagemaker.model.QueryLineageResponse;
import software.amazon.awssdk.services.sagemaker.model.RegisterDevicesRequest;
import software.amazon.awssdk.services.sagemaker.model.RegisterDevicesResponse;
import software.amazon.awssdk.services.sagemaker.model.RenderUiTemplateRequest;
import software.amazon.awssdk.services.sagemaker.model.RenderUiTemplateResponse;
import software.amazon.awssdk.services.sagemaker.model.ResourceInUseException;
import software.amazon.awssdk.services.sagemaker.model.ResourceLimitExceededException;
import software.amazon.awssdk.services.sagemaker.model.ResourceNotFoundException;
import software.amazon.awssdk.services.sagemaker.model.RetryPipelineExecutionRequest;
import software.amazon.awssdk.services.sagemaker.model.RetryPipelineExecutionResponse;
import software.amazon.awssdk.services.sagemaker.model.SageMakerException;
import software.amazon.awssdk.services.sagemaker.model.SearchRequest;
import software.amazon.awssdk.services.sagemaker.model.SearchResponse;
import software.amazon.awssdk.services.sagemaker.model.SearchTrainingPlanOfferingsRequest;
import software.amazon.awssdk.services.sagemaker.model.SearchTrainingPlanOfferingsResponse;
import software.amazon.awssdk.services.sagemaker.model.SendPipelineExecutionStepFailureRequest;
import software.amazon.awssdk.services.sagemaker.model.SendPipelineExecutionStepFailureResponse;
import software.amazon.awssdk.services.sagemaker.model.SendPipelineExecutionStepSuccessRequest;
import software.amazon.awssdk.services.sagemaker.model.SendPipelineExecutionStepSuccessResponse;
import software.amazon.awssdk.services.sagemaker.model.StartEdgeDeploymentStageRequest;
import software.amazon.awssdk.services.sagemaker.model.StartEdgeDeploymentStageResponse;
import software.amazon.awssdk.services.sagemaker.model.StartInferenceExperimentRequest;
import software.amazon.awssdk.services.sagemaker.model.StartInferenceExperimentResponse;
import software.amazon.awssdk.services.sagemaker.model.StartMlflowTrackingServerRequest;
import software.amazon.awssdk.services.sagemaker.model.StartMlflowTrackingServerResponse;
import software.amazon.awssdk.services.sagemaker.model.StartMonitoringScheduleRequest;
import software.amazon.awssdk.services.sagemaker.model.StartMonitoringScheduleResponse;
import software.amazon.awssdk.services.sagemaker.model.StartNotebookInstanceRequest;
import software.amazon.awssdk.services.sagemaker.model.StartNotebookInstanceResponse;
import software.amazon.awssdk.services.sagemaker.model.StartPipelineExecutionRequest;
import software.amazon.awssdk.services.sagemaker.model.StartPipelineExecutionResponse;
import software.amazon.awssdk.services.sagemaker.model.StopAutoMlJobRequest;
import software.amazon.awssdk.services.sagemaker.model.StopAutoMlJobResponse;
import software.amazon.awssdk.services.sagemaker.model.StopCompilationJobRequest;
import software.amazon.awssdk.services.sagemaker.model.StopCompilationJobResponse;
import software.amazon.awssdk.services.sagemaker.model.StopEdgeDeploymentStageRequest;
import software.amazon.awssdk.services.sagemaker.model.StopEdgeDeploymentStageResponse;
import software.amazon.awssdk.services.sagemaker.model.StopEdgePackagingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.StopEdgePackagingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.StopHyperParameterTuningJobRequest;
import software.amazon.awssdk.services.sagemaker.model.StopHyperParameterTuningJobResponse;
import software.amazon.awssdk.services.sagemaker.model.StopInferenceExperimentRequest;
import software.amazon.awssdk.services.sagemaker.model.StopInferenceExperimentResponse;
import software.amazon.awssdk.services.sagemaker.model.StopInferenceRecommendationsJobRequest;
import software.amazon.awssdk.services.sagemaker.model.StopInferenceRecommendationsJobResponse;
import software.amazon.awssdk.services.sagemaker.model.StopLabelingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.StopLabelingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.StopMlflowTrackingServerRequest;
import software.amazon.awssdk.services.sagemaker.model.StopMlflowTrackingServerResponse;
import software.amazon.awssdk.services.sagemaker.model.StopMonitoringScheduleRequest;
import software.amazon.awssdk.services.sagemaker.model.StopMonitoringScheduleResponse;
import software.amazon.awssdk.services.sagemaker.model.StopNotebookInstanceRequest;
import software.amazon.awssdk.services.sagemaker.model.StopNotebookInstanceResponse;
import software.amazon.awssdk.services.sagemaker.model.StopOptimizationJobRequest;
import software.amazon.awssdk.services.sagemaker.model.StopOptimizationJobResponse;
import software.amazon.awssdk.services.sagemaker.model.StopPipelineExecutionRequest;
import software.amazon.awssdk.services.sagemaker.model.StopPipelineExecutionResponse;
import software.amazon.awssdk.services.sagemaker.model.StopProcessingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.StopProcessingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.StopTrainingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.StopTrainingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.StopTransformJobRequest;
import software.amazon.awssdk.services.sagemaker.model.StopTransformJobResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateActionRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateActionResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateAppImageConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateAppImageConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateArtifactRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateArtifactResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateClusterRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateClusterResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateClusterSchedulerConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateClusterSchedulerConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateClusterSoftwareRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateClusterSoftwareResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateCodeRepositoryRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateCodeRepositoryResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateComputeQuotaRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateComputeQuotaResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateContextRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateContextResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateDeviceFleetRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateDeviceFleetResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateDevicesRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateDevicesResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateDomainRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateDomainResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateEndpointRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateEndpointResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateEndpointWeightsAndCapacitiesRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateEndpointWeightsAndCapacitiesResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateExperimentRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateExperimentResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateFeatureGroupRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateFeatureGroupResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateFeatureMetadataRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateFeatureMetadataResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateHubContentReferenceRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateHubContentReferenceResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateHubContentRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateHubContentResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateHubRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateHubResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateImageRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateImageResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateImageVersionRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateImageVersionResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateInferenceComponentRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateInferenceComponentResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateInferenceComponentRuntimeConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateInferenceComponentRuntimeConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateInferenceExperimentRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateInferenceExperimentResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateMlflowTrackingServerRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateMlflowTrackingServerResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateModelCardRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateModelCardResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateModelPackageRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateModelPackageResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateMonitoringAlertRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateMonitoringAlertResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateMonitoringScheduleRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateMonitoringScheduleResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateNotebookInstanceLifecycleConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateNotebookInstanceLifecycleConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateNotebookInstanceRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateNotebookInstanceResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdatePartnerAppRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdatePartnerAppResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdatePipelineExecutionRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdatePipelineExecutionResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdatePipelineRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdatePipelineResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateProjectRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateProjectResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateSpaceRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateSpaceResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateTrainingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateTrainingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateTrialComponentRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateTrialComponentResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateTrialRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateTrialResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateUserProfileRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateUserProfileResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateWorkforceRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateWorkforceResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateWorkteamRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateWorkteamResponse;
import software.amazon.awssdk.services.sagemaker.paginators.ListActionsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListAlgorithmsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListAliasesIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListAppImageConfigsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListAppsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListArtifactsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListAssociationsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListAutoMLJobsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListCandidatesForAutoMLJobIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListClusterNodesIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListClusterSchedulerConfigsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListClustersIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListCodeRepositoriesIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListCompilationJobsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListComputeQuotasIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListContextsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListDataQualityJobDefinitionsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListDeviceFleetsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListDevicesIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListDomainsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListEdgeDeploymentPlansIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListEdgePackagingJobsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListEndpointConfigsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListEndpointsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListExperimentsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListFeatureGroupsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListFlowDefinitionsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListHumanTaskUisIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListHyperParameterTuningJobsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListImageVersionsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListImagesIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListInferenceComponentsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListInferenceExperimentsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListInferenceRecommendationsJobStepsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListInferenceRecommendationsJobsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListLabelingJobsForWorkteamIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListLabelingJobsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListLineageGroupsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListMlflowTrackingServersIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListModelBiasJobDefinitionsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListModelCardExportJobsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListModelCardVersionsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListModelCardsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListModelExplainabilityJobDefinitionsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListModelMetadataIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListModelPackageGroupsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListModelPackagesIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListModelQualityJobDefinitionsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListModelsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListMonitoringAlertHistoryIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListMonitoringAlertsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListMonitoringExecutionsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListMonitoringSchedulesIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListNotebookInstanceLifecycleConfigsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListNotebookInstancesIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListOptimizationJobsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListPartnerAppsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListPipelineExecutionStepsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListPipelineExecutionsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListPipelineParametersForExecutionIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListPipelinesIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListProcessingJobsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListProjectsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListResourceCatalogsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListSpacesIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListStageDevicesIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListStudioLifecycleConfigsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListSubscribedWorkteamsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListTagsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListTrainingJobsForHyperParameterTuningJobIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListTrainingJobsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListTrainingPlansIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListTransformJobsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListTrialComponentsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListTrialsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListUserProfilesIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListWorkforcesIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListWorkteamsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.QueryLineageIterable;
import software.amazon.awssdk.services.sagemaker.paginators.SearchIterable;
import software.amazon.awssdk.services.sagemaker.waiters.SageMakerWaiter;

/**
 * Service client for accessing SageMaker. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Provides APIs for creating and managing SageMaker resources.
 * </p>
 * <p>
 * Other Resources:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/whatis.html#first-time-user">SageMaker Developer Guide</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/augmented-ai/2019-11-07/APIReference/Welcome.html">Amazon Augmented AI Runtime
 * API Reference</a>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface SageMakerClient extends AwsClient {
    String SERVICE_NAME = "sagemaker";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "api.sagemaker";

    /**
     * <p>
     * Creates an <i>association</i> between the source and the destination. A source can be associated with multiple
     * destinations, and a destination can be associated with multiple sources. An association is a lineage tracking
     * entity. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html">Amazon SageMaker ML Lineage
     * Tracking</a>.
     * </p>
     *
     * @param addAssociationRequest
     * @return Result of the AddAssociation operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.AddAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/AddAssociation" target="_top">AWS API
     *      Documentation</a>
     */
    default AddAssociationResponse addAssociation(AddAssociationRequest addAssociationRequest) throws ResourceNotFoundException,
            ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an <i>association</i> between the source and the destination. A source can be associated with multiple
     * destinations, and a destination can be associated with multiple sources. An association is a lineage tracking
     * entity. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html">Amazon SageMaker ML Lineage
     * Tracking</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddAssociationRequest.Builder} avoiding the need to
     * create one manually via {@link AddAssociationRequest#builder()}
     * </p>
     *
     * @param addAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.AddAssociationRequest.Builder} to create a request.
     * @return Result of the AddAssociation operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.AddAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/AddAssociation" target="_top">AWS API
     *      Documentation</a>
     */
    default AddAssociationResponse addAssociation(Consumer<AddAssociationRequest.Builder> addAssociationRequest)
            throws ResourceNotFoundException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            SageMakerException {
        return addAssociation(AddAssociationRequest.builder().applyMutation(addAssociationRequest).build());
    }

    /**
     * <p>
     * Adds or overwrites one or more tags for the specified SageMaker resource. You can add tags to notebook instances,
     * training jobs, hyperparameter tuning jobs, batch transform jobs, models, labeling jobs, work teams, endpoint
     * configurations, and endpoints.
     * </p>
     * <p>
     * Each tag consists of a key and an optional value. Tag keys must be unique per resource. For more information
     * about tags, see For more information, see <a
     * href="https://aws.amazon.com/answers/account-management/aws-tagging-strategies/">Amazon Web Services Tagging
     * Strategies</a>.
     * </p>
     * <note>
     * <p>
     * Tags that you add to a hyperparameter tuning job by calling this API are also added to any training jobs that the
     * hyperparameter tuning job launches after you call this API, but not to training jobs that the hyperparameter
     * tuning job launched before you called this API. To make sure that the tags associated with a hyperparameter
     * tuning job are also added to all training jobs that the hyperparameter tuning job launches, add the tags when you
     * first create the tuning job by specifying them in the <code>Tags</code> parameter of <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateHyperParameterTuningJob.html"
     * >CreateHyperParameterTuningJob</a>
     * </p>
     * </note> <note>
     * <p>
     * Tags that you add to a SageMaker Domain or User Profile by calling this API are also added to any Apps that the
     * Domain or User Profile launches after you call this API, but not to Apps that the Domain or User Profile launched
     * before you called this API. To make sure that the tags associated with a Domain or User Profile are also added to
     * all Apps that the Domain or User Profile launches, add the tags when you first create the Domain or User Profile
     * by specifying them in the <code>Tags</code> parameter of <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateDomain.html">CreateDomain</a> or <a
     * href
     * ="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateUserProfile.html">CreateUserProfile</a>.
     * </p>
     * </note>
     *
     * @param addTagsRequest
     * @return Result of the AddTags operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.AddTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/AddTags" target="_top">AWS API
     *      Documentation</a>
     */
    default AddTagsResponse addTags(AddTagsRequest addTagsRequest) throws AwsServiceException, SdkClientException,
            SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or overwrites one or more tags for the specified SageMaker resource. You can add tags to notebook instances,
     * training jobs, hyperparameter tuning jobs, batch transform jobs, models, labeling jobs, work teams, endpoint
     * configurations, and endpoints.
     * </p>
     * <p>
     * Each tag consists of a key and an optional value. Tag keys must be unique per resource. For more information
     * about tags, see For more information, see <a
     * href="https://aws.amazon.com/answers/account-management/aws-tagging-strategies/">Amazon Web Services Tagging
     * Strategies</a>.
     * </p>
     * <note>
     * <p>
     * Tags that you add to a hyperparameter tuning job by calling this API are also added to any training jobs that the
     * hyperparameter tuning job launches after you call this API, but not to training jobs that the hyperparameter
     * tuning job launched before you called this API. To make sure that the tags associated with a hyperparameter
     * tuning job are also added to all training jobs that the hyperparameter tuning job launches, add the tags when you
     * first create the tuning job by specifying them in the <code>Tags</code> parameter of <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateHyperParameterTuningJob.html"
     * >CreateHyperParameterTuningJob</a>
     * </p>
     * </note> <note>
     * <p>
     * Tags that you add to a SageMaker Domain or User Profile by calling this API are also added to any Apps that the
     * Domain or User Profile launches after you call this API, but not to Apps that the Domain or User Profile launched
     * before you called this API. To make sure that the tags associated with a Domain or User Profile are also added to
     * all Apps that the Domain or User Profile launches, add the tags when you first create the Domain or User Profile
     * by specifying them in the <code>Tags</code> parameter of <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateDomain.html">CreateDomain</a> or <a
     * href
     * ="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateUserProfile.html">CreateUserProfile</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddTagsRequest.Builder} avoiding the need to create
     * one manually via {@link AddTagsRequest#builder()}
     * </p>
     *
     * @param addTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.AddTagsRequest.Builder} to create a request.
     * @return Result of the AddTags operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.AddTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/AddTags" target="_top">AWS API
     *      Documentation</a>
     */
    default AddTagsResponse addTags(Consumer<AddTagsRequest.Builder> addTagsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return addTags(AddTagsRequest.builder().applyMutation(addTagsRequest).build());
    }

    /**
     * <p>
     * Associates a trial component with a trial. A trial component can be associated with multiple trials. To
     * disassociate a trial component from a trial, call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DisassociateTrialComponent.html"
     * >DisassociateTrialComponent</a> API.
     * </p>
     *
     * @param associateTrialComponentRequest
     * @return Result of the AssociateTrialComponent operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.AssociateTrialComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/AssociateTrialComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateTrialComponentResponse associateTrialComponent(AssociateTrialComponentRequest associateTrialComponentRequest)
            throws ResourceNotFoundException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a trial component with a trial. A trial component can be associated with multiple trials. To
     * disassociate a trial component from a trial, call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DisassociateTrialComponent.html"
     * >DisassociateTrialComponent</a> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateTrialComponentRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateTrialComponentRequest#builder()}
     * </p>
     *
     * @param associateTrialComponentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.AssociateTrialComponentRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateTrialComponent operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.AssociateTrialComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/AssociateTrialComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateTrialComponentResponse associateTrialComponent(
            Consumer<AssociateTrialComponentRequest.Builder> associateTrialComponentRequest) throws ResourceNotFoundException,
            ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        return associateTrialComponent(AssociateTrialComponentRequest.builder().applyMutation(associateTrialComponentRequest)
                .build());
    }

    /**
     * <p>
     * Deletes specific nodes within a SageMaker HyperPod cluster. <code>BatchDeleteClusterNodes</code> accepts a
     * cluster name and a list of node IDs.
     * </p>
     * <important>
     * <ul>
     * <li>
     * <p>
     * To safeguard your work, back up your data to Amazon S3 or an FSx for Lustre file system before invoking the API
     * on a worker node group. This will help prevent any potential data loss from the instance root volume. For more
     * information about backup, see <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-hyperpod-operate-cli-command.html#sagemaker-hyperpod-operate-cli-command-update-cluster-software-backup"
     * >Use the backup script provided by SageMaker HyperPod</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you want to invoke this API on an existing cluster, you'll first need to patch the cluster by running the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateClusterSoftware.html">
     * UpdateClusterSoftware API</a>. For more information about patching a cluster, see <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-hyperpod-operate-cli-command.html#sagemaker-hyperpod-operate-cli-command-update-cluster-software"
     * >Update the SageMaker HyperPod platform software of a cluster</a>.
     * </p>
     * </li>
     * </ul>
     * </important>
     *
     * @param batchDeleteClusterNodesRequest
     * @return Result of the BatchDeleteClusterNodes operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.BatchDeleteClusterNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/BatchDeleteClusterNodes"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDeleteClusterNodesResponse batchDeleteClusterNodes(BatchDeleteClusterNodesRequest batchDeleteClusterNodesRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes specific nodes within a SageMaker HyperPod cluster. <code>BatchDeleteClusterNodes</code> accepts a
     * cluster name and a list of node IDs.
     * </p>
     * <important>
     * <ul>
     * <li>
     * <p>
     * To safeguard your work, back up your data to Amazon S3 or an FSx for Lustre file system before invoking the API
     * on a worker node group. This will help prevent any potential data loss from the instance root volume. For more
     * information about backup, see <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-hyperpod-operate-cli-command.html#sagemaker-hyperpod-operate-cli-command-update-cluster-software-backup"
     * >Use the backup script provided by SageMaker HyperPod</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you want to invoke this API on an existing cluster, you'll first need to patch the cluster by running the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateClusterSoftware.html">
     * UpdateClusterSoftware API</a>. For more information about patching a cluster, see <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-hyperpod-operate-cli-command.html#sagemaker-hyperpod-operate-cli-command-update-cluster-software"
     * >Update the SageMaker HyperPod platform software of a cluster</a>.
     * </p>
     * </li>
     * </ul>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeleteClusterNodesRequest.Builder} avoiding
     * the need to create one manually via {@link BatchDeleteClusterNodesRequest#builder()}
     * </p>
     *
     * @param batchDeleteClusterNodesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.BatchDeleteClusterNodesRequest.Builder} to create a
     *        request.
     * @return Result of the BatchDeleteClusterNodes operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.BatchDeleteClusterNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/BatchDeleteClusterNodes"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDeleteClusterNodesResponse batchDeleteClusterNodes(
            Consumer<BatchDeleteClusterNodesRequest.Builder> batchDeleteClusterNodesRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        return batchDeleteClusterNodes(BatchDeleteClusterNodesRequest.builder().applyMutation(batchDeleteClusterNodesRequest)
                .build());
    }

    /**
     * <p>
     * This action batch describes a list of versioned model packages
     * </p>
     *
     * @param batchDescribeModelPackageRequest
     * @return Result of the BatchDescribeModelPackage operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.BatchDescribeModelPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/BatchDescribeModelPackage"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDescribeModelPackageResponse batchDescribeModelPackage(
            BatchDescribeModelPackageRequest batchDescribeModelPackageRequest) throws AwsServiceException, SdkClientException,
            SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This action batch describes a list of versioned model packages
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDescribeModelPackageRequest.Builder} avoiding
     * the need to create one manually via {@link BatchDescribeModelPackageRequest#builder()}
     * </p>
     *
     * @param batchDescribeModelPackageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.BatchDescribeModelPackageRequest.Builder} to create
     *        a request.
     * @return Result of the BatchDescribeModelPackage operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.BatchDescribeModelPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/BatchDescribeModelPackage"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDescribeModelPackageResponse batchDescribeModelPackage(
            Consumer<BatchDescribeModelPackageRequest.Builder> batchDescribeModelPackageRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return batchDescribeModelPackage(BatchDescribeModelPackageRequest.builder()
                .applyMutation(batchDescribeModelPackageRequest).build());
    }

    /**
     * <p>
     * Creates an <i>action</i>. An action is a lineage tracking entity that represents an action or activity. For
     * example, a model deployment or an HPO job. Generally, an action involves at least one input or output artifact.
     * For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html">Amazon
     * SageMaker ML Lineage Tracking</a>.
     * </p>
     *
     * @param createActionRequest
     * @return Result of the CreateAction operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateAction" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateActionResponse createAction(CreateActionRequest createActionRequest) throws ResourceLimitExceededException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an <i>action</i>. An action is a lineage tracking entity that represents an action or activity. For
     * example, a model deployment or an HPO job. Generally, an action involves at least one input or output artifact.
     * For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html">Amazon
     * SageMaker ML Lineage Tracking</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateActionRequest.Builder} avoiding the need to
     * create one manually via {@link CreateActionRequest#builder()}
     * </p>
     *
     * @param createActionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateActionRequest.Builder} to create a request.
     * @return Result of the CreateAction operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateAction" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateActionResponse createAction(Consumer<CreateActionRequest.Builder> createActionRequest)
            throws ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        return createAction(CreateActionRequest.builder().applyMutation(createActionRequest).build());
    }

    /**
     * <p>
     * Create a machine learning algorithm that you can use in SageMaker and list in the Amazon Web Services
     * Marketplace.
     * </p>
     *
     * @param createAlgorithmRequest
     * @return Result of the CreateAlgorithm operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateAlgorithm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateAlgorithm" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAlgorithmResponse createAlgorithm(CreateAlgorithmRequest createAlgorithmRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a machine learning algorithm that you can use in SageMaker and list in the Amazon Web Services
     * Marketplace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAlgorithmRequest.Builder} avoiding the need
     * to create one manually via {@link CreateAlgorithmRequest#builder()}
     * </p>
     *
     * @param createAlgorithmRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateAlgorithmRequest.Builder} to create a
     *        request.
     * @return Result of the CreateAlgorithm operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateAlgorithm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateAlgorithm" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAlgorithmResponse createAlgorithm(Consumer<CreateAlgorithmRequest.Builder> createAlgorithmRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return createAlgorithm(CreateAlgorithmRequest.builder().applyMutation(createAlgorithmRequest).build());
    }

    /**
     * <p>
     * Creates a running app for the specified UserProfile. This operation is automatically invoked by Amazon SageMaker
     * AI upon access to the associated Domain, and when new kernel configurations are selected by the user. A user may
     * have multiple Apps active simultaneously.
     * </p>
     *
     * @param createAppRequest
     * @return Result of the CreateApp operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateApp" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAppResponse createApp(CreateAppRequest createAppRequest) throws ResourceInUseException,
            ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a running app for the specified UserProfile. This operation is automatically invoked by Amazon SageMaker
     * AI upon access to the associated Domain, and when new kernel configurations are selected by the user. A user may
     * have multiple Apps active simultaneously.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAppRequest.Builder} avoiding the need to
     * create one manually via {@link CreateAppRequest#builder()}
     * </p>
     *
     * @param createAppRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateAppRequest.Builder} to create a request.
     * @return Result of the CreateApp operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateApp" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAppResponse createApp(Consumer<CreateAppRequest.Builder> createAppRequest) throws ResourceInUseException,
            ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        return createApp(CreateAppRequest.builder().applyMutation(createAppRequest).build());
    }

    /**
     * <p>
     * Creates a configuration for running a SageMaker AI image as a KernelGateway app. The configuration specifies the
     * Amazon Elastic File System storage volume on the image, and a list of the kernels in the image.
     * </p>
     *
     * @param createAppImageConfigRequest
     * @return Result of the CreateAppImageConfig operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateAppImageConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateAppImageConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAppImageConfigResponse createAppImageConfig(CreateAppImageConfigRequest createAppImageConfigRequest)
            throws ResourceInUseException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a configuration for running a SageMaker AI image as a KernelGateway app. The configuration specifies the
     * Amazon Elastic File System storage volume on the image, and a list of the kernels in the image.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAppImageConfigRequest.Builder} avoiding the
     * need to create one manually via {@link CreateAppImageConfigRequest#builder()}
     * </p>
     *
     * @param createAppImageConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateAppImageConfigRequest.Builder} to create a
     *        request.
     * @return Result of the CreateAppImageConfig operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateAppImageConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateAppImageConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAppImageConfigResponse createAppImageConfig(
            Consumer<CreateAppImageConfigRequest.Builder> createAppImageConfigRequest) throws ResourceInUseException,
            AwsServiceException, SdkClientException, SageMakerException {
        return createAppImageConfig(CreateAppImageConfigRequest.builder().applyMutation(createAppImageConfigRequest).build());
    }

    /**
     * <p>
     * Creates an <i>artifact</i>. An artifact is a lineage tracking entity that represents a URI addressable object or
     * data. Some examples are the S3 URI of a dataset and the ECR registry path of an image. For more information, see
     * <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html">Amazon SageMaker ML Lineage
     * Tracking</a>.
     * </p>
     *
     * @param createArtifactRequest
     * @return Result of the CreateArtifact operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateArtifact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateArtifact" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateArtifactResponse createArtifact(CreateArtifactRequest createArtifactRequest)
            throws ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an <i>artifact</i>. An artifact is a lineage tracking entity that represents a URI addressable object or
     * data. Some examples are the S3 URI of a dataset and the ECR registry path of an image. For more information, see
     * <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html">Amazon SageMaker ML Lineage
     * Tracking</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateArtifactRequest.Builder} avoiding the need to
     * create one manually via {@link CreateArtifactRequest#builder()}
     * </p>
     *
     * @param createArtifactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateArtifactRequest.Builder} to create a request.
     * @return Result of the CreateArtifact operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateArtifact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateArtifact" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateArtifactResponse createArtifact(Consumer<CreateArtifactRequest.Builder> createArtifactRequest)
            throws ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        return createArtifact(CreateArtifactRequest.builder().applyMutation(createArtifactRequest).build());
    }

    /**
     * <p>
     * Creates an Autopilot job also referred to as Autopilot experiment or AutoML job.
     * </p>
     * <p>
     * An AutoML job in SageMaker AI is a fully automated process that allows you to build machine learning models with
     * minimal effort and machine learning expertise. When initiating an AutoML job, you provide your data and
     * optionally specify parameters tailored to your use case. SageMaker AI then automates the entire model development
     * lifecycle, including data preprocessing, model training, tuning, and evaluation. AutoML jobs are designed to
     * simplify and accelerate the model building process by automating various tasks and exploring different
     * combinations of machine learning algorithms, data preprocessing techniques, and hyperparameter values. The output
     * of an AutoML job comprises one or more trained models ready for deployment and inference. Additionally, SageMaker
     * AI AutoML jobs generate a candidate model leaderboard, allowing you to select the best-performing model for
     * deployment.
     * </p>
     * <p>
     * For more information about AutoML jobs, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development.html"
     * >https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development.html</a> in the SageMaker
     * AI developer guide.
     * </p>
     * <note>
     * <p>
     * We recommend using the new versions <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJobV2.html">CreateAutoMLJobV2</a>
     * and <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeAutoMLJobV2.html">
     * DescribeAutoMLJobV2</a>, which offer backward compatibility.
     * </p>
     * <p>
     * <code>CreateAutoMLJobV2</code> can manage tabular problem types identical to those of its previous version
     * <code>CreateAutoMLJob</code>, as well as time-series forecasting, non-tabular problem types such as image or text
     * classification, and text generation (LLMs fine-tuning).
     * </p>
     * <p>
     * Find guidelines about how to migrate a <code>CreateAutoMLJob</code> to <code>CreateAutoMLJobV2</code> in <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development-create-experiment.html#autopilot-create-experiment-api-migrate-v1-v2"
     * >Migrate a CreateAutoMLJob to CreateAutoMLJobV2</a>.
     * </p>
     * </note>
     * <p>
     * You can find the best-performing model after you run an AutoML job by calling <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeAutoMLJobV2.html"
     * >DescribeAutoMLJobV2</a> (recommended) or <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeAutoMLJob.html"
     * >DescribeAutoMLJob</a>.
     * </p>
     *
     * @param createAutoMlJobRequest
     * @return Result of the CreateAutoMLJob operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateAutoMLJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateAutoMLJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAutoMlJobResponse createAutoMLJob(CreateAutoMlJobRequest createAutoMlJobRequest) throws ResourceInUseException,
            ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Autopilot job also referred to as Autopilot experiment or AutoML job.
     * </p>
     * <p>
     * An AutoML job in SageMaker AI is a fully automated process that allows you to build machine learning models with
     * minimal effort and machine learning expertise. When initiating an AutoML job, you provide your data and
     * optionally specify parameters tailored to your use case. SageMaker AI then automates the entire model development
     * lifecycle, including data preprocessing, model training, tuning, and evaluation. AutoML jobs are designed to
     * simplify and accelerate the model building process by automating various tasks and exploring different
     * combinations of machine learning algorithms, data preprocessing techniques, and hyperparameter values. The output
     * of an AutoML job comprises one or more trained models ready for deployment and inference. Additionally, SageMaker
     * AI AutoML jobs generate a candidate model leaderboard, allowing you to select the best-performing model for
     * deployment.
     * </p>
     * <p>
     * For more information about AutoML jobs, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development.html"
     * >https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development.html</a> in the SageMaker
     * AI developer guide.
     * </p>
     * <note>
     * <p>
     * We recommend using the new versions <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJobV2.html">CreateAutoMLJobV2</a>
     * and <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeAutoMLJobV2.html">
     * DescribeAutoMLJobV2</a>, which offer backward compatibility.
     * </p>
     * <p>
     * <code>CreateAutoMLJobV2</code> can manage tabular problem types identical to those of its previous version
     * <code>CreateAutoMLJob</code>, as well as time-series forecasting, non-tabular problem types such as image or text
     * classification, and text generation (LLMs fine-tuning).
     * </p>
     * <p>
     * Find guidelines about how to migrate a <code>CreateAutoMLJob</code> to <code>CreateAutoMLJobV2</code> in <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development-create-experiment.html#autopilot-create-experiment-api-migrate-v1-v2"
     * >Migrate a CreateAutoMLJob to CreateAutoMLJobV2</a>.
     * </p>
     * </note>
     * <p>
     * You can find the best-performing model after you run an AutoML job by calling <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeAutoMLJobV2.html"
     * >DescribeAutoMLJobV2</a> (recommended) or <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeAutoMLJob.html"
     * >DescribeAutoMLJob</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAutoMlJobRequest.Builder} avoiding the need
     * to create one manually via {@link CreateAutoMlJobRequest#builder()}
     * </p>
     *
     * @param createAutoMlJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateAutoMlJobRequest.Builder} to create a
     *        request.
     * @return Result of the CreateAutoMLJob operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateAutoMLJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateAutoMLJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAutoMlJobResponse createAutoMLJob(Consumer<CreateAutoMlJobRequest.Builder> createAutoMlJobRequest)
            throws ResourceInUseException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            SageMakerException {
        return createAutoMLJob(CreateAutoMlJobRequest.builder().applyMutation(createAutoMlJobRequest).build());
    }

    /**
     * <p>
     * Creates an Autopilot job also referred to as Autopilot experiment or AutoML job V2.
     * </p>
     * <p>
     * An AutoML job in SageMaker AI is a fully automated process that allows you to build machine learning models with
     * minimal effort and machine learning expertise. When initiating an AutoML job, you provide your data and
     * optionally specify parameters tailored to your use case. SageMaker AI then automates the entire model development
     * lifecycle, including data preprocessing, model training, tuning, and evaluation. AutoML jobs are designed to
     * simplify and accelerate the model building process by automating various tasks and exploring different
     * combinations of machine learning algorithms, data preprocessing techniques, and hyperparameter values. The output
     * of an AutoML job comprises one or more trained models ready for deployment and inference. Additionally, SageMaker
     * AI AutoML jobs generate a candidate model leaderboard, allowing you to select the best-performing model for
     * deployment.
     * </p>
     * <p>
     * For more information about AutoML jobs, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development.html"
     * >https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development.html</a> in the SageMaker
     * AI developer guide.
     * </p>
     * <p>
     * AutoML jobs V2 support various problem types such as regression, binary, and multiclass classification with
     * tabular data, text and image classification, time-series forecasting, and fine-tuning of large language models
     * (LLMs) for text generation.
     * </p>
     * <note>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJobV2.html">CreateAutoMLJobV2</a>
     * and <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeAutoMLJobV2.html">
     * DescribeAutoMLJobV2</a> are new versions of <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJob.html">CreateAutoMLJob</a> and
     * <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeAutoMLJob.html">DescribeAutoMLJob</a>
     * which offer backward compatibility.
     * </p>
     * <p>
     * <code>CreateAutoMLJobV2</code> can manage tabular problem types identical to those of its previous version
     * <code>CreateAutoMLJob</code>, as well as time-series forecasting, non-tabular problem types such as image or text
     * classification, and text generation (LLMs fine-tuning).
     * </p>
     * <p>
     * Find guidelines about how to migrate a <code>CreateAutoMLJob</code> to <code>CreateAutoMLJobV2</code> in <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development-create-experiment.html#autopilot-create-experiment-api-migrate-v1-v2"
     * >Migrate a CreateAutoMLJob to CreateAutoMLJobV2</a>.
     * </p>
     * </note>
     * <p>
     * For the list of available problem types supported by <code>CreateAutoMLJobV2</code>, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLProblemTypeConfig.html"
     * >AutoMLProblemTypeConfig</a>.
     * </p>
     * <p>
     * You can find the best-performing model after you run an AutoML job V2 by calling <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeAutoMLJobV2.html"
     * >DescribeAutoMLJobV2</a>.
     * </p>
     *
     * @param createAutoMlJobV2Request
     * @return Result of the CreateAutoMLJobV2 operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateAutoMLJobV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateAutoMLJobV2" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateAutoMlJobV2Response createAutoMLJobV2(CreateAutoMlJobV2Request createAutoMlJobV2Request)
            throws ResourceInUseException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Autopilot job also referred to as Autopilot experiment or AutoML job V2.
     * </p>
     * <p>
     * An AutoML job in SageMaker AI is a fully automated process that allows you to build machine learning models with
     * minimal effort and machine learning expertise. When initiating an AutoML job, you provide your data and
     * optionally specify parameters tailored to your use case. SageMaker AI then automates the entire model development
     * lifecycle, including data preprocessing, model training, tuning, and evaluation. AutoML jobs are designed to
     * simplify and accelerate the model building process by automating various tasks and exploring different
     * combinations of machine learning algorithms, data preprocessing techniques, and hyperparameter values. The output
     * of an AutoML job comprises one or more trained models ready for deployment and inference. Additionally, SageMaker
     * AI AutoML jobs generate a candidate model leaderboard, allowing you to select the best-performing model for
     * deployment.
     * </p>
     * <p>
     * For more information about AutoML jobs, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development.html"
     * >https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development.html</a> in the SageMaker
     * AI developer guide.
     * </p>
     * <p>
     * AutoML jobs V2 support various problem types such as regression, binary, and multiclass classification with
     * tabular data, text and image classification, time-series forecasting, and fine-tuning of large language models
     * (LLMs) for text generation.
     * </p>
     * <note>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJobV2.html">CreateAutoMLJobV2</a>
     * and <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeAutoMLJobV2.html">
     * DescribeAutoMLJobV2</a> are new versions of <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJob.html">CreateAutoMLJob</a> and
     * <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeAutoMLJob.html">DescribeAutoMLJob</a>
     * which offer backward compatibility.
     * </p>
     * <p>
     * <code>CreateAutoMLJobV2</code> can manage tabular problem types identical to those of its previous version
     * <code>CreateAutoMLJob</code>, as well as time-series forecasting, non-tabular problem types such as image or text
     * classification, and text generation (LLMs fine-tuning).
     * </p>
     * <p>
     * Find guidelines about how to migrate a <code>CreateAutoMLJob</code> to <code>CreateAutoMLJobV2</code> in <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development-create-experiment.html#autopilot-create-experiment-api-migrate-v1-v2"
     * >Migrate a CreateAutoMLJob to CreateAutoMLJobV2</a>.
     * </p>
     * </note>
     * <p>
     * For the list of available problem types supported by <code>CreateAutoMLJobV2</code>, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLProblemTypeConfig.html"
     * >AutoMLProblemTypeConfig</a>.
     * </p>
     * <p>
     * You can find the best-performing model after you run an AutoML job V2 by calling <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeAutoMLJobV2.html"
     * >DescribeAutoMLJobV2</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAutoMlJobV2Request.Builder} avoiding the need
     * to create one manually via {@link CreateAutoMlJobV2Request#builder()}
     * </p>
     *
     * @param createAutoMlJobV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateAutoMlJobV2Request.Builder} to create a
     *        request.
     * @return Result of the CreateAutoMLJobV2 operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateAutoMLJobV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateAutoMLJobV2" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateAutoMlJobV2Response createAutoMLJobV2(Consumer<CreateAutoMlJobV2Request.Builder> createAutoMlJobV2Request)
            throws ResourceInUseException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            SageMakerException {
        return createAutoMLJobV2(CreateAutoMlJobV2Request.builder().applyMutation(createAutoMlJobV2Request).build());
    }

    /**
     * <p>
     * Creates a SageMaker HyperPod cluster. SageMaker HyperPod is a capability of SageMaker for creating and managing
     * persistent clusters for developing large machine learning models, such as large language models (LLMs) and
     * diffusion models. To learn more, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-hyperpod.html">Amazon SageMaker HyperPod</a> in
     * the <i>Amazon SageMaker Developer Guide</i>.
     * </p>
     *
     * @param createClusterRequest
     * @return Result of the CreateCluster operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateClusterResponse createCluster(CreateClusterRequest createClusterRequest) throws ResourceInUseException,
            ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a SageMaker HyperPod cluster. SageMaker HyperPod is a capability of SageMaker for creating and managing
     * persistent clusters for developing large machine learning models, such as large language models (LLMs) and
     * diffusion models. To learn more, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-hyperpod.html">Amazon SageMaker HyperPod</a> in
     * the <i>Amazon SageMaker Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateClusterRequest.Builder} avoiding the need to
     * create one manually via {@link CreateClusterRequest#builder()}
     * </p>
     *
     * @param createClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateClusterRequest.Builder} to create a request.
     * @return Result of the CreateCluster operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateClusterResponse createCluster(Consumer<CreateClusterRequest.Builder> createClusterRequest)
            throws ResourceInUseException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            SageMakerException {
        return createCluster(CreateClusterRequest.builder().applyMutation(createClusterRequest).build());
    }

    /**
     * <p>
     * Create cluster policy configuration. This policy is used for task prioritization and fair-share allocation of
     * idle compute. This helps prioritize critical workloads and distributes idle compute across entities.
     * </p>
     *
     * @param createClusterSchedulerConfigRequest
     * @return Result of the CreateClusterSchedulerConfig operation returned by the service.
     * @throws ConflictException
     *         There was a conflict when you attempted to modify a SageMaker entity such as an <code>Experiment</code>
     *         or <code>Artifact</code>.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateClusterSchedulerConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateClusterSchedulerConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateClusterSchedulerConfigResponse createClusterSchedulerConfig(
            CreateClusterSchedulerConfigRequest createClusterSchedulerConfigRequest) throws ConflictException,
            ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create cluster policy configuration. This policy is used for task prioritization and fair-share allocation of
     * idle compute. This helps prioritize critical workloads and distributes idle compute across entities.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateClusterSchedulerConfigRequest.Builder}
     * avoiding the need to create one manually via {@link CreateClusterSchedulerConfigRequest#builder()}
     * </p>
     *
     * @param createClusterSchedulerConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateClusterSchedulerConfigRequest.Builder} to
     *        create a request.
     * @return Result of the CreateClusterSchedulerConfig operation returned by the service.
     * @throws ConflictException
     *         There was a conflict when you attempted to modify a SageMaker entity such as an <code>Experiment</code>
     *         or <code>Artifact</code>.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateClusterSchedulerConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateClusterSchedulerConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateClusterSchedulerConfigResponse createClusterSchedulerConfig(
            Consumer<CreateClusterSchedulerConfigRequest.Builder> createClusterSchedulerConfigRequest) throws ConflictException,
            ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        return createClusterSchedulerConfig(CreateClusterSchedulerConfigRequest.builder()
                .applyMutation(createClusterSchedulerConfigRequest).build());
    }

    /**
     * <p>
     * Creates a Git repository as a resource in your SageMaker AI account. You can associate the repository with
     * notebook instances so that you can use Git source control for the notebooks you create. The Git repository is a
     * resource in your SageMaker AI account, so it can be associated with more than one notebook instance, and it
     * persists independently from the lifecycle of any notebook instances it is associated with.
     * </p>
     * <p>
     * The repository can be hosted either in <a
     * href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit</a> or
     * in any other Git repository.
     * </p>
     *
     * @param createCodeRepositoryRequest
     * @return Result of the CreateCodeRepository operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateCodeRepository
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateCodeRepository"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCodeRepositoryResponse createCodeRepository(CreateCodeRepositoryRequest createCodeRepositoryRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Git repository as a resource in your SageMaker AI account. You can associate the repository with
     * notebook instances so that you can use Git source control for the notebooks you create. The Git repository is a
     * resource in your SageMaker AI account, so it can be associated with more than one notebook instance, and it
     * persists independently from the lifecycle of any notebook instances it is associated with.
     * </p>
     * <p>
     * The repository can be hosted either in <a
     * href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit</a> or
     * in any other Git repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCodeRepositoryRequest.Builder} avoiding the
     * need to create one manually via {@link CreateCodeRepositoryRequest#builder()}
     * </p>
     *
     * @param createCodeRepositoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateCodeRepositoryRequest.Builder} to create a
     *        request.
     * @return Result of the CreateCodeRepository operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateCodeRepository
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateCodeRepository"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCodeRepositoryResponse createCodeRepository(
            Consumer<CreateCodeRepositoryRequest.Builder> createCodeRepositoryRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return createCodeRepository(CreateCodeRepositoryRequest.builder().applyMutation(createCodeRepositoryRequest).build());
    }

    /**
     * <p>
     * Starts a model compilation job. After the model has been compiled, Amazon SageMaker AI saves the resulting model
     * artifacts to an Amazon Simple Storage Service (Amazon S3) bucket that you specify.
     * </p>
     * <p>
     * If you choose to host your model using Amazon SageMaker AI hosting services, you can use the resulting model
     * artifacts as part of the model. You can also use the artifacts with Amazon Web Services IoT Greengrass. In that
     * case, deploy them as an ML resource.
     * </p>
     * <p>
     * In the request body, you provide the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A name for the compilation job
     * </p>
     * </li>
     * <li>
     * <p>
     * Information about the input model artifacts
     * </p>
     * </li>
     * <li>
     * <p>
     * The output location for the compiled model and the device (target) that the model runs on
     * </p>
     * </li>
     * <li>
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that Amazon SageMaker AI assumes to perform the model compilation
     * job.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can also provide a <code>Tag</code> to track the model compilation job's resource use and costs. The response
     * body contains the <code>CompilationJobArn</code> for the compiled job.
     * </p>
     * <p>
     * To stop a model compilation job, use <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StopCompilationJob.html"
     * >StopCompilationJob</a>. To get information about a particular model compilation job, use <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeCompilationJob.html"
     * >DescribeCompilationJob</a>. To get information about multiple model compilation jobs, use <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListCompilationJobs.html"
     * >ListCompilationJobs</a>.
     * </p>
     *
     * @param createCompilationJobRequest
     * @return Result of the CreateCompilationJob operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateCompilationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateCompilationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCompilationJobResponse createCompilationJob(CreateCompilationJobRequest createCompilationJobRequest)
            throws ResourceInUseException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a model compilation job. After the model has been compiled, Amazon SageMaker AI saves the resulting model
     * artifacts to an Amazon Simple Storage Service (Amazon S3) bucket that you specify.
     * </p>
     * <p>
     * If you choose to host your model using Amazon SageMaker AI hosting services, you can use the resulting model
     * artifacts as part of the model. You can also use the artifacts with Amazon Web Services IoT Greengrass. In that
     * case, deploy them as an ML resource.
     * </p>
     * <p>
     * In the request body, you provide the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A name for the compilation job
     * </p>
     * </li>
     * <li>
     * <p>
     * Information about the input model artifacts
     * </p>
     * </li>
     * <li>
     * <p>
     * The output location for the compiled model and the device (target) that the model runs on
     * </p>
     * </li>
     * <li>
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that Amazon SageMaker AI assumes to perform the model compilation
     * job.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can also provide a <code>Tag</code> to track the model compilation job's resource use and costs. The response
     * body contains the <code>CompilationJobArn</code> for the compiled job.
     * </p>
     * <p>
     * To stop a model compilation job, use <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StopCompilationJob.html"
     * >StopCompilationJob</a>. To get information about a particular model compilation job, use <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeCompilationJob.html"
     * >DescribeCompilationJob</a>. To get information about multiple model compilation jobs, use <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListCompilationJobs.html"
     * >ListCompilationJobs</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCompilationJobRequest.Builder} avoiding the
     * need to create one manually via {@link CreateCompilationJobRequest#builder()}
     * </p>
     *
     * @param createCompilationJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateCompilationJobRequest.Builder} to create a
     *        request.
     * @return Result of the CreateCompilationJob operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateCompilationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateCompilationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCompilationJobResponse createCompilationJob(
            Consumer<CreateCompilationJobRequest.Builder> createCompilationJobRequest) throws ResourceInUseException,
            ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        return createCompilationJob(CreateCompilationJobRequest.builder().applyMutation(createCompilationJobRequest).build());
    }

    /**
     * <p>
     * Create compute allocation definition. This defines how compute is allocated, shared, and borrowed for specified
     * entities. Specifically, how to lend and borrow idle compute and assign a fair-share weight to the specified
     * entities.
     * </p>
     *
     * @param createComputeQuotaRequest
     * @return Result of the CreateComputeQuota operation returned by the service.
     * @throws ConflictException
     *         There was a conflict when you attempted to modify a SageMaker entity such as an <code>Experiment</code>
     *         or <code>Artifact</code>.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateComputeQuota
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateComputeQuota" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateComputeQuotaResponse createComputeQuota(CreateComputeQuotaRequest createComputeQuotaRequest)
            throws ConflictException, ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create compute allocation definition. This defines how compute is allocated, shared, and borrowed for specified
     * entities. Specifically, how to lend and borrow idle compute and assign a fair-share weight to the specified
     * entities.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateComputeQuotaRequest.Builder} avoiding the
     * need to create one manually via {@link CreateComputeQuotaRequest#builder()}
     * </p>
     *
     * @param createComputeQuotaRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateComputeQuotaRequest.Builder} to create a
     *        request.
     * @return Result of the CreateComputeQuota operation returned by the service.
     * @throws ConflictException
     *         There was a conflict when you attempted to modify a SageMaker entity such as an <code>Experiment</code>
     *         or <code>Artifact</code>.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateComputeQuota
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateComputeQuota" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateComputeQuotaResponse createComputeQuota(Consumer<CreateComputeQuotaRequest.Builder> createComputeQuotaRequest)
            throws ConflictException, ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        return createComputeQuota(CreateComputeQuotaRequest.builder().applyMutation(createComputeQuotaRequest).build());
    }

    /**
     * <p>
     * Creates a <i>context</i>. A context is a lineage tracking entity that represents a logical grouping of other
     * tracking or experiment entities. Some examples are an endpoint and a model package. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html">Amazon SageMaker ML Lineage
     * Tracking</a>.
     * </p>
     *
     * @param createContextRequest
     * @return Result of the CreateContext operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateContext
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateContext" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateContextResponse createContext(CreateContextRequest createContextRequest) throws ResourceLimitExceededException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a <i>context</i>. A context is a lineage tracking entity that represents a logical grouping of other
     * tracking or experiment entities. Some examples are an endpoint and a model package. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html">Amazon SageMaker ML Lineage
     * Tracking</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateContextRequest.Builder} avoiding the need to
     * create one manually via {@link CreateContextRequest#builder()}
     * </p>
     *
     * @param createContextRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateContextRequest.Builder} to create a request.
     * @return Result of the CreateContext operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateContext
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateContext" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateContextResponse createContext(Consumer<CreateContextRequest.Builder> createContextRequest)
            throws ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        return createContext(CreateContextRequest.builder().applyMutation(createContextRequest).build());
    }

    /**
     * <p>
     * Creates a definition for a job that monitors data quality and drift. For information about model monitor, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html">Amazon SageMaker AI Model Monitor</a>.
     * </p>
     *
     * @param createDataQualityJobDefinitionRequest
     * @return Result of the CreateDataQualityJobDefinition operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateDataQualityJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateDataQualityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDataQualityJobDefinitionResponse createDataQualityJobDefinition(
            CreateDataQualityJobDefinitionRequest createDataQualityJobDefinitionRequest) throws ResourceInUseException,
            ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a definition for a job that monitors data quality and drift. For information about model monitor, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html">Amazon SageMaker AI Model Monitor</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDataQualityJobDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateDataQualityJobDefinitionRequest#builder()}
     * </p>
     *
     * @param createDataQualityJobDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateDataQualityJobDefinitionRequest.Builder} to
     *        create a request.
     * @return Result of the CreateDataQualityJobDefinition operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateDataQualityJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateDataQualityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDataQualityJobDefinitionResponse createDataQualityJobDefinition(
            Consumer<CreateDataQualityJobDefinitionRequest.Builder> createDataQualityJobDefinitionRequest)
            throws ResourceInUseException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            SageMakerException {
        return createDataQualityJobDefinition(CreateDataQualityJobDefinitionRequest.builder()
                .applyMutation(createDataQualityJobDefinitionRequest).build());
    }

    /**
     * <p>
     * Creates a device fleet.
     * </p>
     *
     * @param createDeviceFleetRequest
     * @return Result of the CreateDeviceFleet operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateDeviceFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateDeviceFleet" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateDeviceFleetResponse createDeviceFleet(CreateDeviceFleetRequest createDeviceFleetRequest)
            throws ResourceInUseException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a device fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDeviceFleetRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDeviceFleetRequest#builder()}
     * </p>
     *
     * @param createDeviceFleetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateDeviceFleetRequest.Builder} to create a
     *        request.
     * @return Result of the CreateDeviceFleet operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateDeviceFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateDeviceFleet" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateDeviceFleetResponse createDeviceFleet(Consumer<CreateDeviceFleetRequest.Builder> createDeviceFleetRequest)
            throws ResourceInUseException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            SageMakerException {
        return createDeviceFleet(CreateDeviceFleetRequest.builder().applyMutation(createDeviceFleetRequest).build());
    }

    /**
     * <p>
     * Creates a <code>Domain</code>. A domain consists of an associated Amazon Elastic File System volume, a list of
     * authorized users, and a variety of security, application, policy, and Amazon Virtual Private Cloud (VPC)
     * configurations. Users within a domain can share notebook files and other artifacts with each other.
     * </p>
     * <p>
     * <b>EFS storage</b>
     * </p>
     * <p>
     * When a domain is created, an EFS volume is created for use by all of the users within the domain. Each user
     * receives a private home directory within the EFS volume for notebooks, Git repositories, and data files.
     * </p>
     * <p>
     * SageMaker AI uses the Amazon Web Services Key Management Service (Amazon Web Services KMS) to encrypt the EFS
     * volume attached to the domain with an Amazon Web Services managed key by default. For more control, you can
     * specify a customer managed key. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/encryption-at-rest.html">Protect Data at Rest Using
     * Encryption</a>.
     * </p>
     * <p>
     * <b>VPC configuration</b>
     * </p>
     * <p>
     * All traffic between the domain and the Amazon EFS volume is through the specified VPC and subnets. For other
     * traffic, you can specify the <code>AppNetworkAccessType</code> parameter. <code>AppNetworkAccessType</code>
     * corresponds to the network access type that you choose when you onboard to the domain. The following options are
     * available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PublicInternetOnly</code> - Non-EFS traffic goes through a VPC managed by Amazon SageMaker AI, which allows
     * internet access. This is the default value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VpcOnly</code> - All traffic is through the specified VPC and subnets. Internet access is disabled by
     * default. To allow internet access, you must specify a NAT gateway.
     * </p>
     * <p>
     * When internet access is disabled, you won't be able to run a Amazon SageMaker AI Studio notebook or to train or
     * host models unless your VPC has an interface endpoint to the SageMaker AI API and runtime or a NAT gateway and
     * your security groups allow outbound connections.
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * NFS traffic over TCP on port 2049 needs to be allowed in both inbound and outbound rules in order to launch a
     * Amazon SageMaker AI Studio app successfully.
     * </p>
     * </important>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio-notebooks-and-internet-access.html">Connect Amazon
     * SageMaker AI Studio Notebooks to Resources in a VPC</a>.
     * </p>
     *
     * @param createDomainRequest
     * @return Result of the CreateDomain operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDomainResponse createDomain(CreateDomainRequest createDomainRequest) throws ResourceInUseException,
            ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a <code>Domain</code>. A domain consists of an associated Amazon Elastic File System volume, a list of
     * authorized users, and a variety of security, application, policy, and Amazon Virtual Private Cloud (VPC)
     * configurations. Users within a domain can share notebook files and other artifacts with each other.
     * </p>
     * <p>
     * <b>EFS storage</b>
     * </p>
     * <p>
     * When a domain is created, an EFS volume is created for use by all of the users within the domain. Each user
     * receives a private home directory within the EFS volume for notebooks, Git repositories, and data files.
     * </p>
     * <p>
     * SageMaker AI uses the Amazon Web Services Key Management Service (Amazon Web Services KMS) to encrypt the EFS
     * volume attached to the domain with an Amazon Web Services managed key by default. For more control, you can
     * specify a customer managed key. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/encryption-at-rest.html">Protect Data at Rest Using
     * Encryption</a>.
     * </p>
     * <p>
     * <b>VPC configuration</b>
     * </p>
     * <p>
     * All traffic between the domain and the Amazon EFS volume is through the specified VPC and subnets. For other
     * traffic, you can specify the <code>AppNetworkAccessType</code> parameter. <code>AppNetworkAccessType</code>
     * corresponds to the network access type that you choose when you onboard to the domain. The following options are
     * available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PublicInternetOnly</code> - Non-EFS traffic goes through a VPC managed by Amazon SageMaker AI, which allows
     * internet access. This is the default value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VpcOnly</code> - All traffic is through the specified VPC and subnets. Internet access is disabled by
     * default. To allow internet access, you must specify a NAT gateway.
     * </p>
     * <p>
     * When internet access is disabled, you won't be able to run a Amazon SageMaker AI Studio notebook or to train or
     * host models unless your VPC has an interface endpoint to the SageMaker AI API and runtime or a NAT gateway and
     * your security groups allow outbound connections.
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * NFS traffic over TCP on port 2049 needs to be allowed in both inbound and outbound rules in order to launch a
     * Amazon SageMaker AI Studio app successfully.
     * </p>
     * </important>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio-notebooks-and-internet-access.html">Connect Amazon
     * SageMaker AI Studio Notebooks to Resources in a VPC</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDomainRequest.Builder} avoiding the need to
     * create one manually via {@link CreateDomainRequest#builder()}
     * </p>
     *
     * @param createDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateDomainRequest.Builder} to create a request.
     * @return Result of the CreateDomain operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDomainResponse createDomain(Consumer<CreateDomainRequest.Builder> createDomainRequest)
            throws ResourceInUseException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            SageMakerException {
        return createDomain(CreateDomainRequest.builder().applyMutation(createDomainRequest).build());
    }

    /**
     * <p>
     * Creates an edge deployment plan, consisting of multiple stages. Each stage may have a different deployment
     * configuration and devices.
     * </p>
     *
     * @param createEdgeDeploymentPlanRequest
     * @return Result of the CreateEdgeDeploymentPlan operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateEdgeDeploymentPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEdgeDeploymentPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEdgeDeploymentPlanResponse createEdgeDeploymentPlan(
            CreateEdgeDeploymentPlanRequest createEdgeDeploymentPlanRequest) throws ResourceLimitExceededException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an edge deployment plan, consisting of multiple stages. Each stage may have a different deployment
     * configuration and devices.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEdgeDeploymentPlanRequest.Builder} avoiding
     * the need to create one manually via {@link CreateEdgeDeploymentPlanRequest#builder()}
     * </p>
     *
     * @param createEdgeDeploymentPlanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateEdgeDeploymentPlanRequest.Builder} to create
     *        a request.
     * @return Result of the CreateEdgeDeploymentPlan operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateEdgeDeploymentPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEdgeDeploymentPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEdgeDeploymentPlanResponse createEdgeDeploymentPlan(
            Consumer<CreateEdgeDeploymentPlanRequest.Builder> createEdgeDeploymentPlanRequest)
            throws ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        return createEdgeDeploymentPlan(CreateEdgeDeploymentPlanRequest.builder().applyMutation(createEdgeDeploymentPlanRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new stage in an existing edge deployment plan.
     * </p>
     *
     * @param createEdgeDeploymentStageRequest
     * @return Result of the CreateEdgeDeploymentStage operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateEdgeDeploymentStage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEdgeDeploymentStage"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEdgeDeploymentStageResponse createEdgeDeploymentStage(
            CreateEdgeDeploymentStageRequest createEdgeDeploymentStageRequest) throws ResourceLimitExceededException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new stage in an existing edge deployment plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEdgeDeploymentStageRequest.Builder} avoiding
     * the need to create one manually via {@link CreateEdgeDeploymentStageRequest#builder()}
     * </p>
     *
     * @param createEdgeDeploymentStageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateEdgeDeploymentStageRequest.Builder} to create
     *        a request.
     * @return Result of the CreateEdgeDeploymentStage operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateEdgeDeploymentStage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEdgeDeploymentStage"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEdgeDeploymentStageResponse createEdgeDeploymentStage(
            Consumer<CreateEdgeDeploymentStageRequest.Builder> createEdgeDeploymentStageRequest)
            throws ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        return createEdgeDeploymentStage(CreateEdgeDeploymentStageRequest.builder()
                .applyMutation(createEdgeDeploymentStageRequest).build());
    }

    /**
     * <p>
     * Starts a SageMaker Edge Manager model packaging job. Edge Manager will use the model artifacts from the Amazon
     * Simple Storage Service bucket that you specify. After the model has been packaged, Amazon SageMaker saves the
     * resulting artifacts to an S3 bucket that you specify.
     * </p>
     *
     * @param createEdgePackagingJobRequest
     * @return Result of the CreateEdgePackagingJob operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateEdgePackagingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEdgePackagingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEdgePackagingJobResponse createEdgePackagingJob(CreateEdgePackagingJobRequest createEdgePackagingJobRequest)
            throws ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a SageMaker Edge Manager model packaging job. Edge Manager will use the model artifacts from the Amazon
     * Simple Storage Service bucket that you specify. After the model has been packaged, Amazon SageMaker saves the
     * resulting artifacts to an S3 bucket that you specify.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEdgePackagingJobRequest.Builder} avoiding the
     * need to create one manually via {@link CreateEdgePackagingJobRequest#builder()}
     * </p>
     *
     * @param createEdgePackagingJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateEdgePackagingJobRequest.Builder} to create a
     *        request.
     * @return Result of the CreateEdgePackagingJob operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateEdgePackagingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEdgePackagingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEdgePackagingJobResponse createEdgePackagingJob(
            Consumer<CreateEdgePackagingJobRequest.Builder> createEdgePackagingJobRequest) throws ResourceLimitExceededException,
            AwsServiceException, SdkClientException, SageMakerException {
        return createEdgePackagingJob(CreateEdgePackagingJobRequest.builder().applyMutation(createEdgePackagingJobRequest)
                .build());
    }

    /**
     * <p>
     * Creates an endpoint using the endpoint configuration specified in the request. SageMaker uses the endpoint to
     * provision resources and deploy models. You create the endpoint configuration with the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html"
     * >CreateEndpointConfig</a> API.
     * </p>
     * <p>
     * Use this API to deploy models using SageMaker hosting services.
     * </p>
     * <note>
     * <p>
     * You must not delete an <code>EndpointConfig</code> that is in use by an endpoint that is live or while the
     * <code>UpdateEndpoint</code> or <code>CreateEndpoint</code> operations are being performed on the endpoint. To
     * update an endpoint, you must create a new <code>EndpointConfig</code>.
     * </p>
     * </note>
     * <p>
     * The endpoint name must be unique within an Amazon Web Services Region in your Amazon Web Services account.
     * </p>
     * <p>
     * When it receives the request, SageMaker creates the endpoint, launches the resources (ML compute instances), and
     * deploys the model(s) on them.
     * </p>
     * <note>
     * <p>
     * When you call <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html">CreateEndpoint</a>, a
     * load call is made to DynamoDB to verify that your endpoint configuration exists. When you read data from a
     * DynamoDB table supporting <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadConsistency.html">
     * <code>Eventually Consistent Reads</code> </a>, the response might not reflect the results of a recently completed
     * write operation. The response might include some stale data. If the dependent entities are not yet in DynamoDB,
     * this causes a validation error. If you repeat your read request after a short time, the response should return
     * the latest data. So retry logic is recommended to handle these possible issues. We also recommend that customers
     * call <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeEndpointConfig.html">
     * DescribeEndpointConfig</a> before calling <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html">CreateEndpoint</a> to
     * minimize the potential impact of a DynamoDB eventually consistent read.
     * </p>
     * </note>
     * <p>
     * When SageMaker receives the request, it sets the endpoint status to <code>Creating</code>. After it creates the
     * endpoint, it sets the status to <code>InService</code>. SageMaker can then process incoming requests for
     * inferences. To check the status of an endpoint, use the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeEndpoint.html">DescribeEndpoint</a>
     * API.
     * </p>
     * <p>
     * If any of the models hosted at this endpoint get model data from an Amazon S3 location, SageMaker uses Amazon Web
     * Services Security Token Service to download model artifacts from the S3 path you provided. Amazon Web Services
     * STS is activated in your Amazon Web Services account by default. If you previously deactivated Amazon Web
     * Services STS for a region, you need to reactivate Amazon Web Services STS for that region. For more information,
     * see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating
     * and Deactivating Amazon Web Services STS in an Amazon Web Services Region</a> in the <i>Amazon Web Services
     * Identity and Access Management User Guide</i>.
     * </p>
     * <note>
     * <p>
     * To add the IAM role policies for using this API operation, go to the <a
     * href="https://console.aws.amazon.com/iam/">IAM console</a>, and choose Roles in the left navigation pane. Search
     * the IAM role that you want to grant access to use the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html">CreateEndpoint</a> and
     * <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html">
     * CreateEndpointConfig</a> API operations, add the following policies to the role.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Option 1: For a full SageMaker access, search and attach the <code>AmazonSageMakerFullAccess</code> policy.
     * </p>
     * </li>
     * <li>
     * <p>
     * Option 2: For granting a limited access to an IAM role, paste the following Action elements manually into the
     * JSON file of the IAM role:
     * </p>
     * <p>
     * <code>"Action": ["sagemaker:CreateEndpoint", "sagemaker:CreateEndpointConfig"]</code>
     * </p>
     * <p>
     * <code>"Resource": [</code>
     * </p>
     * <p>
     * <code>"arn:aws:sagemaker:region:account-id:endpoint/endpointName"</code>
     * </p>
     * <p>
     * <code>"arn:aws:sagemaker:region:account-id:endpoint-config/endpointConfigName"</code>
     * </p>
     * <p>
     * <code>]</code>
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/api-permissions-reference.html">SageMaker API Permissions:
     * Actions, Permissions, and Resources Reference</a>.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param createEndpointRequest
     * @return Result of the CreateEndpoint operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateEndpointResponse createEndpoint(CreateEndpointRequest createEndpointRequest)
            throws ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an endpoint using the endpoint configuration specified in the request. SageMaker uses the endpoint to
     * provision resources and deploy models. You create the endpoint configuration with the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html"
     * >CreateEndpointConfig</a> API.
     * </p>
     * <p>
     * Use this API to deploy models using SageMaker hosting services.
     * </p>
     * <note>
     * <p>
     * You must not delete an <code>EndpointConfig</code> that is in use by an endpoint that is live or while the
     * <code>UpdateEndpoint</code> or <code>CreateEndpoint</code> operations are being performed on the endpoint. To
     * update an endpoint, you must create a new <code>EndpointConfig</code>.
     * </p>
     * </note>
     * <p>
     * The endpoint name must be unique within an Amazon Web Services Region in your Amazon Web Services account.
     * </p>
     * <p>
     * When it receives the request, SageMaker creates the endpoint, launches the resources (ML compute instances), and
     * deploys the model(s) on them.
     * </p>
     * <note>
     * <p>
     * When you call <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html">CreateEndpoint</a>, a
     * load call is made to DynamoDB to verify that your endpoint configuration exists. When you read data from a
     * DynamoDB table supporting <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadConsistency.html">
     * <code>Eventually Consistent Reads</code> </a>, the response might not reflect the results of a recently completed
     * write operation. The response might include some stale data. If the dependent entities are not yet in DynamoDB,
     * this causes a validation error. If you repeat your read request after a short time, the response should return
     * the latest data. So retry logic is recommended to handle these possible issues. We also recommend that customers
     * call <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeEndpointConfig.html">
     * DescribeEndpointConfig</a> before calling <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html">CreateEndpoint</a> to
     * minimize the potential impact of a DynamoDB eventually consistent read.
     * </p>
     * </note>
     * <p>
     * When SageMaker receives the request, it sets the endpoint status to <code>Creating</code>. After it creates the
     * endpoint, it sets the status to <code>InService</code>. SageMaker can then process incoming requests for
     * inferences. To check the status of an endpoint, use the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeEndpoint.html">DescribeEndpoint</a>
     * API.
     * </p>
     * <p>
     * If any of the models hosted at this endpoint get model data from an Amazon S3 location, SageMaker uses Amazon Web
     * Services Security Token Service to download model artifacts from the S3 path you provided. Amazon Web Services
     * STS is activated in your Amazon Web Services account by default. If you previously deactivated Amazon Web
     * Services STS for a region, you need to reactivate Amazon Web Services STS for that region. For more information,
     * see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating
     * and Deactivating Amazon Web Services STS in an Amazon Web Services Region</a> in the <i>Amazon Web Services
     * Identity and Access Management User Guide</i>.
     * </p>
     * <note>
     * <p>
     * To add the IAM role policies for using this API operation, go to the <a
     * href="https://console.aws.amazon.com/iam/">IAM console</a>, and choose Roles in the left navigation pane. Search
     * the IAM role that you want to grant access to use the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html">CreateEndpoint</a> and
     * <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html">
     * CreateEndpointConfig</a> API operations, add the following policies to the role.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Option 1: For a full SageMaker access, search and attach the <code>AmazonSageMakerFullAccess</code> policy.
     * </p>
     * </li>
     * <li>
     * <p>
     * Option 2: For granting a limited access to an IAM role, paste the following Action elements manually into the
     * JSON file of the IAM role:
     * </p>
     * <p>
     * <code>"Action": ["sagemaker:CreateEndpoint", "sagemaker:CreateEndpointConfig"]</code>
     * </p>
     * <p>
     * <code>"Resource": [</code>
     * </p>
     * <p>
     * <code>"arn:aws:sagemaker:region:account-id:endpoint/endpointName"</code>
     * </p>
     * <p>
     * <code>"arn:aws:sagemaker:region:account-id:endpoint-config/endpointConfigName"</code>
     * </p>
     * <p>
     * <code>]</code>
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/api-permissions-reference.html">SageMaker API Permissions:
     * Actions, Permissions, and Resources Reference</a>.
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEndpointRequest.Builder} avoiding the need to
     * create one manually via {@link CreateEndpointRequest#builder()}
     * </p>
     *
     * @param createEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateEndpointRequest.Builder} to create a request.
     * @return Result of the CreateEndpoint operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateEndpointResponse createEndpoint(Consumer<CreateEndpointRequest.Builder> createEndpointRequest)
            throws ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        return createEndpoint(CreateEndpointRequest.builder().applyMutation(createEndpointRequest).build());
    }

    /**
     * <p>
     * Creates an endpoint configuration that SageMaker hosting services uses to deploy models. In the configuration,
     * you identify one or more models, created using the <code>CreateModel</code> API, to deploy and the resources that
     * you want SageMaker to provision. Then you call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html">CreateEndpoint</a> API.
     * </p>
     * <note>
     * <p>
     * Use this API if you want to use SageMaker hosting services to deploy models into production.
     * </p>
     * </note>
     * <p>
     * In the request, you define a <code>ProductionVariant</code>, for each model that you want to deploy. Each
     * <code>ProductionVariant</code> parameter also describes the resources that you want SageMaker to provision. This
     * includes the number and type of ML compute instances to deploy.
     * </p>
     * <p>
     * If you are hosting multiple models, you also assign a <code>VariantWeight</code> to specify how much traffic you
     * want to allocate to each model. For example, suppose that you want to host two models, A and B, and you assign
     * traffic weight 2 for model A and 1 for model B. SageMaker distributes two-thirds of the traffic to Model A, and
     * one-third to model B.
     * </p>
     * <note>
     * <p>
     * When you call <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html">CreateEndpoint</a>, a
     * load call is made to DynamoDB to verify that your endpoint configuration exists. When you read data from a
     * DynamoDB table supporting <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadConsistency.html">
     * <code>Eventually Consistent Reads</code> </a>, the response might not reflect the results of a recently completed
     * write operation. The response might include some stale data. If the dependent entities are not yet in DynamoDB,
     * this causes a validation error. If you repeat your read request after a short time, the response should return
     * the latest data. So retry logic is recommended to handle these possible issues. We also recommend that customers
     * call <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeEndpointConfig.html">
     * DescribeEndpointConfig</a> before calling <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html">CreateEndpoint</a> to
     * minimize the potential impact of a DynamoDB eventually consistent read.
     * </p>
     * </note>
     *
     * @param createEndpointConfigRequest
     * @return Result of the CreateEndpointConfig operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateEndpointConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEndpointConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEndpointConfigResponse createEndpointConfig(CreateEndpointConfigRequest createEndpointConfigRequest)
            throws ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an endpoint configuration that SageMaker hosting services uses to deploy models. In the configuration,
     * you identify one or more models, created using the <code>CreateModel</code> API, to deploy and the resources that
     * you want SageMaker to provision. Then you call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html">CreateEndpoint</a> API.
     * </p>
     * <note>
     * <p>
     * Use this API if you want to use SageMaker hosting services to deploy models into production.
     * </p>
     * </note>
     * <p>
     * In the request, you define a <code>ProductionVariant</code>, for each model that you want to deploy. Each
     * <code>ProductionVariant</code> parameter also describes the resources that you want SageMaker to provision. This
     * includes the number and type of ML compute instances to deploy.
     * </p>
     * <p>
     * If you are hosting multiple models, you also assign a <code>VariantWeight</code> to specify how much traffic you
     * want to allocate to each model. For example, suppose that you want to host two models, A and B, and you assign
     * traffic weight 2 for model A and 1 for model B. SageMaker distributes two-thirds of the traffic to Model A, and
     * one-third to model B.
     * </p>
     * <note>
     * <p>
     * When you call <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html">CreateEndpoint</a>, a
     * load call is made to DynamoDB to verify that your endpoint configuration exists. When you read data from a
     * DynamoDB table supporting <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadConsistency.html">
     * <code>Eventually Consistent Reads</code> </a>, the response might not reflect the results of a recently completed
     * write operation. The response might include some stale data. If the dependent entities are not yet in DynamoDB,
     * this causes a validation error. If you repeat your read request after a short time, the response should return
     * the latest data. So retry logic is recommended to handle these possible issues. We also recommend that customers
     * call <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeEndpointConfig.html">
     * DescribeEndpointConfig</a> before calling <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html">CreateEndpoint</a> to
     * minimize the potential impact of a DynamoDB eventually consistent read.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEndpointConfigRequest.Builder} avoiding the
     * need to create one manually via {@link CreateEndpointConfigRequest#builder()}
     * </p>
     *
     * @param createEndpointConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateEndpointConfigRequest.Builder} to create a
     *        request.
     * @return Result of the CreateEndpointConfig operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateEndpointConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEndpointConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEndpointConfigResponse createEndpointConfig(
            Consumer<CreateEndpointConfigRequest.Builder> createEndpointConfigRequest) throws ResourceLimitExceededException,
            AwsServiceException, SdkClientException, SageMakerException {
        return createEndpointConfig(CreateEndpointConfigRequest.builder().applyMutation(createEndpointConfigRequest).build());
    }

    /**
     * <p>
     * Creates a SageMaker <i>experiment</i>. An experiment is a collection of <i>trials</i> that are observed, compared
     * and evaluated as a group. A trial is a set of steps, called <i>trial components</i>, that produce a machine
     * learning model.
     * </p>
     * <note>
     * <p>
     * In the Studio UI, trials are referred to as <i>run groups</i> and trial components are referred to as
     * <i>runs</i>.
     * </p>
     * </note>
     * <p>
     * The goal of an experiment is to determine the components that produce the best model. Multiple trials are
     * performed, each one isolating and measuring the impact of a change to one or more inputs, while keeping the
     * remaining inputs constant.
     * </p>
     * <p>
     * When you use SageMaker Studio or the SageMaker Python SDK, all experiments, trials, and trial components are
     * automatically tracked, logged, and indexed. When you use the Amazon Web Services SDK for Python (Boto), you must
     * use the logging APIs provided by the SDK.
     * </p>
     * <p>
     * You can add tags to experiments, trials, trial components and then use the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html">Search</a> API to search for the
     * tags.
     * </p>
     * <p>
     * To add a description to an experiment, specify the optional <code>Description</code> parameter. To add a
     * description later, or to change the description, call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateExperiment.html">UpdateExperiment</a>
     * API.
     * </p>
     * <p>
     * To get a list of all your experiments, call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListExperiments.html">ListExperiments</a>
     * API. To view an experiment's properties, call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeExperiment.html"
     * >DescribeExperiment</a> API. To get a list of all the trials associated with an experiment, call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListTrials.html">ListTrials</a> API. To
     * create a trial call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTrial.html">CreateTrial</a> API.
     * </p>
     *
     * @param createExperimentRequest
     * @return Result of the CreateExperiment operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateExperiment" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateExperimentResponse createExperiment(CreateExperimentRequest createExperimentRequest)
            throws ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a SageMaker <i>experiment</i>. An experiment is a collection of <i>trials</i> that are observed, compared
     * and evaluated as a group. A trial is a set of steps, called <i>trial components</i>, that produce a machine
     * learning model.
     * </p>
     * <note>
     * <p>
     * In the Studio UI, trials are referred to as <i>run groups</i> and trial components are referred to as
     * <i>runs</i>.
     * </p>
     * </note>
     * <p>
     * The goal of an experiment is to determine the components that produce the best model. Multiple trials are
     * performed, each one isolating and measuring the impact of a change to one or more inputs, while keeping the
     * remaining inputs constant.
     * </p>
     * <p>
     * When you use SageMaker Studio or the SageMaker Python SDK, all experiments, trials, and trial components are
     * automatically tracked, logged, and indexed. When you use the Amazon Web Services SDK for Python (Boto), you must
     * use the logging APIs provided by the SDK.
     * </p>
     * <p>
     * You can add tags to experiments, trials, trial components and then use the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html">Search</a> API to search for the
     * tags.
     * </p>
     * <p>
     * To add a description to an experiment, specify the optional <code>Description</code> parameter. To add a
     * description later, or to change the description, call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateExperiment.html">UpdateExperiment</a>
     * API.
     * </p>
     * <p>
     * To get a list of all your experiments, call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListExperiments.html">ListExperiments</a>
     * API. To view an experiment's properties, call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeExperiment.html"
     * >DescribeExperiment</a> API. To get a list of all the trials associated with an experiment, call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListTrials.html">ListTrials</a> API. To
     * create a trial call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTrial.html">CreateTrial</a> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateExperimentRequest.Builder} avoiding the need
     * to create one manually via {@link CreateExperimentRequest#builder()}
     * </p>
     *
     * @param createExperimentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateExperimentRequest.Builder} to create a
     *        request.
     * @return Result of the CreateExperiment operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateExperiment" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateExperimentResponse createExperiment(Consumer<CreateExperimentRequest.Builder> createExperimentRequest)
            throws ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        return createExperiment(CreateExperimentRequest.builder().applyMutation(createExperimentRequest).build());
    }

    /**
     * <p>
     * Create a new <code>FeatureGroup</code>. A <code>FeatureGroup</code> is a group of <code>Features</code> defined
     * in the <code>FeatureStore</code> to describe a <code>Record</code>.
     * </p>
     * <p>
     * The <code>FeatureGroup</code> defines the schema and features contained in the <code>FeatureGroup</code>. A
     * <code>FeatureGroup</code> definition is composed of a list of <code>Features</code>, a
     * <code>RecordIdentifierFeatureName</code>, an <code>EventTimeFeatureName</code> and configurations for its
     * <code>OnlineStore</code> and <code>OfflineStore</code>. Check <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">Amazon Web Services service
     * quotas</a> to see the <code>FeatureGroup</code>s quota for your Amazon Web Services account.
     * </p>
     * <p>
     * Note that it can take approximately 10-15 minutes to provision an <code>OnlineStore</code>
     * <code>FeatureGroup</code> with the <code>InMemory</code> <code>StorageType</code>.
     * </p>
     * <important>
     * <p>
     * You must include at least one of <code>OnlineStoreConfig</code> and <code>OfflineStoreConfig</code> to create a
     * <code>FeatureGroup</code>.
     * </p>
     * </important>
     *
     * @param createFeatureGroupRequest
     * @return Result of the CreateFeatureGroup operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateFeatureGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateFeatureGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateFeatureGroupResponse createFeatureGroup(CreateFeatureGroupRequest createFeatureGroupRequest)
            throws ResourceInUseException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a new <code>FeatureGroup</code>. A <code>FeatureGroup</code> is a group of <code>Features</code> defined
     * in the <code>FeatureStore</code> to describe a <code>Record</code>.
     * </p>
     * <p>
     * The <code>FeatureGroup</code> defines the schema and features contained in the <code>FeatureGroup</code>. A
     * <code>FeatureGroup</code> definition is composed of a list of <code>Features</code>, a
     * <code>RecordIdentifierFeatureName</code>, an <code>EventTimeFeatureName</code> and configurations for its
     * <code>OnlineStore</code> and <code>OfflineStore</code>. Check <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">Amazon Web Services service
     * quotas</a> to see the <code>FeatureGroup</code>s quota for your Amazon Web Services account.
     * </p>
     * <p>
     * Note that it can take approximately 10-15 minutes to provision an <code>OnlineStore</code>
     * <code>FeatureGroup</code> with the <code>InMemory</code> <code>StorageType</code>.
     * </p>
     * <important>
     * <p>
     * You must include at least one of <code>OnlineStoreConfig</code> and <code>OfflineStoreConfig</code> to create a
     * <code>FeatureGroup</code>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFeatureGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateFeatureGroupRequest#builder()}
     * </p>
     *
     * @param createFeatureGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateFeatureGroupRequest.Builder} to create a
     *        request.
     * @return Result of the CreateFeatureGroup operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateFeatureGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateFeatureGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateFeatureGroupResponse createFeatureGroup(Consumer<CreateFeatureGroupRequest.Builder> createFeatureGroupRequest)
            throws ResourceInUseException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            SageMakerException {
        return createFeatureGroup(CreateFeatureGroupRequest.builder().applyMutation(createFeatureGroupRequest).build());
    }

    /**
     * <p>
     * Creates a flow definition.
     * </p>
     *
     * @param createFlowDefinitionRequest
     * @return Result of the CreateFlowDefinition operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateFlowDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateFlowDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateFlowDefinitionResponse createFlowDefinition(CreateFlowDefinitionRequest createFlowDefinitionRequest)
            throws ResourceInUseException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a flow definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFlowDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateFlowDefinitionRequest#builder()}
     * </p>
     *
     * @param createFlowDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateFlowDefinitionRequest.Builder} to create a
     *        request.
     * @return Result of the CreateFlowDefinition operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateFlowDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateFlowDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateFlowDefinitionResponse createFlowDefinition(
            Consumer<CreateFlowDefinitionRequest.Builder> createFlowDefinitionRequest) throws ResourceInUseException,
            ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        return createFlowDefinition(CreateFlowDefinitionRequest.builder().applyMutation(createFlowDefinitionRequest).build());
    }

    /**
     * <p>
     * Create a hub.
     * </p>
     *
     * @param createHubRequest
     * @return Result of the CreateHub operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateHub
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateHub" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateHubResponse createHub(CreateHubRequest createHubRequest) throws ResourceInUseException,
            ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a hub.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateHubRequest.Builder} avoiding the need to
     * create one manually via {@link CreateHubRequest#builder()}
     * </p>
     *
     * @param createHubRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateHubRequest.Builder} to create a request.
     * @return Result of the CreateHub operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateHub
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateHub" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateHubResponse createHub(Consumer<CreateHubRequest.Builder> createHubRequest) throws ResourceInUseException,
            ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        return createHub(CreateHubRequest.builder().applyMutation(createHubRequest).build());
    }

    /**
     * <p>
     * Create a hub content reference in order to add a model in the JumpStart public hub to a private hub.
     * </p>
     *
     * @param createHubContentReferenceRequest
     * @return Result of the CreateHubContentReference operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateHubContentReference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateHubContentReference"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateHubContentReferenceResponse createHubContentReference(
            CreateHubContentReferenceRequest createHubContentReferenceRequest) throws ResourceNotFoundException,
            ResourceInUseException, ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a hub content reference in order to add a model in the JumpStart public hub to a private hub.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateHubContentReferenceRequest.Builder} avoiding
     * the need to create one manually via {@link CreateHubContentReferenceRequest#builder()}
     * </p>
     *
     * @param createHubContentReferenceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateHubContentReferenceRequest.Builder} to create
     *        a request.
     * @return Result of the CreateHubContentReference operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateHubContentReference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateHubContentReference"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateHubContentReferenceResponse createHubContentReference(
            Consumer<CreateHubContentReferenceRequest.Builder> createHubContentReferenceRequest)
            throws ResourceNotFoundException, ResourceInUseException, ResourceLimitExceededException, AwsServiceException,
            SdkClientException, SageMakerException {
        return createHubContentReference(CreateHubContentReferenceRequest.builder()
                .applyMutation(createHubContentReferenceRequest).build());
    }

    /**
     * <p>
     * Defines the settings you will use for the human review workflow user interface. Reviewers will see a three-panel
     * interface with an instruction area, the item to review, and an input area.
     * </p>
     *
     * @param createHumanTaskUiRequest
     * @return Result of the CreateHumanTaskUi operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateHumanTaskUi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateHumanTaskUi" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateHumanTaskUiResponse createHumanTaskUi(CreateHumanTaskUiRequest createHumanTaskUiRequest)
            throws ResourceInUseException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Defines the settings you will use for the human review workflow user interface. Reviewers will see a three-panel
     * interface with an instruction area, the item to review, and an input area.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateHumanTaskUiRequest.Builder} avoiding the need
     * to create one manually via {@link CreateHumanTaskUiRequest#builder()}
     * </p>
     *
     * @param createHumanTaskUiRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateHumanTaskUiRequest.Builder} to create a
     *        request.
     * @return Result of the CreateHumanTaskUi operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateHumanTaskUi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateHumanTaskUi" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateHumanTaskUiResponse createHumanTaskUi(Consumer<CreateHumanTaskUiRequest.Builder> createHumanTaskUiRequest)
            throws ResourceInUseException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            SageMakerException {
        return createHumanTaskUi(CreateHumanTaskUiRequest.builder().applyMutation(createHumanTaskUiRequest).build());
    }

    /**
     * <p>
     * Starts a hyperparameter tuning job. A hyperparameter tuning job finds the best version of a model by running many
     * training jobs on your dataset using the algorithm you choose and values for hyperparameters within ranges that
     * you specify. It then chooses the hyperparameter values that result in a model that performs the best, as measured
     * by an objective metric that you choose.
     * </p>
     * <p>
     * A hyperparameter tuning job automatically creates Amazon SageMaker experiments, trials, and trial components for
     * each training job that it runs. You can view these entities in Amazon SageMaker Studio. For more information, see
     * <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/experiments-view-compare.html#experiments-view">View
     * Experiments, Trials, and Trial Components</a>.
     * </p>
     * <important>
     * <p>
     * Do not include any security-sensitive information including account access IDs, secrets, or tokens in any
     * hyperparameter fields. As part of the shared responsibility model, you are responsible for any potential
     * exposure, unauthorized access, or compromise of your sensitive data if caused by any security-sensitive
     * information included in the request hyperparameter variable or plain text fields..
     * </p>
     * </important>
     *
     * @param createHyperParameterTuningJobRequest
     * @return Result of the CreateHyperParameterTuningJob operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateHyperParameterTuningJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateHyperParameterTuningJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateHyperParameterTuningJobResponse createHyperParameterTuningJob(
            CreateHyperParameterTuningJobRequest createHyperParameterTuningJobRequest) throws ResourceInUseException,
            ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a hyperparameter tuning job. A hyperparameter tuning job finds the best version of a model by running many
     * training jobs on your dataset using the algorithm you choose and values for hyperparameters within ranges that
     * you specify. It then chooses the hyperparameter values that result in a model that performs the best, as measured
     * by an objective metric that you choose.
     * </p>
     * <p>
     * A hyperparameter tuning job automatically creates Amazon SageMaker experiments, trials, and trial components for
     * each training job that it runs. You can view these entities in Amazon SageMaker Studio. For more information, see
     * <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/experiments-view-compare.html#experiments-view">View
     * Experiments, Trials, and Trial Components</a>.
     * </p>
     * <important>
     * <p>
     * Do not include any security-sensitive information including account access IDs, secrets, or tokens in any
     * hyperparameter fields. As part of the shared responsibility model, you are responsible for any potential
     * exposure, unauthorized access, or compromise of your sensitive data if caused by any security-sensitive
     * information included in the request hyperparameter variable or plain text fields..
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateHyperParameterTuningJobRequest.Builder}
     * avoiding the need to create one manually via {@link CreateHyperParameterTuningJobRequest#builder()}
     * </p>
     *
     * @param createHyperParameterTuningJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateHyperParameterTuningJobRequest.Builder} to
     *        create a request.
     * @return Result of the CreateHyperParameterTuningJob operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateHyperParameterTuningJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateHyperParameterTuningJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateHyperParameterTuningJobResponse createHyperParameterTuningJob(
            Consumer<CreateHyperParameterTuningJobRequest.Builder> createHyperParameterTuningJobRequest)
            throws ResourceInUseException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            SageMakerException {
        return createHyperParameterTuningJob(CreateHyperParameterTuningJobRequest.builder()
                .applyMutation(createHyperParameterTuningJobRequest).build());
    }

    /**
     * <p>
     * Creates a custom SageMaker AI image. A SageMaker AI image is a set of image versions. Each image version
     * represents a container image stored in Amazon ECR. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio-byoi.html">Bring your own SageMaker AI image</a>.
     * </p>
     *
     * @param createImageRequest
     * @return Result of the CreateImage operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateImage" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateImageResponse createImage(CreateImageRequest createImageRequest) throws ResourceInUseException,
            ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a custom SageMaker AI image. A SageMaker AI image is a set of image versions. Each image version
     * represents a container image stored in Amazon ECR. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio-byoi.html">Bring your own SageMaker AI image</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateImageRequest.Builder} avoiding the need to
     * create one manually via {@link CreateImageRequest#builder()}
     * </p>
     *
     * @param createImageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateImageRequest.Builder} to create a request.
     * @return Result of the CreateImage operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateImage" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateImageResponse createImage(Consumer<CreateImageRequest.Builder> createImageRequest)
            throws ResourceInUseException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            SageMakerException {
        return createImage(CreateImageRequest.builder().applyMutation(createImageRequest).build());
    }

    /**
     * <p>
     * Creates a version of the SageMaker AI image specified by <code>ImageName</code>. The version represents the
     * Amazon ECR container image specified by <code>BaseImage</code>.
     * </p>
     *
     * @param createImageVersionRequest
     * @return Result of the CreateImageVersion operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateImageVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateImageVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateImageVersionResponse createImageVersion(CreateImageVersionRequest createImageVersionRequest)
            throws ResourceNotFoundException, ResourceInUseException, ResourceLimitExceededException, AwsServiceException,
            SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a version of the SageMaker AI image specified by <code>ImageName</code>. The version represents the
     * Amazon ECR container image specified by <code>BaseImage</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateImageVersionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateImageVersionRequest#builder()}
     * </p>
     *
     * @param createImageVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateImageVersionRequest.Builder} to create a
     *        request.
     * @return Result of the CreateImageVersion operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateImageVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateImageVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateImageVersionResponse createImageVersion(Consumer<CreateImageVersionRequest.Builder> createImageVersionRequest)
            throws ResourceNotFoundException, ResourceInUseException, ResourceLimitExceededException, AwsServiceException,
            SdkClientException, SageMakerException {
        return createImageVersion(CreateImageVersionRequest.builder().applyMutation(createImageVersionRequest).build());
    }

    /**
     * <p>
     * Creates an inference component, which is a SageMaker AI hosting object that you can use to deploy a model to an
     * endpoint. In the inference component settings, you specify the model, the endpoint, and how the model utilizes
     * the resources that the endpoint hosts. You can optimize resource utilization by tailoring how the required CPU
     * cores, accelerators, and memory are allocated. You can deploy multiple inference components to an endpoint, where
     * each inference component contains one model and the resource utilization needs for that individual model. After
     * you deploy an inference component, you can directly invoke the associated model when you use the InvokeEndpoint
     * API action.
     * </p>
     *
     * @param createInferenceComponentRequest
     * @return Result of the CreateInferenceComponent operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateInferenceComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateInferenceComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateInferenceComponentResponse createInferenceComponent(
            CreateInferenceComponentRequest createInferenceComponentRequest) throws ResourceLimitExceededException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an inference component, which is a SageMaker AI hosting object that you can use to deploy a model to an
     * endpoint. In the inference component settings, you specify the model, the endpoint, and how the model utilizes
     * the resources that the endpoint hosts. You can optimize resource utilization by tailoring how the required CPU
     * cores, accelerators, and memory are allocated. You can deploy multiple inference components to an endpoint, where
     * each inference component contains one model and the resource utilization needs for that individual model. After
     * you deploy an inference component, you can directly invoke the associated model when you use the InvokeEndpoint
     * API action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInferenceComponentRequest.Builder} avoiding
     * the need to create one manually via {@link CreateInferenceComponentRequest#builder()}
     * </p>
     *
     * @param createInferenceComponentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateInferenceComponentRequest.Builder} to create
     *        a request.
     * @return Result of the CreateInferenceComponent operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateInferenceComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateInferenceComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateInferenceComponentResponse createInferenceComponent(
            Consumer<CreateInferenceComponentRequest.Builder> createInferenceComponentRequest)
            throws ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        return createInferenceComponent(CreateInferenceComponentRequest.builder().applyMutation(createInferenceComponentRequest)
                .build());
    }

    /**
     * <p>
     * Creates an inference experiment using the configurations specified in the request.
     * </p>
     * <p>
     * Use this API to setup and schedule an experiment to compare model variants on a Amazon SageMaker inference
     * endpoint. For more information about inference experiments, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/shadow-tests.html">Shadow tests</a>.
     * </p>
     * <p>
     * Amazon SageMaker begins your experiment at the scheduled time and routes traffic to your endpoint's model
     * variants based on your specified configuration.
     * </p>
     * <p>
     * While the experiment is in progress or after it has concluded, you can view metrics that compare your model
     * variants. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/shadow-tests-view-monitor-edit.html">View, monitor, and
     * edit shadow tests</a>.
     * </p>
     *
     * @param createInferenceExperimentRequest
     * @return Result of the CreateInferenceExperiment operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateInferenceExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateInferenceExperiment"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateInferenceExperimentResponse createInferenceExperiment(
            CreateInferenceExperimentRequest createInferenceExperimentRequest) throws ResourceInUseException,
            ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an inference experiment using the configurations specified in the request.
     * </p>
     * <p>
     * Use this API to setup and schedule an experiment to compare model variants on a Amazon SageMaker inference
     * endpoint. For more information about inference experiments, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/shadow-tests.html">Shadow tests</a>.
     * </p>
     * <p>
     * Amazon SageMaker begins your experiment at the scheduled time and routes traffic to your endpoint's model
     * variants based on your specified configuration.
     * </p>
     * <p>
     * While the experiment is in progress or after it has concluded, you can view metrics that compare your model
     * variants. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/shadow-tests-view-monitor-edit.html">View, monitor, and
     * edit shadow tests</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInferenceExperimentRequest.Builder} avoiding
     * the need to create one manually via {@link CreateInferenceExperimentRequest#builder()}
     * </p>
     *
     * @param createInferenceExperimentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateInferenceExperimentRequest.Builder} to create
     *        a request.
     * @return Result of the CreateInferenceExperiment operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateInferenceExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateInferenceExperiment"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateInferenceExperimentResponse createInferenceExperiment(
            Consumer<CreateInferenceExperimentRequest.Builder> createInferenceExperimentRequest) throws ResourceInUseException,
            ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        return createInferenceExperiment(CreateInferenceExperimentRequest.builder()
                .applyMutation(createInferenceExperimentRequest).build());
    }

    /**
     * <p>
     * Starts a recommendation job. You can create either an instance recommendation or load test job.
     * </p>
     *
     * @param createInferenceRecommendationsJobRequest
     * @return Result of the CreateInferenceRecommendationsJob operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateInferenceRecommendationsJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateInferenceRecommendationsJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateInferenceRecommendationsJobResponse createInferenceRecommendationsJob(
            CreateInferenceRecommendationsJobRequest createInferenceRecommendationsJobRequest) throws ResourceInUseException,
            ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a recommendation job. You can create either an instance recommendation or load test job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInferenceRecommendationsJobRequest.Builder}
     * avoiding the need to create one manually via {@link CreateInferenceRecommendationsJobRequest#builder()}
     * </p>
     *
     * @param createInferenceRecommendationsJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateInferenceRecommendationsJobRequest.Builder}
     *        to create a request.
     * @return Result of the CreateInferenceRecommendationsJob operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateInferenceRecommendationsJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateInferenceRecommendationsJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateInferenceRecommendationsJobResponse createInferenceRecommendationsJob(
            Consumer<CreateInferenceRecommendationsJobRequest.Builder> createInferenceRecommendationsJobRequest)
            throws ResourceInUseException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            SageMakerException {
        return createInferenceRecommendationsJob(CreateInferenceRecommendationsJobRequest.builder()
                .applyMutation(createInferenceRecommendationsJobRequest).build());
    }

    /**
     * <p>
     * Creates a job that uses workers to label the data objects in your input dataset. You can use the labeled data to
     * train machine learning models.
     * </p>
     * <p>
     * You can select your workforce from one of three providers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A private workforce that you create. It can include employees, contractors, and outside experts. Use a private
     * workforce when want the data to stay within your organization or when a specific set of skills is required.
     * </p>
     * </li>
     * <li>
     * <p>
     * One or more vendors that you select from the Amazon Web Services Marketplace. Vendors provide expertise in
     * specific areas.
     * </p>
     * </li>
     * <li>
     * <p>
     * The Amazon Mechanical Turk workforce. This is the largest workforce, but it should only be used for public data
     * or data that has been stripped of any personally identifiable information.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can also use <i>automated data labeling</i> to reduce the number of data objects that need to be labeled by a
     * human. Automated data labeling uses <i>active learning</i> to determine if a data object can be labeled by
     * machine or if it needs to be sent to a human worker. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-automated-labeling.html">Using Automated Data
     * Labeling</a>.
     * </p>
     * <p>
     * The data objects to be labeled are contained in an Amazon S3 bucket. You create a <i>manifest file</i> that
     * describes the location of each object. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data.html">Using Input and Output Data</a>.
     * </p>
     * <p>
     * The output can be used as the manifest file for another labeling job or as training data for your machine
     * learning models.
     * </p>
     * <p>
     * You can use this operation to create a static labeling job or a streaming labeling job. A static labeling job
     * stops if all data objects in the input manifest file identified in <code>ManifestS3Uri</code> have been labeled.
     * A streaming labeling job runs perpetually until it is manually stopped, or remains idle for 10 days. You can send
     * new data objects to an active (<code>InProgress</code>) streaming labeling job in real time. To learn how to
     * create a static labeling job, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-create-labeling-job-api.html">Create a Labeling Job
     * (API) </a> in the Amazon SageMaker Developer Guide. To learn how to create a streaming labeling job, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-streaming-create-job.html">Create a Streaming Labeling
     * Job</a>.
     * </p>
     *
     * @param createLabelingJobRequest
     * @return Result of the CreateLabelingJob operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateLabelingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateLabelingJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateLabelingJobResponse createLabelingJob(CreateLabelingJobRequest createLabelingJobRequest)
            throws ResourceInUseException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a job that uses workers to label the data objects in your input dataset. You can use the labeled data to
     * train machine learning models.
     * </p>
     * <p>
     * You can select your workforce from one of three providers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A private workforce that you create. It can include employees, contractors, and outside experts. Use a private
     * workforce when want the data to stay within your organization or when a specific set of skills is required.
     * </p>
     * </li>
     * <li>
     * <p>
     * One or more vendors that you select from the Amazon Web Services Marketplace. Vendors provide expertise in
     * specific areas.
     * </p>
     * </li>
     * <li>
     * <p>
     * The Amazon Mechanical Turk workforce. This is the largest workforce, but it should only be used for public data
     * or data that has been stripped of any personally identifiable information.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can also use <i>automated data labeling</i> to reduce the number of data objects that need to be labeled by a
     * human. Automated data labeling uses <i>active learning</i> to determine if a data object can be labeled by
     * machine or if it needs to be sent to a human worker. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-automated-labeling.html">Using Automated Data
     * Labeling</a>.
     * </p>
     * <p>
     * The data objects to be labeled are contained in an Amazon S3 bucket. You create a <i>manifest file</i> that
     * describes the location of each object. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data.html">Using Input and Output Data</a>.
     * </p>
     * <p>
     * The output can be used as the manifest file for another labeling job or as training data for your machine
     * learning models.
     * </p>
     * <p>
     * You can use this operation to create a static labeling job or a streaming labeling job. A static labeling job
     * stops if all data objects in the input manifest file identified in <code>ManifestS3Uri</code> have been labeled.
     * A streaming labeling job runs perpetually until it is manually stopped, or remains idle for 10 days. You can send
     * new data objects to an active (<code>InProgress</code>) streaming labeling job in real time. To learn how to
     * create a static labeling job, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-create-labeling-job-api.html">Create a Labeling Job
     * (API) </a> in the Amazon SageMaker Developer Guide. To learn how to create a streaming labeling job, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-streaming-create-job.html">Create a Streaming Labeling
     * Job</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLabelingJobRequest.Builder} avoiding the need
     * to create one manually via {@link CreateLabelingJobRequest#builder()}
     * </p>
     *
     * @param createLabelingJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateLabelingJobRequest.Builder} to create a
     *        request.
     * @return Result of the CreateLabelingJob operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateLabelingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateLabelingJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateLabelingJobResponse createLabelingJob(Consumer<CreateLabelingJobRequest.Builder> createLabelingJobRequest)
            throws ResourceInUseException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            SageMakerException {
        return createLabelingJob(CreateLabelingJobRequest.builder().applyMutation(createLabelingJobRequest).build());
    }

    /**
     * <p>
     * Creates an MLflow Tracking Server using a general purpose Amazon S3 bucket as the artifact store. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow-create-tracking-server.html">Create an MLflow
     * Tracking Server</a>.
     * </p>
     *
     * @param createMlflowTrackingServerRequest
     * @return Result of the CreateMlflowTrackingServer operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateMlflowTrackingServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateMlflowTrackingServer"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateMlflowTrackingServerResponse createMlflowTrackingServer(
            CreateMlflowTrackingServerRequest createMlflowTrackingServerRequest) throws ResourceLimitExceededException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an MLflow Tracking Server using a general purpose Amazon S3 bucket as the artifact store. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow-create-tracking-server.html">Create an MLflow
     * Tracking Server</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMlflowTrackingServerRequest.Builder} avoiding
     * the need to create one manually via {@link CreateMlflowTrackingServerRequest#builder()}
     * </p>
     *
     * @param createMlflowTrackingServerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateMlflowTrackingServerRequest.Builder} to
     *        create a request.
     * @return Result of the CreateMlflowTrackingServer operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateMlflowTrackingServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateMlflowTrackingServer"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateMlflowTrackingServerResponse createMlflowTrackingServer(
            Consumer<CreateMlflowTrackingServerRequest.Builder> createMlflowTrackingServerRequest)
            throws ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        return createMlflowTrackingServer(CreateMlflowTrackingServerRequest.builder()
                .applyMutation(createMlflowTrackingServerRequest).build());
    }

    /**
     * <p>
     * Creates a model in SageMaker. In the request, you name the model and describe a primary container. For the
     * primary container, you specify the Docker image that contains inference code, artifacts (from prior training),
     * and a custom environment map that the inference code uses when you deploy the model for predictions.
     * </p>
     * <p>
     * Use this API to create a model if you want to use SageMaker hosting services or run a batch transform job.
     * </p>
     * <p>
     * To host your model, you create an endpoint configuration with the <code>CreateEndpointConfig</code> API, and then
     * create an endpoint with the <code>CreateEndpoint</code> API. SageMaker then deploys all of the containers that
     * you defined for the model in the hosting environment.
     * </p>
     * <p>
     * To run a batch transform using your model, you start a job with the <code>CreateTransformJob</code> API.
     * SageMaker uses your model and your dataset to get inferences which are then saved to a specified S3 location.
     * </p>
     * <p>
     * In the request, you also provide an IAM role that SageMaker can assume to access model artifacts and docker image
     * for deployment on ML compute hosting instances or for batch transform jobs. In addition, you also use the IAM
     * role to manage permissions the inference code needs. For example, if the inference code access any other Amazon
     * Web Services resources, you grant necessary permissions via this role.
     * </p>
     *
     * @param createModelRequest
     * @return Result of the CreateModel operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModel" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateModelResponse createModel(CreateModelRequest createModelRequest) throws ResourceLimitExceededException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a model in SageMaker. In the request, you name the model and describe a primary container. For the
     * primary container, you specify the Docker image that contains inference code, artifacts (from prior training),
     * and a custom environment map that the inference code uses when you deploy the model for predictions.
     * </p>
     * <p>
     * Use this API to create a model if you want to use SageMaker hosting services or run a batch transform job.
     * </p>
     * <p>
     * To host your model, you create an endpoint configuration with the <code>CreateEndpointConfig</code> API, and then
     * create an endpoint with the <code>CreateEndpoint</code> API. SageMaker then deploys all of the containers that
     * you defined for the model in the hosting environment.
     * </p>
     * <p>
     * To run a batch transform using your model, you start a job with the <code>CreateTransformJob</code> API.
     * SageMaker uses your model and your dataset to get inferences which are then saved to a specified S3 location.
     * </p>
     * <p>
     * In the request, you also provide an IAM role that SageMaker can assume to access model artifacts and docker image
     * for deployment on ML compute hosting instances or for batch transform jobs. In addition, you also use the IAM
     * role to manage permissions the inference code needs. For example, if the inference code access any other Amazon
     * Web Services resources, you grant necessary permissions via this role.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateModelRequest.Builder} avoiding the need to
     * create one manually via {@link CreateModelRequest#builder()}
     * </p>
     *
     * @param createModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateModelRequest.Builder} to create a request.
     * @return Result of the CreateModel operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModel" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateModelResponse createModel(Consumer<CreateModelRequest.Builder> createModelRequest)
            throws ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        return createModel(CreateModelRequest.builder().applyMutation(createModelRequest).build());
    }

    /**
     * <p>
     * Creates the definition for a model bias job.
     * </p>
     *
     * @param createModelBiasJobDefinitionRequest
     * @return Result of the CreateModelBiasJobDefinition operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateModelBiasJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelBiasJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateModelBiasJobDefinitionResponse createModelBiasJobDefinition(
            CreateModelBiasJobDefinitionRequest createModelBiasJobDefinitionRequest) throws ResourceInUseException,
            ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates the definition for a model bias job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateModelBiasJobDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateModelBiasJobDefinitionRequest#builder()}
     * </p>
     *
     * @param createModelBiasJobDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateModelBiasJobDefinitionRequest.Builder} to
     *        create a request.
     * @return Result of the CreateModelBiasJobDefinition operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateModelBiasJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelBiasJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateModelBiasJobDefinitionResponse createModelBiasJobDefinition(
            Consumer<CreateModelBiasJobDefinitionRequest.Builder> createModelBiasJobDefinitionRequest)
            throws ResourceInUseException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            SageMakerException {
        return createModelBiasJobDefinition(CreateModelBiasJobDefinitionRequest.builder()
                .applyMutation(createModelBiasJobDefinitionRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon SageMaker Model Card.
     * </p>
     * <p>
     * For information about how to use model cards, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-cards.html">Amazon SageMaker Model Card</a>.
     * </p>
     *
     * @param createModelCardRequest
     * @return Result of the CreateModelCard operation returned by the service.
     * @throws ConflictException
     *         There was a conflict when you attempted to modify a SageMaker entity such as an <code>Experiment</code>
     *         or <code>Artifact</code>.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateModelCard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelCard" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateModelCardResponse createModelCard(CreateModelCardRequest createModelCardRequest) throws ConflictException,
            ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon SageMaker Model Card.
     * </p>
     * <p>
     * For information about how to use model cards, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-cards.html">Amazon SageMaker Model Card</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateModelCardRequest.Builder} avoiding the need
     * to create one manually via {@link CreateModelCardRequest#builder()}
     * </p>
     *
     * @param createModelCardRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateModelCardRequest.Builder} to create a
     *        request.
     * @return Result of the CreateModelCard operation returned by the service.
     * @throws ConflictException
     *         There was a conflict when you attempted to modify a SageMaker entity such as an <code>Experiment</code>
     *         or <code>Artifact</code>.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateModelCard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelCard" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateModelCardResponse createModelCard(Consumer<CreateModelCardRequest.Builder> createModelCardRequest)
            throws ConflictException, ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        return createModelCard(CreateModelCardRequest.builder().applyMutation(createModelCardRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon SageMaker Model Card export job.
     * </p>
     *
     * @param createModelCardExportJobRequest
     * @return Result of the CreateModelCardExportJob operation returned by the service.
     * @throws ConflictException
     *         There was a conflict when you attempted to modify a SageMaker entity such as an <code>Experiment</code>
     *         or <code>Artifact</code>.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateModelCardExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelCardExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateModelCardExportJobResponse createModelCardExportJob(
            CreateModelCardExportJobRequest createModelCardExportJobRequest) throws ConflictException, ResourceNotFoundException,
            ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon SageMaker Model Card export job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateModelCardExportJobRequest.Builder} avoiding
     * the need to create one manually via {@link CreateModelCardExportJobRequest#builder()}
     * </p>
     *
     * @param createModelCardExportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateModelCardExportJobRequest.Builder} to create
     *        a request.
     * @return Result of the CreateModelCardExportJob operation returned by the service.
     * @throws ConflictException
     *         There was a conflict when you attempted to modify a SageMaker entity such as an <code>Experiment</code>
     *         or <code>Artifact</code>.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateModelCardExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelCardExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateModelCardExportJobResponse createModelCardExportJob(
            Consumer<CreateModelCardExportJobRequest.Builder> createModelCardExportJobRequest) throws ConflictException,
            ResourceNotFoundException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            SageMakerException {
        return createModelCardExportJob(CreateModelCardExportJobRequest.builder().applyMutation(createModelCardExportJobRequest)
                .build());
    }

    /**
     * <p>
     * Creates the definition for a model explainability job.
     * </p>
     *
     * @param createModelExplainabilityJobDefinitionRequest
     * @return Result of the CreateModelExplainabilityJobDefinition operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateModelExplainabilityJobDefinition
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelExplainabilityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateModelExplainabilityJobDefinitionResponse createModelExplainabilityJobDefinition(
            CreateModelExplainabilityJobDefinitionRequest createModelExplainabilityJobDefinitionRequest)
            throws ResourceInUseException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates the definition for a model explainability job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateModelExplainabilityJobDefinitionRequest.Builder} avoiding the need to create one manually via
     * {@link CreateModelExplainabilityJobDefinitionRequest#builder()}
     * </p>
     *
     * @param createModelExplainabilityJobDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateModelExplainabilityJobDefinitionRequest.Builder}
     *        to create a request.
     * @return Result of the CreateModelExplainabilityJobDefinition operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateModelExplainabilityJobDefinition
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelExplainabilityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateModelExplainabilityJobDefinitionResponse createModelExplainabilityJobDefinition(
            Consumer<CreateModelExplainabilityJobDefinitionRequest.Builder> createModelExplainabilityJobDefinitionRequest)
            throws ResourceInUseException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            SageMakerException {
        return createModelExplainabilityJobDefinition(CreateModelExplainabilityJobDefinitionRequest.builder()
                .applyMutation(createModelExplainabilityJobDefinitionRequest).build());
    }

    /**
     * <p>
     * Creates a model package that you can use to create SageMaker models or list on Amazon Web Services Marketplace,
     * or a versioned model that is part of a model group. Buyers can subscribe to model packages listed on Amazon Web
     * Services Marketplace to create models in SageMaker.
     * </p>
     * <p>
     * To create a model package by specifying a Docker container that contains your inference code and the Amazon S3
     * location of your model artifacts, provide values for <code>InferenceSpecification</code>. To create a model from
     * an algorithm resource that you created or subscribed to in Amazon Web Services Marketplace, provide a value for
     * <code>SourceAlgorithmSpecification</code>.
     * </p>
     * <note>
     * <p>
     * There are two types of model packages:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Versioned - a model that is part of a model group in the model registry.
     * </p>
     * </li>
     * <li>
     * <p>
     * Unversioned - a model package that is not part of a model group.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param createModelPackageRequest
     * @return Result of the CreateModelPackage operation returned by the service.
     * @throws ConflictException
     *         There was a conflict when you attempted to modify a SageMaker entity such as an <code>Experiment</code>
     *         or <code>Artifact</code>.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateModelPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelPackage" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateModelPackageResponse createModelPackage(CreateModelPackageRequest createModelPackageRequest)
            throws ConflictException, ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a model package that you can use to create SageMaker models or list on Amazon Web Services Marketplace,
     * or a versioned model that is part of a model group. Buyers can subscribe to model packages listed on Amazon Web
     * Services Marketplace to create models in SageMaker.
     * </p>
     * <p>
     * To create a model package by specifying a Docker container that contains your inference code and the Amazon S3
     * location of your model artifacts, provide values for <code>InferenceSpecification</code>. To create a model from
     * an algorithm resource that you created or subscribed to in Amazon Web Services Marketplace, provide a value for
     * <code>SourceAlgorithmSpecification</code>.
     * </p>
     * <note>
     * <p>
     * There are two types of model packages:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Versioned - a model that is part of a model group in the model registry.
     * </p>
     * </li>
     * <li>
     * <p>
     * Unversioned - a model package that is not part of a model group.
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateModelPackageRequest.Builder} avoiding the
     * need to create one manually via {@link CreateModelPackageRequest#builder()}
     * </p>
     *
     * @param createModelPackageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateModelPackageRequest.Builder} to create a
     *        request.
     * @return Result of the CreateModelPackage operation returned by the service.
     * @throws ConflictException
     *         There was a conflict when you attempted to modify a SageMaker entity such as an <code>Experiment</code>
     *         or <code>Artifact</code>.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateModelPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelPackage" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateModelPackageResponse createModelPackage(Consumer<CreateModelPackageRequest.Builder> createModelPackageRequest)
            throws ConflictException, ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        return createModelPackage(CreateModelPackageRequest.builder().applyMutation(createModelPackageRequest).build());
    }

    /**
     * <p>
     * Creates a model group. A model group contains a group of model versions.
     * </p>
     *
     * @param createModelPackageGroupRequest
     * @return Result of the CreateModelPackageGroup operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateModelPackageGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelPackageGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateModelPackageGroupResponse createModelPackageGroup(CreateModelPackageGroupRequest createModelPackageGroupRequest)
            throws ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a model group. A model group contains a group of model versions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateModelPackageGroupRequest.Builder} avoiding
     * the need to create one manually via {@link CreateModelPackageGroupRequest#builder()}
     * </p>
     *
     * @param createModelPackageGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateModelPackageGroupRequest.Builder} to create a
     *        request.
     * @return Result of the CreateModelPackageGroup operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateModelPackageGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelPackageGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateModelPackageGroupResponse createModelPackageGroup(
            Consumer<CreateModelPackageGroupRequest.Builder> createModelPackageGroupRequest)
            throws ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        return createModelPackageGroup(CreateModelPackageGroupRequest.builder().applyMutation(createModelPackageGroupRequest)
                .build());
    }

    /**
     * <p>
     * Creates a definition for a job that monitors model quality and drift. For information about model monitor, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html">Amazon SageMaker AI Model Monitor</a>.
     * </p>
     *
     * @param createModelQualityJobDefinitionRequest
     * @return Result of the CreateModelQualityJobDefinition operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateModelQualityJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelQualityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateModelQualityJobDefinitionResponse createModelQualityJobDefinition(
            CreateModelQualityJobDefinitionRequest createModelQualityJobDefinitionRequest) throws ResourceInUseException,
            ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a definition for a job that monitors model quality and drift. For information about model monitor, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html">Amazon SageMaker AI Model Monitor</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateModelQualityJobDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateModelQualityJobDefinitionRequest#builder()}
     * </p>
     *
     * @param createModelQualityJobDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateModelQualityJobDefinitionRequest.Builder} to
     *        create a request.
     * @return Result of the CreateModelQualityJobDefinition operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateModelQualityJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelQualityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateModelQualityJobDefinitionResponse createModelQualityJobDefinition(
            Consumer<CreateModelQualityJobDefinitionRequest.Builder> createModelQualityJobDefinitionRequest)
            throws ResourceInUseException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            SageMakerException {
        return createModelQualityJobDefinition(CreateModelQualityJobDefinitionRequest.builder()
                .applyMutation(createModelQualityJobDefinitionRequest).build());
    }

    /**
     * <p>
     * Creates a schedule that regularly starts Amazon SageMaker AI Processing Jobs to monitor the data captured for an
     * Amazon SageMaker AI Endpoint.
     * </p>
     *
     * @param createMonitoringScheduleRequest
     * @return Result of the CreateMonitoringSchedule operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateMonitoringSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateMonitoringSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateMonitoringScheduleResponse createMonitoringSchedule(
            CreateMonitoringScheduleRequest createMonitoringScheduleRequest) throws ResourceInUseException,
            ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a schedule that regularly starts Amazon SageMaker AI Processing Jobs to monitor the data captured for an
     * Amazon SageMaker AI Endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMonitoringScheduleRequest.Builder} avoiding
     * the need to create one manually via {@link CreateMonitoringScheduleRequest#builder()}
     * </p>
     *
     * @param createMonitoringScheduleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateMonitoringScheduleRequest.Builder} to create
     *        a request.
     * @return Result of the CreateMonitoringSchedule operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateMonitoringSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateMonitoringSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateMonitoringScheduleResponse createMonitoringSchedule(
            Consumer<CreateMonitoringScheduleRequest.Builder> createMonitoringScheduleRequest) throws ResourceInUseException,
            ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        return createMonitoringSchedule(CreateMonitoringScheduleRequest.builder().applyMutation(createMonitoringScheduleRequest)
                .build());
    }

    /**
     * <p>
     * Creates an SageMaker AI notebook instance. A notebook instance is a machine learning (ML) compute instance
     * running on a Jupyter notebook.
     * </p>
     * <p>
     * In a <code>CreateNotebookInstance</code> request, specify the type of ML compute instance that you want to run.
     * SageMaker AI launches the instance, installs common libraries that you can use to explore datasets for model
     * training, and attaches an ML storage volume to the notebook instance.
     * </p>
     * <p>
     * SageMaker AI also provides a set of example notebooks. Each notebook demonstrates how to use SageMaker AI with a
     * specific algorithm or with a machine learning framework.
     * </p>
     * <p>
     * After receiving the request, SageMaker AI does the following:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Creates a network interface in the SageMaker AI VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Option) If you specified <code>SubnetId</code>, SageMaker AI creates a network interface in your own VPC, which
     * is inferred from the subnet ID that you provide in the input. When creating this network interface, SageMaker AI
     * attaches the security group that you specified in the request to the network interface that it creates in your
     * VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * Launches an EC2 instance of the type specified in the request in the SageMaker AI VPC. If you specified
     * <code>SubnetId</code> of your VPC, SageMaker AI specifies both network interfaces when launching this instance.
     * This enables inbound traffic from your own VPC to the notebook instance, assuming that the security groups allow
     * it.
     * </p>
     * </li>
     * </ol>
     * <p>
     * After creating the notebook instance, SageMaker AI returns its Amazon Resource Name (ARN). You can't change the
     * name of a notebook instance after you create it.
     * </p>
     * <p>
     * After SageMaker AI creates the notebook instance, you can connect to the Jupyter server and work in Jupyter
     * notebooks. For example, you can write code to explore a dataset that you can use for model training, train a
     * model, host models by creating SageMaker AI endpoints, and validate hosted models.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works.html">How It
     * Works</a>.
     * </p>
     *
     * @param createNotebookInstanceRequest
     * @return Result of the CreateNotebookInstance operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateNotebookInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateNotebookInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateNotebookInstanceResponse createNotebookInstance(CreateNotebookInstanceRequest createNotebookInstanceRequest)
            throws ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an SageMaker AI notebook instance. A notebook instance is a machine learning (ML) compute instance
     * running on a Jupyter notebook.
     * </p>
     * <p>
     * In a <code>CreateNotebookInstance</code> request, specify the type of ML compute instance that you want to run.
     * SageMaker AI launches the instance, installs common libraries that you can use to explore datasets for model
     * training, and attaches an ML storage volume to the notebook instance.
     * </p>
     * <p>
     * SageMaker AI also provides a set of example notebooks. Each notebook demonstrates how to use SageMaker AI with a
     * specific algorithm or with a machine learning framework.
     * </p>
     * <p>
     * After receiving the request, SageMaker AI does the following:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Creates a network interface in the SageMaker AI VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Option) If you specified <code>SubnetId</code>, SageMaker AI creates a network interface in your own VPC, which
     * is inferred from the subnet ID that you provide in the input. When creating this network interface, SageMaker AI
     * attaches the security group that you specified in the request to the network interface that it creates in your
     * VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * Launches an EC2 instance of the type specified in the request in the SageMaker AI VPC. If you specified
     * <code>SubnetId</code> of your VPC, SageMaker AI specifies both network interfaces when launching this instance.
     * This enables inbound traffic from your own VPC to the notebook instance, assuming that the security groups allow
     * it.
     * </p>
     * </li>
     * </ol>
     * <p>
     * After creating the notebook instance, SageMaker AI returns its Amazon Resource Name (ARN). You can't change the
     * name of a notebook instance after you create it.
     * </p>
     * <p>
     * After SageMaker AI creates the notebook instance, you can connect to the Jupyter server and work in Jupyter
     * notebooks. For example, you can write code to explore a dataset that you can use for model training, train a
     * model, host models by creating SageMaker AI endpoints, and validate hosted models.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works.html">How It
     * Works</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNotebookInstanceRequest.Builder} avoiding the
     * need to create one manually via {@link CreateNotebookInstanceRequest#builder()}
     * </p>
     *
     * @param createNotebookInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceRequest.Builder} to create a
     *        request.
     * @return Result of the CreateNotebookInstance operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateNotebookInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateNotebookInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateNotebookInstanceResponse createNotebookInstance(
            Consumer<CreateNotebookInstanceRequest.Builder> createNotebookInstanceRequest) throws ResourceLimitExceededException,
            AwsServiceException, SdkClientException, SageMakerException {
        return createNotebookInstance(CreateNotebookInstanceRequest.builder().applyMutation(createNotebookInstanceRequest)
                .build());
    }

    /**
     * <p>
     * Creates a lifecycle configuration that you can associate with a notebook instance. A <i>lifecycle
     * configuration</i> is a collection of shell scripts that run when you create or start a notebook instance.
     * </p>
     * <p>
     * Each lifecycle configuration script has a limit of 16384 characters.
     * </p>
     * <p>
     * The value of the <code>&#36PATH</code> environment variable that is available to both scripts is
     * <code>/sbin:bin:/usr/sbin:/usr/bin</code>.
     * </p>
     * <p>
     * View Amazon CloudWatch Logs for notebook instance lifecycle configurations in log group
     * <code>/aws/sagemaker/NotebookInstances</code> in log stream
     * <code>[notebook-instance-name]/[LifecycleConfigHook]</code>.
     * </p>
     * <p>
     * Lifecycle configuration scripts cannot run for longer than 5 minutes. If a script runs for longer than 5 minutes,
     * it fails and the notebook instance is not created or started.
     * </p>
     * <p>
     * For information about notebook instance lifestyle configurations, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional)
     * Customize a Notebook Instance</a>.
     * </p>
     *
     * @param createNotebookInstanceLifecycleConfigRequest
     * @return Result of the CreateNotebookInstanceLifecycleConfig operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateNotebookInstanceLifecycleConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateNotebookInstanceLifecycleConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateNotebookInstanceLifecycleConfigResponse createNotebookInstanceLifecycleConfig(
            CreateNotebookInstanceLifecycleConfigRequest createNotebookInstanceLifecycleConfigRequest)
            throws ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a lifecycle configuration that you can associate with a notebook instance. A <i>lifecycle
     * configuration</i> is a collection of shell scripts that run when you create or start a notebook instance.
     * </p>
     * <p>
     * Each lifecycle configuration script has a limit of 16384 characters.
     * </p>
     * <p>
     * The value of the <code>&#36PATH</code> environment variable that is available to both scripts is
     * <code>/sbin:bin:/usr/sbin:/usr/bin</code>.
     * </p>
     * <p>
     * View Amazon CloudWatch Logs for notebook instance lifecycle configurations in log group
     * <code>/aws/sagemaker/NotebookInstances</code> in log stream
     * <code>[notebook-instance-name]/[LifecycleConfigHook]</code>.
     * </p>
     * <p>
     * Lifecycle configuration scripts cannot run for longer than 5 minutes. If a script runs for longer than 5 minutes,
     * it fails and the notebook instance is not created or started.
     * </p>
     * <p>
     * For information about notebook instance lifestyle configurations, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional)
     * Customize a Notebook Instance</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateNotebookInstanceLifecycleConfigRequest.Builder} avoiding the need to create one manually via
     * {@link CreateNotebookInstanceLifecycleConfigRequest#builder()}
     * </p>
     *
     * @param createNotebookInstanceLifecycleConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceLifecycleConfigRequest.Builder}
     *        to create a request.
     * @return Result of the CreateNotebookInstanceLifecycleConfig operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateNotebookInstanceLifecycleConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateNotebookInstanceLifecycleConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateNotebookInstanceLifecycleConfigResponse createNotebookInstanceLifecycleConfig(
            Consumer<CreateNotebookInstanceLifecycleConfigRequest.Builder> createNotebookInstanceLifecycleConfigRequest)
            throws ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        return createNotebookInstanceLifecycleConfig(CreateNotebookInstanceLifecycleConfigRequest.builder()
                .applyMutation(createNotebookInstanceLifecycleConfigRequest).build());
    }

    /**
     * <p>
     * Creates a job that optimizes a model for inference performance. To create the job, you provide the location of a
     * source model, and you provide the settings for the optimization techniques that you want the job to apply. When
     * the job completes successfully, SageMaker uploads the new optimized model to the output destination that you
     * specify.
     * </p>
     * <p>
     * For more information about how to use this action, and about the supported optimization techniques, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-optimize.html">Optimize model inference with Amazon
     * SageMaker</a>.
     * </p>
     *
     * @param createOptimizationJobRequest
     * @return Result of the CreateOptimizationJob operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateOptimizationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateOptimizationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateOptimizationJobResponse createOptimizationJob(CreateOptimizationJobRequest createOptimizationJobRequest)
            throws ResourceInUseException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a job that optimizes a model for inference performance. To create the job, you provide the location of a
     * source model, and you provide the settings for the optimization techniques that you want the job to apply. When
     * the job completes successfully, SageMaker uploads the new optimized model to the output destination that you
     * specify.
     * </p>
     * <p>
     * For more information about how to use this action, and about the supported optimization techniques, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-optimize.html">Optimize model inference with Amazon
     * SageMaker</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateOptimizationJobRequest.Builder} avoiding the
     * need to create one manually via {@link CreateOptimizationJobRequest#builder()}
     * </p>
     *
     * @param createOptimizationJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateOptimizationJobRequest.Builder} to create a
     *        request.
     * @return Result of the CreateOptimizationJob operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateOptimizationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateOptimizationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateOptimizationJobResponse createOptimizationJob(
            Consumer<CreateOptimizationJobRequest.Builder> createOptimizationJobRequest) throws ResourceInUseException,
            ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        return createOptimizationJob(CreateOptimizationJobRequest.builder().applyMutation(createOptimizationJobRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon SageMaker Partner AI App.
     * </p>
     *
     * @param createPartnerAppRequest
     * @return Result of the CreatePartnerApp operation returned by the service.
     * @throws ConflictException
     *         There was a conflict when you attempted to modify a SageMaker entity such as an <code>Experiment</code>
     *         or <code>Artifact</code>.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreatePartnerApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreatePartnerApp" target="_top">AWS
     *      API Documentation</a>
     */
    default CreatePartnerAppResponse createPartnerApp(CreatePartnerAppRequest createPartnerAppRequest) throws ConflictException,
            ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon SageMaker Partner AI App.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePartnerAppRequest.Builder} avoiding the need
     * to create one manually via {@link CreatePartnerAppRequest#builder()}
     * </p>
     *
     * @param createPartnerAppRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreatePartnerAppRequest.Builder} to create a
     *        request.
     * @return Result of the CreatePartnerApp operation returned by the service.
     * @throws ConflictException
     *         There was a conflict when you attempted to modify a SageMaker entity such as an <code>Experiment</code>
     *         or <code>Artifact</code>.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreatePartnerApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreatePartnerApp" target="_top">AWS
     *      API Documentation</a>
     */
    default CreatePartnerAppResponse createPartnerApp(Consumer<CreatePartnerAppRequest.Builder> createPartnerAppRequest)
            throws ConflictException, ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        return createPartnerApp(CreatePartnerAppRequest.builder().applyMutation(createPartnerAppRequest).build());
    }

    /**
     * <p>
     * Creates a presigned URL to access an Amazon SageMaker Partner AI App.
     * </p>
     *
     * @param createPartnerAppPresignedUrlRequest
     * @return Result of the CreatePartnerAppPresignedUrl operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreatePartnerAppPresignedUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreatePartnerAppPresignedUrl"
     *      target="_top">AWS API Documentation</a>
     */
    default CreatePartnerAppPresignedUrlResponse createPartnerAppPresignedUrl(
            CreatePartnerAppPresignedUrlRequest createPartnerAppPresignedUrlRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a presigned URL to access an Amazon SageMaker Partner AI App.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePartnerAppPresignedUrlRequest.Builder}
     * avoiding the need to create one manually via {@link CreatePartnerAppPresignedUrlRequest#builder()}
     * </p>
     *
     * @param createPartnerAppPresignedUrlRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreatePartnerAppPresignedUrlRequest.Builder} to
     *        create a request.
     * @return Result of the CreatePartnerAppPresignedUrl operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreatePartnerAppPresignedUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreatePartnerAppPresignedUrl"
     *      target="_top">AWS API Documentation</a>
     */
    default CreatePartnerAppPresignedUrlResponse createPartnerAppPresignedUrl(
            Consumer<CreatePartnerAppPresignedUrlRequest.Builder> createPartnerAppPresignedUrlRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return createPartnerAppPresignedUrl(CreatePartnerAppPresignedUrlRequest.builder()
                .applyMutation(createPartnerAppPresignedUrlRequest).build());
    }

    /**
     * <p>
     * Creates a pipeline using a JSON pipeline definition.
     * </p>
     *
     * @param createPipelineRequest
     * @return Result of the CreatePipeline operation returned by the service.
     * @throws ConflictException
     *         There was a conflict when you attempted to modify a SageMaker entity such as an <code>Experiment</code>
     *         or <code>Artifact</code>.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreatePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreatePipeline" target="_top">AWS API
     *      Documentation</a>
     */
    default CreatePipelineResponse createPipeline(CreatePipelineRequest createPipelineRequest) throws ConflictException,
            ResourceNotFoundException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a pipeline using a JSON pipeline definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePipelineRequest.Builder} avoiding the need to
     * create one manually via {@link CreatePipelineRequest#builder()}
     * </p>
     *
     * @param createPipelineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreatePipelineRequest.Builder} to create a request.
     * @return Result of the CreatePipeline operation returned by the service.
     * @throws ConflictException
     *         There was a conflict when you attempted to modify a SageMaker entity such as an <code>Experiment</code>
     *         or <code>Artifact</code>.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreatePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreatePipeline" target="_top">AWS API
     *      Documentation</a>
     */
    default CreatePipelineResponse createPipeline(Consumer<CreatePipelineRequest.Builder> createPipelineRequest)
            throws ConflictException, ResourceNotFoundException, ResourceLimitExceededException, AwsServiceException,
            SdkClientException, SageMakerException {
        return createPipeline(CreatePipelineRequest.builder().applyMutation(createPipelineRequest).build());
    }

    /**
     * <p>
     * Creates a URL for a specified UserProfile in a Domain. When accessed in a web browser, the user will be
     * automatically signed in to the domain, and granted access to all of the Apps and files associated with the
     * Domain's Amazon Elastic File System volume. This operation can only be called when the authentication mode equals
     * IAM.
     * </p>
     * <p>
     * The IAM role or user passed to this API defines the permissions to access the app. Once the presigned URL is
     * created, no additional permission is required to access this URL. IAM authorization policies for this API are
     * also enforced for every HTTP request and WebSocket frame that attempts to connect to the app.
     * </p>
     * <p>
     * You can restrict access to this API and to the URL that it returns to a list of IP addresses, Amazon VPCs or
     * Amazon VPC Endpoints that you specify. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio-interface-endpoint.html">Connect to Amazon SageMaker
     * AI Studio Through an Interface VPC Endpoint</a> .
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * The URL that you get from a call to <code>CreatePresignedDomainUrl</code> has a default timeout of 5 minutes. You
     * can configure this value using <code>ExpiresInSeconds</code>. If you try to use the URL after the timeout limit
     * expires, you are directed to the Amazon Web Services console sign-in page.
     * </p>
     * </li>
     * <li>
     * <p>
     * The JupyterLab session default expiration time is 12 hours. You can configure this value using
     * SessionExpirationDurationInSeconds.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param createPresignedDomainUrlRequest
     * @return Result of the CreatePresignedDomainUrl operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreatePresignedDomainUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreatePresignedDomainUrl"
     *      target="_top">AWS API Documentation</a>
     */
    default CreatePresignedDomainUrlResponse createPresignedDomainUrl(
            CreatePresignedDomainUrlRequest createPresignedDomainUrlRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a URL for a specified UserProfile in a Domain. When accessed in a web browser, the user will be
     * automatically signed in to the domain, and granted access to all of the Apps and files associated with the
     * Domain's Amazon Elastic File System volume. This operation can only be called when the authentication mode equals
     * IAM.
     * </p>
     * <p>
     * The IAM role or user passed to this API defines the permissions to access the app. Once the presigned URL is
     * created, no additional permission is required to access this URL. IAM authorization policies for this API are
     * also enforced for every HTTP request and WebSocket frame that attempts to connect to the app.
     * </p>
     * <p>
     * You can restrict access to this API and to the URL that it returns to a list of IP addresses, Amazon VPCs or
     * Amazon VPC Endpoints that you specify. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio-interface-endpoint.html">Connect to Amazon SageMaker
     * AI Studio Through an Interface VPC Endpoint</a> .
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * The URL that you get from a call to <code>CreatePresignedDomainUrl</code> has a default timeout of 5 minutes. You
     * can configure this value using <code>ExpiresInSeconds</code>. If you try to use the URL after the timeout limit
     * expires, you are directed to the Amazon Web Services console sign-in page.
     * </p>
     * </li>
     * <li>
     * <p>
     * The JupyterLab session default expiration time is 12 hours. You can configure this value using
     * SessionExpirationDurationInSeconds.
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePresignedDomainUrlRequest.Builder} avoiding
     * the need to create one manually via {@link CreatePresignedDomainUrlRequest#builder()}
     * </p>
     *
     * @param createPresignedDomainUrlRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreatePresignedDomainUrlRequest.Builder} to create
     *        a request.
     * @return Result of the CreatePresignedDomainUrl operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreatePresignedDomainUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreatePresignedDomainUrl"
     *      target="_top">AWS API Documentation</a>
     */
    default CreatePresignedDomainUrlResponse createPresignedDomainUrl(
            Consumer<CreatePresignedDomainUrlRequest.Builder> createPresignedDomainUrlRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        return createPresignedDomainUrl(CreatePresignedDomainUrlRequest.builder().applyMutation(createPresignedDomainUrlRequest)
                .build());
    }

    /**
     * <p>
     * Returns a presigned URL that you can use to connect to the MLflow UI attached to your tracking server. For more
     * information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow-launch-ui.html">Launch the
     * MLflow UI using a presigned URL</a>.
     * </p>
     *
     * @param createPresignedMlflowTrackingServerUrlRequest
     * @return Result of the CreatePresignedMlflowTrackingServerUrl operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreatePresignedMlflowTrackingServerUrl
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreatePresignedMlflowTrackingServerUrl"
     *      target="_top">AWS API Documentation</a>
     */
    default CreatePresignedMlflowTrackingServerUrlResponse createPresignedMlflowTrackingServerUrl(
            CreatePresignedMlflowTrackingServerUrlRequest createPresignedMlflowTrackingServerUrlRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a presigned URL that you can use to connect to the MLflow UI attached to your tracking server. For more
     * information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow-launch-ui.html">Launch the
     * MLflow UI using a presigned URL</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreatePresignedMlflowTrackingServerUrlRequest.Builder} avoiding the need to create one manually via
     * {@link CreatePresignedMlflowTrackingServerUrlRequest#builder()}
     * </p>
     *
     * @param createPresignedMlflowTrackingServerUrlRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreatePresignedMlflowTrackingServerUrlRequest.Builder}
     *        to create a request.
     * @return Result of the CreatePresignedMlflowTrackingServerUrl operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreatePresignedMlflowTrackingServerUrl
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreatePresignedMlflowTrackingServerUrl"
     *      target="_top">AWS API Documentation</a>
     */
    default CreatePresignedMlflowTrackingServerUrlResponse createPresignedMlflowTrackingServerUrl(
            Consumer<CreatePresignedMlflowTrackingServerUrlRequest.Builder> createPresignedMlflowTrackingServerUrlRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return createPresignedMlflowTrackingServerUrl(CreatePresignedMlflowTrackingServerUrlRequest.builder()
                .applyMutation(createPresignedMlflowTrackingServerUrlRequest).build());
    }

    /**
     * <p>
     * Returns a URL that you can use to connect to the Jupyter server from a notebook instance. In the SageMaker AI
     * console, when you choose <code>Open</code> next to a notebook instance, SageMaker AI opens a new tab showing the
     * Jupyter server home page from the notebook instance. The console uses this API to get the URL and show the page.
     * </p>
     * <p>
     * The IAM role or user used to call this API defines the permissions to access the notebook instance. Once the
     * presigned URL is created, no additional permission is required to access this URL. IAM authorization policies for
     * this API are also enforced for every HTTP request and WebSocket frame that attempts to connect to the notebook
     * instance.
     * </p>
     * <p>
     * You can restrict access to this API and to the URL that it returns to a list of IP addresses that you specify.
     * Use the <code>NotIpAddress</code> condition operator and the <code>aws:SourceIP</code> condition context key to
     * specify the list of IP addresses that you want to have access to the notebook instance. For more information, see
     * <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/security_iam_id-based-policy-examples.html#nbi-ip-filter"
     * >Limit Access to a Notebook Instance by IP Address</a>.
     * </p>
     * <note>
     * <p>
     * The URL that you get from a call to <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreatePresignedNotebookInstanceUrl.html"
     * >CreatePresignedNotebookInstanceUrl</a> is valid only for 5 minutes. If you try to use the URL after the 5-minute
     * limit expires, you are directed to the Amazon Web Services console sign-in page.
     * </p>
     * </note>
     *
     * @param createPresignedNotebookInstanceUrlRequest
     * @return Result of the CreatePresignedNotebookInstanceUrl operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreatePresignedNotebookInstanceUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreatePresignedNotebookInstanceUrl"
     *      target="_top">AWS API Documentation</a>
     */
    default CreatePresignedNotebookInstanceUrlResponse createPresignedNotebookInstanceUrl(
            CreatePresignedNotebookInstanceUrlRequest createPresignedNotebookInstanceUrlRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a URL that you can use to connect to the Jupyter server from a notebook instance. In the SageMaker AI
     * console, when you choose <code>Open</code> next to a notebook instance, SageMaker AI opens a new tab showing the
     * Jupyter server home page from the notebook instance. The console uses this API to get the URL and show the page.
     * </p>
     * <p>
     * The IAM role or user used to call this API defines the permissions to access the notebook instance. Once the
     * presigned URL is created, no additional permission is required to access this URL. IAM authorization policies for
     * this API are also enforced for every HTTP request and WebSocket frame that attempts to connect to the notebook
     * instance.
     * </p>
     * <p>
     * You can restrict access to this API and to the URL that it returns to a list of IP addresses that you specify.
     * Use the <code>NotIpAddress</code> condition operator and the <code>aws:SourceIP</code> condition context key to
     * specify the list of IP addresses that you want to have access to the notebook instance. For more information, see
     * <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/security_iam_id-based-policy-examples.html#nbi-ip-filter"
     * >Limit Access to a Notebook Instance by IP Address</a>.
     * </p>
     * <note>
     * <p>
     * The URL that you get from a call to <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreatePresignedNotebookInstanceUrl.html"
     * >CreatePresignedNotebookInstanceUrl</a> is valid only for 5 minutes. If you try to use the URL after the 5-minute
     * limit expires, you are directed to the Amazon Web Services console sign-in page.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePresignedNotebookInstanceUrlRequest.Builder}
     * avoiding the need to create one manually via {@link CreatePresignedNotebookInstanceUrlRequest#builder()}
     * </p>
     *
     * @param createPresignedNotebookInstanceUrlRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreatePresignedNotebookInstanceUrlRequest.Builder}
     *        to create a request.
     * @return Result of the CreatePresignedNotebookInstanceUrl operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreatePresignedNotebookInstanceUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreatePresignedNotebookInstanceUrl"
     *      target="_top">AWS API Documentation</a>
     */
    default CreatePresignedNotebookInstanceUrlResponse createPresignedNotebookInstanceUrl(
            Consumer<CreatePresignedNotebookInstanceUrlRequest.Builder> createPresignedNotebookInstanceUrlRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return createPresignedNotebookInstanceUrl(CreatePresignedNotebookInstanceUrlRequest.builder()
                .applyMutation(createPresignedNotebookInstanceUrlRequest).build());
    }

    /**
     * <p>
     * Creates a processing job.
     * </p>
     *
     * @param createProcessingJobRequest
     * @return Result of the CreateProcessingJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateProcessingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateProcessingJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateProcessingJobResponse createProcessingJob(CreateProcessingJobRequest createProcessingJobRequest)
            throws ResourceNotFoundException, ResourceInUseException, ResourceLimitExceededException, AwsServiceException,
            SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a processing job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProcessingJobRequest.Builder} avoiding the
     * need to create one manually via {@link CreateProcessingJobRequest#builder()}
     * </p>
     *
     * @param createProcessingJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateProcessingJobRequest.Builder} to create a
     *        request.
     * @return Result of the CreateProcessingJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateProcessingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateProcessingJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateProcessingJobResponse createProcessingJob(
            Consumer<CreateProcessingJobRequest.Builder> createProcessingJobRequest) throws ResourceNotFoundException,
            ResourceInUseException, ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        return createProcessingJob(CreateProcessingJobRequest.builder().applyMutation(createProcessingJobRequest).build());
    }

    /**
     * <p>
     * Creates a machine learning (ML) project that can contain one or more templates that set up an ML pipeline from
     * training to deploying an approved model.
     * </p>
     *
     * @param createProjectRequest
     * @return Result of the CreateProject operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateProjectResponse createProject(CreateProjectRequest createProjectRequest) throws ResourceLimitExceededException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a machine learning (ML) project that can contain one or more templates that set up an ML pipeline from
     * training to deploying an approved model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProjectRequest.Builder} avoiding the need to
     * create one manually via {@link CreateProjectRequest#builder()}
     * </p>
     *
     * @param createProjectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateProjectRequest.Builder} to create a request.
     * @return Result of the CreateProject operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateProjectResponse createProject(Consumer<CreateProjectRequest.Builder> createProjectRequest)
            throws ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        return createProject(CreateProjectRequest.builder().applyMutation(createProjectRequest).build());
    }

    /**
     * <p>
     * Creates a private space or a space used for real time collaboration in a domain.
     * </p>
     *
     * @param createSpaceRequest
     * @return Result of the CreateSpace operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateSpace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateSpace" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateSpaceResponse createSpace(CreateSpaceRequest createSpaceRequest) throws ResourceInUseException,
            ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a private space or a space used for real time collaboration in a domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSpaceRequest.Builder} avoiding the need to
     * create one manually via {@link CreateSpaceRequest#builder()}
     * </p>
     *
     * @param createSpaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateSpaceRequest.Builder} to create a request.
     * @return Result of the CreateSpace operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateSpace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateSpace" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateSpaceResponse createSpace(Consumer<CreateSpaceRequest.Builder> createSpaceRequest)
            throws ResourceInUseException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            SageMakerException {
        return createSpace(CreateSpaceRequest.builder().applyMutation(createSpaceRequest).build());
    }

    /**
     * <p>
     * Creates a new Amazon SageMaker AI Studio Lifecycle Configuration.
     * </p>
     *
     * @param createStudioLifecycleConfigRequest
     * @return Result of the CreateStudioLifecycleConfig operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateStudioLifecycleConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateStudioLifecycleConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateStudioLifecycleConfigResponse createStudioLifecycleConfig(
            CreateStudioLifecycleConfigRequest createStudioLifecycleConfigRequest) throws ResourceInUseException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Amazon SageMaker AI Studio Lifecycle Configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStudioLifecycleConfigRequest.Builder}
     * avoiding the need to create one manually via {@link CreateStudioLifecycleConfigRequest#builder()}
     * </p>
     *
     * @param createStudioLifecycleConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateStudioLifecycleConfigRequest.Builder} to
     *        create a request.
     * @return Result of the CreateStudioLifecycleConfig operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateStudioLifecycleConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateStudioLifecycleConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateStudioLifecycleConfigResponse createStudioLifecycleConfig(
            Consumer<CreateStudioLifecycleConfigRequest.Builder> createStudioLifecycleConfigRequest)
            throws ResourceInUseException, AwsServiceException, SdkClientException, SageMakerException {
        return createStudioLifecycleConfig(CreateStudioLifecycleConfigRequest.builder()
                .applyMutation(createStudioLifecycleConfigRequest).build());
    }

    /**
     * <p>
     * Starts a model training job. After training completes, SageMaker saves the resulting model artifacts to an Amazon
     * S3 location that you specify.
     * </p>
     * <p>
     * If you choose to host your model using SageMaker hosting services, you can use the resulting model artifacts as
     * part of the model. You can also use the artifacts in a machine learning service other than SageMaker, provided
     * that you know how to use them for inference.
     * </p>
     * <p>
     * In the request body, you provide the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AlgorithmSpecification</code> - Identifies the training algorithm to use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HyperParameters</code> - Specify these algorithm-specific parameters to enable the estimation of model
     * parameters during training. Hyperparameters can be tuned to optimize this learning process. For a list of
     * hyperparameters for each training algorithm provided by SageMaker, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html">Algorithms</a>.
     * </p>
     * <important>
     * <p>
     * Do not include any security-sensitive information including account access IDs, secrets, or tokens in any
     * hyperparameter fields. As part of the shared responsibility model, you are responsible for any potential
     * exposure, unauthorized access, or compromise of your sensitive data if caused by security-sensitive information
     * included in the request hyperparameter variable or plain text fields.
     * </p>
     * </important></li>
     * <li>
     * <p>
     * <code>InputDataConfig</code> - Describes the input required by the training job and the Amazon S3, EFS, or FSx
     * location where it is stored.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OutputDataConfig</code> - Identifies the Amazon S3 bucket where you want SageMaker to save the results of
     * model training.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ResourceConfig</code> - Identifies the resources, ML compute instances, and ML storage volumes to deploy
     * for model training. In distributed training, you specify more than one instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EnableManagedSpotTraining</code> - Optimize the cost of training machine learning models by up to 80% by
     * using Amazon EC2 Spot instances. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-managed-spot-training.html">Managed Spot
     * Training</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RoleArn</code> - The Amazon Resource Name (ARN) that SageMaker assumes to perform tasks on your behalf
     * during model training. You must grant this role the necessary permissions so that SageMaker can successfully
     * complete model training.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>StoppingCondition</code> - To help cap training costs, use <code>MaxRuntimeInSeconds</code> to set a time
     * limit for training. Use <code>MaxWaitTimeInSeconds</code> to specify how long a managed spot training job has to
     * complete.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Environment</code> - The environment variables to set in the Docker container.
     * </p>
     * <important>
     * <p>
     * Do not include any security-sensitive information including account access IDs, secrets, or tokens in any
     * environment fields. As part of the shared responsibility model, you are responsible for any potential exposure,
     * unauthorized access, or compromise of your sensitive data if caused by security-sensitive information included in
     * the request environment variable or plain text fields.
     * </p>
     * </important></li>
     * <li>
     * <p>
     * <code>RetryStrategy</code> - The number of times to retry the job when the job fails due to an
     * <code>InternalServerError</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about SageMaker, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works.html">How It Works</a>.
     * </p>
     *
     * @param createTrainingJobRequest
     * @return Result of the CreateTrainingJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateTrainingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTrainingJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateTrainingJobResponse createTrainingJob(CreateTrainingJobRequest createTrainingJobRequest)
            throws ResourceNotFoundException, ResourceInUseException, ResourceLimitExceededException, AwsServiceException,
            SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a model training job. After training completes, SageMaker saves the resulting model artifacts to an Amazon
     * S3 location that you specify.
     * </p>
     * <p>
     * If you choose to host your model using SageMaker hosting services, you can use the resulting model artifacts as
     * part of the model. You can also use the artifacts in a machine learning service other than SageMaker, provided
     * that you know how to use them for inference.
     * </p>
     * <p>
     * In the request body, you provide the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AlgorithmSpecification</code> - Identifies the training algorithm to use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HyperParameters</code> - Specify these algorithm-specific parameters to enable the estimation of model
     * parameters during training. Hyperparameters can be tuned to optimize this learning process. For a list of
     * hyperparameters for each training algorithm provided by SageMaker, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html">Algorithms</a>.
     * </p>
     * <important>
     * <p>
     * Do not include any security-sensitive information including account access IDs, secrets, or tokens in any
     * hyperparameter fields. As part of the shared responsibility model, you are responsible for any potential
     * exposure, unauthorized access, or compromise of your sensitive data if caused by security-sensitive information
     * included in the request hyperparameter variable or plain text fields.
     * </p>
     * </important></li>
     * <li>
     * <p>
     * <code>InputDataConfig</code> - Describes the input required by the training job and the Amazon S3, EFS, or FSx
     * location where it is stored.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OutputDataConfig</code> - Identifies the Amazon S3 bucket where you want SageMaker to save the results of
     * model training.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ResourceConfig</code> - Identifies the resources, ML compute instances, and ML storage volumes to deploy
     * for model training. In distributed training, you specify more than one instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EnableManagedSpotTraining</code> - Optimize the cost of training machine learning models by up to 80% by
     * using Amazon EC2 Spot instances. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-managed-spot-training.html">Managed Spot
     * Training</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RoleArn</code> - The Amazon Resource Name (ARN) that SageMaker assumes to perform tasks on your behalf
     * during model training. You must grant this role the necessary permissions so that SageMaker can successfully
     * complete model training.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>StoppingCondition</code> - To help cap training costs, use <code>MaxRuntimeInSeconds</code> to set a time
     * limit for training. Use <code>MaxWaitTimeInSeconds</code> to specify how long a managed spot training job has to
     * complete.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Environment</code> - The environment variables to set in the Docker container.
     * </p>
     * <important>
     * <p>
     * Do not include any security-sensitive information including account access IDs, secrets, or tokens in any
     * environment fields. As part of the shared responsibility model, you are responsible for any potential exposure,
     * unauthorized access, or compromise of your sensitive data if caused by security-sensitive information included in
     * the request environment variable or plain text fields.
     * </p>
     * </important></li>
     * <li>
     * <p>
     * <code>RetryStrategy</code> - The number of times to retry the job when the job fails due to an
     * <code>InternalServerError</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about SageMaker, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works.html">How It Works</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTrainingJobRequest.Builder} avoiding the need
     * to create one manually via {@link CreateTrainingJobRequest#builder()}
     * </p>
     *
     * @param createTrainingJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateTrainingJobRequest.Builder} to create a
     *        request.
     * @return Result of the CreateTrainingJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateTrainingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTrainingJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateTrainingJobResponse createTrainingJob(Consumer<CreateTrainingJobRequest.Builder> createTrainingJobRequest)
            throws ResourceNotFoundException, ResourceInUseException, ResourceLimitExceededException, AwsServiceException,
            SdkClientException, SageMakerException {
        return createTrainingJob(CreateTrainingJobRequest.builder().applyMutation(createTrainingJobRequest).build());
    }

    /**
     * <p>
     * Creates a new training plan in SageMaker to reserve compute capacity.
     * </p>
     * <p>
     * Amazon SageMaker Training Plan is a capability within SageMaker that allows customers to reserve and manage GPU
     * capacity for large-scale AI model training. It provides a way to secure predictable access to computational
     * resources within specific timelines and budgets, without the need to manage underlying infrastructure.
     * </p>
     * <p>
     * <b>How it works</b>
     * </p>
     * <p>
     * Plans can be created for specific resources such as SageMaker Training Jobs or SageMaker HyperPod clusters,
     * automatically provisioning resources, setting up infrastructure, executing workloads, and handling infrastructure
     * failures.
     * </p>
     * <p>
     * <b>Plan creation workflow</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Users search for available plan offerings based on their requirements (e.g., instance type, count, start time,
     * duration) using the
     * <code> <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_SearchTrainingPlanOfferings.html">SearchTrainingPlanOfferings</a> </code>
     * API operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * They create a plan that best matches their needs using the ID of the plan offering they want to use.
     * </p>
     * </li>
     * <li>
     * <p>
     * After successful upfront payment, the plan's status becomes <code>Scheduled</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The plan can be used to:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Queue training jobs.
     * </p>
     * </li>
     * <li>
     * <p>
     * Allocate to an instance group of a SageMaker HyperPod cluster.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * When the plan start date arrives, it becomes <code>Active</code>. Based on available reserved capacity:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Training jobs are launched.
     * </p>
     * </li>
     * <li>
     * <p>
     * Instance groups are provisioned.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * <b>Plan composition</b>
     * </p>
     * <p>
     * A plan can consist of one or more Reserved Capacities, each defined by a specific instance type, quantity,
     * Availability Zone, duration, and start and end times. For more information about Reserved Capacity, see
     * <code> <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ReservedCapacitySummary.html">ReservedCapacitySummary</a> </code>
     * .
     * </p>
     *
     * @param createTrainingPlanRequest
     * @return Result of the CreateTrainingPlan operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateTrainingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTrainingPlan" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateTrainingPlanResponse createTrainingPlan(CreateTrainingPlanRequest createTrainingPlanRequest)
            throws ResourceNotFoundException, ResourceInUseException, ResourceLimitExceededException, AwsServiceException,
            SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new training plan in SageMaker to reserve compute capacity.
     * </p>
     * <p>
     * Amazon SageMaker Training Plan is a capability within SageMaker that allows customers to reserve and manage GPU
     * capacity for large-scale AI model training. It provides a way to secure predictable access to computational
     * resources within specific timelines and budgets, without the need to manage underlying infrastructure.
     * </p>
     * <p>
     * <b>How it works</b>
     * </p>
     * <p>
     * Plans can be created for specific resources such as SageMaker Training Jobs or SageMaker HyperPod clusters,
     * automatically provisioning resources, setting up infrastructure, executing workloads, and handling infrastructure
     * failures.
     * </p>
     * <p>
     * <b>Plan creation workflow</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Users search for available plan offerings based on their requirements (e.g., instance type, count, start time,
     * duration) using the
     * <code> <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_SearchTrainingPlanOfferings.html">SearchTrainingPlanOfferings</a> </code>
     * API operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * They create a plan that best matches their needs using the ID of the plan offering they want to use.
     * </p>
     * </li>
     * <li>
     * <p>
     * After successful upfront payment, the plan's status becomes <code>Scheduled</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The plan can be used to:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Queue training jobs.
     * </p>
     * </li>
     * <li>
     * <p>
     * Allocate to an instance group of a SageMaker HyperPod cluster.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * When the plan start date arrives, it becomes <code>Active</code>. Based on available reserved capacity:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Training jobs are launched.
     * </p>
     * </li>
     * <li>
     * <p>
     * Instance groups are provisioned.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * <b>Plan composition</b>
     * </p>
     * <p>
     * A plan can consist of one or more Reserved Capacities, each defined by a specific instance type, quantity,
     * Availability Zone, duration, and start and end times. For more information about Reserved Capacity, see
     * <code> <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ReservedCapacitySummary.html">ReservedCapacitySummary</a> </code>
     * .
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTrainingPlanRequest.Builder} avoiding the
     * need to create one manually via {@link CreateTrainingPlanRequest#builder()}
     * </p>
     *
     * @param createTrainingPlanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateTrainingPlanRequest.Builder} to create a
     *        request.
     * @return Result of the CreateTrainingPlan operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateTrainingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTrainingPlan" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateTrainingPlanResponse createTrainingPlan(Consumer<CreateTrainingPlanRequest.Builder> createTrainingPlanRequest)
            throws ResourceNotFoundException, ResourceInUseException, ResourceLimitExceededException, AwsServiceException,
            SdkClientException, SageMakerException {
        return createTrainingPlan(CreateTrainingPlanRequest.builder().applyMutation(createTrainingPlanRequest).build());
    }

    /**
     * <p>
     * Starts a transform job. A transform job uses a trained model to get inferences on a dataset and saves these
     * results to an Amazon S3 location that you specify.
     * </p>
     * <p>
     * To perform batch transformations, you create a transform job and use the data that you have readily available.
     * </p>
     * <p>
     * In the request body, you provide the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TransformJobName</code> - Identifies the transform job. The name must be unique within an Amazon Web
     * Services Region in an Amazon Web Services account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ModelName</code> - Identifies the model to use. <code>ModelName</code> must be the name of an existing
     * Amazon SageMaker model in the same Amazon Web Services Region and Amazon Web Services account. For information on
     * creating a model, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateModel.html">CreateModel</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TransformInput</code> - Describes the dataset to be transformed and the Amazon S3 location where it is
     * stored.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TransformOutput</code> - Identifies the Amazon S3 location where you want Amazon SageMaker to save the
     * results from the transform job.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TransformResources</code> - Identifies the ML compute instances and AMI image versions for the transform
     * job.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about how batch transformation works, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform.html">Batch Transform</a>.
     * </p>
     *
     * @param createTransformJobRequest
     * @return Result of the CreateTransformJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateTransformJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTransformJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateTransformJobResponse createTransformJob(CreateTransformJobRequest createTransformJobRequest)
            throws ResourceNotFoundException, ResourceInUseException, ResourceLimitExceededException, AwsServiceException,
            SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a transform job. A transform job uses a trained model to get inferences on a dataset and saves these
     * results to an Amazon S3 location that you specify.
     * </p>
     * <p>
     * To perform batch transformations, you create a transform job and use the data that you have readily available.
     * </p>
     * <p>
     * In the request body, you provide the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TransformJobName</code> - Identifies the transform job. The name must be unique within an Amazon Web
     * Services Region in an Amazon Web Services account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ModelName</code> - Identifies the model to use. <code>ModelName</code> must be the name of an existing
     * Amazon SageMaker model in the same Amazon Web Services Region and Amazon Web Services account. For information on
     * creating a model, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateModel.html">CreateModel</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TransformInput</code> - Describes the dataset to be transformed and the Amazon S3 location where it is
     * stored.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TransformOutput</code> - Identifies the Amazon S3 location where you want Amazon SageMaker to save the
     * results from the transform job.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TransformResources</code> - Identifies the ML compute instances and AMI image versions for the transform
     * job.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about how batch transformation works, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform.html">Batch Transform</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTransformJobRequest.Builder} avoiding the
     * need to create one manually via {@link CreateTransformJobRequest#builder()}
     * </p>
     *
     * @param createTransformJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateTransformJobRequest.Builder} to create a
     *        request.
     * @return Result of the CreateTransformJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateTransformJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTransformJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateTransformJobResponse createTransformJob(Consumer<CreateTransformJobRequest.Builder> createTransformJobRequest)
            throws ResourceNotFoundException, ResourceInUseException, ResourceLimitExceededException, AwsServiceException,
            SdkClientException, SageMakerException {
        return createTransformJob(CreateTransformJobRequest.builder().applyMutation(createTransformJobRequest).build());
    }

    /**
     * <p>
     * Creates an SageMaker <i>trial</i>. A trial is a set of steps called <i>trial components</i> that produce a
     * machine learning model. A trial is part of a single SageMaker <i>experiment</i>.
     * </p>
     * <p>
     * When you use SageMaker Studio or the SageMaker Python SDK, all experiments, trials, and trial components are
     * automatically tracked, logged, and indexed. When you use the Amazon Web Services SDK for Python (Boto), you must
     * use the logging APIs provided by the SDK.
     * </p>
     * <p>
     * You can add tags to a trial and then use the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html">Search</a> API to search for the
     * tags.
     * </p>
     * <p>
     * To get a list of all your trials, call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListTrials.html">ListTrials</a> API. To view
     * a trial's properties, call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeTrial.html">DescribeTrial</a> API. To
     * create a trial component, call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTrialComponent.html"
     * >CreateTrialComponent</a> API.
     * </p>
     *
     * @param createTrialRequest
     * @return Result of the CreateTrial operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateTrial
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTrial" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateTrialResponse createTrial(CreateTrialRequest createTrialRequest) throws ResourceNotFoundException,
            ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an SageMaker <i>trial</i>. A trial is a set of steps called <i>trial components</i> that produce a
     * machine learning model. A trial is part of a single SageMaker <i>experiment</i>.
     * </p>
     * <p>
     * When you use SageMaker Studio or the SageMaker Python SDK, all experiments, trials, and trial components are
     * automatically tracked, logged, and indexed. When you use the Amazon Web Services SDK for Python (Boto), you must
     * use the logging APIs provided by the SDK.
     * </p>
     * <p>
     * You can add tags to a trial and then use the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html">Search</a> API to search for the
     * tags.
     * </p>
     * <p>
     * To get a list of all your trials, call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListTrials.html">ListTrials</a> API. To view
     * a trial's properties, call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeTrial.html">DescribeTrial</a> API. To
     * create a trial component, call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTrialComponent.html"
     * >CreateTrialComponent</a> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTrialRequest.Builder} avoiding the need to
     * create one manually via {@link CreateTrialRequest#builder()}
     * </p>
     *
     * @param createTrialRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateTrialRequest.Builder} to create a request.
     * @return Result of the CreateTrial operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateTrial
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTrial" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateTrialResponse createTrial(Consumer<CreateTrialRequest.Builder> createTrialRequest)
            throws ResourceNotFoundException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            SageMakerException {
        return createTrial(CreateTrialRequest.builder().applyMutation(createTrialRequest).build());
    }

    /**
     * <p>
     * Creates a <i>trial component</i>, which is a stage of a machine learning <i>trial</i>. A trial is composed of one
     * or more trial components. A trial component can be used in multiple trials.
     * </p>
     * <p>
     * Trial components include pre-processing jobs, training jobs, and batch transform jobs.
     * </p>
     * <p>
     * When you use SageMaker Studio or the SageMaker Python SDK, all experiments, trials, and trial components are
     * automatically tracked, logged, and indexed. When you use the Amazon Web Services SDK for Python (Boto), you must
     * use the logging APIs provided by the SDK.
     * </p>
     * <p>
     * You can add tags to a trial component and then use the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html">Search</a> API to search for the
     * tags.
     * </p>
     *
     * @param createTrialComponentRequest
     * @return Result of the CreateTrialComponent operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateTrialComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTrialComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTrialComponentResponse createTrialComponent(CreateTrialComponentRequest createTrialComponentRequest)
            throws ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a <i>trial component</i>, which is a stage of a machine learning <i>trial</i>. A trial is composed of one
     * or more trial components. A trial component can be used in multiple trials.
     * </p>
     * <p>
     * Trial components include pre-processing jobs, training jobs, and batch transform jobs.
     * </p>
     * <p>
     * When you use SageMaker Studio or the SageMaker Python SDK, all experiments, trials, and trial components are
     * automatically tracked, logged, and indexed. When you use the Amazon Web Services SDK for Python (Boto), you must
     * use the logging APIs provided by the SDK.
     * </p>
     * <p>
     * You can add tags to a trial component and then use the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html">Search</a> API to search for the
     * tags.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTrialComponentRequest.Builder} avoiding the
     * need to create one manually via {@link CreateTrialComponentRequest#builder()}
     * </p>
     *
     * @param createTrialComponentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateTrialComponentRequest.Builder} to create a
     *        request.
     * @return Result of the CreateTrialComponent operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateTrialComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTrialComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTrialComponentResponse createTrialComponent(
            Consumer<CreateTrialComponentRequest.Builder> createTrialComponentRequest) throws ResourceLimitExceededException,
            AwsServiceException, SdkClientException, SageMakerException {
        return createTrialComponent(CreateTrialComponentRequest.builder().applyMutation(createTrialComponentRequest).build());
    }

    /**
     * <p>
     * Creates a user profile. A user profile represents a single user within a domain, and is the main way to reference
     * a "person" for the purposes of sharing, reporting, and other user-oriented features. This entity is created when
     * a user onboards to a domain. If an administrator invites a person by email or imports them from IAM Identity
     * Center, a user profile is automatically created. A user profile is the primary holder of settings for an
     * individual user and has a reference to the user's private Amazon Elastic File System home directory.
     * </p>
     *
     * @param createUserProfileRequest
     * @return Result of the CreateUserProfile operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateUserProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateUserProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateUserProfileResponse createUserProfile(CreateUserProfileRequest createUserProfileRequest)
            throws ResourceInUseException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a user profile. A user profile represents a single user within a domain, and is the main way to reference
     * a "person" for the purposes of sharing, reporting, and other user-oriented features. This entity is created when
     * a user onboards to a domain. If an administrator invites a person by email or imports them from IAM Identity
     * Center, a user profile is automatically created. A user profile is the primary holder of settings for an
     * individual user and has a reference to the user's private Amazon Elastic File System home directory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUserProfileRequest.Builder} avoiding the need
     * to create one manually via {@link CreateUserProfileRequest#builder()}
     * </p>
     *
     * @param createUserProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateUserProfileRequest.Builder} to create a
     *        request.
     * @return Result of the CreateUserProfile operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateUserProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateUserProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateUserProfileResponse createUserProfile(Consumer<CreateUserProfileRequest.Builder> createUserProfileRequest)
            throws ResourceInUseException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            SageMakerException {
        return createUserProfile(CreateUserProfileRequest.builder().applyMutation(createUserProfileRequest).build());
    }

    /**
     * <p>
     * Use this operation to create a workforce. This operation will return an error if a workforce already exists in
     * the Amazon Web Services Region that you specify. You can only create one workforce in each Amazon Web Services
     * Region per Amazon Web Services account.
     * </p>
     * <p>
     * If you want to create a new workforce in an Amazon Web Services Region where a workforce already exists, use the
     * <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteWorkforce.html">DeleteWorkforce</a>
     * API operation to delete the existing workforce and then use <code>CreateWorkforce</code> to create a new
     * workforce.
     * </p>
     * <p>
     * To create a private workforce using Amazon Cognito, you must specify a Cognito user pool in
     * <code>CognitoConfig</code>. You can also create an Amazon Cognito workforce using the Amazon SageMaker console.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private.html"> Create a Private
     * Workforce (Amazon Cognito)</a>.
     * </p>
     * <p>
     * To create a private workforce using your own OIDC Identity Provider (IdP), specify your IdP configuration in
     * <code>OidcConfig</code>. Your OIDC IdP must support <i>groups</i> because groups are used by Ground Truth and
     * Amazon A2I to create work teams. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private-oidc.html"> Create a Private
     * Workforce (OIDC IdP)</a>.
     * </p>
     *
     * @param createWorkforceRequest
     * @return Result of the CreateWorkforce operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateWorkforce
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateWorkforce" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateWorkforceResponse createWorkforce(CreateWorkforceRequest createWorkforceRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this operation to create a workforce. This operation will return an error if a workforce already exists in
     * the Amazon Web Services Region that you specify. You can only create one workforce in each Amazon Web Services
     * Region per Amazon Web Services account.
     * </p>
     * <p>
     * If you want to create a new workforce in an Amazon Web Services Region where a workforce already exists, use the
     * <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteWorkforce.html">DeleteWorkforce</a>
     * API operation to delete the existing workforce and then use <code>CreateWorkforce</code> to create a new
     * workforce.
     * </p>
     * <p>
     * To create a private workforce using Amazon Cognito, you must specify a Cognito user pool in
     * <code>CognitoConfig</code>. You can also create an Amazon Cognito workforce using the Amazon SageMaker console.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private.html"> Create a Private
     * Workforce (Amazon Cognito)</a>.
     * </p>
     * <p>
     * To create a private workforce using your own OIDC Identity Provider (IdP), specify your IdP configuration in
     * <code>OidcConfig</code>. Your OIDC IdP must support <i>groups</i> because groups are used by Ground Truth and
     * Amazon A2I to create work teams. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private-oidc.html"> Create a Private
     * Workforce (OIDC IdP)</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorkforceRequest.Builder} avoiding the need
     * to create one manually via {@link CreateWorkforceRequest#builder()}
     * </p>
     *
     * @param createWorkforceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateWorkforceRequest.Builder} to create a
     *        request.
     * @return Result of the CreateWorkforce operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateWorkforce
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateWorkforce" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateWorkforceResponse createWorkforce(Consumer<CreateWorkforceRequest.Builder> createWorkforceRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return createWorkforce(CreateWorkforceRequest.builder().applyMutation(createWorkforceRequest).build());
    }

    /**
     * <p>
     * Creates a new work team for labeling your data. A work team is defined by one or more Amazon Cognito user pools.
     * You must first create the user pools before you can create a work team.
     * </p>
     * <p>
     * You cannot create more than 25 work teams in an account and region.
     * </p>
     *
     * @param createWorkteamRequest
     * @return Result of the CreateWorkteam operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateWorkteam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateWorkteam" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateWorkteamResponse createWorkteam(CreateWorkteamRequest createWorkteamRequest) throws ResourceInUseException,
            ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new work team for labeling your data. A work team is defined by one or more Amazon Cognito user pools.
     * You must first create the user pools before you can create a work team.
     * </p>
     * <p>
     * You cannot create more than 25 work teams in an account and region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorkteamRequest.Builder} avoiding the need to
     * create one manually via {@link CreateWorkteamRequest#builder()}
     * </p>
     *
     * @param createWorkteamRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateWorkteamRequest.Builder} to create a request.
     * @return Result of the CreateWorkteam operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateWorkteam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateWorkteam" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateWorkteamResponse createWorkteam(Consumer<CreateWorkteamRequest.Builder> createWorkteamRequest)
            throws ResourceInUseException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            SageMakerException {
        return createWorkteam(CreateWorkteamRequest.builder().applyMutation(createWorkteamRequest).build());
    }

    /**
     * <p>
     * Deletes an action.
     * </p>
     *
     * @param deleteActionRequest
     * @return Result of the DeleteAction operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteAction" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteActionResponse deleteAction(DeleteActionRequest deleteActionRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteActionRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteActionRequest#builder()}
     * </p>
     *
     * @param deleteActionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteActionRequest.Builder} to create a request.
     * @return Result of the DeleteAction operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteAction" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteActionResponse deleteAction(Consumer<DeleteActionRequest.Builder> deleteActionRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return deleteAction(DeleteActionRequest.builder().applyMutation(deleteActionRequest).build());
    }

    /**
     * <p>
     * Removes the specified algorithm from your account.
     * </p>
     *
     * @param deleteAlgorithmRequest
     * @return Result of the DeleteAlgorithm operation returned by the service.
     * @throws ConflictException
     *         There was a conflict when you attempted to modify a SageMaker entity such as an <code>Experiment</code>
     *         or <code>Artifact</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteAlgorithm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteAlgorithm" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAlgorithmResponse deleteAlgorithm(DeleteAlgorithmRequest deleteAlgorithmRequest) throws ConflictException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified algorithm from your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAlgorithmRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAlgorithmRequest#builder()}
     * </p>
     *
     * @param deleteAlgorithmRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteAlgorithmRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteAlgorithm operation returned by the service.
     * @throws ConflictException
     *         There was a conflict when you attempted to modify a SageMaker entity such as an <code>Experiment</code>
     *         or <code>Artifact</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteAlgorithm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteAlgorithm" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAlgorithmResponse deleteAlgorithm(Consumer<DeleteAlgorithmRequest.Builder> deleteAlgorithmRequest)
            throws ConflictException, AwsServiceException, SdkClientException, SageMakerException {
        return deleteAlgorithm(DeleteAlgorithmRequest.builder().applyMutation(deleteAlgorithmRequest).build());
    }

    /**
     * <p>
     * Used to stop and delete an app.
     * </p>
     *
     * @param deleteAppRequest
     * @return Result of the DeleteApp operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteApp" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAppResponse deleteApp(DeleteAppRequest deleteAppRequest) throws ResourceNotFoundException,
            ResourceInUseException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used to stop and delete an app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAppRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteAppRequest#builder()}
     * </p>
     *
     * @param deleteAppRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteAppRequest.Builder} to create a request.
     * @return Result of the DeleteApp operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteApp" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAppResponse deleteApp(Consumer<DeleteAppRequest.Builder> deleteAppRequest) throws ResourceNotFoundException,
            ResourceInUseException, AwsServiceException, SdkClientException, SageMakerException {
        return deleteApp(DeleteAppRequest.builder().applyMutation(deleteAppRequest).build());
    }

    /**
     * <p>
     * Deletes an AppImageConfig.
     * </p>
     *
     * @param deleteAppImageConfigRequest
     * @return Result of the DeleteAppImageConfig operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteAppImageConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteAppImageConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAppImageConfigResponse deleteAppImageConfig(DeleteAppImageConfigRequest deleteAppImageConfigRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an AppImageConfig.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAppImageConfigRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAppImageConfigRequest#builder()}
     * </p>
     *
     * @param deleteAppImageConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteAppImageConfigRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteAppImageConfig operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteAppImageConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteAppImageConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAppImageConfigResponse deleteAppImageConfig(
            Consumer<DeleteAppImageConfigRequest.Builder> deleteAppImageConfigRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        return deleteAppImageConfig(DeleteAppImageConfigRequest.builder().applyMutation(deleteAppImageConfigRequest).build());
    }

    /**
     * <p>
     * Deletes an artifact. Either <code>ArtifactArn</code> or <code>Source</code> must be specified.
     * </p>
     *
     * @param deleteArtifactRequest
     * @return Result of the DeleteArtifact operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteArtifact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteArtifact" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteArtifactResponse deleteArtifact(DeleteArtifactRequest deleteArtifactRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an artifact. Either <code>ArtifactArn</code> or <code>Source</code> must be specified.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteArtifactRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteArtifactRequest#builder()}
     * </p>
     *
     * @param deleteArtifactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteArtifactRequest.Builder} to create a request.
     * @return Result of the DeleteArtifact operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteArtifact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteArtifact" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteArtifactResponse deleteArtifact(Consumer<DeleteArtifactRequest.Builder> deleteArtifactRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return deleteArtifact(DeleteArtifactRequest.builder().applyMutation(deleteArtifactRequest).build());
    }

    /**
     * <p>
     * Deletes an association.
     * </p>
     *
     * @param deleteAssociationRequest
     * @return Result of the DeleteAssociation operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteAssociation" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteAssociationResponse deleteAssociation(DeleteAssociationRequest deleteAssociationRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an association.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAssociationRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAssociationRequest#builder()}
     * </p>
     *
     * @param deleteAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteAssociationRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteAssociation operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteAssociation" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteAssociationResponse deleteAssociation(Consumer<DeleteAssociationRequest.Builder> deleteAssociationRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return deleteAssociation(DeleteAssociationRequest.builder().applyMutation(deleteAssociationRequest).build());
    }

    /**
     * <p>
     * Delete a SageMaker HyperPod cluster.
     * </p>
     *
     * @param deleteClusterRequest
     * @return Result of the DeleteCluster operation returned by the service.
     * @throws ConflictException
     *         There was a conflict when you attempted to modify a SageMaker entity such as an <code>Experiment</code>
     *         or <code>Artifact</code>.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteClusterResponse deleteCluster(DeleteClusterRequest deleteClusterRequest) throws ConflictException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a SageMaker HyperPod cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteClusterRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteClusterRequest#builder()}
     * </p>
     *
     * @param deleteClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteClusterRequest.Builder} to create a request.
     * @return Result of the DeleteCluster operation returned by the service.
     * @throws ConflictException
     *         There was a conflict when you attempted to modify a SageMaker entity such as an <code>Experiment</code>
     *         or <code>Artifact</code>.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteClusterResponse deleteCluster(Consumer<DeleteClusterRequest.Builder> deleteClusterRequest)
            throws ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return deleteCluster(DeleteClusterRequest.builder().applyMutation(deleteClusterRequest).build());
    }

    /**
     * <p>
     * Deletes the cluster policy of the cluster.
     * </p>
     *
     * @param deleteClusterSchedulerConfigRequest
     * @return Result of the DeleteClusterSchedulerConfig operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteClusterSchedulerConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteClusterSchedulerConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteClusterSchedulerConfigResponse deleteClusterSchedulerConfig(
            DeleteClusterSchedulerConfigRequest deleteClusterSchedulerConfigRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the cluster policy of the cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteClusterSchedulerConfigRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteClusterSchedulerConfigRequest#builder()}
     * </p>
     *
     * @param deleteClusterSchedulerConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteClusterSchedulerConfigRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteClusterSchedulerConfig operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteClusterSchedulerConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteClusterSchedulerConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteClusterSchedulerConfigResponse deleteClusterSchedulerConfig(
            Consumer<DeleteClusterSchedulerConfigRequest.Builder> deleteClusterSchedulerConfigRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return deleteClusterSchedulerConfig(DeleteClusterSchedulerConfigRequest.builder()
                .applyMutation(deleteClusterSchedulerConfigRequest).build());
    }

    /**
     * <p>
     * Deletes the specified Git repository from your account.
     * </p>
     *
     * @param deleteCodeRepositoryRequest
     * @return Result of the DeleteCodeRepository operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteCodeRepository
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteCodeRepository"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCodeRepositoryResponse deleteCodeRepository(DeleteCodeRepositoryRequest deleteCodeRepositoryRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified Git repository from your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCodeRepositoryRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteCodeRepositoryRequest#builder()}
     * </p>
     *
     * @param deleteCodeRepositoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteCodeRepositoryRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteCodeRepository operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteCodeRepository
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteCodeRepository"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCodeRepositoryResponse deleteCodeRepository(
            Consumer<DeleteCodeRepositoryRequest.Builder> deleteCodeRepositoryRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return deleteCodeRepository(DeleteCodeRepositoryRequest.builder().applyMutation(deleteCodeRepositoryRequest).build());
    }

    /**
     * <p>
     * Deletes the specified compilation job. This action deletes only the compilation job resource in Amazon SageMaker
     * AI. It doesn't delete other resources that are related to that job, such as the model artifacts that the job
     * creates, the compilation logs in CloudWatch, the compiled model, or the IAM role.
     * </p>
     * <p>
     * You can delete a compilation job only if its current status is <code>COMPLETED</code>, <code>FAILED</code>, or
     * <code>STOPPED</code>. If the job status is <code>STARTING</code> or <code>INPROGRESS</code>, stop the job, and
     * then delete it after its status becomes <code>STOPPED</code>.
     * </p>
     *
     * @param deleteCompilationJobRequest
     * @return Result of the DeleteCompilationJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteCompilationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteCompilationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCompilationJobResponse deleteCompilationJob(DeleteCompilationJobRequest deleteCompilationJobRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified compilation job. This action deletes only the compilation job resource in Amazon SageMaker
     * AI. It doesn't delete other resources that are related to that job, such as the model artifacts that the job
     * creates, the compilation logs in CloudWatch, the compiled model, or the IAM role.
     * </p>
     * <p>
     * You can delete a compilation job only if its current status is <code>COMPLETED</code>, <code>FAILED</code>, or
     * <code>STOPPED</code>. If the job status is <code>STARTING</code> or <code>INPROGRESS</code>, stop the job, and
     * then delete it after its status becomes <code>STOPPED</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCompilationJobRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteCompilationJobRequest#builder()}
     * </p>
     *
     * @param deleteCompilationJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteCompilationJobRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteCompilationJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteCompilationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteCompilationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCompilationJobResponse deleteCompilationJob(
            Consumer<DeleteCompilationJobRequest.Builder> deleteCompilationJobRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        return deleteCompilationJob(DeleteCompilationJobRequest.builder().applyMutation(deleteCompilationJobRequest).build());
    }

    /**
     * <p>
     * Deletes the compute allocation from the cluster.
     * </p>
     *
     * @param deleteComputeQuotaRequest
     * @return Result of the DeleteComputeQuota operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteComputeQuota
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteComputeQuota" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteComputeQuotaResponse deleteComputeQuota(DeleteComputeQuotaRequest deleteComputeQuotaRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the compute allocation from the cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteComputeQuotaRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteComputeQuotaRequest#builder()}
     * </p>
     *
     * @param deleteComputeQuotaRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteComputeQuotaRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteComputeQuota operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteComputeQuota
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteComputeQuota" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteComputeQuotaResponse deleteComputeQuota(Consumer<DeleteComputeQuotaRequest.Builder> deleteComputeQuotaRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return deleteComputeQuota(DeleteComputeQuotaRequest.builder().applyMutation(deleteComputeQuotaRequest).build());
    }

    /**
     * <p>
     * Deletes an context.
     * </p>
     *
     * @param deleteContextRequest
     * @return Result of the DeleteContext operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteContext
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteContext" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteContextResponse deleteContext(DeleteContextRequest deleteContextRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an context.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteContextRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteContextRequest#builder()}
     * </p>
     *
     * @param deleteContextRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteContextRequest.Builder} to create a request.
     * @return Result of the DeleteContext operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteContext
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteContext" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteContextResponse deleteContext(Consumer<DeleteContextRequest.Builder> deleteContextRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return deleteContext(DeleteContextRequest.builder().applyMutation(deleteContextRequest).build());
    }

    /**
     * <p>
     * Deletes a data quality monitoring job definition.
     * </p>
     *
     * @param deleteDataQualityJobDefinitionRequest
     * @return Result of the DeleteDataQualityJobDefinition operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteDataQualityJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteDataQualityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDataQualityJobDefinitionResponse deleteDataQualityJobDefinition(
            DeleteDataQualityJobDefinitionRequest deleteDataQualityJobDefinitionRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a data quality monitoring job definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDataQualityJobDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteDataQualityJobDefinitionRequest#builder()}
     * </p>
     *
     * @param deleteDataQualityJobDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteDataQualityJobDefinitionRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteDataQualityJobDefinition operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteDataQualityJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteDataQualityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDataQualityJobDefinitionResponse deleteDataQualityJobDefinition(
            Consumer<DeleteDataQualityJobDefinitionRequest.Builder> deleteDataQualityJobDefinitionRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return deleteDataQualityJobDefinition(DeleteDataQualityJobDefinitionRequest.builder()
                .applyMutation(deleteDataQualityJobDefinitionRequest).build());
    }

    /**
     * <p>
     * Deletes a fleet.
     * </p>
     *
     * @param deleteDeviceFleetRequest
     * @return Result of the DeleteDeviceFleet operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteDeviceFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteDeviceFleet" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteDeviceFleetResponse deleteDeviceFleet(DeleteDeviceFleetRequest deleteDeviceFleetRequest)
            throws ResourceInUseException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDeviceFleetRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDeviceFleetRequest#builder()}
     * </p>
     *
     * @param deleteDeviceFleetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteDeviceFleetRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteDeviceFleet operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteDeviceFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteDeviceFleet" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteDeviceFleetResponse deleteDeviceFleet(Consumer<DeleteDeviceFleetRequest.Builder> deleteDeviceFleetRequest)
            throws ResourceInUseException, AwsServiceException, SdkClientException, SageMakerException {
        return deleteDeviceFleet(DeleteDeviceFleetRequest.builder().applyMutation(deleteDeviceFleetRequest).build());
    }

    /**
     * <p>
     * Used to delete a domain. If you onboarded with IAM mode, you will need to delete your domain to onboard again
     * using IAM Identity Center. Use with caution. All of the members of the domain will lose access to their EFS
     * volume, including data, notebooks, and other artifacts.
     * </p>
     *
     * @param deleteDomainRequest
     * @return Result of the DeleteDomain operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDomainResponse deleteDomain(DeleteDomainRequest deleteDomainRequest) throws ResourceNotFoundException,
            ResourceInUseException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used to delete a domain. If you onboarded with IAM mode, you will need to delete your domain to onboard again
     * using IAM Identity Center. Use with caution. All of the members of the domain will lose access to their EFS
     * volume, including data, notebooks, and other artifacts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDomainRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDomainRequest#builder()}
     * </p>
     *
     * @param deleteDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteDomainRequest.Builder} to create a request.
     * @return Result of the DeleteDomain operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDomainResponse deleteDomain(Consumer<DeleteDomainRequest.Builder> deleteDomainRequest)
            throws ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, SageMakerException {
        return deleteDomain(DeleteDomainRequest.builder().applyMutation(deleteDomainRequest).build());
    }

    /**
     * <p>
     * Deletes an edge deployment plan if (and only if) all the stages in the plan are inactive or there are no stages
     * in the plan.
     * </p>
     *
     * @param deleteEdgeDeploymentPlanRequest
     * @return Result of the DeleteEdgeDeploymentPlan operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteEdgeDeploymentPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteEdgeDeploymentPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEdgeDeploymentPlanResponse deleteEdgeDeploymentPlan(
            DeleteEdgeDeploymentPlanRequest deleteEdgeDeploymentPlanRequest) throws ResourceInUseException, AwsServiceException,
            SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an edge deployment plan if (and only if) all the stages in the plan are inactive or there are no stages
     * in the plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEdgeDeploymentPlanRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteEdgeDeploymentPlanRequest#builder()}
     * </p>
     *
     * @param deleteEdgeDeploymentPlanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteEdgeDeploymentPlanRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteEdgeDeploymentPlan operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteEdgeDeploymentPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteEdgeDeploymentPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEdgeDeploymentPlanResponse deleteEdgeDeploymentPlan(
            Consumer<DeleteEdgeDeploymentPlanRequest.Builder> deleteEdgeDeploymentPlanRequest) throws ResourceInUseException,
            AwsServiceException, SdkClientException, SageMakerException {
        return deleteEdgeDeploymentPlan(DeleteEdgeDeploymentPlanRequest.builder().applyMutation(deleteEdgeDeploymentPlanRequest)
                .build());
    }

    /**
     * <p>
     * Delete a stage in an edge deployment plan if (and only if) the stage is inactive.
     * </p>
     *
     * @param deleteEdgeDeploymentStageRequest
     * @return Result of the DeleteEdgeDeploymentStage operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteEdgeDeploymentStage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteEdgeDeploymentStage"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEdgeDeploymentStageResponse deleteEdgeDeploymentStage(
            DeleteEdgeDeploymentStageRequest deleteEdgeDeploymentStageRequest) throws ResourceInUseException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a stage in an edge deployment plan if (and only if) the stage is inactive.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEdgeDeploymentStageRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteEdgeDeploymentStageRequest#builder()}
     * </p>
     *
     * @param deleteEdgeDeploymentStageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteEdgeDeploymentStageRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteEdgeDeploymentStage operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteEdgeDeploymentStage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteEdgeDeploymentStage"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEdgeDeploymentStageResponse deleteEdgeDeploymentStage(
            Consumer<DeleteEdgeDeploymentStageRequest.Builder> deleteEdgeDeploymentStageRequest) throws ResourceInUseException,
            AwsServiceException, SdkClientException, SageMakerException {
        return deleteEdgeDeploymentStage(DeleteEdgeDeploymentStageRequest.builder()
                .applyMutation(deleteEdgeDeploymentStageRequest).build());
    }

    /**
     * <p>
     * Deletes an endpoint. SageMaker frees up all of the resources that were deployed when the endpoint was created.
     * </p>
     * <p>
     * SageMaker retires any custom KMS key grants associated with the endpoint, meaning you don't need to use the <a
     * href="http://docs.aws.amazon.com/kms/latest/APIReference/API_RevokeGrant.html">RevokeGrant</a> API call.
     * </p>
     * <p>
     * When you delete your endpoint, SageMaker asynchronously deletes associated endpoint resources such as KMS key
     * grants. You might still see these resources in your account for a few minutes after deleting your endpoint. Do
     * not delete or revoke the permissions for your
     * <code> <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateModel.html#sagemaker-CreateModel-request-ExecutionRoleArn">ExecutionRoleArn</a> </code>
     * , otherwise SageMaker cannot delete these resources.
     * </p>
     *
     * @param deleteEndpointRequest
     * @return Result of the DeleteEndpoint operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteEndpointResponse deleteEndpoint(DeleteEndpointRequest deleteEndpointRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an endpoint. SageMaker frees up all of the resources that were deployed when the endpoint was created.
     * </p>
     * <p>
     * SageMaker retires any custom KMS key grants associated with the endpoint, meaning you don't need to use the <a
     * href="http://docs.aws.amazon.com/kms/latest/APIReference/API_RevokeGrant.html">RevokeGrant</a> API call.
     * </p>
     * <p>
     * When you delete your endpoint, SageMaker asynchronously deletes associated endpoint resources such as KMS key
     * grants. You might still see these resources in your account for a few minutes after deleting your endpoint. Do
     * not delete or revoke the permissions for your
     * <code> <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateModel.html#sagemaker-CreateModel-request-ExecutionRoleArn">ExecutionRoleArn</a> </code>
     * , otherwise SageMaker cannot delete these resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEndpointRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteEndpointRequest#builder()}
     * </p>
     *
     * @param deleteEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteEndpointRequest.Builder} to create a request.
     * @return Result of the DeleteEndpoint operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteEndpointResponse deleteEndpoint(Consumer<DeleteEndpointRequest.Builder> deleteEndpointRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return deleteEndpoint(DeleteEndpointRequest.builder().applyMutation(deleteEndpointRequest).build());
    }

    /**
     * <p>
     * Deletes an endpoint configuration. The <code>DeleteEndpointConfig</code> API deletes only the specified
     * configuration. It does not delete endpoints created using the configuration.
     * </p>
     * <p>
     * You must not delete an <code>EndpointConfig</code> in use by an endpoint that is live or while the
     * <code>UpdateEndpoint</code> or <code>CreateEndpoint</code> operations are being performed on the endpoint. If you
     * delete the <code>EndpointConfig</code> of an endpoint that is active or being created or updated you may lose
     * visibility into the instance type the endpoint is using. The endpoint must be deleted in order to stop incurring
     * charges.
     * </p>
     *
     * @param deleteEndpointConfigRequest
     * @return Result of the DeleteEndpointConfig operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteEndpointConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteEndpointConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEndpointConfigResponse deleteEndpointConfig(DeleteEndpointConfigRequest deleteEndpointConfigRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an endpoint configuration. The <code>DeleteEndpointConfig</code> API deletes only the specified
     * configuration. It does not delete endpoints created using the configuration.
     * </p>
     * <p>
     * You must not delete an <code>EndpointConfig</code> in use by an endpoint that is live or while the
     * <code>UpdateEndpoint</code> or <code>CreateEndpoint</code> operations are being performed on the endpoint. If you
     * delete the <code>EndpointConfig</code> of an endpoint that is active or being created or updated you may lose
     * visibility into the instance type the endpoint is using. The endpoint must be deleted in order to stop incurring
     * charges.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEndpointConfigRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteEndpointConfigRequest#builder()}
     * </p>
     *
     * @param deleteEndpointConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteEndpointConfigRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteEndpointConfig operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteEndpointConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteEndpointConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEndpointConfigResponse deleteEndpointConfig(
            Consumer<DeleteEndpointConfigRequest.Builder> deleteEndpointConfigRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return deleteEndpointConfig(DeleteEndpointConfigRequest.builder().applyMutation(deleteEndpointConfigRequest).build());
    }

    /**
     * <p>
     * Deletes an SageMaker experiment. All trials associated with the experiment must be deleted first. Use the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListTrials.html">ListTrials</a> API to get a
     * list of the trials associated with the experiment.
     * </p>
     *
     * @param deleteExperimentRequest
     * @return Result of the DeleteExperiment operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteExperiment" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteExperimentResponse deleteExperiment(DeleteExperimentRequest deleteExperimentRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an SageMaker experiment. All trials associated with the experiment must be deleted first. Use the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListTrials.html">ListTrials</a> API to get a
     * list of the trials associated with the experiment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteExperimentRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteExperimentRequest#builder()}
     * </p>
     *
     * @param deleteExperimentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteExperimentRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteExperiment operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteExperiment" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteExperimentResponse deleteExperiment(Consumer<DeleteExperimentRequest.Builder> deleteExperimentRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return deleteExperiment(DeleteExperimentRequest.builder().applyMutation(deleteExperimentRequest).build());
    }

    /**
     * <p>
     * Delete the <code>FeatureGroup</code> and any data that was written to the <code>OnlineStore</code> of the
     * <code>FeatureGroup</code>. Data cannot be accessed from the <code>OnlineStore</code> immediately after
     * <code>DeleteFeatureGroup</code> is called.
     * </p>
     * <p>
     * Data written into the <code>OfflineStore</code> will not be deleted. The Amazon Web Services Glue database and
     * tables that are automatically created for your <code>OfflineStore</code> are not deleted.
     * </p>
     * <p>
     * Note that it can take approximately 10-15 minutes to delete an <code>OnlineStore</code> <code>FeatureGroup</code>
     * with the <code>InMemory</code> <code>StorageType</code>.
     * </p>
     *
     * @param deleteFeatureGroupRequest
     * @return Result of the DeleteFeatureGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteFeatureGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteFeatureGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteFeatureGroupResponse deleteFeatureGroup(DeleteFeatureGroupRequest deleteFeatureGroupRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete the <code>FeatureGroup</code> and any data that was written to the <code>OnlineStore</code> of the
     * <code>FeatureGroup</code>. Data cannot be accessed from the <code>OnlineStore</code> immediately after
     * <code>DeleteFeatureGroup</code> is called.
     * </p>
     * <p>
     * Data written into the <code>OfflineStore</code> will not be deleted. The Amazon Web Services Glue database and
     * tables that are automatically created for your <code>OfflineStore</code> are not deleted.
     * </p>
     * <p>
     * Note that it can take approximately 10-15 minutes to delete an <code>OnlineStore</code> <code>FeatureGroup</code>
     * with the <code>InMemory</code> <code>StorageType</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFeatureGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteFeatureGroupRequest#builder()}
     * </p>
     *
     * @param deleteFeatureGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteFeatureGroupRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteFeatureGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteFeatureGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteFeatureGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteFeatureGroupResponse deleteFeatureGroup(Consumer<DeleteFeatureGroupRequest.Builder> deleteFeatureGroupRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return deleteFeatureGroup(DeleteFeatureGroupRequest.builder().applyMutation(deleteFeatureGroupRequest).build());
    }

    /**
     * <p>
     * Deletes the specified flow definition.
     * </p>
     *
     * @param deleteFlowDefinitionRequest
     * @return Result of the DeleteFlowDefinition operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteFlowDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteFlowDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFlowDefinitionResponse deleteFlowDefinition(DeleteFlowDefinitionRequest deleteFlowDefinitionRequest)
            throws ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified flow definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFlowDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteFlowDefinitionRequest#builder()}
     * </p>
     *
     * @param deleteFlowDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteFlowDefinitionRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteFlowDefinition operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteFlowDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteFlowDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFlowDefinitionResponse deleteFlowDefinition(
            Consumer<DeleteFlowDefinitionRequest.Builder> deleteFlowDefinitionRequest) throws ResourceNotFoundException,
            ResourceInUseException, AwsServiceException, SdkClientException, SageMakerException {
        return deleteFlowDefinition(DeleteFlowDefinitionRequest.builder().applyMutation(deleteFlowDefinitionRequest).build());
    }

    /**
     * <p>
     * Delete a hub.
     * </p>
     *
     * @param deleteHubRequest
     * @return Result of the DeleteHub operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteHub
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteHub" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteHubResponse deleteHub(DeleteHubRequest deleteHubRequest) throws ResourceNotFoundException,
            ResourceInUseException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a hub.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteHubRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteHubRequest#builder()}
     * </p>
     *
     * @param deleteHubRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteHubRequest.Builder} to create a request.
     * @return Result of the DeleteHub operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteHub
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteHub" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteHubResponse deleteHub(Consumer<DeleteHubRequest.Builder> deleteHubRequest) throws ResourceNotFoundException,
            ResourceInUseException, AwsServiceException, SdkClientException, SageMakerException {
        return deleteHub(DeleteHubRequest.builder().applyMutation(deleteHubRequest).build());
    }

    /**
     * <p>
     * Delete the contents of a hub.
     * </p>
     *
     * @param deleteHubContentRequest
     * @return Result of the DeleteHubContent operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteHubContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteHubContent" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteHubContentResponse deleteHubContent(DeleteHubContentRequest deleteHubContentRequest)
            throws ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete the contents of a hub.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteHubContentRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteHubContentRequest#builder()}
     * </p>
     *
     * @param deleteHubContentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteHubContentRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteHubContent operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteHubContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteHubContent" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteHubContentResponse deleteHubContent(Consumer<DeleteHubContentRequest.Builder> deleteHubContentRequest)
            throws ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, SageMakerException {
        return deleteHubContent(DeleteHubContentRequest.builder().applyMutation(deleteHubContentRequest).build());
    }

    /**
     * <p>
     * Delete a hub content reference in order to remove a model from a private hub.
     * </p>
     *
     * @param deleteHubContentReferenceRequest
     * @return Result of the DeleteHubContentReference operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteHubContentReference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteHubContentReference"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteHubContentReferenceResponse deleteHubContentReference(
            DeleteHubContentReferenceRequest deleteHubContentReferenceRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a hub content reference in order to remove a model from a private hub.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteHubContentReferenceRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteHubContentReferenceRequest#builder()}
     * </p>
     *
     * @param deleteHubContentReferenceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteHubContentReferenceRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteHubContentReference operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteHubContentReference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteHubContentReference"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteHubContentReferenceResponse deleteHubContentReference(
            Consumer<DeleteHubContentReferenceRequest.Builder> deleteHubContentReferenceRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return deleteHubContentReference(DeleteHubContentReferenceRequest.builder()
                .applyMutation(deleteHubContentReferenceRequest).build());
    }

    /**
     * <p>
     * Use this operation to delete a human task user interface (worker task template).
     * </p>
     * <p>
     * To see a list of human task user interfaces (work task templates) in your account, use <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListHumanTaskUis.html">ListHumanTaskUis</a>.
     * When you delete a worker task template, it no longer appears when you call <code>ListHumanTaskUis</code>.
     * </p>
     *
     * @param deleteHumanTaskUiRequest
     * @return Result of the DeleteHumanTaskUi operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteHumanTaskUi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteHumanTaskUi" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteHumanTaskUiResponse deleteHumanTaskUi(DeleteHumanTaskUiRequest deleteHumanTaskUiRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this operation to delete a human task user interface (worker task template).
     * </p>
     * <p>
     * To see a list of human task user interfaces (work task templates) in your account, use <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListHumanTaskUis.html">ListHumanTaskUis</a>.
     * When you delete a worker task template, it no longer appears when you call <code>ListHumanTaskUis</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteHumanTaskUiRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteHumanTaskUiRequest#builder()}
     * </p>
     *
     * @param deleteHumanTaskUiRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteHumanTaskUiRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteHumanTaskUi operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteHumanTaskUi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteHumanTaskUi" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteHumanTaskUiResponse deleteHumanTaskUi(Consumer<DeleteHumanTaskUiRequest.Builder> deleteHumanTaskUiRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return deleteHumanTaskUi(DeleteHumanTaskUiRequest.builder().applyMutation(deleteHumanTaskUiRequest).build());
    }

    /**
     * <p>
     * Deletes a hyperparameter tuning job. The <code>DeleteHyperParameterTuningJob</code> API deletes only the tuning
     * job entry that was created in SageMaker when you called the <code>CreateHyperParameterTuningJob</code> API. It
     * does not delete training jobs, artifacts, or the IAM role that you specified when creating the model.
     * </p>
     *
     * @param deleteHyperParameterTuningJobRequest
     * @return Result of the DeleteHyperParameterTuningJob operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteHyperParameterTuningJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteHyperParameterTuningJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteHyperParameterTuningJobResponse deleteHyperParameterTuningJob(
            DeleteHyperParameterTuningJobRequest deleteHyperParameterTuningJobRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a hyperparameter tuning job. The <code>DeleteHyperParameterTuningJob</code> API deletes only the tuning
     * job entry that was created in SageMaker when you called the <code>CreateHyperParameterTuningJob</code> API. It
     * does not delete training jobs, artifacts, or the IAM role that you specified when creating the model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteHyperParameterTuningJobRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteHyperParameterTuningJobRequest#builder()}
     * </p>
     *
     * @param deleteHyperParameterTuningJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteHyperParameterTuningJobRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteHyperParameterTuningJob operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteHyperParameterTuningJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteHyperParameterTuningJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteHyperParameterTuningJobResponse deleteHyperParameterTuningJob(
            Consumer<DeleteHyperParameterTuningJobRequest.Builder> deleteHyperParameterTuningJobRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return deleteHyperParameterTuningJob(DeleteHyperParameterTuningJobRequest.builder()
                .applyMutation(deleteHyperParameterTuningJobRequest).build());
    }

    /**
     * <p>
     * Deletes a SageMaker AI image and all versions of the image. The container images aren't deleted.
     * </p>
     *
     * @param deleteImageRequest
     * @return Result of the DeleteImage operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteImage" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteImageResponse deleteImage(DeleteImageRequest deleteImageRequest) throws ResourceNotFoundException,
            ResourceInUseException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a SageMaker AI image and all versions of the image. The container images aren't deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteImageRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteImageRequest#builder()}
     * </p>
     *
     * @param deleteImageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteImageRequest.Builder} to create a request.
     * @return Result of the DeleteImage operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteImage" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteImageResponse deleteImage(Consumer<DeleteImageRequest.Builder> deleteImageRequest)
            throws ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, SageMakerException {
        return deleteImage(DeleteImageRequest.builder().applyMutation(deleteImageRequest).build());
    }

    /**
     * <p>
     * Deletes a version of a SageMaker AI image. The container image the version represents isn't deleted.
     * </p>
     *
     * @param deleteImageVersionRequest
     * @return Result of the DeleteImageVersion operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteImageVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteImageVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteImageVersionResponse deleteImageVersion(DeleteImageVersionRequest deleteImageVersionRequest)
            throws ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a version of a SageMaker AI image. The container image the version represents isn't deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteImageVersionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteImageVersionRequest#builder()}
     * </p>
     *
     * @param deleteImageVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteImageVersionRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteImageVersion operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteImageVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteImageVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteImageVersionResponse deleteImageVersion(Consumer<DeleteImageVersionRequest.Builder> deleteImageVersionRequest)
            throws ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, SageMakerException {
        return deleteImageVersion(DeleteImageVersionRequest.builder().applyMutation(deleteImageVersionRequest).build());
    }

    /**
     * <p>
     * Deletes an inference component.
     * </p>
     *
     * @param deleteInferenceComponentRequest
     * @return Result of the DeleteInferenceComponent operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteInferenceComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteInferenceComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteInferenceComponentResponse deleteInferenceComponent(
            DeleteInferenceComponentRequest deleteInferenceComponentRequest) throws AwsServiceException, SdkClientException,
            SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an inference component.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInferenceComponentRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteInferenceComponentRequest#builder()}
     * </p>
     *
     * @param deleteInferenceComponentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteInferenceComponentRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteInferenceComponent operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteInferenceComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteInferenceComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteInferenceComponentResponse deleteInferenceComponent(
            Consumer<DeleteInferenceComponentRequest.Builder> deleteInferenceComponentRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return deleteInferenceComponent(DeleteInferenceComponentRequest.builder().applyMutation(deleteInferenceComponentRequest)
                .build());
    }

    /**
     * <p>
     * Deletes an inference experiment.
     * </p>
     * <note>
     * <p>
     * This operation does not delete your endpoint, variants, or any underlying resources. This operation only deletes
     * the metadata of your experiment.
     * </p>
     * </note>
     *
     * @param deleteInferenceExperimentRequest
     * @return Result of the DeleteInferenceExperiment operation returned by the service.
     * @throws ConflictException
     *         There was a conflict when you attempted to modify a SageMaker entity such as an <code>Experiment</code>
     *         or <code>Artifact</code>.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteInferenceExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteInferenceExperiment"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteInferenceExperimentResponse deleteInferenceExperiment(
            DeleteInferenceExperimentRequest deleteInferenceExperimentRequest) throws ConflictException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an inference experiment.
     * </p>
     * <note>
     * <p>
     * This operation does not delete your endpoint, variants, or any underlying resources. This operation only deletes
     * the metadata of your experiment.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInferenceExperimentRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteInferenceExperimentRequest#builder()}
     * </p>
     *
     * @param deleteInferenceExperimentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteInferenceExperimentRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteInferenceExperiment operation returned by the service.
     * @throws ConflictException
     *         There was a conflict when you attempted to modify a SageMaker entity such as an <code>Experiment</code>
     *         or <code>Artifact</code>.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteInferenceExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteInferenceExperiment"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteInferenceExperimentResponse deleteInferenceExperiment(
            Consumer<DeleteInferenceExperimentRequest.Builder> deleteInferenceExperimentRequest) throws ConflictException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return deleteInferenceExperiment(DeleteInferenceExperimentRequest.builder()
                .applyMutation(deleteInferenceExperimentRequest).build());
    }

    /**
     * <p>
     * Deletes an MLflow Tracking Server. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow-cleanup.html.html">Clean up MLflow resources</a>.
     * </p>
     *
     * @param deleteMlflowTrackingServerRequest
     * @return Result of the DeleteMlflowTrackingServer operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteMlflowTrackingServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteMlflowTrackingServer"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMlflowTrackingServerResponse deleteMlflowTrackingServer(
            DeleteMlflowTrackingServerRequest deleteMlflowTrackingServerRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an MLflow Tracking Server. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow-cleanup.html.html">Clean up MLflow resources</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMlflowTrackingServerRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteMlflowTrackingServerRequest#builder()}
     * </p>
     *
     * @param deleteMlflowTrackingServerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteMlflowTrackingServerRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteMlflowTrackingServer operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteMlflowTrackingServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteMlflowTrackingServer"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMlflowTrackingServerResponse deleteMlflowTrackingServer(
            Consumer<DeleteMlflowTrackingServerRequest.Builder> deleteMlflowTrackingServerRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return deleteMlflowTrackingServer(DeleteMlflowTrackingServerRequest.builder()
                .applyMutation(deleteMlflowTrackingServerRequest).build());
    }

    /**
     * <p>
     * Deletes a model. The <code>DeleteModel</code> API deletes only the model entry that was created in SageMaker when
     * you called the <code>CreateModel</code> API. It does not delete model artifacts, inference code, or the IAM role
     * that you specified when creating the model.
     * </p>
     *
     * @param deleteModelRequest
     * @return Result of the DeleteModel operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModel" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteModelResponse deleteModel(DeleteModelRequest deleteModelRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a model. The <code>DeleteModel</code> API deletes only the model entry that was created in SageMaker when
     * you called the <code>CreateModel</code> API. It does not delete model artifacts, inference code, or the IAM role
     * that you specified when creating the model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteModelRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteModelRequest#builder()}
     * </p>
     *
     * @param deleteModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteModelRequest.Builder} to create a request.
     * @return Result of the DeleteModel operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModel" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteModelResponse deleteModel(Consumer<DeleteModelRequest.Builder> deleteModelRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return deleteModel(DeleteModelRequest.builder().applyMutation(deleteModelRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon SageMaker AI model bias job definition.
     * </p>
     *
     * @param deleteModelBiasJobDefinitionRequest
     * @return Result of the DeleteModelBiasJobDefinition operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteModelBiasJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelBiasJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteModelBiasJobDefinitionResponse deleteModelBiasJobDefinition(
            DeleteModelBiasJobDefinitionRequest deleteModelBiasJobDefinitionRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon SageMaker AI model bias job definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteModelBiasJobDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteModelBiasJobDefinitionRequest#builder()}
     * </p>
     *
     * @param deleteModelBiasJobDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteModelBiasJobDefinitionRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteModelBiasJobDefinition operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteModelBiasJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelBiasJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteModelBiasJobDefinitionResponse deleteModelBiasJobDefinition(
            Consumer<DeleteModelBiasJobDefinitionRequest.Builder> deleteModelBiasJobDefinitionRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return deleteModelBiasJobDefinition(DeleteModelBiasJobDefinitionRequest.builder()
                .applyMutation(deleteModelBiasJobDefinitionRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon SageMaker Model Card.
     * </p>
     *
     * @param deleteModelCardRequest
     * @return Result of the DeleteModelCard operation returned by the service.
     * @throws ConflictException
     *         There was a conflict when you attempted to modify a SageMaker entity such as an <code>Experiment</code>
     *         or <code>Artifact</code>.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteModelCard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelCard" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteModelCardResponse deleteModelCard(DeleteModelCardRequest deleteModelCardRequest) throws ConflictException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon SageMaker Model Card.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteModelCardRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteModelCardRequest#builder()}
     * </p>
     *
     * @param deleteModelCardRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteModelCardRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteModelCard operation returned by the service.
     * @throws ConflictException
     *         There was a conflict when you attempted to modify a SageMaker entity such as an <code>Experiment</code>
     *         or <code>Artifact</code>.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteModelCard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelCard" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteModelCardResponse deleteModelCard(Consumer<DeleteModelCardRequest.Builder> deleteModelCardRequest)
            throws ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return deleteModelCard(DeleteModelCardRequest.builder().applyMutation(deleteModelCardRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon SageMaker AI model explainability job definition.
     * </p>
     *
     * @param deleteModelExplainabilityJobDefinitionRequest
     * @return Result of the DeleteModelExplainabilityJobDefinition operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteModelExplainabilityJobDefinition
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelExplainabilityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteModelExplainabilityJobDefinitionResponse deleteModelExplainabilityJobDefinition(
            DeleteModelExplainabilityJobDefinitionRequest deleteModelExplainabilityJobDefinitionRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon SageMaker AI model explainability job definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteModelExplainabilityJobDefinitionRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteModelExplainabilityJobDefinitionRequest#builder()}
     * </p>
     *
     * @param deleteModelExplainabilityJobDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteModelExplainabilityJobDefinitionRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteModelExplainabilityJobDefinition operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteModelExplainabilityJobDefinition
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelExplainabilityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteModelExplainabilityJobDefinitionResponse deleteModelExplainabilityJobDefinition(
            Consumer<DeleteModelExplainabilityJobDefinitionRequest.Builder> deleteModelExplainabilityJobDefinitionRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return deleteModelExplainabilityJobDefinition(DeleteModelExplainabilityJobDefinitionRequest.builder()
                .applyMutation(deleteModelExplainabilityJobDefinitionRequest).build());
    }

    /**
     * <p>
     * Deletes a model package.
     * </p>
     * <p>
     * A model package is used to create SageMaker models or list on Amazon Web Services Marketplace. Buyers can
     * subscribe to model packages listed on Amazon Web Services Marketplace to create models in SageMaker.
     * </p>
     *
     * @param deleteModelPackageRequest
     * @return Result of the DeleteModelPackage operation returned by the service.
     * @throws ConflictException
     *         There was a conflict when you attempted to modify a SageMaker entity such as an <code>Experiment</code>
     *         or <code>Artifact</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteModelPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelPackage" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteModelPackageResponse deleteModelPackage(DeleteModelPackageRequest deleteModelPackageRequest)
            throws ConflictException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a model package.
     * </p>
     * <p>
     * A model package is used to create SageMaker models or list on Amazon Web Services Marketplace. Buyers can
     * subscribe to model packages listed on Amazon Web Services Marketplace to create models in SageMaker.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteModelPackageRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteModelPackageRequest#builder()}
     * </p>
     *
     * @param deleteModelPackageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteModelPackage operation returned by the service.
     * @throws ConflictException
     *         There was a conflict when you attempted to modify a SageMaker entity such as an <code>Experiment</code>
     *         or <code>Artifact</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteModelPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelPackage" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteModelPackageResponse deleteModelPackage(Consumer<DeleteModelPackageRequest.Builder> deleteModelPackageRequest)
            throws ConflictException, AwsServiceException, SdkClientException, SageMakerException {
        return deleteModelPackage(DeleteModelPackageRequest.builder().applyMutation(deleteModelPackageRequest).build());
    }

    /**
     * <p>
     * Deletes the specified model group.
     * </p>
     *
     * @param deleteModelPackageGroupRequest
     * @return Result of the DeleteModelPackageGroup operation returned by the service.
     * @throws ConflictException
     *         There was a conflict when you attempted to modify a SageMaker entity such as an <code>Experiment</code>
     *         or <code>Artifact</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteModelPackageGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelPackageGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteModelPackageGroupResponse deleteModelPackageGroup(DeleteModelPackageGroupRequest deleteModelPackageGroupRequest)
            throws ConflictException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified model group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteModelPackageGroupRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteModelPackageGroupRequest#builder()}
     * </p>
     *
     * @param deleteModelPackageGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageGroupRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteModelPackageGroup operation returned by the service.
     * @throws ConflictException
     *         There was a conflict when you attempted to modify a SageMaker entity such as an <code>Experiment</code>
     *         or <code>Artifact</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteModelPackageGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelPackageGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteModelPackageGroupResponse deleteModelPackageGroup(
            Consumer<DeleteModelPackageGroupRequest.Builder> deleteModelPackageGroupRequest) throws ConflictException,
            AwsServiceException, SdkClientException, SageMakerException {
        return deleteModelPackageGroup(DeleteModelPackageGroupRequest.builder().applyMutation(deleteModelPackageGroupRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a model group resource policy.
     * </p>
     *
     * @param deleteModelPackageGroupPolicyRequest
     * @return Result of the DeleteModelPackageGroupPolicy operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteModelPackageGroupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelPackageGroupPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteModelPackageGroupPolicyResponse deleteModelPackageGroupPolicy(
            DeleteModelPackageGroupPolicyRequest deleteModelPackageGroupPolicyRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a model group resource policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteModelPackageGroupPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteModelPackageGroupPolicyRequest#builder()}
     * </p>
     *
     * @param deleteModelPackageGroupPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageGroupPolicyRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteModelPackageGroupPolicy operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteModelPackageGroupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelPackageGroupPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteModelPackageGroupPolicyResponse deleteModelPackageGroupPolicy(
            Consumer<DeleteModelPackageGroupPolicyRequest.Builder> deleteModelPackageGroupPolicyRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return deleteModelPackageGroupPolicy(DeleteModelPackageGroupPolicyRequest.builder()
                .applyMutation(deleteModelPackageGroupPolicyRequest).build());
    }

    /**
     * <p>
     * Deletes the secified model quality monitoring job definition.
     * </p>
     *
     * @param deleteModelQualityJobDefinitionRequest
     * @return Result of the DeleteModelQualityJobDefinition operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteModelQualityJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelQualityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteModelQualityJobDefinitionResponse deleteModelQualityJobDefinition(
            DeleteModelQualityJobDefinitionRequest deleteModelQualityJobDefinitionRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the secified model quality monitoring job definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteModelQualityJobDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteModelQualityJobDefinitionRequest#builder()}
     * </p>
     *
     * @param deleteModelQualityJobDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteModelQualityJobDefinitionRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteModelQualityJobDefinition operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteModelQualityJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelQualityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteModelQualityJobDefinitionResponse deleteModelQualityJobDefinition(
            Consumer<DeleteModelQualityJobDefinitionRequest.Builder> deleteModelQualityJobDefinitionRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return deleteModelQualityJobDefinition(DeleteModelQualityJobDefinitionRequest.builder()
                .applyMutation(deleteModelQualityJobDefinitionRequest).build());
    }

    /**
     * <p>
     * Deletes a monitoring schedule. Also stops the schedule had not already been stopped. This does not delete the job
     * execution history of the monitoring schedule.
     * </p>
     *
     * @param deleteMonitoringScheduleRequest
     * @return Result of the DeleteMonitoringSchedule operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteMonitoringSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteMonitoringSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMonitoringScheduleResponse deleteMonitoringSchedule(
            DeleteMonitoringScheduleRequest deleteMonitoringScheduleRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a monitoring schedule. Also stops the schedule had not already been stopped. This does not delete the job
     * execution history of the monitoring schedule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMonitoringScheduleRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteMonitoringScheduleRequest#builder()}
     * </p>
     *
     * @param deleteMonitoringScheduleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteMonitoringScheduleRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteMonitoringSchedule operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteMonitoringSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteMonitoringSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMonitoringScheduleResponse deleteMonitoringSchedule(
            Consumer<DeleteMonitoringScheduleRequest.Builder> deleteMonitoringScheduleRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        return deleteMonitoringSchedule(DeleteMonitoringScheduleRequest.builder().applyMutation(deleteMonitoringScheduleRequest)
                .build());
    }

    /**
     * <p>
     * Deletes an SageMaker AI notebook instance. Before you can delete a notebook instance, you must call the
     * <code>StopNotebookInstance</code> API.
     * </p>
     * <important>
     * <p>
     * When you delete a notebook instance, you lose all of your data. SageMaker AI removes the ML compute instance, and
     * deletes the ML storage volume and the network interface associated with the notebook instance.
     * </p>
     * </important>
     *
     * @param deleteNotebookInstanceRequest
     * @return Result of the DeleteNotebookInstance operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteNotebookInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteNotebookInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteNotebookInstanceResponse deleteNotebookInstance(DeleteNotebookInstanceRequest deleteNotebookInstanceRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an SageMaker AI notebook instance. Before you can delete a notebook instance, you must call the
     * <code>StopNotebookInstance</code> API.
     * </p>
     * <important>
     * <p>
     * When you delete a notebook instance, you lose all of your data. SageMaker AI removes the ML compute instance, and
     * deletes the ML storage volume and the network interface associated with the notebook instance.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNotebookInstanceRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteNotebookInstanceRequest#builder()}
     * </p>
     *
     * @param deleteNotebookInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteNotebookInstanceRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteNotebookInstance operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteNotebookInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteNotebookInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteNotebookInstanceResponse deleteNotebookInstance(
            Consumer<DeleteNotebookInstanceRequest.Builder> deleteNotebookInstanceRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return deleteNotebookInstance(DeleteNotebookInstanceRequest.builder().applyMutation(deleteNotebookInstanceRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a notebook instance lifecycle configuration.
     * </p>
     *
     * @param deleteNotebookInstanceLifecycleConfigRequest
     * @return Result of the DeleteNotebookInstanceLifecycleConfig operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteNotebookInstanceLifecycleConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteNotebookInstanceLifecycleConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteNotebookInstanceLifecycleConfigResponse deleteNotebookInstanceLifecycleConfig(
            DeleteNotebookInstanceLifecycleConfigRequest deleteNotebookInstanceLifecycleConfigRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a notebook instance lifecycle configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteNotebookInstanceLifecycleConfigRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteNotebookInstanceLifecycleConfigRequest#builder()}
     * </p>
     *
     * @param deleteNotebookInstanceLifecycleConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteNotebookInstanceLifecycleConfigRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteNotebookInstanceLifecycleConfig operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteNotebookInstanceLifecycleConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteNotebookInstanceLifecycleConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteNotebookInstanceLifecycleConfigResponse deleteNotebookInstanceLifecycleConfig(
            Consumer<DeleteNotebookInstanceLifecycleConfigRequest.Builder> deleteNotebookInstanceLifecycleConfigRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return deleteNotebookInstanceLifecycleConfig(DeleteNotebookInstanceLifecycleConfigRequest.builder()
                .applyMutation(deleteNotebookInstanceLifecycleConfigRequest).build());
    }

    /**
     * <p>
     * Deletes an optimization job.
     * </p>
     *
     * @param deleteOptimizationJobRequest
     * @return Result of the DeleteOptimizationJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteOptimizationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteOptimizationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteOptimizationJobResponse deleteOptimizationJob(DeleteOptimizationJobRequest deleteOptimizationJobRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an optimization job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteOptimizationJobRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteOptimizationJobRequest#builder()}
     * </p>
     *
     * @param deleteOptimizationJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteOptimizationJobRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteOptimizationJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteOptimizationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteOptimizationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteOptimizationJobResponse deleteOptimizationJob(
            Consumer<DeleteOptimizationJobRequest.Builder> deleteOptimizationJobRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        return deleteOptimizationJob(DeleteOptimizationJobRequest.builder().applyMutation(deleteOptimizationJobRequest).build());
    }

    /**
     * <p>
     * Deletes a SageMaker Partner AI App.
     * </p>
     *
     * @param deletePartnerAppRequest
     * @return Result of the DeletePartnerApp operation returned by the service.
     * @throws ConflictException
     *         There was a conflict when you attempted to modify a SageMaker entity such as an <code>Experiment</code>
     *         or <code>Artifact</code>.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeletePartnerApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeletePartnerApp" target="_top">AWS
     *      API Documentation</a>
     */
    default DeletePartnerAppResponse deletePartnerApp(DeletePartnerAppRequest deletePartnerAppRequest) throws ConflictException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a SageMaker Partner AI App.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePartnerAppRequest.Builder} avoiding the need
     * to create one manually via {@link DeletePartnerAppRequest#builder()}
     * </p>
     *
     * @param deletePartnerAppRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeletePartnerAppRequest.Builder} to create a
     *        request.
     * @return Result of the DeletePartnerApp operation returned by the service.
     * @throws ConflictException
     *         There was a conflict when you attempted to modify a SageMaker entity such as an <code>Experiment</code>
     *         or <code>Artifact</code>.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeletePartnerApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeletePartnerApp" target="_top">AWS
     *      API Documentation</a>
     */
    default DeletePartnerAppResponse deletePartnerApp(Consumer<DeletePartnerAppRequest.Builder> deletePartnerAppRequest)
            throws ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return deletePartnerApp(DeletePartnerAppRequest.builder().applyMutation(deletePartnerAppRequest).build());
    }

    /**
     * <p>
     * Deletes a pipeline if there are no running instances of the pipeline. To delete a pipeline, you must stop all
     * running instances of the pipeline using the <code>StopPipelineExecution</code> API. When you delete a pipeline,
     * all instances of the pipeline are deleted.
     * </p>
     *
     * @param deletePipelineRequest
     * @return Result of the DeletePipeline operation returned by the service.
     * @throws ConflictException
     *         There was a conflict when you attempted to modify a SageMaker entity such as an <code>Experiment</code>
     *         or <code>Artifact</code>.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeletePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeletePipeline" target="_top">AWS API
     *      Documentation</a>
     */
    default DeletePipelineResponse deletePipeline(DeletePipelineRequest deletePipelineRequest) throws ConflictException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a pipeline if there are no running instances of the pipeline. To delete a pipeline, you must stop all
     * running instances of the pipeline using the <code>StopPipelineExecution</code> API. When you delete a pipeline,
     * all instances of the pipeline are deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePipelineRequest.Builder} avoiding the need to
     * create one manually via {@link DeletePipelineRequest#builder()}
     * </p>
     *
     * @param deletePipelineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeletePipelineRequest.Builder} to create a request.
     * @return Result of the DeletePipeline operation returned by the service.
     * @throws ConflictException
     *         There was a conflict when you attempted to modify a SageMaker entity such as an <code>Experiment</code>
     *         or <code>Artifact</code>.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeletePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeletePipeline" target="_top">AWS API
     *      Documentation</a>
     */
    default DeletePipelineResponse deletePipeline(Consumer<DeletePipelineRequest.Builder> deletePipelineRequest)
            throws ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return deletePipeline(DeletePipelineRequest.builder().applyMutation(deletePipelineRequest).build());
    }

    /**
     * <p>
     * Delete the specified project.
     * </p>
     *
     * @param deleteProjectRequest
     * @return Result of the DeleteProject operation returned by the service.
     * @throws ConflictException
     *         There was a conflict when you attempted to modify a SageMaker entity such as an <code>Experiment</code>
     *         or <code>Artifact</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteProject" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteProjectResponse deleteProject(DeleteProjectRequest deleteProjectRequest) throws ConflictException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete the specified project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProjectRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteProjectRequest#builder()}
     * </p>
     *
     * @param deleteProjectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteProjectRequest.Builder} to create a request.
     * @return Result of the DeleteProject operation returned by the service.
     * @throws ConflictException
     *         There was a conflict when you attempted to modify a SageMaker entity such as an <code>Experiment</code>
     *         or <code>Artifact</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteProject" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteProjectResponse deleteProject(Consumer<DeleteProjectRequest.Builder> deleteProjectRequest)
            throws ConflictException, AwsServiceException, SdkClientException, SageMakerException {
        return deleteProject(DeleteProjectRequest.builder().applyMutation(deleteProjectRequest).build());
    }

    /**
     * <p>
     * Used to delete a space.
     * </p>
     *
     * @param deleteSpaceRequest
     * @return Result of the DeleteSpace operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteSpace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteSpace" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteSpaceResponse deleteSpace(DeleteSpaceRequest deleteSpaceRequest) throws ResourceNotFoundException,
            ResourceInUseException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used to delete a space.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSpaceRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteSpaceRequest#builder()}
     * </p>
     *
     * @param deleteSpaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteSpaceRequest.Builder} to create a request.
     * @return Result of the DeleteSpace operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteSpace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteSpace" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteSpaceResponse deleteSpace(Consumer<DeleteSpaceRequest.Builder> deleteSpaceRequest)
            throws ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, SageMakerException {
        return deleteSpace(DeleteSpaceRequest.builder().applyMutation(deleteSpaceRequest).build());
    }

    /**
     * <p>
     * Deletes the Amazon SageMaker AI Studio Lifecycle Configuration. In order to delete the Lifecycle Configuration,
     * there must be no running apps using the Lifecycle Configuration. You must also remove the Lifecycle Configuration
     * from UserSettings in all Domains and UserProfiles.
     * </p>
     *
     * @param deleteStudioLifecycleConfigRequest
     * @return Result of the DeleteStudioLifecycleConfig operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteStudioLifecycleConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteStudioLifecycleConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteStudioLifecycleConfigResponse deleteStudioLifecycleConfig(
            DeleteStudioLifecycleConfigRequest deleteStudioLifecycleConfigRequest) throws ResourceNotFoundException,
            ResourceInUseException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the Amazon SageMaker AI Studio Lifecycle Configuration. In order to delete the Lifecycle Configuration,
     * there must be no running apps using the Lifecycle Configuration. You must also remove the Lifecycle Configuration
     * from UserSettings in all Domains and UserProfiles.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteStudioLifecycleConfigRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteStudioLifecycleConfigRequest#builder()}
     * </p>
     *
     * @param deleteStudioLifecycleConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteStudioLifecycleConfigRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteStudioLifecycleConfig operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteStudioLifecycleConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteStudioLifecycleConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteStudioLifecycleConfigResponse deleteStudioLifecycleConfig(
            Consumer<DeleteStudioLifecycleConfigRequest.Builder> deleteStudioLifecycleConfigRequest)
            throws ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, SageMakerException {
        return deleteStudioLifecycleConfig(DeleteStudioLifecycleConfigRequest.builder()
                .applyMutation(deleteStudioLifecycleConfigRequest).build());
    }

    /**
     * <p>
     * Deletes the specified tags from an SageMaker resource.
     * </p>
     * <p>
     * To list a resource's tags, use the <code>ListTags</code> API.
     * </p>
     * <note>
     * <p>
     * When you call this API to delete tags from a hyperparameter tuning job, the deleted tags are not removed from
     * training jobs that the hyperparameter tuning job launched before you called this API.
     * </p>
     * </note> <note>
     * <p>
     * When you call this API to delete tags from a SageMaker Domain or User Profile, the deleted tags are not removed
     * from Apps that the SageMaker Domain or User Profile launched before you called this API.
     * </p>
     * </note>
     *
     * @param deleteTagsRequest
     * @return Result of the DeleteTags operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteTags" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteTagsResponse deleteTags(DeleteTagsRequest deleteTagsRequest) throws AwsServiceException, SdkClientException,
            SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified tags from an SageMaker resource.
     * </p>
     * <p>
     * To list a resource's tags, use the <code>ListTags</code> API.
     * </p>
     * <note>
     * <p>
     * When you call this API to delete tags from a hyperparameter tuning job, the deleted tags are not removed from
     * training jobs that the hyperparameter tuning job launched before you called this API.
     * </p>
     * </note> <note>
     * <p>
     * When you call this API to delete tags from a SageMaker Domain or User Profile, the deleted tags are not removed
     * from Apps that the SageMaker Domain or User Profile launched before you called this API.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTagsRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTagsRequest#builder()}
     * </p>
     *
     * @param deleteTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteTagsRequest.Builder} to create a request.
     * @return Result of the DeleteTags operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteTags" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteTagsResponse deleteTags(Consumer<DeleteTagsRequest.Builder> deleteTagsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return deleteTags(DeleteTagsRequest.builder().applyMutation(deleteTagsRequest).build());
    }

    /**
     * <p>
     * Deletes the specified trial. All trial components that make up the trial must be deleted first. Use the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeTrialComponent.html"
     * >DescribeTrialComponent</a> API to get the list of trial components.
     * </p>
     *
     * @param deleteTrialRequest
     * @return Result of the DeleteTrial operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteTrial
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteTrial" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteTrialResponse deleteTrial(DeleteTrialRequest deleteTrialRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified trial. All trial components that make up the trial must be deleted first. Use the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeTrialComponent.html"
     * >DescribeTrialComponent</a> API to get the list of trial components.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTrialRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTrialRequest#builder()}
     * </p>
     *
     * @param deleteTrialRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteTrialRequest.Builder} to create a request.
     * @return Result of the DeleteTrial operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteTrial
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteTrial" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteTrialResponse deleteTrial(Consumer<DeleteTrialRequest.Builder> deleteTrialRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return deleteTrial(DeleteTrialRequest.builder().applyMutation(deleteTrialRequest).build());
    }

    /**
     * <p>
     * Deletes the specified trial component. A trial component must be disassociated from all trials before the trial
     * component can be deleted. To disassociate a trial component from a trial, call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DisassociateTrialComponent.html"
     * >DisassociateTrialComponent</a> API.
     * </p>
     *
     * @param deleteTrialComponentRequest
     * @return Result of the DeleteTrialComponent operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteTrialComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteTrialComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTrialComponentResponse deleteTrialComponent(DeleteTrialComponentRequest deleteTrialComponentRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified trial component. A trial component must be disassociated from all trials before the trial
     * component can be deleted. To disassociate a trial component from a trial, call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DisassociateTrialComponent.html"
     * >DisassociateTrialComponent</a> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTrialComponentRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteTrialComponentRequest#builder()}
     * </p>
     *
     * @param deleteTrialComponentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteTrialComponentRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteTrialComponent operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteTrialComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteTrialComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTrialComponentResponse deleteTrialComponent(
            Consumer<DeleteTrialComponentRequest.Builder> deleteTrialComponentRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        return deleteTrialComponent(DeleteTrialComponentRequest.builder().applyMutation(deleteTrialComponentRequest).build());
    }

    /**
     * <p>
     * Deletes a user profile. When a user profile is deleted, the user loses access to their EFS volume, including
     * data, notebooks, and other artifacts.
     * </p>
     *
     * @param deleteUserProfileRequest
     * @return Result of the DeleteUserProfile operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteUserProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteUserProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteUserProfileResponse deleteUserProfile(DeleteUserProfileRequest deleteUserProfileRequest)
            throws ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a user profile. When a user profile is deleted, the user loses access to their EFS volume, including
     * data, notebooks, and other artifacts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserProfileRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteUserProfileRequest#builder()}
     * </p>
     *
     * @param deleteUserProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteUserProfileRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteUserProfile operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteUserProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteUserProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteUserProfileResponse deleteUserProfile(Consumer<DeleteUserProfileRequest.Builder> deleteUserProfileRequest)
            throws ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, SageMakerException {
        return deleteUserProfile(DeleteUserProfileRequest.builder().applyMutation(deleteUserProfileRequest).build());
    }

    /**
     * <p>
     * Use this operation to delete a workforce.
     * </p>
     * <p>
     * If you want to create a new workforce in an Amazon Web Services Region where a workforce already exists, use this
     * operation to delete the existing workforce and then use <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateWorkforce.html">CreateWorkforce</a> to
     * create a new workforce.
     * </p>
     * <important>
     * <p>
     * If a private workforce contains one or more work teams, you must use the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteWorkteam.html">DeleteWorkteam</a>
     * operation to delete all work teams before you delete the workforce. If you try to delete a workforce that
     * contains one or more work teams, you will receive a <code>ResourceInUse</code> error.
     * </p>
     * </important>
     *
     * @param deleteWorkforceRequest
     * @return Result of the DeleteWorkforce operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteWorkforce
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteWorkforce" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteWorkforceResponse deleteWorkforce(DeleteWorkforceRequest deleteWorkforceRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this operation to delete a workforce.
     * </p>
     * <p>
     * If you want to create a new workforce in an Amazon Web Services Region where a workforce already exists, use this
     * operation to delete the existing workforce and then use <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateWorkforce.html">CreateWorkforce</a> to
     * create a new workforce.
     * </p>
     * <important>
     * <p>
     * If a private workforce contains one or more work teams, you must use the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteWorkteam.html">DeleteWorkteam</a>
     * operation to delete all work teams before you delete the workforce. If you try to delete a workforce that
     * contains one or more work teams, you will receive a <code>ResourceInUse</code> error.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWorkforceRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteWorkforceRequest#builder()}
     * </p>
     *
     * @param deleteWorkforceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteWorkforceRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteWorkforce operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteWorkforce
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteWorkforce" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteWorkforceResponse deleteWorkforce(Consumer<DeleteWorkforceRequest.Builder> deleteWorkforceRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return deleteWorkforce(DeleteWorkforceRequest.builder().applyMutation(deleteWorkforceRequest).build());
    }

    /**
     * <p>
     * Deletes an existing work team. This operation can't be undone.
     * </p>
     *
     * @param deleteWorkteamRequest
     * @return Result of the DeleteWorkteam operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteWorkteam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteWorkteam" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteWorkteamResponse deleteWorkteam(DeleteWorkteamRequest deleteWorkteamRequest)
            throws ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing work team. This operation can't be undone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWorkteamRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteWorkteamRequest#builder()}
     * </p>
     *
     * @param deleteWorkteamRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteWorkteamRequest.Builder} to create a request.
     * @return Result of the DeleteWorkteam operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteWorkteam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteWorkteam" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteWorkteamResponse deleteWorkteam(Consumer<DeleteWorkteamRequest.Builder> deleteWorkteamRequest)
            throws ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        return deleteWorkteam(DeleteWorkteamRequest.builder().applyMutation(deleteWorkteamRequest).build());
    }

    /**
     * <p>
     * Deregisters the specified devices. After you deregister a device, you will need to re-register the devices.
     * </p>
     *
     * @param deregisterDevicesRequest
     * @return Result of the DeregisterDevices operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeregisterDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeregisterDevices" target="_top">AWS
     *      API Documentation</a>
     */
    default DeregisterDevicesResponse deregisterDevices(DeregisterDevicesRequest deregisterDevicesRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deregisters the specified devices. After you deregister a device, you will need to re-register the devices.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterDevicesRequest.Builder} avoiding the need
     * to create one manually via {@link DeregisterDevicesRequest#builder()}
     * </p>
     *
     * @param deregisterDevicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeregisterDevicesRequest.Builder} to create a
     *        request.
     * @return Result of the DeregisterDevices operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeregisterDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeregisterDevices" target="_top">AWS
     *      API Documentation</a>
     */
    default DeregisterDevicesResponse deregisterDevices(Consumer<DeregisterDevicesRequest.Builder> deregisterDevicesRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return deregisterDevices(DeregisterDevicesRequest.builder().applyMutation(deregisterDevicesRequest).build());
    }

    /**
     * <p>
     * Describes an action.
     * </p>
     *
     * @param describeActionRequest
     * @return Result of the DescribeAction operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeAction" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeActionResponse describeAction(DescribeActionRequest describeActionRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeActionRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeActionRequest#builder()}
     * </p>
     *
     * @param describeActionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeActionRequest.Builder} to create a request.
     * @return Result of the DescribeAction operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeAction" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeActionResponse describeAction(Consumer<DescribeActionRequest.Builder> describeActionRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return describeAction(DescribeActionRequest.builder().applyMutation(describeActionRequest).build());
    }

    /**
     * <p>
     * Returns a description of the specified algorithm that is in your account.
     * </p>
     *
     * @param describeAlgorithmRequest
     * @return Result of the DescribeAlgorithm operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeAlgorithm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeAlgorithm" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeAlgorithmResponse describeAlgorithm(DescribeAlgorithmRequest describeAlgorithmRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a description of the specified algorithm that is in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAlgorithmRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeAlgorithmRequest#builder()}
     * </p>
     *
     * @param describeAlgorithmRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeAlgorithmRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeAlgorithm operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeAlgorithm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeAlgorithm" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeAlgorithmResponse describeAlgorithm(Consumer<DescribeAlgorithmRequest.Builder> describeAlgorithmRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return describeAlgorithm(DescribeAlgorithmRequest.builder().applyMutation(describeAlgorithmRequest).build());
    }

    /**
     * <p>
     * Describes the app.
     * </p>
     *
     * @param describeAppRequest
     * @return Result of the DescribeApp operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeApp" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeAppResponse describeApp(DescribeAppRequest describeAppRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAppRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeAppRequest#builder()}
     * </p>
     *
     * @param describeAppRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeAppRequest.Builder} to create a request.
     * @return Result of the DescribeApp operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeApp" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeAppResponse describeApp(Consumer<DescribeAppRequest.Builder> describeAppRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return describeApp(DescribeAppRequest.builder().applyMutation(describeAppRequest).build());
    }

    /**
     * <p>
     * Describes an AppImageConfig.
     * </p>
     *
     * @param describeAppImageConfigRequest
     * @return Result of the DescribeAppImageConfig operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeAppImageConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeAppImageConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAppImageConfigResponse describeAppImageConfig(DescribeAppImageConfigRequest describeAppImageConfigRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an AppImageConfig.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAppImageConfigRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeAppImageConfigRequest#builder()}
     * </p>
     *
     * @param describeAppImageConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeAppImageConfigRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeAppImageConfig operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeAppImageConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeAppImageConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAppImageConfigResponse describeAppImageConfig(
            Consumer<DescribeAppImageConfigRequest.Builder> describeAppImageConfigRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        return describeAppImageConfig(DescribeAppImageConfigRequest.builder().applyMutation(describeAppImageConfigRequest)
                .build());
    }

    /**
     * <p>
     * Describes an artifact.
     * </p>
     *
     * @param describeArtifactRequest
     * @return Result of the DescribeArtifact operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeArtifact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeArtifact" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeArtifactResponse describeArtifact(DescribeArtifactRequest describeArtifactRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an artifact.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeArtifactRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeArtifactRequest#builder()}
     * </p>
     *
     * @param describeArtifactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeArtifactRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeArtifact operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeArtifact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeArtifact" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeArtifactResponse describeArtifact(Consumer<DescribeArtifactRequest.Builder> describeArtifactRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return describeArtifact(DescribeArtifactRequest.builder().applyMutation(describeArtifactRequest).build());
    }

    /**
     * <p>
     * Returns information about an AutoML job created by calling <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJob.html">CreateAutoMLJob</a>.
     * </p>
     * <note>
     * <p>
     * AutoML jobs created by calling <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJobV2.html">CreateAutoMLJobV2</a>
     * cannot be described by <code>DescribeAutoMLJob</code>.
     * </p>
     * </note>
     *
     * @param describeAutoMlJobRequest
     * @return Result of the DescribeAutoMLJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeAutoMLJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeAutoMLJob" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeAutoMlJobResponse describeAutoMLJob(DescribeAutoMlJobRequest describeAutoMlJobRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about an AutoML job created by calling <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJob.html">CreateAutoMLJob</a>.
     * </p>
     * <note>
     * <p>
     * AutoML jobs created by calling <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJobV2.html">CreateAutoMLJobV2</a>
     * cannot be described by <code>DescribeAutoMLJob</code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAutoMlJobRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeAutoMlJobRequest#builder()}
     * </p>
     *
     * @param describeAutoMlJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeAutoMlJobRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeAutoMLJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeAutoMLJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeAutoMLJob" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeAutoMlJobResponse describeAutoMLJob(Consumer<DescribeAutoMlJobRequest.Builder> describeAutoMlJobRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return describeAutoMLJob(DescribeAutoMlJobRequest.builder().applyMutation(describeAutoMlJobRequest).build());
    }

    /**
     * <p>
     * Returns information about an AutoML job created by calling <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJobV2.html">CreateAutoMLJobV2</a>
     * or <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJob.html">CreateAutoMLJob</a>.
     * </p>
     *
     * @param describeAutoMlJobV2Request
     * @return Result of the DescribeAutoMLJobV2 operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeAutoMLJobV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeAutoMLJobV2" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeAutoMlJobV2Response describeAutoMLJobV2(DescribeAutoMlJobV2Request describeAutoMlJobV2Request)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about an AutoML job created by calling <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJobV2.html">CreateAutoMLJobV2</a>
     * or <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJob.html">CreateAutoMLJob</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAutoMlJobV2Request.Builder} avoiding the
     * need to create one manually via {@link DescribeAutoMlJobV2Request#builder()}
     * </p>
     *
     * @param describeAutoMlJobV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeAutoMlJobV2Request.Builder} to create a
     *        request.
     * @return Result of the DescribeAutoMLJobV2 operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeAutoMLJobV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeAutoMLJobV2" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeAutoMlJobV2Response describeAutoMLJobV2(
            Consumer<DescribeAutoMlJobV2Request.Builder> describeAutoMlJobV2Request) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        return describeAutoMLJobV2(DescribeAutoMlJobV2Request.builder().applyMutation(describeAutoMlJobV2Request).build());
    }

    /**
     * <p>
     * Retrieves information of a SageMaker HyperPod cluster.
     * </p>
     *
     * @param describeClusterRequest
     * @return Result of the DescribeCluster operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeClusterResponse describeCluster(DescribeClusterRequest describeClusterRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information of a SageMaker HyperPod cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClusterRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeClusterRequest#builder()}
     * </p>
     *
     * @param describeClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeClusterRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeCluster operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeClusterResponse describeCluster(Consumer<DescribeClusterRequest.Builder> describeClusterRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return describeCluster(DescribeClusterRequest.builder().applyMutation(describeClusterRequest).build());
    }

    /**
     * <p>
     * Retrieves information of a node (also called a <i>instance</i> interchangeably) of a SageMaker HyperPod cluster.
     * </p>
     *
     * @param describeClusterNodeRequest
     * @return Result of the DescribeClusterNode operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeClusterNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeClusterNode" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeClusterNodeResponse describeClusterNode(DescribeClusterNodeRequest describeClusterNodeRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information of a node (also called a <i>instance</i> interchangeably) of a SageMaker HyperPod cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClusterNodeRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeClusterNodeRequest#builder()}
     * </p>
     *
     * @param describeClusterNodeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeClusterNodeRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeClusterNode operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeClusterNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeClusterNode" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeClusterNodeResponse describeClusterNode(
            Consumer<DescribeClusterNodeRequest.Builder> describeClusterNodeRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        return describeClusterNode(DescribeClusterNodeRequest.builder().applyMutation(describeClusterNodeRequest).build());
    }

    /**
     * <p>
     * Description of the cluster policy. This policy is used for task prioritization and fair-share allocation. This
     * helps prioritize critical workloads and distributes idle compute across entities.
     * </p>
     *
     * @param describeClusterSchedulerConfigRequest
     * @return Result of the DescribeClusterSchedulerConfig operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeClusterSchedulerConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeClusterSchedulerConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterSchedulerConfigResponse describeClusterSchedulerConfig(
            DescribeClusterSchedulerConfigRequest describeClusterSchedulerConfigRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Description of the cluster policy. This policy is used for task prioritization and fair-share allocation. This
     * helps prioritize critical workloads and distributes idle compute across entities.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClusterSchedulerConfigRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeClusterSchedulerConfigRequest#builder()}
     * </p>
     *
     * @param describeClusterSchedulerConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeClusterSchedulerConfigRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeClusterSchedulerConfig operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeClusterSchedulerConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeClusterSchedulerConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterSchedulerConfigResponse describeClusterSchedulerConfig(
            Consumer<DescribeClusterSchedulerConfigRequest.Builder> describeClusterSchedulerConfigRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return describeClusterSchedulerConfig(DescribeClusterSchedulerConfigRequest.builder()
                .applyMutation(describeClusterSchedulerConfigRequest).build());
    }

    /**
     * <p>
     * Gets details about the specified Git repository.
     * </p>
     *
     * @param describeCodeRepositoryRequest
     * @return Result of the DescribeCodeRepository operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeCodeRepository
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeCodeRepository"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCodeRepositoryResponse describeCodeRepository(DescribeCodeRepositoryRequest describeCodeRepositoryRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details about the specified Git repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCodeRepositoryRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeCodeRepositoryRequest#builder()}
     * </p>
     *
     * @param describeCodeRepositoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeCodeRepositoryRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeCodeRepository operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeCodeRepository
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeCodeRepository"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCodeRepositoryResponse describeCodeRepository(
            Consumer<DescribeCodeRepositoryRequest.Builder> describeCodeRepositoryRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return describeCodeRepository(DescribeCodeRepositoryRequest.builder().applyMutation(describeCodeRepositoryRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about a model compilation job.
     * </p>
     * <p>
     * To create a model compilation job, use <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateCompilationJob.html"
     * >CreateCompilationJob</a>. To get information about multiple model compilation jobs, use <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListCompilationJobs.html"
     * >ListCompilationJobs</a>.
     * </p>
     *
     * @param describeCompilationJobRequest
     * @return Result of the DescribeCompilationJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeCompilationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeCompilationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCompilationJobResponse describeCompilationJob(DescribeCompilationJobRequest describeCompilationJobRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a model compilation job.
     * </p>
     * <p>
     * To create a model compilation job, use <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateCompilationJob.html"
     * >CreateCompilationJob</a>. To get information about multiple model compilation jobs, use <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListCompilationJobs.html"
     * >ListCompilationJobs</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCompilationJobRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeCompilationJobRequest#builder()}
     * </p>
     *
     * @param describeCompilationJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeCompilationJobRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeCompilationJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeCompilationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeCompilationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCompilationJobResponse describeCompilationJob(
            Consumer<DescribeCompilationJobRequest.Builder> describeCompilationJobRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        return describeCompilationJob(DescribeCompilationJobRequest.builder().applyMutation(describeCompilationJobRequest)
                .build());
    }

    /**
     * <p>
     * Description of the compute allocation definition.
     * </p>
     *
     * @param describeComputeQuotaRequest
     * @return Result of the DescribeComputeQuota operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeComputeQuota
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeComputeQuota"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeComputeQuotaResponse describeComputeQuota(DescribeComputeQuotaRequest describeComputeQuotaRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Description of the compute allocation definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeComputeQuotaRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeComputeQuotaRequest#builder()}
     * </p>
     *
     * @param describeComputeQuotaRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeComputeQuotaRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeComputeQuota operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeComputeQuota
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeComputeQuota"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeComputeQuotaResponse describeComputeQuota(
            Consumer<DescribeComputeQuotaRequest.Builder> describeComputeQuotaRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        return describeComputeQuota(DescribeComputeQuotaRequest.builder().applyMutation(describeComputeQuotaRequest).build());
    }

    /**
     * <p>
     * Describes a context.
     * </p>
     *
     * @param describeContextRequest
     * @return Result of the DescribeContext operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeContext
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeContext" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeContextResponse describeContext(DescribeContextRequest describeContextRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a context.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeContextRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeContextRequest#builder()}
     * </p>
     *
     * @param describeContextRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeContextRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeContext operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeContext
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeContext" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeContextResponse describeContext(Consumer<DescribeContextRequest.Builder> describeContextRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return describeContext(DescribeContextRequest.builder().applyMutation(describeContextRequest).build());
    }

    /**
     * <p>
     * Gets the details of a data quality monitoring job definition.
     * </p>
     *
     * @param describeDataQualityJobDefinitionRequest
     * @return Result of the DescribeDataQualityJobDefinition operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeDataQualityJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeDataQualityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDataQualityJobDefinitionResponse describeDataQualityJobDefinition(
            DescribeDataQualityJobDefinitionRequest describeDataQualityJobDefinitionRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the details of a data quality monitoring job definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDataQualityJobDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDataQualityJobDefinitionRequest#builder()}
     * </p>
     *
     * @param describeDataQualityJobDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeDataQualityJobDefinitionRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeDataQualityJobDefinition operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeDataQualityJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeDataQualityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDataQualityJobDefinitionResponse describeDataQualityJobDefinition(
            Consumer<DescribeDataQualityJobDefinitionRequest.Builder> describeDataQualityJobDefinitionRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return describeDataQualityJobDefinition(DescribeDataQualityJobDefinitionRequest.builder()
                .applyMutation(describeDataQualityJobDefinitionRequest).build());
    }

    /**
     * <p>
     * Describes the device.
     * </p>
     *
     * @param describeDeviceRequest
     * @return Result of the DescribeDevice operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDeviceResponse describeDevice(DescribeDeviceRequest describeDeviceRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDeviceRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeDeviceRequest#builder()}
     * </p>
     *
     * @param describeDeviceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeDeviceRequest.Builder} to create a request.
     * @return Result of the DescribeDevice operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDeviceResponse describeDevice(Consumer<DescribeDeviceRequest.Builder> describeDeviceRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return describeDevice(DescribeDeviceRequest.builder().applyMutation(describeDeviceRequest).build());
    }

    /**
     * <p>
     * A description of the fleet the device belongs to.
     * </p>
     *
     * @param describeDeviceFleetRequest
     * @return Result of the DescribeDeviceFleet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeDeviceFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeDeviceFleet" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDeviceFleetResponse describeDeviceFleet(DescribeDeviceFleetRequest describeDeviceFleetRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A description of the fleet the device belongs to.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDeviceFleetRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDeviceFleetRequest#builder()}
     * </p>
     *
     * @param describeDeviceFleetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeDeviceFleetRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeDeviceFleet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeDeviceFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeDeviceFleet" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDeviceFleetResponse describeDeviceFleet(
            Consumer<DescribeDeviceFleetRequest.Builder> describeDeviceFleetRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        return describeDeviceFleet(DescribeDeviceFleetRequest.builder().applyMutation(describeDeviceFleetRequest).build());
    }

    /**
     * <p>
     * The description of the domain.
     * </p>
     *
     * @param describeDomainRequest
     * @return Result of the DescribeDomain operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDomainResponse describeDomain(DescribeDomainRequest describeDomainRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The description of the domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDomainRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeDomainRequest#builder()}
     * </p>
     *
     * @param describeDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeDomainRequest.Builder} to create a request.
     * @return Result of the DescribeDomain operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDomainResponse describeDomain(Consumer<DescribeDomainRequest.Builder> describeDomainRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return describeDomain(DescribeDomainRequest.builder().applyMutation(describeDomainRequest).build());
    }

    /**
     * <p>
     * Describes an edge deployment plan with deployment status per stage.
     * </p>
     *
     * @param describeEdgeDeploymentPlanRequest
     * @return Result of the DescribeEdgeDeploymentPlan operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeEdgeDeploymentPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeEdgeDeploymentPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEdgeDeploymentPlanResponse describeEdgeDeploymentPlan(
            DescribeEdgeDeploymentPlanRequest describeEdgeDeploymentPlanRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an edge deployment plan with deployment status per stage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEdgeDeploymentPlanRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeEdgeDeploymentPlanRequest#builder()}
     * </p>
     *
     * @param describeEdgeDeploymentPlanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeEdgeDeploymentPlanRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeEdgeDeploymentPlan operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeEdgeDeploymentPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeEdgeDeploymentPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEdgeDeploymentPlanResponse describeEdgeDeploymentPlan(
            Consumer<DescribeEdgeDeploymentPlanRequest.Builder> describeEdgeDeploymentPlanRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return describeEdgeDeploymentPlan(DescribeEdgeDeploymentPlanRequest.builder()
                .applyMutation(describeEdgeDeploymentPlanRequest).build());
    }

    /**
     * <p>
     * A description of edge packaging jobs.
     * </p>
     *
     * @param describeEdgePackagingJobRequest
     * @return Result of the DescribeEdgePackagingJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeEdgePackagingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeEdgePackagingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEdgePackagingJobResponse describeEdgePackagingJob(
            DescribeEdgePackagingJobRequest describeEdgePackagingJobRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A description of edge packaging jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEdgePackagingJobRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeEdgePackagingJobRequest#builder()}
     * </p>
     *
     * @param describeEdgePackagingJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeEdgePackagingJobRequest.Builder} to create
     *        a request.
     * @return Result of the DescribeEdgePackagingJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeEdgePackagingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeEdgePackagingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEdgePackagingJobResponse describeEdgePackagingJob(
            Consumer<DescribeEdgePackagingJobRequest.Builder> describeEdgePackagingJobRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        return describeEdgePackagingJob(DescribeEdgePackagingJobRequest.builder().applyMutation(describeEdgePackagingJobRequest)
                .build());
    }

    /**
     * <p>
     * Returns the description of an endpoint.
     * </p>
     *
     * @param describeEndpointRequest
     * @return Result of the DescribeEndpoint operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeEndpointResponse describeEndpoint(DescribeEndpointRequest describeEndpointRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the description of an endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEndpointRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeEndpointRequest#builder()}
     * </p>
     *
     * @param describeEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeEndpointRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeEndpoint operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeEndpointResponse describeEndpoint(Consumer<DescribeEndpointRequest.Builder> describeEndpointRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return describeEndpoint(DescribeEndpointRequest.builder().applyMutation(describeEndpointRequest).build());
    }

    /**
     * <p>
     * Returns the description of an endpoint configuration created using the <code>CreateEndpointConfig</code> API.
     * </p>
     *
     * @param describeEndpointConfigRequest
     * @return Result of the DescribeEndpointConfig operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeEndpointConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeEndpointConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEndpointConfigResponse describeEndpointConfig(DescribeEndpointConfigRequest describeEndpointConfigRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the description of an endpoint configuration created using the <code>CreateEndpointConfig</code> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEndpointConfigRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeEndpointConfigRequest#builder()}
     * </p>
     *
     * @param describeEndpointConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeEndpointConfigRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeEndpointConfig operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeEndpointConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeEndpointConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEndpointConfigResponse describeEndpointConfig(
            Consumer<DescribeEndpointConfigRequest.Builder> describeEndpointConfigRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return describeEndpointConfig(DescribeEndpointConfigRequest.builder().applyMutation(describeEndpointConfigRequest)
                .build());
    }

    /**
     * <p>
     * Provides a list of an experiment's properties.
     * </p>
     *
     * @param describeExperimentRequest
     * @return Result of the DescribeExperiment operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeExperiment" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeExperimentResponse describeExperiment(DescribeExperimentRequest describeExperimentRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of an experiment's properties.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeExperimentRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeExperimentRequest#builder()}
     * </p>
     *
     * @param describeExperimentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeExperimentRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeExperiment operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeExperiment" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeExperimentResponse describeExperiment(Consumer<DescribeExperimentRequest.Builder> describeExperimentRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return describeExperiment(DescribeExperimentRequest.builder().applyMutation(describeExperimentRequest).build());
    }

    /**
     * <p>
     * Use this operation to describe a <code>FeatureGroup</code>. The response includes information on the creation
     * time, <code>FeatureGroup</code> name, the unique identifier for each <code>FeatureGroup</code>, and more.
     * </p>
     *
     * @param describeFeatureGroupRequest
     * @return Result of the DescribeFeatureGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeFeatureGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeFeatureGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFeatureGroupResponse describeFeatureGroup(DescribeFeatureGroupRequest describeFeatureGroupRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this operation to describe a <code>FeatureGroup</code>. The response includes information on the creation
     * time, <code>FeatureGroup</code> name, the unique identifier for each <code>FeatureGroup</code>, and more.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFeatureGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeFeatureGroupRequest#builder()}
     * </p>
     *
     * @param describeFeatureGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeFeatureGroupRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeFeatureGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeFeatureGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeFeatureGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFeatureGroupResponse describeFeatureGroup(
            Consumer<DescribeFeatureGroupRequest.Builder> describeFeatureGroupRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        return describeFeatureGroup(DescribeFeatureGroupRequest.builder().applyMutation(describeFeatureGroupRequest).build());
    }

    /**
     * <p>
     * Shows the metadata for a feature within a feature group.
     * </p>
     *
     * @param describeFeatureMetadataRequest
     * @return Result of the DescribeFeatureMetadata operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeFeatureMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeFeatureMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFeatureMetadataResponse describeFeatureMetadata(DescribeFeatureMetadataRequest describeFeatureMetadataRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Shows the metadata for a feature within a feature group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFeatureMetadataRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeFeatureMetadataRequest#builder()}
     * </p>
     *
     * @param describeFeatureMetadataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeFeatureMetadataRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeFeatureMetadata operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeFeatureMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeFeatureMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFeatureMetadataResponse describeFeatureMetadata(
            Consumer<DescribeFeatureMetadataRequest.Builder> describeFeatureMetadataRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        return describeFeatureMetadata(DescribeFeatureMetadataRequest.builder().applyMutation(describeFeatureMetadataRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about the specified flow definition.
     * </p>
     *
     * @param describeFlowDefinitionRequest
     * @return Result of the DescribeFlowDefinition operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeFlowDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeFlowDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFlowDefinitionResponse describeFlowDefinition(DescribeFlowDefinitionRequest describeFlowDefinitionRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the specified flow definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFlowDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeFlowDefinitionRequest#builder()}
     * </p>
     *
     * @param describeFlowDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeFlowDefinitionRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeFlowDefinition operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeFlowDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeFlowDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFlowDefinitionResponse describeFlowDefinition(
            Consumer<DescribeFlowDefinitionRequest.Builder> describeFlowDefinitionRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        return describeFlowDefinition(DescribeFlowDefinitionRequest.builder().applyMutation(describeFlowDefinitionRequest)
                .build());
    }

    /**
     * <p>
     * Describes a hub.
     * </p>
     *
     * @param describeHubRequest
     * @return Result of the DescribeHub operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeHub
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeHub" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeHubResponse describeHub(DescribeHubRequest describeHubRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a hub.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeHubRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeHubRequest#builder()}
     * </p>
     *
     * @param describeHubRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeHubRequest.Builder} to create a request.
     * @return Result of the DescribeHub operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeHub
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeHub" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeHubResponse describeHub(Consumer<DescribeHubRequest.Builder> describeHubRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return describeHub(DescribeHubRequest.builder().applyMutation(describeHubRequest).build());
    }

    /**
     * <p>
     * Describe the content of a hub.
     * </p>
     *
     * @param describeHubContentRequest
     * @return Result of the DescribeHubContent operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeHubContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeHubContent" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeHubContentResponse describeHubContent(DescribeHubContentRequest describeHubContentRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describe the content of a hub.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeHubContentRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeHubContentRequest#builder()}
     * </p>
     *
     * @param describeHubContentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeHubContentRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeHubContent operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeHubContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeHubContent" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeHubContentResponse describeHubContent(Consumer<DescribeHubContentRequest.Builder> describeHubContentRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return describeHubContent(DescribeHubContentRequest.builder().applyMutation(describeHubContentRequest).build());
    }

    /**
     * <p>
     * Returns information about the requested human task user interface (worker task template).
     * </p>
     *
     * @param describeHumanTaskUiRequest
     * @return Result of the DescribeHumanTaskUi operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeHumanTaskUi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeHumanTaskUi" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeHumanTaskUiResponse describeHumanTaskUi(DescribeHumanTaskUiRequest describeHumanTaskUiRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the requested human task user interface (worker task template).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeHumanTaskUiRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeHumanTaskUiRequest#builder()}
     * </p>
     *
     * @param describeHumanTaskUiRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeHumanTaskUiRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeHumanTaskUi operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeHumanTaskUi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeHumanTaskUi" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeHumanTaskUiResponse describeHumanTaskUi(
            Consumer<DescribeHumanTaskUiRequest.Builder> describeHumanTaskUiRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        return describeHumanTaskUi(DescribeHumanTaskUiRequest.builder().applyMutation(describeHumanTaskUiRequest).build());
    }

    /**
     * <p>
     * Returns a description of a hyperparameter tuning job, depending on the fields selected. These fields can include
     * the name, Amazon Resource Name (ARN), job status of your tuning job and more.
     * </p>
     *
     * @param describeHyperParameterTuningJobRequest
     * @return Result of the DescribeHyperParameterTuningJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeHyperParameterTuningJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeHyperParameterTuningJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeHyperParameterTuningJobResponse describeHyperParameterTuningJob(
            DescribeHyperParameterTuningJobRequest describeHyperParameterTuningJobRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a description of a hyperparameter tuning job, depending on the fields selected. These fields can include
     * the name, Amazon Resource Name (ARN), job status of your tuning job and more.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeHyperParameterTuningJobRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeHyperParameterTuningJobRequest#builder()}
     * </p>
     *
     * @param describeHyperParameterTuningJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeHyperParameterTuningJobRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeHyperParameterTuningJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeHyperParameterTuningJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeHyperParameterTuningJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeHyperParameterTuningJobResponse describeHyperParameterTuningJob(
            Consumer<DescribeHyperParameterTuningJobRequest.Builder> describeHyperParameterTuningJobRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return describeHyperParameterTuningJob(DescribeHyperParameterTuningJobRequest.builder()
                .applyMutation(describeHyperParameterTuningJobRequest).build());
    }

    /**
     * <p>
     * Describes a SageMaker AI image.
     * </p>
     *
     * @param describeImageRequest
     * @return Result of the DescribeImage operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeImage" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeImageResponse describeImage(DescribeImageRequest describeImageRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a SageMaker AI image.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeImageRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeImageRequest#builder()}
     * </p>
     *
     * @param describeImageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeImageRequest.Builder} to create a request.
     * @return Result of the DescribeImage operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeImage" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeImageResponse describeImage(Consumer<DescribeImageRequest.Builder> describeImageRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return describeImage(DescribeImageRequest.builder().applyMutation(describeImageRequest).build());
    }

    /**
     * <p>
     * Describes a version of a SageMaker AI image.
     * </p>
     *
     * @param describeImageVersionRequest
     * @return Result of the DescribeImageVersion operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeImageVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeImageVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeImageVersionResponse describeImageVersion(DescribeImageVersionRequest describeImageVersionRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a version of a SageMaker AI image.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeImageVersionRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeImageVersionRequest#builder()}
     * </p>
     *
     * @param describeImageVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeImageVersionRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeImageVersion operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeImageVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeImageVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeImageVersionResponse describeImageVersion(
            Consumer<DescribeImageVersionRequest.Builder> describeImageVersionRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        return describeImageVersion(DescribeImageVersionRequest.builder().applyMutation(describeImageVersionRequest).build());
    }

    /**
     * <p>
     * Returns information about an inference component.
     * </p>
     *
     * @param describeInferenceComponentRequest
     * @return Result of the DescribeInferenceComponent operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeInferenceComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeInferenceComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInferenceComponentResponse describeInferenceComponent(
            DescribeInferenceComponentRequest describeInferenceComponentRequest) throws AwsServiceException, SdkClientException,
            SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about an inference component.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInferenceComponentRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeInferenceComponentRequest#builder()}
     * </p>
     *
     * @param describeInferenceComponentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeInferenceComponentRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeInferenceComponent operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeInferenceComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeInferenceComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInferenceComponentResponse describeInferenceComponent(
            Consumer<DescribeInferenceComponentRequest.Builder> describeInferenceComponentRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return describeInferenceComponent(DescribeInferenceComponentRequest.builder()
                .applyMutation(describeInferenceComponentRequest).build());
    }

    /**
     * <p>
     * Returns details about an inference experiment.
     * </p>
     *
     * @param describeInferenceExperimentRequest
     * @return Result of the DescribeInferenceExperiment operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeInferenceExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeInferenceExperiment"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInferenceExperimentResponse describeInferenceExperiment(
            DescribeInferenceExperimentRequest describeInferenceExperimentRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details about an inference experiment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInferenceExperimentRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeInferenceExperimentRequest#builder()}
     * </p>
     *
     * @param describeInferenceExperimentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeInferenceExperimentRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeInferenceExperiment operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeInferenceExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeInferenceExperiment"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInferenceExperimentResponse describeInferenceExperiment(
            Consumer<DescribeInferenceExperimentRequest.Builder> describeInferenceExperimentRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return describeInferenceExperiment(DescribeInferenceExperimentRequest.builder()
                .applyMutation(describeInferenceExperimentRequest).build());
    }

    /**
     * <p>
     * Provides the results of the Inference Recommender job. One or more recommendation jobs are returned.
     * </p>
     *
     * @param describeInferenceRecommendationsJobRequest
     * @return Result of the DescribeInferenceRecommendationsJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeInferenceRecommendationsJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeInferenceRecommendationsJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInferenceRecommendationsJobResponse describeInferenceRecommendationsJob(
            DescribeInferenceRecommendationsJobRequest describeInferenceRecommendationsJobRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides the results of the Inference Recommender job. One or more recommendation jobs are returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInferenceRecommendationsJobRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeInferenceRecommendationsJobRequest#builder()}
     * </p>
     *
     * @param describeInferenceRecommendationsJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeInferenceRecommendationsJobRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeInferenceRecommendationsJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeInferenceRecommendationsJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeInferenceRecommendationsJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInferenceRecommendationsJobResponse describeInferenceRecommendationsJob(
            Consumer<DescribeInferenceRecommendationsJobRequest.Builder> describeInferenceRecommendationsJobRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return describeInferenceRecommendationsJob(DescribeInferenceRecommendationsJobRequest.builder()
                .applyMutation(describeInferenceRecommendationsJobRequest).build());
    }

    /**
     * <p>
     * Gets information about a labeling job.
     * </p>
     *
     * @param describeLabelingJobRequest
     * @return Result of the DescribeLabelingJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeLabelingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeLabelingJob" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeLabelingJobResponse describeLabelingJob(DescribeLabelingJobRequest describeLabelingJobRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a labeling job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLabelingJobRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeLabelingJobRequest#builder()}
     * </p>
     *
     * @param describeLabelingJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeLabelingJobRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeLabelingJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeLabelingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeLabelingJob" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeLabelingJobResponse describeLabelingJob(
            Consumer<DescribeLabelingJobRequest.Builder> describeLabelingJobRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        return describeLabelingJob(DescribeLabelingJobRequest.builder().applyMutation(describeLabelingJobRequest).build());
    }

    /**
     * <p>
     * Provides a list of properties for the requested lineage group. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/xaccount-lineage-tracking.html"> Cross-Account Lineage
     * Tracking </a> in the <i>Amazon SageMaker Developer Guide</i>.
     * </p>
     *
     * @param describeLineageGroupRequest
     * @return Result of the DescribeLineageGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeLineageGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeLineageGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLineageGroupResponse describeLineageGroup(DescribeLineageGroupRequest describeLineageGroupRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of properties for the requested lineage group. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/xaccount-lineage-tracking.html"> Cross-Account Lineage
     * Tracking </a> in the <i>Amazon SageMaker Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLineageGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeLineageGroupRequest#builder()}
     * </p>
     *
     * @param describeLineageGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeLineageGroupRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeLineageGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeLineageGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeLineageGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLineageGroupResponse describeLineageGroup(
            Consumer<DescribeLineageGroupRequest.Builder> describeLineageGroupRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        return describeLineageGroup(DescribeLineageGroupRequest.builder().applyMutation(describeLineageGroupRequest).build());
    }

    /**
     * <p>
     * Returns information about an MLflow Tracking Server.
     * </p>
     *
     * @param describeMlflowTrackingServerRequest
     * @return Result of the DescribeMlflowTrackingServer operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeMlflowTrackingServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeMlflowTrackingServer"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMlflowTrackingServerResponse describeMlflowTrackingServer(
            DescribeMlflowTrackingServerRequest describeMlflowTrackingServerRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about an MLflow Tracking Server.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMlflowTrackingServerRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeMlflowTrackingServerRequest#builder()}
     * </p>
     *
     * @param describeMlflowTrackingServerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeMlflowTrackingServerRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeMlflowTrackingServer operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeMlflowTrackingServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeMlflowTrackingServer"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMlflowTrackingServerResponse describeMlflowTrackingServer(
            Consumer<DescribeMlflowTrackingServerRequest.Builder> describeMlflowTrackingServerRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return describeMlflowTrackingServer(DescribeMlflowTrackingServerRequest.builder()
                .applyMutation(describeMlflowTrackingServerRequest).build());
    }

    /**
     * <p>
     * Describes a model that you created using the <code>CreateModel</code> API.
     * </p>
     *
     * @param describeModelRequest
     * @return Result of the DescribeModel operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModel" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeModelResponse describeModel(DescribeModelRequest describeModelRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a model that you created using the <code>CreateModel</code> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeModelRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeModelRequest#builder()}
     * </p>
     *
     * @param describeModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeModelRequest.Builder} to create a request.
     * @return Result of the DescribeModel operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModel" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeModelResponse describeModel(Consumer<DescribeModelRequest.Builder> describeModelRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return describeModel(DescribeModelRequest.builder().applyMutation(describeModelRequest).build());
    }

    /**
     * <p>
     * Returns a description of a model bias job definition.
     * </p>
     *
     * @param describeModelBiasJobDefinitionRequest
     * @return Result of the DescribeModelBiasJobDefinition operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeModelBiasJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelBiasJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeModelBiasJobDefinitionResponse describeModelBiasJobDefinition(
            DescribeModelBiasJobDefinitionRequest describeModelBiasJobDefinitionRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a description of a model bias job definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeModelBiasJobDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeModelBiasJobDefinitionRequest#builder()}
     * </p>
     *
     * @param describeModelBiasJobDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeModelBiasJobDefinitionRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeModelBiasJobDefinition operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeModelBiasJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelBiasJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeModelBiasJobDefinitionResponse describeModelBiasJobDefinition(
            Consumer<DescribeModelBiasJobDefinitionRequest.Builder> describeModelBiasJobDefinitionRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return describeModelBiasJobDefinition(DescribeModelBiasJobDefinitionRequest.builder()
                .applyMutation(describeModelBiasJobDefinitionRequest).build());
    }

    /**
     * <p>
     * Describes the content, creation time, and security configuration of an Amazon SageMaker Model Card.
     * </p>
     *
     * @param describeModelCardRequest
     * @return Result of the DescribeModelCard operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeModelCard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelCard" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeModelCardResponse describeModelCard(DescribeModelCardRequest describeModelCardRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the content, creation time, and security configuration of an Amazon SageMaker Model Card.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeModelCardRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeModelCardRequest#builder()}
     * </p>
     *
     * @param describeModelCardRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeModelCardRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeModelCard operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeModelCard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelCard" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeModelCardResponse describeModelCard(Consumer<DescribeModelCardRequest.Builder> describeModelCardRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return describeModelCard(DescribeModelCardRequest.builder().applyMutation(describeModelCardRequest).build());
    }

    /**
     * <p>
     * Describes an Amazon SageMaker Model Card export job.
     * </p>
     *
     * @param describeModelCardExportJobRequest
     * @return Result of the DescribeModelCardExportJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeModelCardExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelCardExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeModelCardExportJobResponse describeModelCardExportJob(
            DescribeModelCardExportJobRequest describeModelCardExportJobRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an Amazon SageMaker Model Card export job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeModelCardExportJobRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeModelCardExportJobRequest#builder()}
     * </p>
     *
     * @param describeModelCardExportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeModelCardExportJobRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeModelCardExportJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeModelCardExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelCardExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeModelCardExportJobResponse describeModelCardExportJob(
            Consumer<DescribeModelCardExportJobRequest.Builder> describeModelCardExportJobRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return describeModelCardExportJob(DescribeModelCardExportJobRequest.builder()
                .applyMutation(describeModelCardExportJobRequest).build());
    }

    /**
     * <p>
     * Returns a description of a model explainability job definition.
     * </p>
     *
     * @param describeModelExplainabilityJobDefinitionRequest
     * @return Result of the DescribeModelExplainabilityJobDefinition operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeModelExplainabilityJobDefinition
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelExplainabilityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeModelExplainabilityJobDefinitionResponse describeModelExplainabilityJobDefinition(
            DescribeModelExplainabilityJobDefinitionRequest describeModelExplainabilityJobDefinitionRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a description of a model explainability job definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeModelExplainabilityJobDefinitionRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeModelExplainabilityJobDefinitionRequest#builder()}
     * </p>
     *
     * @param describeModelExplainabilityJobDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeModelExplainabilityJobDefinitionRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeModelExplainabilityJobDefinition operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeModelExplainabilityJobDefinition
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelExplainabilityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeModelExplainabilityJobDefinitionResponse describeModelExplainabilityJobDefinition(
            Consumer<DescribeModelExplainabilityJobDefinitionRequest.Builder> describeModelExplainabilityJobDefinitionRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return describeModelExplainabilityJobDefinition(DescribeModelExplainabilityJobDefinitionRequest.builder()
                .applyMutation(describeModelExplainabilityJobDefinitionRequest).build());
    }

    /**
     * <p>
     * Returns a description of the specified model package, which is used to create SageMaker models or list them on
     * Amazon Web Services Marketplace.
     * </p>
     * <important>
     * <p>
     * If you provided a KMS Key ID when you created your model package, you will see the <a
     * href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Decrypt.html">KMS Decrypt</a> API call in your
     * CloudTrail logs when you use this API.
     * </p>
     * </important>
     * <p>
     * To create models in SageMaker, buyers can subscribe to model packages listed on Amazon Web Services Marketplace.
     * </p>
     *
     * @param describeModelPackageRequest
     * @return Result of the DescribeModelPackage operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeModelPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelPackage"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeModelPackageResponse describeModelPackage(DescribeModelPackageRequest describeModelPackageRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a description of the specified model package, which is used to create SageMaker models or list them on
     * Amazon Web Services Marketplace.
     * </p>
     * <important>
     * <p>
     * If you provided a KMS Key ID when you created your model package, you will see the <a
     * href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Decrypt.html">KMS Decrypt</a> API call in your
     * CloudTrail logs when you use this API.
     * </p>
     * </important>
     * <p>
     * To create models in SageMaker, buyers can subscribe to model packages listed on Amazon Web Services Marketplace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeModelPackageRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeModelPackageRequest#builder()}
     * </p>
     *
     * @param describeModelPackageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeModelPackageRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeModelPackage operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeModelPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelPackage"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeModelPackageResponse describeModelPackage(
            Consumer<DescribeModelPackageRequest.Builder> describeModelPackageRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return describeModelPackage(DescribeModelPackageRequest.builder().applyMutation(describeModelPackageRequest).build());
    }

    /**
     * <p>
     * Gets a description for the specified model group.
     * </p>
     *
     * @param describeModelPackageGroupRequest
     * @return Result of the DescribeModelPackageGroup operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeModelPackageGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelPackageGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeModelPackageGroupResponse describeModelPackageGroup(
            DescribeModelPackageGroupRequest describeModelPackageGroupRequest) throws AwsServiceException, SdkClientException,
            SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a description for the specified model group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeModelPackageGroupRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeModelPackageGroupRequest#builder()}
     * </p>
     *
     * @param describeModelPackageGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeModelPackageGroupRequest.Builder} to create
     *        a request.
     * @return Result of the DescribeModelPackageGroup operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeModelPackageGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelPackageGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeModelPackageGroupResponse describeModelPackageGroup(
            Consumer<DescribeModelPackageGroupRequest.Builder> describeModelPackageGroupRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return describeModelPackageGroup(DescribeModelPackageGroupRequest.builder()
                .applyMutation(describeModelPackageGroupRequest).build());
    }

    /**
     * <p>
     * Returns a description of a model quality job definition.
     * </p>
     *
     * @param describeModelQualityJobDefinitionRequest
     * @return Result of the DescribeModelQualityJobDefinition operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeModelQualityJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelQualityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeModelQualityJobDefinitionResponse describeModelQualityJobDefinition(
            DescribeModelQualityJobDefinitionRequest describeModelQualityJobDefinitionRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a description of a model quality job definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeModelQualityJobDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeModelQualityJobDefinitionRequest#builder()}
     * </p>
     *
     * @param describeModelQualityJobDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeModelQualityJobDefinitionRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeModelQualityJobDefinition operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeModelQualityJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelQualityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeModelQualityJobDefinitionResponse describeModelQualityJobDefinition(
            Consumer<DescribeModelQualityJobDefinitionRequest.Builder> describeModelQualityJobDefinitionRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return describeModelQualityJobDefinition(DescribeModelQualityJobDefinitionRequest.builder()
                .applyMutation(describeModelQualityJobDefinitionRequest).build());
    }

    /**
     * <p>
     * Describes the schedule for a monitoring job.
     * </p>
     *
     * @param describeMonitoringScheduleRequest
     * @return Result of the DescribeMonitoringSchedule operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeMonitoringSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeMonitoringSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMonitoringScheduleResponse describeMonitoringSchedule(
            DescribeMonitoringScheduleRequest describeMonitoringScheduleRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the schedule for a monitoring job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMonitoringScheduleRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeMonitoringScheduleRequest#builder()}
     * </p>
     *
     * @param describeMonitoringScheduleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeMonitoringScheduleRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeMonitoringSchedule operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeMonitoringSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeMonitoringSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMonitoringScheduleResponse describeMonitoringSchedule(
            Consumer<DescribeMonitoringScheduleRequest.Builder> describeMonitoringScheduleRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return describeMonitoringSchedule(DescribeMonitoringScheduleRequest.builder()
                .applyMutation(describeMonitoringScheduleRequest).build());
    }

    /**
     * <p>
     * Returns information about a notebook instance.
     * </p>
     *
     * @param describeNotebookInstanceRequest
     * @return Result of the DescribeNotebookInstance operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeNotebookInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeNotebookInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeNotebookInstanceResponse describeNotebookInstance(
            DescribeNotebookInstanceRequest describeNotebookInstanceRequest) throws AwsServiceException, SdkClientException,
            SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a notebook instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeNotebookInstanceRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeNotebookInstanceRequest#builder()}
     * </p>
     *
     * @param describeNotebookInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceRequest.Builder} to create
     *        a request.
     * @return Result of the DescribeNotebookInstance operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeNotebookInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeNotebookInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeNotebookInstanceResponse describeNotebookInstance(
            Consumer<DescribeNotebookInstanceRequest.Builder> describeNotebookInstanceRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return describeNotebookInstance(DescribeNotebookInstanceRequest.builder().applyMutation(describeNotebookInstanceRequest)
                .build());
    }

    /**
     * <p>
     * Returns a description of a notebook instance lifecycle configuration.
     * </p>
     * <p>
     * For information about notebook instance lifestyle configurations, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional)
     * Customize a Notebook Instance</a>.
     * </p>
     *
     * @param describeNotebookInstanceLifecycleConfigRequest
     * @return Result of the DescribeNotebookInstanceLifecycleConfig operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeNotebookInstanceLifecycleConfig
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeNotebookInstanceLifecycleConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeNotebookInstanceLifecycleConfigResponse describeNotebookInstanceLifecycleConfig(
            DescribeNotebookInstanceLifecycleConfigRequest describeNotebookInstanceLifecycleConfigRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a description of a notebook instance lifecycle configuration.
     * </p>
     * <p>
     * For information about notebook instance lifestyle configurations, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional)
     * Customize a Notebook Instance</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeNotebookInstanceLifecycleConfigRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeNotebookInstanceLifecycleConfigRequest#builder()}
     * </p>
     *
     * @param describeNotebookInstanceLifecycleConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceLifecycleConfigRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeNotebookInstanceLifecycleConfig operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeNotebookInstanceLifecycleConfig
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeNotebookInstanceLifecycleConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeNotebookInstanceLifecycleConfigResponse describeNotebookInstanceLifecycleConfig(
            Consumer<DescribeNotebookInstanceLifecycleConfigRequest.Builder> describeNotebookInstanceLifecycleConfigRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return describeNotebookInstanceLifecycleConfig(DescribeNotebookInstanceLifecycleConfigRequest.builder()
                .applyMutation(describeNotebookInstanceLifecycleConfigRequest).build());
    }

    /**
     * <p>
     * Provides the properties of the specified optimization job.
     * </p>
     *
     * @param describeOptimizationJobRequest
     * @return Result of the DescribeOptimizationJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeOptimizationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeOptimizationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOptimizationJobResponse describeOptimizationJob(DescribeOptimizationJobRequest describeOptimizationJobRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides the properties of the specified optimization job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOptimizationJobRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeOptimizationJobRequest#builder()}
     * </p>
     *
     * @param describeOptimizationJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeOptimizationJobRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeOptimizationJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeOptimizationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeOptimizationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOptimizationJobResponse describeOptimizationJob(
            Consumer<DescribeOptimizationJobRequest.Builder> describeOptimizationJobRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        return describeOptimizationJob(DescribeOptimizationJobRequest.builder().applyMutation(describeOptimizationJobRequest)
                .build());
    }

    /**
     * <p>
     * Gets information about a SageMaker Partner AI App.
     * </p>
     *
     * @param describePartnerAppRequest
     * @return Result of the DescribePartnerApp operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribePartnerApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribePartnerApp" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribePartnerAppResponse describePartnerApp(DescribePartnerAppRequest describePartnerAppRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a SageMaker Partner AI App.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePartnerAppRequest.Builder} avoiding the
     * need to create one manually via {@link DescribePartnerAppRequest#builder()}
     * </p>
     *
     * @param describePartnerAppRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribePartnerAppRequest.Builder} to create a
     *        request.
     * @return Result of the DescribePartnerApp operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribePartnerApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribePartnerApp" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribePartnerAppResponse describePartnerApp(Consumer<DescribePartnerAppRequest.Builder> describePartnerAppRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return describePartnerApp(DescribePartnerAppRequest.builder().applyMutation(describePartnerAppRequest).build());
    }

    /**
     * <p>
     * Describes the details of a pipeline.
     * </p>
     *
     * @param describePipelineRequest
     * @return Result of the DescribePipeline operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribePipeline" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribePipelineResponse describePipeline(DescribePipelineRequest describePipelineRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the details of a pipeline.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePipelineRequest.Builder} avoiding the need
     * to create one manually via {@link DescribePipelineRequest#builder()}
     * </p>
     *
     * @param describePipelineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribePipelineRequest.Builder} to create a
     *        request.
     * @return Result of the DescribePipeline operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribePipeline" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribePipelineResponse describePipeline(Consumer<DescribePipelineRequest.Builder> describePipelineRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return describePipeline(DescribePipelineRequest.builder().applyMutation(describePipelineRequest).build());
    }

    /**
     * <p>
     * Describes the details of an execution's pipeline definition.
     * </p>
     *
     * @param describePipelineDefinitionForExecutionRequest
     * @return Result of the DescribePipelineDefinitionForExecution operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribePipelineDefinitionForExecution
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribePipelineDefinitionForExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePipelineDefinitionForExecutionResponse describePipelineDefinitionForExecution(
            DescribePipelineDefinitionForExecutionRequest describePipelineDefinitionForExecutionRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the details of an execution's pipeline definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribePipelineDefinitionForExecutionRequest.Builder} avoiding the need to create one manually via
     * {@link DescribePipelineDefinitionForExecutionRequest#builder()}
     * </p>
     *
     * @param describePipelineDefinitionForExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribePipelineDefinitionForExecutionRequest.Builder}
     *        to create a request.
     * @return Result of the DescribePipelineDefinitionForExecution operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribePipelineDefinitionForExecution
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribePipelineDefinitionForExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePipelineDefinitionForExecutionResponse describePipelineDefinitionForExecution(
            Consumer<DescribePipelineDefinitionForExecutionRequest.Builder> describePipelineDefinitionForExecutionRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return describePipelineDefinitionForExecution(DescribePipelineDefinitionForExecutionRequest.builder()
                .applyMutation(describePipelineDefinitionForExecutionRequest).build());
    }

    /**
     * <p>
     * Describes the details of a pipeline execution.
     * </p>
     *
     * @param describePipelineExecutionRequest
     * @return Result of the DescribePipelineExecution operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribePipelineExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribePipelineExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePipelineExecutionResponse describePipelineExecution(
            DescribePipelineExecutionRequest describePipelineExecutionRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the details of a pipeline execution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePipelineExecutionRequest.Builder} avoiding
     * the need to create one manually via {@link DescribePipelineExecutionRequest#builder()}
     * </p>
     *
     * @param describePipelineExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribePipelineExecutionRequest.Builder} to create
     *        a request.
     * @return Result of the DescribePipelineExecution operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribePipelineExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribePipelineExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePipelineExecutionResponse describePipelineExecution(
            Consumer<DescribePipelineExecutionRequest.Builder> describePipelineExecutionRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return describePipelineExecution(DescribePipelineExecutionRequest.builder()
                .applyMutation(describePipelineExecutionRequest).build());
    }

    /**
     * <p>
     * Returns a description of a processing job.
     * </p>
     *
     * @param describeProcessingJobRequest
     * @return Result of the DescribeProcessingJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeProcessingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeProcessingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeProcessingJobResponse describeProcessingJob(DescribeProcessingJobRequest describeProcessingJobRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a description of a processing job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProcessingJobRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeProcessingJobRequest#builder()}
     * </p>
     *
     * @param describeProcessingJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeProcessingJobRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeProcessingJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeProcessingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeProcessingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeProcessingJobResponse describeProcessingJob(
            Consumer<DescribeProcessingJobRequest.Builder> describeProcessingJobRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        return describeProcessingJob(DescribeProcessingJobRequest.builder().applyMutation(describeProcessingJobRequest).build());
    }

    /**
     * <p>
     * Describes the details of a project.
     * </p>
     *
     * @param describeProjectRequest
     * @return Result of the DescribeProject operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeProject" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeProjectResponse describeProject(DescribeProjectRequest describeProjectRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the details of a project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProjectRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeProjectRequest#builder()}
     * </p>
     *
     * @param describeProjectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeProjectRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeProject operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeProject" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeProjectResponse describeProject(Consumer<DescribeProjectRequest.Builder> describeProjectRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return describeProject(DescribeProjectRequest.builder().applyMutation(describeProjectRequest).build());
    }

    /**
     * <p>
     * Describes the space.
     * </p>
     *
     * @param describeSpaceRequest
     * @return Result of the DescribeSpace operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeSpace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeSpace" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeSpaceResponse describeSpace(DescribeSpaceRequest describeSpaceRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the space.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSpaceRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeSpaceRequest#builder()}
     * </p>
     *
     * @param describeSpaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeSpaceRequest.Builder} to create a request.
     * @return Result of the DescribeSpace operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeSpace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeSpace" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeSpaceResponse describeSpace(Consumer<DescribeSpaceRequest.Builder> describeSpaceRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return describeSpace(DescribeSpaceRequest.builder().applyMutation(describeSpaceRequest).build());
    }

    /**
     * <p>
     * Describes the Amazon SageMaker AI Studio Lifecycle Configuration.
     * </p>
     *
     * @param describeStudioLifecycleConfigRequest
     * @return Result of the DescribeStudioLifecycleConfig operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeStudioLifecycleConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeStudioLifecycleConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStudioLifecycleConfigResponse describeStudioLifecycleConfig(
            DescribeStudioLifecycleConfigRequest describeStudioLifecycleConfigRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the Amazon SageMaker AI Studio Lifecycle Configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStudioLifecycleConfigRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeStudioLifecycleConfigRequest#builder()}
     * </p>
     *
     * @param describeStudioLifecycleConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeStudioLifecycleConfigRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeStudioLifecycleConfig operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeStudioLifecycleConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeStudioLifecycleConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStudioLifecycleConfigResponse describeStudioLifecycleConfig(
            Consumer<DescribeStudioLifecycleConfigRequest.Builder> describeStudioLifecycleConfigRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return describeStudioLifecycleConfig(DescribeStudioLifecycleConfigRequest.builder()
                .applyMutation(describeStudioLifecycleConfigRequest).build());
    }

    /**
     * <p>
     * Gets information about a work team provided by a vendor. It returns details about the subscription with a vendor
     * in the Amazon Web Services Marketplace.
     * </p>
     *
     * @param describeSubscribedWorkteamRequest
     * @return Result of the DescribeSubscribedWorkteam operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeSubscribedWorkteam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeSubscribedWorkteam"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSubscribedWorkteamResponse describeSubscribedWorkteam(
            DescribeSubscribedWorkteamRequest describeSubscribedWorkteamRequest) throws AwsServiceException, SdkClientException,
            SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a work team provided by a vendor. It returns details about the subscription with a vendor
     * in the Amazon Web Services Marketplace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSubscribedWorkteamRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeSubscribedWorkteamRequest#builder()}
     * </p>
     *
     * @param describeSubscribedWorkteamRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeSubscribedWorkteamRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeSubscribedWorkteam operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeSubscribedWorkteam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeSubscribedWorkteam"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSubscribedWorkteamResponse describeSubscribedWorkteam(
            Consumer<DescribeSubscribedWorkteamRequest.Builder> describeSubscribedWorkteamRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return describeSubscribedWorkteam(DescribeSubscribedWorkteamRequest.builder()
                .applyMutation(describeSubscribedWorkteamRequest).build());
    }

    /**
     * <p>
     * Returns information about a training job.
     * </p>
     * <p>
     * Some of the attributes below only appear if the training job successfully starts. If the training job fails,
     * <code>TrainingJobStatus</code> is <code>Failed</code> and, depending on the <code>FailureReason</code>,
     * attributes like <code>TrainingStartTime</code>, <code>TrainingTimeInSeconds</code>, <code>TrainingEndTime</code>,
     * and <code>BillableTimeInSeconds</code> may not be present in the response.
     * </p>
     *
     * @param describeTrainingJobRequest
     * @return Result of the DescribeTrainingJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeTrainingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTrainingJob" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeTrainingJobResponse describeTrainingJob(DescribeTrainingJobRequest describeTrainingJobRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a training job.
     * </p>
     * <p>
     * Some of the attributes below only appear if the training job successfully starts. If the training job fails,
     * <code>TrainingJobStatus</code> is <code>Failed</code> and, depending on the <code>FailureReason</code>,
     * attributes like <code>TrainingStartTime</code>, <code>TrainingTimeInSeconds</code>, <code>TrainingEndTime</code>,
     * and <code>BillableTimeInSeconds</code> may not be present in the response.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTrainingJobRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeTrainingJobRequest#builder()}
     * </p>
     *
     * @param describeTrainingJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeTrainingJobRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeTrainingJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeTrainingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTrainingJob" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeTrainingJobResponse describeTrainingJob(
            Consumer<DescribeTrainingJobRequest.Builder> describeTrainingJobRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        return describeTrainingJob(DescribeTrainingJobRequest.builder().applyMutation(describeTrainingJobRequest).build());
    }

    /**
     * <p>
     * Retrieves detailed information about a specific training plan.
     * </p>
     *
     * @param describeTrainingPlanRequest
     * @return Result of the DescribeTrainingPlan operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeTrainingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTrainingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTrainingPlanResponse describeTrainingPlan(DescribeTrainingPlanRequest describeTrainingPlanRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves detailed information about a specific training plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTrainingPlanRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeTrainingPlanRequest#builder()}
     * </p>
     *
     * @param describeTrainingPlanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeTrainingPlanRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeTrainingPlan operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeTrainingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTrainingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTrainingPlanResponse describeTrainingPlan(
            Consumer<DescribeTrainingPlanRequest.Builder> describeTrainingPlanRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        return describeTrainingPlan(DescribeTrainingPlanRequest.builder().applyMutation(describeTrainingPlanRequest).build());
    }

    /**
     * <p>
     * Returns information about a transform job.
     * </p>
     *
     * @param describeTransformJobRequest
     * @return Result of the DescribeTransformJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeTransformJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTransformJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTransformJobResponse describeTransformJob(DescribeTransformJobRequest describeTransformJobRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a transform job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTransformJobRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeTransformJobRequest#builder()}
     * </p>
     *
     * @param describeTransformJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeTransformJobRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeTransformJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeTransformJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTransformJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTransformJobResponse describeTransformJob(
            Consumer<DescribeTransformJobRequest.Builder> describeTransformJobRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        return describeTransformJob(DescribeTransformJobRequest.builder().applyMutation(describeTransformJobRequest).build());
    }

    /**
     * <p>
     * Provides a list of a trial's properties.
     * </p>
     *
     * @param describeTrialRequest
     * @return Result of the DescribeTrial operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeTrial
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTrial" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeTrialResponse describeTrial(DescribeTrialRequest describeTrialRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of a trial's properties.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTrialRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeTrialRequest#builder()}
     * </p>
     *
     * @param describeTrialRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeTrialRequest.Builder} to create a request.
     * @return Result of the DescribeTrial operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeTrial
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTrial" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeTrialResponse describeTrial(Consumer<DescribeTrialRequest.Builder> describeTrialRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return describeTrial(DescribeTrialRequest.builder().applyMutation(describeTrialRequest).build());
    }

    /**
     * <p>
     * Provides a list of a trials component's properties.
     * </p>
     *
     * @param describeTrialComponentRequest
     * @return Result of the DescribeTrialComponent operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeTrialComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTrialComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTrialComponentResponse describeTrialComponent(DescribeTrialComponentRequest describeTrialComponentRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of a trials component's properties.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTrialComponentRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeTrialComponentRequest#builder()}
     * </p>
     *
     * @param describeTrialComponentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeTrialComponentRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeTrialComponent operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeTrialComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTrialComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTrialComponentResponse describeTrialComponent(
            Consumer<DescribeTrialComponentRequest.Builder> describeTrialComponentRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        return describeTrialComponent(DescribeTrialComponentRequest.builder().applyMutation(describeTrialComponentRequest)
                .build());
    }

    /**
     * <p>
     * Describes a user profile. For more information, see <code>CreateUserProfile</code>.
     * </p>
     *
     * @param describeUserProfileRequest
     * @return Result of the DescribeUserProfile operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeUserProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeUserProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeUserProfileResponse describeUserProfile(DescribeUserProfileRequest describeUserProfileRequest)
            throws ResourceNotFoundException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a user profile. For more information, see <code>CreateUserProfile</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUserProfileRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeUserProfileRequest#builder()}
     * </p>
     *
     * @param describeUserProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeUserProfileRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeUserProfile operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeUserProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeUserProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeUserProfileResponse describeUserProfile(
            Consumer<DescribeUserProfileRequest.Builder> describeUserProfileRequest) throws ResourceNotFoundException,
            ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        return describeUserProfile(DescribeUserProfileRequest.builder().applyMutation(describeUserProfileRequest).build());
    }

    /**
     * <p>
     * Lists private workforce information, including workforce name, Amazon Resource Name (ARN), and, if applicable,
     * allowed IP address ranges (<a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">CIDRs</a>). Allowable IP address ranges
     * are the IP addresses that workers can use to access tasks.
     * </p>
     * <important>
     * <p>
     * This operation applies only to private workforces.
     * </p>
     * </important>
     *
     * @param describeWorkforceRequest
     * @return Result of the DescribeWorkforce operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeWorkforce
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeWorkforce" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeWorkforceResponse describeWorkforce(DescribeWorkforceRequest describeWorkforceRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists private workforce information, including workforce name, Amazon Resource Name (ARN), and, if applicable,
     * allowed IP address ranges (<a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">CIDRs</a>). Allowable IP address ranges
     * are the IP addresses that workers can use to access tasks.
     * </p>
     * <important>
     * <p>
     * This operation applies only to private workforces.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorkforceRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeWorkforceRequest#builder()}
     * </p>
     *
     * @param describeWorkforceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeWorkforceRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeWorkforce operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeWorkforce
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeWorkforce" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeWorkforceResponse describeWorkforce(Consumer<DescribeWorkforceRequest.Builder> describeWorkforceRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return describeWorkforce(DescribeWorkforceRequest.builder().applyMutation(describeWorkforceRequest).build());
    }

    /**
     * <p>
     * Gets information about a specific work team. You can see information such as the creation date, the last updated
     * date, membership information, and the work team's Amazon Resource Name (ARN).
     * </p>
     *
     * @param describeWorkteamRequest
     * @return Result of the DescribeWorkteam operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeWorkteam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeWorkteam" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeWorkteamResponse describeWorkteam(DescribeWorkteamRequest describeWorkteamRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a specific work team. You can see information such as the creation date, the last updated
     * date, membership information, and the work team's Amazon Resource Name (ARN).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorkteamRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeWorkteamRequest#builder()}
     * </p>
     *
     * @param describeWorkteamRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeWorkteamRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeWorkteam operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeWorkteam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeWorkteam" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeWorkteamResponse describeWorkteam(Consumer<DescribeWorkteamRequest.Builder> describeWorkteamRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return describeWorkteam(DescribeWorkteamRequest.builder().applyMutation(describeWorkteamRequest).build());
    }

    /**
     * <p>
     * Disables using Service Catalog in SageMaker. Service Catalog is used to create SageMaker projects.
     * </p>
     *
     * @param disableSagemakerServicecatalogPortfolioRequest
     * @return Result of the DisableSagemakerServicecatalogPortfolio operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DisableSagemakerServicecatalogPortfolio
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DisableSagemakerServicecatalogPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    default DisableSagemakerServicecatalogPortfolioResponse disableSagemakerServicecatalogPortfolio(
            DisableSagemakerServicecatalogPortfolioRequest disableSagemakerServicecatalogPortfolioRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables using Service Catalog in SageMaker. Service Catalog is used to create SageMaker projects.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisableSagemakerServicecatalogPortfolioRequest.Builder} avoiding the need to create one manually via
     * {@link DisableSagemakerServicecatalogPortfolioRequest#builder()}
     * </p>
     *
     * @param disableSagemakerServicecatalogPortfolioRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DisableSagemakerServicecatalogPortfolioRequest.Builder}
     *        to create a request.
     * @return Result of the DisableSagemakerServicecatalogPortfolio operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DisableSagemakerServicecatalogPortfolio
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DisableSagemakerServicecatalogPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    default DisableSagemakerServicecatalogPortfolioResponse disableSagemakerServicecatalogPortfolio(
            Consumer<DisableSagemakerServicecatalogPortfolioRequest.Builder> disableSagemakerServicecatalogPortfolioRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return disableSagemakerServicecatalogPortfolio(DisableSagemakerServicecatalogPortfolioRequest.builder()
                .applyMutation(disableSagemakerServicecatalogPortfolioRequest).build());
    }

    /**
     * <p>
     * Disassociates a trial component from a trial. This doesn't effect other trials the component is associated with.
     * Before you can delete a component, you must disassociate the component from all trials it is associated with. To
     * associate a trial component with a trial, call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AssociateTrialComponent.html"
     * >AssociateTrialComponent</a> API.
     * </p>
     * <p>
     * To get a list of the trials a component is associated with, use the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html">Search</a> API. Specify
     * <code>ExperimentTrialComponent</code> for the <code>Resource</code> parameter. The list appears in the response
     * under <code>Results.TrialComponent.Parents</code>.
     * </p>
     *
     * @param disassociateTrialComponentRequest
     * @return Result of the DisassociateTrialComponent operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DisassociateTrialComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DisassociateTrialComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateTrialComponentResponse disassociateTrialComponent(
            DisassociateTrialComponentRequest disassociateTrialComponentRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a trial component from a trial. This doesn't effect other trials the component is associated with.
     * Before you can delete a component, you must disassociate the component from all trials it is associated with. To
     * associate a trial component with a trial, call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AssociateTrialComponent.html"
     * >AssociateTrialComponent</a> API.
     * </p>
     * <p>
     * To get a list of the trials a component is associated with, use the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html">Search</a> API. Specify
     * <code>ExperimentTrialComponent</code> for the <code>Resource</code> parameter. The list appears in the response
     * under <code>Results.TrialComponent.Parents</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateTrialComponentRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateTrialComponentRequest#builder()}
     * </p>
     *
     * @param disassociateTrialComponentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DisassociateTrialComponentRequest.Builder} to
     *        create a request.
     * @return Result of the DisassociateTrialComponent operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DisassociateTrialComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DisassociateTrialComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateTrialComponentResponse disassociateTrialComponent(
            Consumer<DisassociateTrialComponentRequest.Builder> disassociateTrialComponentRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return disassociateTrialComponent(DisassociateTrialComponentRequest.builder()
                .applyMutation(disassociateTrialComponentRequest).build());
    }

    /**
     * <p>
     * Enables using Service Catalog in SageMaker. Service Catalog is used to create SageMaker projects.
     * </p>
     *
     * @param enableSagemakerServicecatalogPortfolioRequest
     * @return Result of the EnableSagemakerServicecatalogPortfolio operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.EnableSagemakerServicecatalogPortfolio
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/EnableSagemakerServicecatalogPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    default EnableSagemakerServicecatalogPortfolioResponse enableSagemakerServicecatalogPortfolio(
            EnableSagemakerServicecatalogPortfolioRequest enableSagemakerServicecatalogPortfolioRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables using Service Catalog in SageMaker. Service Catalog is used to create SageMaker projects.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link EnableSagemakerServicecatalogPortfolioRequest.Builder} avoiding the need to create one manually via
     * {@link EnableSagemakerServicecatalogPortfolioRequest#builder()}
     * </p>
     *
     * @param enableSagemakerServicecatalogPortfolioRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.EnableSagemakerServicecatalogPortfolioRequest.Builder}
     *        to create a request.
     * @return Result of the EnableSagemakerServicecatalogPortfolio operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.EnableSagemakerServicecatalogPortfolio
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/EnableSagemakerServicecatalogPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    default EnableSagemakerServicecatalogPortfolioResponse enableSagemakerServicecatalogPortfolio(
            Consumer<EnableSagemakerServicecatalogPortfolioRequest.Builder> enableSagemakerServicecatalogPortfolioRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return enableSagemakerServicecatalogPortfolio(EnableSagemakerServicecatalogPortfolioRequest.builder()
                .applyMutation(enableSagemakerServicecatalogPortfolioRequest).build());
    }

    /**
     * <p>
     * Describes a fleet.
     * </p>
     *
     * @param getDeviceFleetReportRequest
     * @return Result of the GetDeviceFleetReport operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.GetDeviceFleetReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/GetDeviceFleetReport"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDeviceFleetReportResponse getDeviceFleetReport(GetDeviceFleetReportRequest getDeviceFleetReportRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeviceFleetReportRequest.Builder} avoiding the
     * need to create one manually via {@link GetDeviceFleetReportRequest#builder()}
     * </p>
     *
     * @param getDeviceFleetReportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.GetDeviceFleetReportRequest.Builder} to create a
     *        request.
     * @return Result of the GetDeviceFleetReport operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.GetDeviceFleetReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/GetDeviceFleetReport"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDeviceFleetReportResponse getDeviceFleetReport(
            Consumer<GetDeviceFleetReportRequest.Builder> getDeviceFleetReportRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return getDeviceFleetReport(GetDeviceFleetReportRequest.builder().applyMutation(getDeviceFleetReportRequest).build());
    }

    /**
     * <p>
     * The resource policy for the lineage group.
     * </p>
     *
     * @param getLineageGroupPolicyRequest
     * @return Result of the GetLineageGroupPolicy operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.GetLineageGroupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/GetLineageGroupPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetLineageGroupPolicyResponse getLineageGroupPolicy(GetLineageGroupPolicyRequest getLineageGroupPolicyRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The resource policy for the lineage group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLineageGroupPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link GetLineageGroupPolicyRequest#builder()}
     * </p>
     *
     * @param getLineageGroupPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.GetLineageGroupPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the GetLineageGroupPolicy operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.GetLineageGroupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/GetLineageGroupPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetLineageGroupPolicyResponse getLineageGroupPolicy(
            Consumer<GetLineageGroupPolicyRequest.Builder> getLineageGroupPolicyRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        return getLineageGroupPolicy(GetLineageGroupPolicyRequest.builder().applyMutation(getLineageGroupPolicyRequest).build());
    }

    /**
     * <p>
     * Gets a resource policy that manages access for a model group. For information about resource policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_identity-vs-resource.html">Identity-based
     * policies and resource-based policies</a> in the <i>Amazon Web Services Identity and Access Management User
     * Guide.</i>.
     * </p>
     *
     * @param getModelPackageGroupPolicyRequest
     * @return Result of the GetModelPackageGroupPolicy operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.GetModelPackageGroupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/GetModelPackageGroupPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetModelPackageGroupPolicyResponse getModelPackageGroupPolicy(
            GetModelPackageGroupPolicyRequest getModelPackageGroupPolicyRequest) throws AwsServiceException, SdkClientException,
            SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a resource policy that manages access for a model group. For information about resource policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_identity-vs-resource.html">Identity-based
     * policies and resource-based policies</a> in the <i>Amazon Web Services Identity and Access Management User
     * Guide.</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetModelPackageGroupPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link GetModelPackageGroupPolicyRequest#builder()}
     * </p>
     *
     * @param getModelPackageGroupPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.GetModelPackageGroupPolicyRequest.Builder} to
     *        create a request.
     * @return Result of the GetModelPackageGroupPolicy operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.GetModelPackageGroupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/GetModelPackageGroupPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetModelPackageGroupPolicyResponse getModelPackageGroupPolicy(
            Consumer<GetModelPackageGroupPolicyRequest.Builder> getModelPackageGroupPolicyRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return getModelPackageGroupPolicy(GetModelPackageGroupPolicyRequest.builder()
                .applyMutation(getModelPackageGroupPolicyRequest).build());
    }

    /**
     * <p>
     * Gets the status of Service Catalog in SageMaker. Service Catalog is used to create SageMaker projects.
     * </p>
     *
     * @param getSagemakerServicecatalogPortfolioStatusRequest
     * @return Result of the GetSagemakerServicecatalogPortfolioStatus operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.GetSagemakerServicecatalogPortfolioStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/GetSagemakerServicecatalogPortfolioStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSagemakerServicecatalogPortfolioStatusResponse getSagemakerServicecatalogPortfolioStatus(
            GetSagemakerServicecatalogPortfolioStatusRequest getSagemakerServicecatalogPortfolioStatusRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the status of Service Catalog in SageMaker. Service Catalog is used to create SageMaker projects.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetSagemakerServicecatalogPortfolioStatusRequest.Builder} avoiding the need to create one manually via
     * {@link GetSagemakerServicecatalogPortfolioStatusRequest#builder()}
     * </p>
     *
     * @param getSagemakerServicecatalogPortfolioStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.GetSagemakerServicecatalogPortfolioStatusRequest.Builder}
     *        to create a request.
     * @return Result of the GetSagemakerServicecatalogPortfolioStatus operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.GetSagemakerServicecatalogPortfolioStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/GetSagemakerServicecatalogPortfolioStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSagemakerServicecatalogPortfolioStatusResponse getSagemakerServicecatalogPortfolioStatus(
            Consumer<GetSagemakerServicecatalogPortfolioStatusRequest.Builder> getSagemakerServicecatalogPortfolioStatusRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return getSagemakerServicecatalogPortfolioStatus(GetSagemakerServicecatalogPortfolioStatusRequest.builder()
                .applyMutation(getSagemakerServicecatalogPortfolioStatusRequest).build());
    }

    /**
     * <p>
     * Starts an Amazon SageMaker Inference Recommender autoscaling recommendation job. Returns recommendations for
     * autoscaling policies that you can apply to your SageMaker endpoint.
     * </p>
     *
     * @param getScalingConfigurationRecommendationRequest
     * @return Result of the GetScalingConfigurationRecommendation operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.GetScalingConfigurationRecommendation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/GetScalingConfigurationRecommendation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetScalingConfigurationRecommendationResponse getScalingConfigurationRecommendation(
            GetScalingConfigurationRecommendationRequest getScalingConfigurationRecommendationRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an Amazon SageMaker Inference Recommender autoscaling recommendation job. Returns recommendations for
     * autoscaling policies that you can apply to your SageMaker endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetScalingConfigurationRecommendationRequest.Builder} avoiding the need to create one manually via
     * {@link GetScalingConfigurationRecommendationRequest#builder()}
     * </p>
     *
     * @param getScalingConfigurationRecommendationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.GetScalingConfigurationRecommendationRequest.Builder}
     *        to create a request.
     * @return Result of the GetScalingConfigurationRecommendation operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.GetScalingConfigurationRecommendation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/GetScalingConfigurationRecommendation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetScalingConfigurationRecommendationResponse getScalingConfigurationRecommendation(
            Consumer<GetScalingConfigurationRecommendationRequest.Builder> getScalingConfigurationRecommendationRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return getScalingConfigurationRecommendation(GetScalingConfigurationRecommendationRequest.builder()
                .applyMutation(getScalingConfigurationRecommendationRequest).build());
    }

    /**
     * <p>
     * An auto-complete API for the search functionality in the SageMaker console. It returns suggestions of possible
     * matches for the property name to use in <code>Search</code> queries. Provides suggestions for
     * <code>HyperParameters</code>, <code>Tags</code>, and <code>Metrics</code>.
     * </p>
     *
     * @param getSearchSuggestionsRequest
     * @return Result of the GetSearchSuggestions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.GetSearchSuggestions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/GetSearchSuggestions"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSearchSuggestionsResponse getSearchSuggestions(GetSearchSuggestionsRequest getSearchSuggestionsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * An auto-complete API for the search functionality in the SageMaker console. It returns suggestions of possible
     * matches for the property name to use in <code>Search</code> queries. Provides suggestions for
     * <code>HyperParameters</code>, <code>Tags</code>, and <code>Metrics</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSearchSuggestionsRequest.Builder} avoiding the
     * need to create one manually via {@link GetSearchSuggestionsRequest#builder()}
     * </p>
     *
     * @param getSearchSuggestionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.GetSearchSuggestionsRequest.Builder} to create a
     *        request.
     * @return Result of the GetSearchSuggestions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.GetSearchSuggestions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/GetSearchSuggestions"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSearchSuggestionsResponse getSearchSuggestions(
            Consumer<GetSearchSuggestionsRequest.Builder> getSearchSuggestionsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return getSearchSuggestions(GetSearchSuggestionsRequest.builder().applyMutation(getSearchSuggestionsRequest).build());
    }

    /**
     * <p>
     * Import hub content.
     * </p>
     *
     * @param importHubContentRequest
     * @return Result of the ImportHubContent operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ImportHubContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ImportHubContent" target="_top">AWS
     *      API Documentation</a>
     */
    default ImportHubContentResponse importHubContent(ImportHubContentRequest importHubContentRequest)
            throws ResourceNotFoundException, ResourceInUseException, ResourceLimitExceededException, AwsServiceException,
            SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Import hub content.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportHubContentRequest.Builder} avoiding the need
     * to create one manually via {@link ImportHubContentRequest#builder()}
     * </p>
     *
     * @param importHubContentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.ImportHubContentRequest.Builder} to create a
     *        request.
     * @return Result of the ImportHubContent operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ImportHubContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ImportHubContent" target="_top">AWS
     *      API Documentation</a>
     */
    default ImportHubContentResponse importHubContent(Consumer<ImportHubContentRequest.Builder> importHubContentRequest)
            throws ResourceNotFoundException, ResourceInUseException, ResourceLimitExceededException, AwsServiceException,
            SdkClientException, SageMakerException {
        return importHubContent(ImportHubContentRequest.builder().applyMutation(importHubContentRequest).build());
    }

    /**
     * <p>
     * Lists the actions in your account and their properties.
     * </p>
     *
     * @param listActionsRequest
     * @return Result of the ListActions operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListActions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListActionsResponse listActions(ListActionsRequest listActionsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the actions in your account and their properties.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListActionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListActionsRequest#builder()}
     * </p>
     *
     * @param listActionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.ListActionsRequest.Builder} to create a request.
     * @return Result of the ListActions operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListActions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListActionsResponse listActions(Consumer<ListActionsRequest.Builder> listActionsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return listActions(ListActionsRequest.builder().applyMutation(listActionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listActions(software.amazon.awssdk.services.sagemaker.model.ListActionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListActionsIterable responses = client.listActionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListActionsIterable responses = client.listActionsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListActionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListActionsIterable responses = client.listActionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listActions(software.amazon.awssdk.services.sagemaker.model.ListActionsRequest)} operation.</b>
     * </p>
     *
     * @param listActionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListActions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListActionsIterable listActionsPaginator(ListActionsRequest listActionsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        return new ListActionsIterable(this, listActionsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listActions(software.amazon.awssdk.services.sagemaker.model.ListActionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListActionsIterable responses = client.listActionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListActionsIterable responses = client.listActionsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListActionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListActionsIterable responses = client.listActionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listActions(software.amazon.awssdk.services.sagemaker.model.ListActionsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListActionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListActionsRequest#builder()}
     * </p>
     *
     * @param listActionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.ListActionsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListActions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListActionsIterable listActionsPaginator(Consumer<ListActionsRequest.Builder> listActionsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return listActionsPaginator(ListActionsRequest.builder().applyMutation(listActionsRequest).build());
    }

    /**
     * <p>
     * Lists the machine learning algorithms that have been created.
     * </p>
     *
     * @param listAlgorithmsRequest
     * @return Result of the ListAlgorithms operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListAlgorithms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListAlgorithms" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAlgorithmsResponse listAlgorithms(ListAlgorithmsRequest listAlgorithmsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the machine learning algorithms that have been created.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAlgorithmsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAlgorithmsRequest#builder()}
     * </p>
     *
     * @param listAlgorithmsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.ListAlgorithmsRequest.Builder} to create a request.
     * @return Result of the ListAlgorithms operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListAlgorithms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListAlgorithms" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAlgorithmsResponse listAlgorithms(Consumer<ListAlgorithmsRequest.Builder> listAlgorithmsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return listAlgorithms(ListAlgorithmsRequest.builder().applyMutation(listAlgorithmsRequest).build());
    }

    /**
     * <p>
     * Lists the machine learning algorithms that have been created.
     * </p>
     *
     * @return Result of the ListAlgorithms operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListAlgorithms
     * @see #listAlgorithms(ListAlgorithmsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListAlgorithms" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAlgorithmsResponse listAlgorithms() throws AwsServiceException, SdkClientException, SageMakerException {
        return listAlgorithms(ListAlgorithmsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAlgorithms(software.amazon.awssdk.services.sagemaker.model.ListAlgorithmsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListAlgorithmsIterable responses = client.listAlgorithmsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListAlgorithmsIterable responses = client
     *             .listAlgorithmsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListAlgorithmsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListAlgorithmsIterable responses = client.listAlgorithmsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAlgorithms(software.amazon.awssdk.services.sagemaker.model.ListAlgorithmsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListAlgorithms
     * @see #listAlgorithmsPaginator(ListAlgorithmsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListAlgorithms" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAlgorithmsIterable listAlgorithmsPaginator() throws AwsServiceException, SdkClientException, SageMakerException {
        return listAlgorithmsPaginator(ListAlgorithmsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAlgorithms(software.amazon.awssdk.services.sagemaker.model.ListAlgorithmsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListAlgorithmsIterable responses = client.listAlgorithmsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListAlgorithmsIterable responses = client
     *             .listAlgorithmsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListAlgorithmsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListAlgorithmsIterable responses = client.listAlgorithmsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAlgorithms(software.amazon.awssdk.services.sagemaker.model.ListAlgorithmsRequest)} operation.</b>
     * </p>
     *
     * @param listAlgorithmsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListAlgorithms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListAlgorithms" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAlgorithmsIterable listAlgorithmsPaginator(ListAlgorithmsRequest listAlgorithmsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return new ListAlgorithmsIterable(this, listAlgorithmsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAlgorithms(software.amazon.awssdk.services.sagemaker.model.ListAlgorithmsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListAlgorithmsIterable responses = client.listAlgorithmsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListAlgorithmsIterable responses = client
     *             .listAlgorithmsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListAlgorithmsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListAlgorithmsIterable responses = client.listAlgorithmsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAlgorithms(software.amazon.awssdk.services.sagemaker.model.ListAlgorithmsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAlgorithmsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAlgorithmsRequest#builder()}
     * </p>
     *
     * @param listAlgorithmsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.ListAlgorithmsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListAlgorithms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListAlgorithms" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAlgorithmsIterable listAlgorithmsPaginator(Consumer<ListAlgorithmsRequest.Builder> listAlgorithmsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return listAlgorithmsPaginator(ListAlgorithmsRequest.builder().applyMutation(listAlgorithmsRequest).build());
    }

    /**
     * <p>
     * Lists the aliases of a specified image or image version.
     * </p>
     *
     * @param listAliasesRequest
     * @return Result of the ListAliases operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListAliases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAliasesResponse listAliases(ListAliasesRequest listAliasesRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the aliases of a specified image or image version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAliasesRequest.Builder} avoiding the need to
     * create one manually via {@link ListAliasesRequest#builder()}
     * </p>
     *
     * @param listAliasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.ListAliasesRequest.Builder} to create a request.
     * @return Result of the ListAliases operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListAliases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAliasesResponse listAliases(Consumer<ListAliasesRequest.Builder> listAliasesRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return listAliases(ListAliasesRequest.builder().applyMutation(listAliasesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listAliases(software.amazon.awssdk.services.sagemaker.model.ListAliasesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListAliasesIterable responses = client.listAliasesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListAliasesIterable responses = client.listAliasesPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListAliasesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListAliasesIterable responses = client.listAliasesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAliases(software.amazon.awssdk.services.sagemaker.model.ListAliasesRequest)} operation.</b>
     * </p>
     *
     * @param listAliasesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListAliases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAliasesIterable listAliasesPaginator(ListAliasesRequest listAliasesRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        return new ListAliasesIterable(this, listAliasesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listAliases(software.amazon.awssdk.services.sagemaker.model.ListAliasesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListAliasesIterable responses = client.listAliasesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListAliasesIterable responses = client.listAliasesPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListAliasesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListAliasesIterable responses = client.listAliasesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAliases(software.amazon.awssdk.services.sagemaker.model.ListAliasesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAliasesRequest.Builder} avoiding the need to
     * create one manually via {@link ListAliasesRequest#builder()}
     * </p>
     *
     * @param listAliasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.ListAliasesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListAliases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAliasesIterable listAliasesPaginator(Consumer<ListAliasesRequest.Builder> listAliasesRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return listAliasesPaginator(ListAliasesRequest.builder().applyMutation(listAliasesRequest).build());
    }

    /**
     * <p>
     * Lists the AppImageConfigs in your account and their properties. The list can be filtered by creation time or
     * modified time, and whether the AppImageConfig name contains a specified string.
     * </p>
     *
     * @param listAppImageConfigsRequest
     * @return Result of the ListAppImageConfigs operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListAppImageConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListAppImageConfigs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAppImageConfigsResponse listAppImageConfigs(ListAppImageConfigsRequest listAppImageConfigsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the AppImageConfigs in your account and their properties. The list can be filtered by creation time or
     * modified time, and whether the AppImageConfig name contains a specified string.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAppImageConfigsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAppImageConfigsRequest#builder()}
     * </p>
     *
     * @param listAppImageConfigsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.ListAppImageConfigsRequest.Builder} to create a
     *        request.
     * @return Result of the ListAppImageConfigs operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListAppImageConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListAppImageConfigs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAppImageConfigsResponse listAppImageConfigs(
            Consumer<ListAppImageConfigsRequest.Builder> listAppImageConfigsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return listAppImageConfigs(ListAppImageConfigsRequest.builder().applyMutation(listAppImageConfigsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAppImageConfigs(software.amazon.awssdk.services.sagemaker.model.ListAppImageConfigsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListAppImageConfigsIterable responses = client.listAppImageConfigsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListAppImageConfigsIterable responses = client
     *             .listAppImageConfigsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListAppImageConfigsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListAppImageConfigsIterable responses = client.listAppImageConfigsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAppImageConfigs(software.amazon.awssdk.services.sagemaker.model.ListAppImageConfigsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAppImageConfigsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListAppImageConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListAppImageConfigs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAppImageConfigsIterable listAppImageConfigsPaginator(ListAppImageConfigsRequest listAppImageConfigsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return new ListAppImageConfigsIterable(this, listAppImageConfigsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAppImageConfigs(software.amazon.awssdk.services.sagemaker.model.ListAppImageConfigsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListAppImageConfigsIterable responses = client.listAppImageConfigsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListAppImageConfigsIterable responses = client
     *             .listAppImageConfigsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListAppImageConfigsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListAppImageConfigsIterable responses = client.listAppImageConfigsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAppImageConfigs(software.amazon.awssdk.services.sagemaker.model.ListAppImageConfigsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAppImageConfigsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAppImageConfigsRequest#builder()}
     * </p>
     *
     * @param listAppImageConfigsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.ListAppImageConfigsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListAppImageConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListAppImageConfigs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAppImageConfigsIterable listAppImageConfigsPaginator(
            Consumer<ListAppImageConfigsRequest.Builder> listAppImageConfigsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return listAppImageConfigsPaginator(ListAppImageConfigsRequest.builder().applyMutation(listAppImageConfigsRequest)
                .build());
    }

    /**
     * <p>
     * Lists apps.
     * </p>
     *
     * @param listAppsRequest
     * @return Result of the ListApps operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListApps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListApps" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAppsResponse listApps(ListAppsRequest listAppsRequest) throws AwsServiceException, SdkClientException,
            SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists apps.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAppsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAppsRequest#builder()}
     * </p>
     *
     * @param listAppsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.ListAppsRequest.Builder} to create a request.
     * @return Result of the ListApps operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListApps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListApps" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAppsResponse listApps(Consumer<ListAppsRequest.Builder> listAppsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return listApps(ListAppsRequest.builder().applyMutation(listAppsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listApps(software.amazon.awssdk.services.sagemaker.model.ListAppsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListAppsIterable responses = client.listAppsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListAppsIterable responses = client.listAppsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListAppsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListAppsIterable responses = client.listAppsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApps(software.amazon.awssdk.services.sagemaker.model.ListAppsRequest)} operation.</b>
     * </p>
     *
     * @param listAppsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListApps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListApps" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAppsIterable listAppsPaginator(ListAppsRequest listAppsRequest) throws AwsServiceException, SdkClientException,
            SageMakerException {
        return new ListAppsIterable(this, listAppsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listApps(software.amazon.awssdk.services.sagemaker.model.ListAppsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListAppsIterable responses = client.listAppsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListAppsIterable responses = client.listAppsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListAppsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListAppsIterable responses = client.listAppsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApps(software.amazon.awssdk.services.sagemaker.model.ListAppsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAppsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAppsRequest#builder()}
     * </p>
     *
     * @param listAppsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.ListAppsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListApps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListApps" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAppsIterable listAppsPaginator(Consumer<ListAppsRequest.Builder> listAppsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return listAppsPaginator(ListAppsRequest.builder().applyMutation(listAppsRequest).build());
    }

    /**
     * <p>
     * Lists the artifacts in your account and their properties.
     * </p>
     *
     * @param listArtifactsRequest
     * @return Result of the ListArtifacts operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListArtifacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListArtifacts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListArtifactsResponse listArtifacts(ListArtifactsRequest listArtifactsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the artifacts in your account and their properties.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListArtifactsRequest.Builder} avoiding the need to
     * create one manually via {@link ListArtifactsRequest#builder()}
     * </p>
     *
     * @param listArtifactsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.ListArtifactsRequest.Builder} to create a request.
     * @return Result of the ListArtifacts operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListArtifacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListArtifacts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListArtifactsResponse listArtifacts(Consumer<ListArtifactsRequest.Builder> listArtifactsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return listArtifacts(ListArtifactsRequest.builder().applyMutation(listArtifactsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listArtifacts(software.amazon.awssdk.services.sagemaker.model.ListArtifactsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListArtifactsIterable responses = client.listArtifactsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListArtifactsIterable responses = client.listArtifactsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListArtifactsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListArtifactsIterable responses = client.listArtifactsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listArtifacts(software.amazon.awssdk.services.sagemaker.model.ListArtifactsRequest)} operation.</b>
     * </p>
     *
     * @param listArtifactsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListArtifacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListArtifacts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListArtifactsIterable listArtifactsPaginator(ListArtifactsRequest listArtifactsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return new ListArtifactsIterable(this, listArtifactsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listArtifacts(software.amazon.awssdk.services.sagemaker.model.ListArtifactsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListArtifactsIterable responses = client.listArtifactsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListArtifactsIterable responses = client.listArtifactsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListArtifactsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListArtifactsIterable responses = client.listArtifactsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listArtifacts(software.amazon.awssdk.services.sagemaker.model.ListArtifactsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListArtifactsRequest.Builder} avoiding the need to
     * create one manually via {@link ListArtifactsRequest#builder()}
     * </p>
     *
     * @param listArtifactsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.ListArtifactsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListArtifacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListArtifacts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListArtifactsIterable listArtifactsPaginator(Consumer<ListArtifactsRequest.Builder> listArtifactsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return listArtifactsPaginator(ListArtifactsRequest.builder().applyMutation(listArtifactsRequest).build());
    }

    /**
     * <p>
     * Lists the associations in your account and their properties.
     * </p>
     *
     * @param listAssociationsRequest
     * @return Result of the ListAssociations operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListAssociations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAssociationsResponse listAssociations(ListAssociationsRequest listAssociationsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the associations in your account and their properties.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssociationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListAssociationsRequest#builder()}
     * </p>
     *
     * @param listAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.ListAssociationsRequest.Builder} to create a
     *        request.
     * @return Result of the ListAssociations operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListAssociations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAssociationsResponse listAssociations(Consumer<ListAssociationsRequest.Builder> listAssociationsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return listAssociations(ListAssociationsRequest.builder().applyMutation(listAssociationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAssociations(software.amazon.awssdk.services.sagemaker.model.ListAssociationsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListAssociationsIterable responses = client.listAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListAssociationsIterable responses = client
     *             .listAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListAssociationsIterable responses = client.listAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssociations(software.amazon.awssdk.services.sagemaker.model.ListAssociationsRequest)} operation.</b>
     * </p>
     *
     * @param listAssociationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListAssociations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAssociationsIterable listAssociationsPaginator(ListAssociationsRequest listAssociationsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return new ListAssociationsIterable(this, listAssociationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAssociations(software.amazon.awssdk.services.sagemaker.model.ListAssociationsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListAssociationsIterable responses = client.listAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListAssociationsIterable responses = client
     *             .listAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListAssociationsIterable responses = client.listAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssociations(software.amazon.awssdk.services.sagemaker.model.ListAssociationsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssociationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListAssociationsRequest#builder()}
     * </p>
     *
     * @param listAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.ListAssociationsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListAssociations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAssociationsIterable listAssociationsPaginator(Consumer<ListAssociationsRequest.Builder> listAssociationsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return listAssociationsPaginator(ListAssociationsRequest.builder().applyMutation(listAssociationsRequest).build());
    }

    /**
     * <p>
     * Request a list of jobs.
     * </p>
     *
     * @param listAutoMlJobsRequest
     * @return Result of the ListAutoMLJobs operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListAutoMLJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListAutoMLJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAutoMlJobsResponse listAutoMLJobs(ListAutoMlJobsRequest listAutoMlJobsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Request a list of jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAutoMlJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAutoMlJobsRequest#builder()}
     * </p>
     *
     * @param listAutoMlJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.ListAutoMlJobsRequest.Builder} to create a request.
     * @return Result of the ListAutoMLJobs operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListAutoMLJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListAutoMLJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAutoMlJobsResponse listAutoMLJobs(Consumer<ListAutoMlJobsRequest.Builder> listAutoMlJobsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return listAutoMLJobs(ListAutoMlJobsRequest.builder().applyMutation(listAutoMlJobsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAutoMLJobs(software.amazon.awssdk.services.sagemaker.model.ListAutoMlJobsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListAutoMLJobsIterable responses = client.listAutoMLJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListAutoMLJobsIterable responses = client
     *             .listAutoMLJobsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListAutoMlJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListAutoMLJobsIterable responses = client.listAutoMLJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAutoMLJobs(software.amazon.awssdk.services.sagemaker.model.ListAutoMlJobsRequest)} operation.</b>
     * </p>
     *
     * @param listAutoMlJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListAutoMLJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListAutoMLJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAutoMLJobsIterable listAutoMLJobsPaginator(ListAutoMlJobsRequest listAutoMlJobsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return new ListAutoMLJobsIterable(this, listAutoMlJobsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAutoMLJobs(software.amazon.awssdk.services.sagemaker.model.ListAutoMlJobsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListAutoMLJobsIterable responses = client.listAutoMLJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListAutoMLJobsIterable responses = client
     *             .listAutoMLJobsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListAutoMlJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListAutoMLJobsIterable responses = client.listAutoMLJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAutoMLJobs(software.amazon.awssdk.services.sagemaker.model.ListAutoMlJobsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAutoMlJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAutoMlJobsRequest#builder()}
     * </p>
     *
     * @param listAutoMlJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.ListAutoMlJobsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListAutoMLJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListAutoMLJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAutoMLJobsIterable listAutoMLJobsPaginator(Consumer<ListAutoMlJobsRequest.Builder> listAutoMlJobsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return listAutoMLJobsPaginator(ListAutoMlJobsRequest.builder().applyMutation(listAutoMlJobsRequest).build());
    }

    /**
     * <p>
     * List the candidates created for the job.
     * </p>
     *
     * @param listCandidatesForAutoMlJobRequest
     * @return Result of the ListCandidatesForAutoMLJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListCandidatesForAutoMLJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListCandidatesForAutoMLJob"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCandidatesForAutoMlJobResponse listCandidatesForAutoMLJob(
            ListCandidatesForAutoMlJobRequest listCandidatesForAutoMlJobRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the candidates created for the job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCandidatesForAutoMlJobRequest.Builder} avoiding
     * the need to create one manually via {@link ListCandidatesForAutoMlJobRequest#builder()}
     * </p>
     *
     * @param listCandidatesForAutoMlJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.ListCandidatesForAutoMlJobRequest.Builder} to
     *        create a request.
     * @return Result of the ListCandidatesForAutoMLJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListCandidatesForAutoMLJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListCandidatesForAutoMLJob"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCandidatesForAutoMlJobResponse listCandidatesForAutoMLJob(
            Consumer<ListCandidatesForAutoMlJobRequest.Builder> listCandidatesForAutoMlJobRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return listCandidatesForAutoMLJob(ListCandidatesForAutoMlJobRequest.builder()
                .applyMutation(listCandidatesForAutoMlJobRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCandidatesForAutoMLJob(software.amazon.awssdk.services.sagemaker.model.ListCandidatesForAutoMlJobRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListCandidatesForAutoMLJobIterable responses = client.listCandidatesForAutoMLJobPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListCandidatesForAutoMLJobIterable responses = client
     *             .listCandidatesForAutoMLJobPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListCandidatesForAutoMlJobResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListCandidatesForAutoMLJobIterable responses = client.listCandidatesForAutoMLJobPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCandidatesForAutoMLJob(software.amazon.awssdk.services.sagemaker.model.ListCandidatesForAutoMlJobRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCandidatesForAutoMlJobRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListCandidatesForAutoMLJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListCandidatesForAutoMLJob"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCandidatesForAutoMLJobIterable listCandidatesForAutoMLJobPaginator(
            ListCandidatesForAutoMlJobRequest listCandidatesForAutoMlJobRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        return new ListCandidatesForAutoMLJobIterable(this, listCandidatesForAutoMlJobRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCandidatesForAutoMLJob(software.amazon.awssdk.services.sagemaker.model.ListCandidatesForAutoMlJobRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListCandidatesForAutoMLJobIterable responses = client.listCandidatesForAutoMLJobPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListCandidatesForAutoMLJobIterable responses = client
     *             .listCandidatesForAutoMLJobPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListCandidatesForAutoMlJobResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListCandidatesForAutoMLJobIterable responses = client.listCandidatesForAutoMLJobPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCandidatesForAutoMLJob(software.amazon.awssdk.services.sagemaker.model.ListCandidatesForAutoMlJobRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCandidatesForAutoMlJobRequest.Builder} avoiding
     * the need to create one manually via {@link ListCandidatesForAutoMlJobRequest#builder()}
     * </p>
     *
     * @param listCandidatesForAutoMlJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.ListCandidatesForAutoMlJobRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListCandidatesForAutoMLJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListCandidatesForAutoMLJob"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCandidatesForAutoMLJobIterable listCandidatesForAutoMLJobPaginator(
            Consumer<ListCandidatesForAutoMlJobRequest.Builder> listCandidatesForAutoMlJobRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return listCandidatesForAutoMLJobPaginator(ListCandidatesForAutoMlJobRequest.builder()
                .applyMutation(listCandidatesForAutoMlJobRequest).build());
    }

    /**
     * <p>
     * Retrieves the list of instances (also called <i>nodes</i> interchangeably) in a SageMaker HyperPod cluster.
     * </p>
     *
     * @param listClusterNodesRequest
     * @return Result of the ListClusterNodes operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListClusterNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListClusterNodes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListClusterNodesResponse listClusterNodes(ListClusterNodesRequest listClusterNodesRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the list of instances (also called <i>nodes</i> interchangeably) in a SageMaker HyperPod cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListClusterNodesRequest.Builder} avoiding the need
     * to create one manually via {@link ListClusterNodesRequest#builder()}
     * </p>
     *
     * @param listClusterNodesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.ListClusterNodesRequest.Builder} to create a
     *        request.
     * @return Result of the ListClusterNodes operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListClusterNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListClusterNodes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListClusterNodesResponse listClusterNodes(Consumer<ListClusterNodesRequest.Builder> listClusterNodesRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return listClusterNodes(ListClusterNodesRequest.builder().applyMutation(listClusterNodesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listClusterNodes(software.amazon.awssdk.services.sagemaker.model.ListClusterNodesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListClusterNodesIterable responses = client.listClusterNodesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListClusterNodesIterable responses = client
     *             .listClusterNodesPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListClusterNodesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListClusterNodesIterable responses = client.listClusterNodesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClusterNodes(software.amazon.awssdk.services.sagemaker.model.ListClusterNodesRequest)} operation.</b>
     * </p>
     *
     * @param listClusterNodesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListClusterNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListClusterNodes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListClusterNodesIterable listClusterNodesPaginator(ListClusterNodesRequest listClusterNodesRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return new ListClusterNodesIterable(this, listClusterNodesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listClusterNodes(software.amazon.awssdk.services.sagemaker.model.ListClusterNodesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListClusterNodesIterable responses = client.listClusterNodesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListClusterNodesIterable responses = client
     *             .listClusterNodesPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListClusterNodesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListClusterNodesIterable responses = client.listClusterNodesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClusterNodes(software.amazon.awssdk.services.sagemaker.model.ListClusterNodesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListClusterNodesRequest.Builder} avoiding the need
     * to create one manually via {@link ListClusterNodesRequest#builder()}
     * </p>
     *
     * @param listClusterNodesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.ListClusterNodesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListClusterNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListClusterNodes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListClusterNodesIterable listClusterNodesPaginator(Consumer<ListClusterNodesRequest.Builder> listClusterNodesRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return listClusterNodesPaginator(ListClusterNodesRequest.builder().applyMutation(listClusterNodesRequest).build());
    }

    /**
     * <p>
     * List the cluster policy configurations.
     * </p>
     *
     * @param listClusterSchedulerConfigsRequest
     * @return Result of the ListClusterSchedulerConfigs operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListClusterSchedulerConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListClusterSchedulerConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListClusterSchedulerConfigsResponse listClusterSchedulerConfigs(
            ListClusterSchedulerConfigsRequest listClusterSchedulerConfigsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the cluster policy configurations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListClusterSchedulerConfigsRequest.Builder}
     * avoiding the need to create one manually via {@link ListClusterSchedulerConfigsRequest#builder()}
     * </p>
     *
     * @param listClusterSchedulerConfigsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.ListClusterSchedulerConfigsRequest.Builder} to
     *        create a request.
     * @return Result of the ListClusterSchedulerConfigs operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListClusterSchedulerConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListClusterSchedulerConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListClusterSchedulerConfigsResponse listClusterSchedulerConfigs(
            Consumer<ListClusterSchedulerConfigsRequest.Builder> listClusterSchedulerConfigsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return listClusterSchedulerConfigs(ListClusterSchedulerConfigsRequest.builder()
                .applyMutation(listClusterSchedulerConfigsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listClusterSchedulerConfigs(software.amazon.awssdk.services.sagemaker.model.ListClusterSchedulerConfigsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListClusterSchedulerConfigsIterable responses = client.listClusterSchedulerConfigsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListClusterSchedulerConfigsIterable responses = client
     *             .listClusterSchedulerConfigsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListClusterSchedulerConfigsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListClusterSchedulerConfigsIterable responses = client.listClusterSchedulerConfigsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClusterSchedulerConfigs(software.amazon.awssdk.services.sagemaker.model.ListClusterSchedulerConfigsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listClusterSchedulerConfigsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListClusterSchedulerConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListClusterSchedulerConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListClusterSchedulerConfigsIterable listClusterSchedulerConfigsPaginator(
            ListClusterSchedulerConfigsRequest listClusterSchedulerConfigsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return new ListClusterSchedulerConfigsIterable(this, listClusterSchedulerConfigsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listClusterSchedulerConfigs(software.amazon.awssdk.services.sagemaker.model.ListClusterSchedulerConfigsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListClusterSchedulerConfigsIterable responses = client.listClusterSchedulerConfigsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListClusterSchedulerConfigsIterable responses = client
     *             .listClusterSchedulerConfigsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListClusterSchedulerConfigsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListClusterSchedulerConfigsIterable responses = client.listClusterSchedulerConfigsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClusterSchedulerConfigs(software.amazon.awssdk.services.sagemaker.model.ListClusterSchedulerConfigsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListClusterSchedulerConfigsRequest.Builder}
     * avoiding the need to create one manually via {@link ListClusterSchedulerConfigsRequest#builder()}
     * </p>
     *
     * @param listClusterSchedulerConfigsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.ListClusterSchedulerConfigsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListClusterSchedulerConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListClusterSchedulerConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListClusterSchedulerConfigsIterable listClusterSchedulerConfigsPaginator(
            Consumer<ListClusterSchedulerConfigsRequest.Builder> listClusterSchedulerConfigsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return listClusterSchedulerConfigsPaginator(ListClusterSchedulerConfigsRequest.builder()
                .applyMutation(listClusterSchedulerConfigsRequest).build());
    }

    /**
     * <p>
     * Retrieves the list of SageMaker HyperPod clusters.
     * </p>
     *
     * @param listClustersRequest
     * @return Result of the ListClusters operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListClustersResponse listClusters(ListClustersRequest listClustersRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the list of SageMaker HyperPod clusters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListClustersRequest.Builder} avoiding the need to
     * create one manually via {@link ListClustersRequest#builder()}
     * </p>
     *
     * @param listClustersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.ListClustersRequest.Builder} to create a request.
     * @return Result of the ListClusters operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListClustersResponse listClusters(Consumer<ListClustersRequest.Builder> listClustersRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return listClusters(ListClustersRequest.builder().applyMutation(listClustersRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listClusters(software.amazon.awssdk.services.sagemaker.model.ListClustersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListClustersIterable responses = client.listClustersPaginator(request);
     * 