/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration to run a processing job in a specified container image.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AppSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<AppSpecification.Builder, AppSpecification> {
    private static final SdkField<String> IMAGE_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageUri").getter(getter(AppSpecification::imageUri)).setter(setter(Builder::imageUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageUri").build()).build();

    private static final SdkField<List<String>> CONTAINER_ENTRYPOINT_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ContainerEntrypoint")
            .getter(getter(AppSpecification::containerEntrypoint))
            .setter(setter(Builder::containerEntrypoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerEntrypoint").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> CONTAINER_ARGUMENTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ContainerArguments")
            .getter(getter(AppSpecification::containerArguments))
            .setter(setter(Builder::containerArguments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerArguments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_URI_FIELD,
            CONTAINER_ENTRYPOINT_FIELD, CONTAINER_ARGUMENTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String imageUri;

    private final List<String> containerEntrypoint;

    private final List<String> containerArguments;

    private AppSpecification(BuilderImpl builder) {
        this.imageUri = builder.imageUri;
        this.containerEntrypoint = builder.containerEntrypoint;
        this.containerArguments = builder.containerArguments;
    }

    /**
     * <p>
     * The container image to be run by the processing job.
     * </p>
     * 
     * @return The container image to be run by the processing job.
     */
    public final String imageUri() {
        return imageUri;
    }

    /**
     * For responses, this returns true if the service returned a value for the ContainerEntrypoint property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasContainerEntrypoint() {
        return containerEntrypoint != null && !(containerEntrypoint instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The entrypoint for a container used to run a processing job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContainerEntrypoint} method.
     * </p>
     * 
     * @return The entrypoint for a container used to run a processing job.
     */
    public final List<String> containerEntrypoint() {
        return containerEntrypoint;
    }

    /**
     * For responses, this returns true if the service returned a value for the ContainerArguments property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasContainerArguments() {
        return containerArguments != null && !(containerArguments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The arguments for a container used to run a processing job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContainerArguments} method.
     * </p>
     * 
     * @return The arguments for a container used to run a processing job.
     */
    public final List<String> containerArguments() {
        return containerArguments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(imageUri());
        hashCode = 31 * hashCode + Objects.hashCode(hasContainerEntrypoint() ? containerEntrypoint() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasContainerArguments() ? containerArguments() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppSpecification)) {
            return false;
        }
        AppSpecification other = (AppSpecification) obj;
        return Objects.equals(imageUri(), other.imageUri()) && hasContainerEntrypoint() == other.hasContainerEntrypoint()
                && Objects.equals(containerEntrypoint(), other.containerEntrypoint())
                && hasContainerArguments() == other.hasContainerArguments()
                && Objects.equals(containerArguments(), other.containerArguments());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AppSpecification").add("ImageUri", imageUri())
                .add("ContainerEntrypoint", hasContainerEntrypoint() ? containerEntrypoint() : null)
                .add("ContainerArguments", hasContainerArguments() ? containerArguments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImageUri":
            return Optional.ofNullable(clazz.cast(imageUri()));
        case "ContainerEntrypoint":
            return Optional.ofNullable(clazz.cast(containerEntrypoint()));
        case "ContainerArguments":
            return Optional.ofNullable(clazz.cast(containerArguments()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ImageUri", IMAGE_URI_FIELD);
        map.put("ContainerEntrypoint", CONTAINER_ENTRYPOINT_FIELD);
        map.put("ContainerArguments", CONTAINER_ARGUMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AppSpecification, T> g) {
        return obj -> g.apply((AppSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AppSpecification> {
        /**
         * <p>
         * The container image to be run by the processing job.
         * </p>
         * 
         * @param imageUri
         *        The container image to be run by the processing job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageUri(String imageUri);

        /**
         * <p>
         * The entrypoint for a container used to run a processing job.
         * </p>
         * 
         * @param containerEntrypoint
         *        The entrypoint for a container used to run a processing job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerEntrypoint(Collection<String> containerEntrypoint);

        /**
         * <p>
         * The entrypoint for a container used to run a processing job.
         * </p>
         * 
         * @param containerEntrypoint
         *        The entrypoint for a container used to run a processing job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerEntrypoint(String... containerEntrypoint);

        /**
         * <p>
         * The arguments for a container used to run a processing job.
         * </p>
         * 
         * @param containerArguments
         *        The arguments for a container used to run a processing job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerArguments(Collection<String> containerArguments);

        /**
         * <p>
         * The arguments for a container used to run a processing job.
         * </p>
         * 
         * @param containerArguments
         *        The arguments for a container used to run a processing job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerArguments(String... containerArguments);
    }

    static final class BuilderImpl implements Builder {
        private String imageUri;

        private List<String> containerEntrypoint = DefaultSdkAutoConstructList.getInstance();

        private List<String> containerArguments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AppSpecification model) {
            imageUri(model.imageUri);
            containerEntrypoint(model.containerEntrypoint);
            containerArguments(model.containerArguments);
        }

        public final String getImageUri() {
            return imageUri;
        }

        public final void setImageUri(String imageUri) {
            this.imageUri = imageUri;
        }

        @Override
        public final Builder imageUri(String imageUri) {
            this.imageUri = imageUri;
            return this;
        }

        public final Collection<String> getContainerEntrypoint() {
            if (containerEntrypoint instanceof SdkAutoConstructList) {
                return null;
            }
            return containerEntrypoint;
        }

        public final void setContainerEntrypoint(Collection<String> containerEntrypoint) {
            this.containerEntrypoint = ContainerEntrypointCopier.copy(containerEntrypoint);
        }

        @Override
        public final Builder containerEntrypoint(Collection<String> containerEntrypoint) {
            this.containerEntrypoint = ContainerEntrypointCopier.copy(containerEntrypoint);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerEntrypoint(String... containerEntrypoint) {
            containerEntrypoint(Arrays.asList(containerEntrypoint));
            return this;
        }

        public final Collection<String> getContainerArguments() {
            if (containerArguments instanceof SdkAutoConstructList) {
                return null;
            }
            return containerArguments;
        }

        public final void setContainerArguments(Collection<String> containerArguments) {
            this.containerArguments = ContainerArgumentsCopier.copy(containerArguments);
        }

        @Override
        public final Builder containerArguments(Collection<String> containerArguments) {
            this.containerArguments = ContainerArgumentsCopier.copy(containerArguments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerArguments(String... containerArguments) {
            containerArguments(Arrays.asList(containerArguments));
            return this;
        }

        @Override
        public AppSpecification build() {
            return new AppSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
