/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure describing the source of an artifact.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ArtifactSource implements SdkPojo, Serializable, ToCopyableBuilder<ArtifactSource.Builder, ArtifactSource> {
    private static final SdkField<String> SOURCE_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceUri").getter(getter(ArtifactSource::sourceUri)).setter(setter(Builder::sourceUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceUri").build()).build();

    private static final SdkField<List<ArtifactSourceType>> SOURCE_TYPES_FIELD = SdkField
            .<List<ArtifactSourceType>> builder(MarshallingType.LIST)
            .memberName("SourceTypes")
            .getter(getter(ArtifactSource::sourceTypes))
            .setter(setter(Builder::sourceTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ArtifactSourceType> builder(MarshallingType.SDK_POJO)
                                            .constructor(ArtifactSourceType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_URI_FIELD,
            SOURCE_TYPES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sourceUri;

    private final List<ArtifactSourceType> sourceTypes;

    private ArtifactSource(BuilderImpl builder) {
        this.sourceUri = builder.sourceUri;
        this.sourceTypes = builder.sourceTypes;
    }

    /**
     * <p>
     * The URI of the source.
     * </p>
     * 
     * @return The URI of the source.
     */
    public final String sourceUri() {
        return sourceUri;
    }

    /**
     * For responses, this returns true if the service returned a value for the SourceTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSourceTypes() {
        return sourceTypes != null && !(sourceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of source types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourceTypes} method.
     * </p>
     * 
     * @return A list of source types.
     */
    public final List<ArtifactSourceType> sourceTypes() {
        return sourceTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceUri());
        hashCode = 31 * hashCode + Objects.hashCode(hasSourceTypes() ? sourceTypes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArtifactSource)) {
            return false;
        }
        ArtifactSource other = (ArtifactSource) obj;
        return Objects.equals(sourceUri(), other.sourceUri()) && hasSourceTypes() == other.hasSourceTypes()
                && Objects.equals(sourceTypes(), other.sourceTypes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ArtifactSource").add("SourceUri", sourceUri())
                .add("SourceTypes", hasSourceTypes() ? sourceTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceUri":
            return Optional.ofNullable(clazz.cast(sourceUri()));
        case "SourceTypes":
            return Optional.ofNullable(clazz.cast(sourceTypes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SourceUri", SOURCE_URI_FIELD);
        map.put("SourceTypes", SOURCE_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ArtifactSource, T> g) {
        return obj -> g.apply((ArtifactSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ArtifactSource> {
        /**
         * <p>
         * The URI of the source.
         * </p>
         * 
         * @param sourceUri
         *        The URI of the source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceUri(String sourceUri);

        /**
         * <p>
         * A list of source types.
         * </p>
         * 
         * @param sourceTypes
         *        A list of source types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceTypes(Collection<ArtifactSourceType> sourceTypes);

        /**
         * <p>
         * A list of source types.
         * </p>
         * 
         * @param sourceTypes
         *        A list of source types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceTypes(ArtifactSourceType... sourceTypes);

        /**
         * <p>
         * A list of source types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.ArtifactSourceType.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.sagemaker.model.ArtifactSourceType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.ArtifactSourceType.Builder#build()} is called
         * immediately and its result is passed to {@link #sourceTypes(List<ArtifactSourceType>)}.
         * 
         * @param sourceTypes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.ArtifactSourceType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceTypes(java.util.Collection<ArtifactSourceType>)
         */
        Builder sourceTypes(Consumer<ArtifactSourceType.Builder>... sourceTypes);
    }

    static final class BuilderImpl implements Builder {
        private String sourceUri;

        private List<ArtifactSourceType> sourceTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ArtifactSource model) {
            sourceUri(model.sourceUri);
            sourceTypes(model.sourceTypes);
        }

        public final String getSourceUri() {
            return sourceUri;
        }

        public final void setSourceUri(String sourceUri) {
            this.sourceUri = sourceUri;
        }

        @Override
        public final Builder sourceUri(String sourceUri) {
            this.sourceUri = sourceUri;
            return this;
        }

        public final List<ArtifactSourceType.Builder> getSourceTypes() {
            List<ArtifactSourceType.Builder> result = ArtifactSourceTypesCopier.copyToBuilder(this.sourceTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourceTypes(Collection<ArtifactSourceType.BuilderImpl> sourceTypes) {
            this.sourceTypes = ArtifactSourceTypesCopier.copyFromBuilder(sourceTypes);
        }

        @Override
        public final Builder sourceTypes(Collection<ArtifactSourceType> sourceTypes) {
            this.sourceTypes = ArtifactSourceTypesCopier.copy(sourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceTypes(ArtifactSourceType... sourceTypes) {
            sourceTypes(Arrays.asList(sourceTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceTypes(Consumer<ArtifactSourceType.Builder>... sourceTypes) {
            sourceTypes(Stream.of(sourceTypes).map(c -> ArtifactSourceType.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ArtifactSource build() {
            return new ArtifactSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
