/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDescribeModelPackageResponse extends SageMakerResponse implements
        ToCopyableBuilder<BatchDescribeModelPackageResponse.Builder, BatchDescribeModelPackageResponse> {
    private static final SdkField<Map<String, BatchDescribeModelPackageSummary>> MODEL_PACKAGE_SUMMARIES_FIELD = SdkField
            .<Map<String, BatchDescribeModelPackageSummary>> builder(MarshallingType.MAP)
            .memberName("ModelPackageSummaries")
            .getter(getter(BatchDescribeModelPackageResponse::modelPackageSummaries))
            .setter(setter(Builder::modelPackageSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageSummaries").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<BatchDescribeModelPackageSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchDescribeModelPackageSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, BatchDescribeModelPackageError>> BATCH_DESCRIBE_MODEL_PACKAGE_ERROR_MAP_FIELD = SdkField
            .<Map<String, BatchDescribeModelPackageError>> builder(MarshallingType.MAP)
            .memberName("BatchDescribeModelPackageErrorMap")
            .getter(getter(BatchDescribeModelPackageResponse::batchDescribeModelPackageErrorMap))
            .setter(setter(Builder::batchDescribeModelPackageErrorMap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchDescribeModelPackageErrorMap")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<BatchDescribeModelPackageError> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchDescribeModelPackageError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_PACKAGE_SUMMARIES_FIELD,
            BATCH_DESCRIBE_MODEL_PACKAGE_ERROR_MAP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Map<String, BatchDescribeModelPackageSummary> modelPackageSummaries;

    private final Map<String, BatchDescribeModelPackageError> batchDescribeModelPackageErrorMap;

    private BatchDescribeModelPackageResponse(BuilderImpl builder) {
        super(builder);
        this.modelPackageSummaries = builder.modelPackageSummaries;
        this.batchDescribeModelPackageErrorMap = builder.batchDescribeModelPackageErrorMap;
    }

    /**
     * For responses, this returns true if the service returned a value for the ModelPackageSummaries property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasModelPackageSummaries() {
        return modelPackageSummaries != null && !(modelPackageSummaries instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The summaries for the model package versions
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasModelPackageSummaries} method.
     * </p>
     * 
     * @return The summaries for the model package versions
     */
    public final Map<String, BatchDescribeModelPackageSummary> modelPackageSummaries() {
        return modelPackageSummaries;
    }

    /**
     * For responses, this returns true if the service returned a value for the BatchDescribeModelPackageErrorMap
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasBatchDescribeModelPackageErrorMap() {
        return batchDescribeModelPackageErrorMap != null && !(batchDescribeModelPackageErrorMap instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of the resource and BatchDescribeModelPackageError objects reporting the error associated with describing
     * the model package.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBatchDescribeModelPackageErrorMap}
     * method.
     * </p>
     * 
     * @return A map of the resource and BatchDescribeModelPackageError objects reporting the error associated with
     *         describing the model package.
     */
    public final Map<String, BatchDescribeModelPackageError> batchDescribeModelPackageErrorMap() {
        return batchDescribeModelPackageErrorMap;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasModelPackageSummaries() ? modelPackageSummaries() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasBatchDescribeModelPackageErrorMap() ? batchDescribeModelPackageErrorMap() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDescribeModelPackageResponse)) {
            return false;
        }
        BatchDescribeModelPackageResponse other = (BatchDescribeModelPackageResponse) obj;
        return hasModelPackageSummaries() == other.hasModelPackageSummaries()
                && Objects.equals(modelPackageSummaries(), other.modelPackageSummaries())
                && hasBatchDescribeModelPackageErrorMap() == other.hasBatchDescribeModelPackageErrorMap()
                && Objects.equals(batchDescribeModelPackageErrorMap(), other.batchDescribeModelPackageErrorMap());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("BatchDescribeModelPackageResponse")
                .add("ModelPackageSummaries", hasModelPackageSummaries() ? modelPackageSummaries() : null)
                .add("BatchDescribeModelPackageErrorMap",
                        hasBatchDescribeModelPackageErrorMap() ? batchDescribeModelPackageErrorMap() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelPackageSummaries":
            return Optional.ofNullable(clazz.cast(modelPackageSummaries()));
        case "BatchDescribeModelPackageErrorMap":
            return Optional.ofNullable(clazz.cast(batchDescribeModelPackageErrorMap()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ModelPackageSummaries", MODEL_PACKAGE_SUMMARIES_FIELD);
        map.put("BatchDescribeModelPackageErrorMap", BATCH_DESCRIBE_MODEL_PACKAGE_ERROR_MAP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchDescribeModelPackageResponse, T> g) {
        return obj -> g.apply((BatchDescribeModelPackageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchDescribeModelPackageResponse> {
        /**
         * <p>
         * The summaries for the model package versions
         * </p>
         * 
         * @param modelPackageSummaries
         *        The summaries for the model package versions
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackageSummaries(Map<String, BatchDescribeModelPackageSummary> modelPackageSummaries);

        /**
         * <p>
         * A map of the resource and BatchDescribeModelPackageError objects reporting the error associated with
         * describing the model package.
         * </p>
         * 
         * @param batchDescribeModelPackageErrorMap
         *        A map of the resource and BatchDescribeModelPackageError objects reporting the error associated with
         *        describing the model package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchDescribeModelPackageErrorMap(Map<String, BatchDescribeModelPackageError> batchDescribeModelPackageErrorMap);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private Map<String, BatchDescribeModelPackageSummary> modelPackageSummaries = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, BatchDescribeModelPackageError> batchDescribeModelPackageErrorMap = DefaultSdkAutoConstructMap
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDescribeModelPackageResponse model) {
            super(model);
            modelPackageSummaries(model.modelPackageSummaries);
            batchDescribeModelPackageErrorMap(model.batchDescribeModelPackageErrorMap);
        }

        public final Map<String, BatchDescribeModelPackageSummary.Builder> getModelPackageSummaries() {
            Map<String, BatchDescribeModelPackageSummary.Builder> result = ModelPackageSummariesCopier
                    .copyToBuilder(this.modelPackageSummaries);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setModelPackageSummaries(Map<String, BatchDescribeModelPackageSummary.BuilderImpl> modelPackageSummaries) {
            this.modelPackageSummaries = ModelPackageSummariesCopier.copyFromBuilder(modelPackageSummaries);
        }

        @Override
        public final Builder modelPackageSummaries(Map<String, BatchDescribeModelPackageSummary> modelPackageSummaries) {
            this.modelPackageSummaries = ModelPackageSummariesCopier.copy(modelPackageSummaries);
            return this;
        }

        public final Map<String, BatchDescribeModelPackageError.Builder> getBatchDescribeModelPackageErrorMap() {
            Map<String, BatchDescribeModelPackageError.Builder> result = BatchDescribeModelPackageErrorMapCopier
                    .copyToBuilder(this.batchDescribeModelPackageErrorMap);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setBatchDescribeModelPackageErrorMap(
                Map<String, BatchDescribeModelPackageError.BuilderImpl> batchDescribeModelPackageErrorMap) {
            this.batchDescribeModelPackageErrorMap = BatchDescribeModelPackageErrorMapCopier
                    .copyFromBuilder(batchDescribeModelPackageErrorMap);
        }

        @Override
        public final Builder batchDescribeModelPackageErrorMap(
                Map<String, BatchDescribeModelPackageError> batchDescribeModelPackageErrorMap) {
            this.batchDescribeModelPackageErrorMap = BatchDescribeModelPackageErrorMapCopier
                    .copy(batchDescribeModelPackageErrorMap);
            return this;
        }

        @Override
        public BatchDescribeModelPackageResponse build() {
            return new BatchDescribeModelPackageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
