/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies data Model Monitor will capture.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CaptureOption implements SdkPojo, Serializable, ToCopyableBuilder<CaptureOption.Builder, CaptureOption> {
    private static final SdkField<String> CAPTURE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CaptureMode").getter(getter(CaptureOption::captureModeAsString)).setter(setter(Builder::captureMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaptureMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPTURE_MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String captureMode;

    private CaptureOption(BuilderImpl builder) {
        this.captureMode = builder.captureMode;
    }

    /**
     * <p>
     * Specify the boundary of data to capture.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #captureMode} will
     * return {@link CaptureMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #captureModeAsString}.
     * </p>
     * 
     * @return Specify the boundary of data to capture.
     * @see CaptureMode
     */
    public final CaptureMode captureMode() {
        return CaptureMode.fromValue(captureMode);
    }

    /**
     * <p>
     * Specify the boundary of data to capture.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #captureMode} will
     * return {@link CaptureMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #captureModeAsString}.
     * </p>
     * 
     * @return Specify the boundary of data to capture.
     * @see CaptureMode
     */
    public final String captureModeAsString() {
        return captureMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(captureModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CaptureOption)) {
            return false;
        }
        CaptureOption other = (CaptureOption) obj;
        return Objects.equals(captureModeAsString(), other.captureModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CaptureOption").add("CaptureMode", captureModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CaptureMode":
            return Optional.ofNullable(clazz.cast(captureModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CaptureMode", CAPTURE_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CaptureOption, T> g) {
        return obj -> g.apply((CaptureOption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CaptureOption> {
        /**
         * <p>
         * Specify the boundary of data to capture.
         * </p>
         * 
         * @param captureMode
         *        Specify the boundary of data to capture.
         * @see CaptureMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CaptureMode
         */
        Builder captureMode(String captureMode);

        /**
         * <p>
         * Specify the boundary of data to capture.
         * </p>
         * 
         * @param captureMode
         *        Specify the boundary of data to capture.
         * @see CaptureMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CaptureMode
         */
        Builder captureMode(CaptureMode captureMode);
    }

    static final class BuilderImpl implements Builder {
        private String captureMode;

        private BuilderImpl() {
        }

        private BuilderImpl(CaptureOption model) {
            captureMode(model.captureMode);
        }

        public final String getCaptureMode() {
            return captureMode;
        }

        public final void setCaptureMode(String captureMode) {
            this.captureMode = captureMode;
        }

        @Override
        public final Builder captureMode(String captureMode) {
            this.captureMode = captureMode;
            return this;
        }

        @Override
        public final Builder captureMode(CaptureMode captureMode) {
            this.captureMode(captureMode == null ? null : captureMode.toString());
            return this;
        }

        @Override
        public CaptureOption build() {
            return new CaptureOption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
