/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Lists a summary of the properties of a context. A context provides a logical grouping of other entities.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContextSummary implements SdkPojo, Serializable, ToCopyableBuilder<ContextSummary.Builder, ContextSummary> {
    private static final SdkField<String> CONTEXT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContextArn").getter(getter(ContextSummary::contextArn)).setter(setter(Builder::contextArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextArn").build()).build();

    private static final SdkField<String> CONTEXT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContextName").getter(getter(ContextSummary::contextName)).setter(setter(Builder::contextName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextName").build()).build();

    private static final SdkField<ContextSource> SOURCE_FIELD = SdkField.<ContextSource> builder(MarshallingType.SDK_POJO)
            .memberName("Source").getter(getter(ContextSummary::source)).setter(setter(Builder::source))
            .constructor(ContextSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final SdkField<String> CONTEXT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContextType").getter(getter(ContextSummary::contextType)).setter(setter(Builder::contextType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextType").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(ContextSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(ContextSummary::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTEXT_ARN_FIELD,
            CONTEXT_NAME_FIELD, SOURCE_FIELD, CONTEXT_TYPE_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String contextArn;

    private final String contextName;

    private final ContextSource source;

    private final String contextType;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private ContextSummary(BuilderImpl builder) {
        this.contextArn = builder.contextArn;
        this.contextName = builder.contextName;
        this.source = builder.source;
        this.contextType = builder.contextType;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the context.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the context.
     */
    public final String contextArn() {
        return contextArn;
    }

    /**
     * <p>
     * The name of the context.
     * </p>
     * 
     * @return The name of the context.
     */
    public final String contextName() {
        return contextName;
    }

    /**
     * <p>
     * The source of the context.
     * </p>
     * 
     * @return The source of the context.
     */
    public final ContextSource source() {
        return source;
    }

    /**
     * <p>
     * The type of the context.
     * </p>
     * 
     * @return The type of the context.
     */
    public final String contextType() {
        return contextType;
    }

    /**
     * <p>
     * When the context was created.
     * </p>
     * 
     * @return When the context was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * When the context was last modified.
     * </p>
     * 
     * @return When the context was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(contextArn());
        hashCode = 31 * hashCode + Objects.hashCode(contextName());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(contextType());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContextSummary)) {
            return false;
        }
        ContextSummary other = (ContextSummary) obj;
        return Objects.equals(contextArn(), other.contextArn()) && Objects.equals(contextName(), other.contextName())
                && Objects.equals(source(), other.source()) && Objects.equals(contextType(), other.contextType())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContextSummary").add("ContextArn", contextArn()).add("ContextName", contextName())
                .add("Source", source()).add("ContextType", contextType()).add("CreationTime", creationTime())
                .add("LastModifiedTime", lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContextArn":
            return Optional.ofNullable(clazz.cast(contextArn()));
        case "ContextName":
            return Optional.ofNullable(clazz.cast(contextName()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "ContextType":
            return Optional.ofNullable(clazz.cast(contextType()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ContextArn", CONTEXT_ARN_FIELD);
        map.put("ContextName", CONTEXT_NAME_FIELD);
        map.put("Source", SOURCE_FIELD);
        map.put("ContextType", CONTEXT_TYPE_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContextSummary, T> g) {
        return obj -> g.apply((ContextSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContextSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the context.
         * </p>
         * 
         * @param contextArn
         *        The Amazon Resource Name (ARN) of the context.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contextArn(String contextArn);

        /**
         * <p>
         * The name of the context.
         * </p>
         * 
         * @param contextName
         *        The name of the context.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contextName(String contextName);

        /**
         * <p>
         * The source of the context.
         * </p>
         * 
         * @param source
         *        The source of the context.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(ContextSource source);

        /**
         * <p>
         * The source of the context.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContextSource.Builder} avoiding the need
         * to create one manually via {@link ContextSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContextSource.Builder#build()} is called immediately and its
         * result is passed to {@link #source(ContextSource)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link ContextSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(ContextSource)
         */
        default Builder source(Consumer<ContextSource.Builder> source) {
            return source(ContextSource.builder().applyMutation(source).build());
        }

        /**
         * <p>
         * The type of the context.
         * </p>
         * 
         * @param contextType
         *        The type of the context.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contextType(String contextType);

        /**
         * <p>
         * When the context was created.
         * </p>
         * 
         * @param creationTime
         *        When the context was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * When the context was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        When the context was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);
    }

    static final class BuilderImpl implements Builder {
        private String contextArn;

        private String contextName;

        private ContextSource source;

        private String contextType;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ContextSummary model) {
            contextArn(model.contextArn);
            contextName(model.contextName);
            source(model.source);
            contextType(model.contextType);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
        }

        public final String getContextArn() {
            return contextArn;
        }

        public final void setContextArn(String contextArn) {
            this.contextArn = contextArn;
        }

        @Override
        public final Builder contextArn(String contextArn) {
            this.contextArn = contextArn;
            return this;
        }

        public final String getContextName() {
            return contextName;
        }

        public final void setContextName(String contextName) {
            this.contextName = contextName;
        }

        @Override
        public final Builder contextName(String contextName) {
            this.contextName = contextName;
            return this;
        }

        public final ContextSource.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(ContextSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(ContextSource source) {
            this.source = source;
            return this;
        }

        public final String getContextType() {
            return contextType;
        }

        public final void setContextType(String contextType) {
            this.contextType = contextType;
        }

        @Override
        public final Builder contextType(String contextType) {
            this.contextType = contextType;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        @Override
        public ContextSummary build() {
            return new ContextSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
