/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A flag to indicating that automatic model tuning (AMT) has detected model convergence, defined as a lack of
 * significant improvement (1% or less) against an objective metric.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConvergenceDetected implements SdkPojo, Serializable,
        ToCopyableBuilder<ConvergenceDetected.Builder, ConvergenceDetected> {
    private static final SdkField<String> COMPLETE_ON_CONVERGENCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CompleteOnConvergence").getter(getter(ConvergenceDetected::completeOnConvergenceAsString))
            .setter(setter(Builder::completeOnConvergence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompleteOnConvergence").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(COMPLETE_ON_CONVERGENCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String completeOnConvergence;

    private ConvergenceDetected(BuilderImpl builder) {
        this.completeOnConvergence = builder.completeOnConvergence;
    }

    /**
     * <p>
     * A flag to stop a tuning job once AMT has detected that the job has converged.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #completeOnConvergence} will return {@link CompleteOnConvergence#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #completeOnConvergenceAsString}.
     * </p>
     * 
     * @return A flag to stop a tuning job once AMT has detected that the job has converged.
     * @see CompleteOnConvergence
     */
    public final CompleteOnConvergence completeOnConvergence() {
        return CompleteOnConvergence.fromValue(completeOnConvergence);
    }

    /**
     * <p>
     * A flag to stop a tuning job once AMT has detected that the job has converged.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #completeOnConvergence} will return {@link CompleteOnConvergence#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #completeOnConvergenceAsString}.
     * </p>
     * 
     * @return A flag to stop a tuning job once AMT has detected that the job has converged.
     * @see CompleteOnConvergence
     */
    public final String completeOnConvergenceAsString() {
        return completeOnConvergence;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(completeOnConvergenceAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConvergenceDetected)) {
            return false;
        }
        ConvergenceDetected other = (ConvergenceDetected) obj;
        return Objects.equals(completeOnConvergenceAsString(), other.completeOnConvergenceAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConvergenceDetected").add("CompleteOnConvergence", completeOnConvergenceAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CompleteOnConvergence":
            return Optional.ofNullable(clazz.cast(completeOnConvergenceAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CompleteOnConvergence", COMPLETE_ON_CONVERGENCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConvergenceDetected, T> g) {
        return obj -> g.apply((ConvergenceDetected) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConvergenceDetected> {
        /**
         * <p>
         * A flag to stop a tuning job once AMT has detected that the job has converged.
         * </p>
         * 
         * @param completeOnConvergence
         *        A flag to stop a tuning job once AMT has detected that the job has converged.
         * @see CompleteOnConvergence
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CompleteOnConvergence
         */
        Builder completeOnConvergence(String completeOnConvergence);

        /**
         * <p>
         * A flag to stop a tuning job once AMT has detected that the job has converged.
         * </p>
         * 
         * @param completeOnConvergence
         *        A flag to stop a tuning job once AMT has detected that the job has converged.
         * @see CompleteOnConvergence
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CompleteOnConvergence
         */
        Builder completeOnConvergence(CompleteOnConvergence completeOnConvergence);
    }

    static final class BuilderImpl implements Builder {
        private String completeOnConvergence;

        private BuilderImpl() {
        }

        private BuilderImpl(ConvergenceDetected model) {
            completeOnConvergence(model.completeOnConvergence);
        }

        public final String getCompleteOnConvergence() {
            return completeOnConvergence;
        }

        public final void setCompleteOnConvergence(String completeOnConvergence) {
            this.completeOnConvergence = completeOnConvergence;
        }

        @Override
        public final Builder completeOnConvergence(String completeOnConvergence) {
            this.completeOnConvergence = completeOnConvergence;
            return this;
        }

        @Override
        public final Builder completeOnConvergence(CompleteOnConvergence completeOnConvergence) {
            this.completeOnConvergence(completeOnConvergence == null ? null : completeOnConvergence.toString());
            return this;
        }

        @Override
        public ConvergenceDetected build() {
            return new ConvergenceDetected(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
