/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateComputeQuotaResponse extends SageMakerResponse implements
        ToCopyableBuilder<CreateComputeQuotaResponse.Builder, CreateComputeQuotaResponse> {
    private static final SdkField<String> COMPUTE_QUOTA_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComputeQuotaArn").getter(getter(CreateComputeQuotaResponse::computeQuotaArn))
            .setter(setter(Builder::computeQuotaArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeQuotaArn").build()).build();

    private static final SdkField<String> COMPUTE_QUOTA_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComputeQuotaId").getter(getter(CreateComputeQuotaResponse::computeQuotaId))
            .setter(setter(Builder::computeQuotaId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeQuotaId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTE_QUOTA_ARN_FIELD,
            COMPUTE_QUOTA_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String computeQuotaArn;

    private final String computeQuotaId;

    private CreateComputeQuotaResponse(BuilderImpl builder) {
        super(builder);
        this.computeQuotaArn = builder.computeQuotaArn;
        this.computeQuotaId = builder.computeQuotaId;
    }

    /**
     * <p>
     * ARN of the compute allocation definition.
     * </p>
     * 
     * @return ARN of the compute allocation definition.
     */
    public final String computeQuotaArn() {
        return computeQuotaArn;
    }

    /**
     * <p>
     * ID of the compute allocation definition.
     * </p>
     * 
     * @return ID of the compute allocation definition.
     */
    public final String computeQuotaId() {
        return computeQuotaId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(computeQuotaArn());
        hashCode = 31 * hashCode + Objects.hashCode(computeQuotaId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateComputeQuotaResponse)) {
            return false;
        }
        CreateComputeQuotaResponse other = (CreateComputeQuotaResponse) obj;
        return Objects.equals(computeQuotaArn(), other.computeQuotaArn())
                && Objects.equals(computeQuotaId(), other.computeQuotaId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateComputeQuotaResponse").add("ComputeQuotaArn", computeQuotaArn())
                .add("ComputeQuotaId", computeQuotaId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComputeQuotaArn":
            return Optional.ofNullable(clazz.cast(computeQuotaArn()));
        case "ComputeQuotaId":
            return Optional.ofNullable(clazz.cast(computeQuotaId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ComputeQuotaArn", COMPUTE_QUOTA_ARN_FIELD);
        map.put("ComputeQuotaId", COMPUTE_QUOTA_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateComputeQuotaResponse, T> g) {
        return obj -> g.apply((CreateComputeQuotaResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateComputeQuotaResponse> {
        /**
         * <p>
         * ARN of the compute allocation definition.
         * </p>
         * 
         * @param computeQuotaArn
         *        ARN of the compute allocation definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeQuotaArn(String computeQuotaArn);

        /**
         * <p>
         * ID of the compute allocation definition.
         * </p>
         * 
         * @param computeQuotaId
         *        ID of the compute allocation definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeQuotaId(String computeQuotaId);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String computeQuotaArn;

        private String computeQuotaId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateComputeQuotaResponse model) {
            super(model);
            computeQuotaArn(model.computeQuotaArn);
            computeQuotaId(model.computeQuotaId);
        }

        public final String getComputeQuotaArn() {
            return computeQuotaArn;
        }

        public final void setComputeQuotaArn(String computeQuotaArn) {
            this.computeQuotaArn = computeQuotaArn;
        }

        @Override
        public final Builder computeQuotaArn(String computeQuotaArn) {
            this.computeQuotaArn = computeQuotaArn;
            return this;
        }

        public final String getComputeQuotaId() {
            return computeQuotaId;
        }

        public final void setComputeQuotaId(String computeQuotaId) {
            this.computeQuotaId = computeQuotaId;
        }

        @Override
        public final Builder computeQuotaId(String computeQuotaId) {
            this.computeQuotaId = computeQuotaId;
            return this;
        }

        @Override
        public CreateComputeQuotaResponse build() {
            return new CreateComputeQuotaResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
