/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTrainingPlanRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreateTrainingPlanRequest.Builder, CreateTrainingPlanRequest> {
    private static final SdkField<String> TRAINING_PLAN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrainingPlanName").getter(getter(CreateTrainingPlanRequest::trainingPlanName))
            .setter(setter(Builder::trainingPlanName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingPlanName").build()).build();

    private static final SdkField<String> TRAINING_PLAN_OFFERING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrainingPlanOfferingId").getter(getter(CreateTrainingPlanRequest::trainingPlanOfferingId))
            .setter(setter(Builder::trainingPlanOfferingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingPlanOfferingId").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateTrainingPlanRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAINING_PLAN_NAME_FIELD,
            TRAINING_PLAN_OFFERING_ID_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String trainingPlanName;

    private final String trainingPlanOfferingId;

    private final List<Tag> tags;

    private CreateTrainingPlanRequest(BuilderImpl builder) {
        super(builder);
        this.trainingPlanName = builder.trainingPlanName;
        this.trainingPlanOfferingId = builder.trainingPlanOfferingId;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the training plan to create.
     * </p>
     * 
     * @return The name of the training plan to create.
     */
    public final String trainingPlanName() {
        return trainingPlanName;
    }

    /**
     * <p>
     * The unique identifier of the training plan offering to use for creating this plan.
     * </p>
     * 
     * @return The unique identifier of the training plan offering to use for creating this plan.
     */
    public final String trainingPlanOfferingId() {
        return trainingPlanOfferingId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of key-value pairs to apply to this training plan.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An array of key-value pairs to apply to this training plan.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trainingPlanName());
        hashCode = 31 * hashCode + Objects.hashCode(trainingPlanOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrainingPlanRequest)) {
            return false;
        }
        CreateTrainingPlanRequest other = (CreateTrainingPlanRequest) obj;
        return Objects.equals(trainingPlanName(), other.trainingPlanName())
                && Objects.equals(trainingPlanOfferingId(), other.trainingPlanOfferingId()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTrainingPlanRequest").add("TrainingPlanName", trainingPlanName())
                .add("TrainingPlanOfferingId", trainingPlanOfferingId()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrainingPlanName":
            return Optional.ofNullable(clazz.cast(trainingPlanName()));
        case "TrainingPlanOfferingId":
            return Optional.ofNullable(clazz.cast(trainingPlanOfferingId()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TrainingPlanName", TRAINING_PLAN_NAME_FIELD);
        map.put("TrainingPlanOfferingId", TRAINING_PLAN_OFFERING_ID_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTrainingPlanRequest, T> g) {
        return obj -> g.apply((CreateTrainingPlanRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateTrainingPlanRequest> {
        /**
         * <p>
         * The name of the training plan to create.
         * </p>
         * 
         * @param trainingPlanName
         *        The name of the training plan to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingPlanName(String trainingPlanName);

        /**
         * <p>
         * The unique identifier of the training plan offering to use for creating this plan.
         * </p>
         * 
         * @param trainingPlanOfferingId
         *        The unique identifier of the training plan offering to use for creating this plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingPlanOfferingId(String trainingPlanOfferingId);

        /**
         * <p>
         * An array of key-value pairs to apply to this training plan.
         * </p>
         * 
         * @param tags
         *        An array of key-value pairs to apply to this training plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * An array of key-value pairs to apply to this training plan.
         * </p>
         * 
         * @param tags
         *        An array of key-value pairs to apply to this training plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * An array of key-value pairs to apply to this training plan.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.sagemaker.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String trainingPlanName;

        private String trainingPlanOfferingId;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrainingPlanRequest model) {
            super(model);
            trainingPlanName(model.trainingPlanName);
            trainingPlanOfferingId(model.trainingPlanOfferingId);
            tags(model.tags);
        }

        public final String getTrainingPlanName() {
            return trainingPlanName;
        }

        public final void setTrainingPlanName(String trainingPlanName) {
            this.trainingPlanName = trainingPlanName;
        }

        @Override
        public final Builder trainingPlanName(String trainingPlanName) {
            this.trainingPlanName = trainingPlanName;
            return this;
        }

        public final String getTrainingPlanOfferingId() {
            return trainingPlanOfferingId;
        }

        public final void setTrainingPlanOfferingId(String trainingPlanOfferingId) {
            this.trainingPlanOfferingId = trainingPlanOfferingId;
        }

        @Override
        public final Builder trainingPlanOfferingId(String trainingPlanOfferingId) {
            this.trainingPlanOfferingId = trainingPlanOfferingId;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTrainingPlanRequest build() {
            return new CreateTrainingPlanRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
