/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information summarizing the deployment stage results.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeploymentStageStatusSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<DeploymentStageStatusSummary.Builder, DeploymentStageStatusSummary> {
    private static final SdkField<String> STAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StageName").getter(getter(DeploymentStageStatusSummary::stageName)).setter(setter(Builder::stageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StageName").build()).build();

    private static final SdkField<DeviceSelectionConfig> DEVICE_SELECTION_CONFIG_FIELD = SdkField
            .<DeviceSelectionConfig> builder(MarshallingType.SDK_POJO).memberName("DeviceSelectionConfig")
            .getter(getter(DeploymentStageStatusSummary::deviceSelectionConfig)).setter(setter(Builder::deviceSelectionConfig))
            .constructor(DeviceSelectionConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceSelectionConfig").build())
            .build();

    private static final SdkField<EdgeDeploymentConfig> DEPLOYMENT_CONFIG_FIELD = SdkField
            .<EdgeDeploymentConfig> builder(MarshallingType.SDK_POJO).memberName("DeploymentConfig")
            .getter(getter(DeploymentStageStatusSummary::deploymentConfig)).setter(setter(Builder::deploymentConfig))
            .constructor(EdgeDeploymentConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentConfig").build()).build();

    private static final SdkField<EdgeDeploymentStatus> DEPLOYMENT_STATUS_FIELD = SdkField
            .<EdgeDeploymentStatus> builder(MarshallingType.SDK_POJO).memberName("DeploymentStatus")
            .getter(getter(DeploymentStageStatusSummary::deploymentStatus)).setter(setter(Builder::deploymentStatus))
            .constructor(EdgeDeploymentStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STAGE_NAME_FIELD,
            DEVICE_SELECTION_CONFIG_FIELD, DEPLOYMENT_CONFIG_FIELD, DEPLOYMENT_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String stageName;

    private final DeviceSelectionConfig deviceSelectionConfig;

    private final EdgeDeploymentConfig deploymentConfig;

    private final EdgeDeploymentStatus deploymentStatus;

    private DeploymentStageStatusSummary(BuilderImpl builder) {
        this.stageName = builder.stageName;
        this.deviceSelectionConfig = builder.deviceSelectionConfig;
        this.deploymentConfig = builder.deploymentConfig;
        this.deploymentStatus = builder.deploymentStatus;
    }

    /**
     * <p>
     * The name of the stage.
     * </p>
     * 
     * @return The name of the stage.
     */
    public final String stageName() {
        return stageName;
    }

    /**
     * <p>
     * Configuration of the devices in the stage.
     * </p>
     * 
     * @return Configuration of the devices in the stage.
     */
    public final DeviceSelectionConfig deviceSelectionConfig() {
        return deviceSelectionConfig;
    }

    /**
     * <p>
     * Configuration of the deployment details.
     * </p>
     * 
     * @return Configuration of the deployment details.
     */
    public final EdgeDeploymentConfig deploymentConfig() {
        return deploymentConfig;
    }

    /**
     * <p>
     * General status of the current state.
     * </p>
     * 
     * @return General status of the current state.
     */
    public final EdgeDeploymentStatus deploymentStatus() {
        return deploymentStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stageName());
        hashCode = 31 * hashCode + Objects.hashCode(deviceSelectionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentConfig());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentStageStatusSummary)) {
            return false;
        }
        DeploymentStageStatusSummary other = (DeploymentStageStatusSummary) obj;
        return Objects.equals(stageName(), other.stageName())
                && Objects.equals(deviceSelectionConfig(), other.deviceSelectionConfig())
                && Objects.equals(deploymentConfig(), other.deploymentConfig())
                && Objects.equals(deploymentStatus(), other.deploymentStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeploymentStageStatusSummary").add("StageName", stageName())
                .add("DeviceSelectionConfig", deviceSelectionConfig()).add("DeploymentConfig", deploymentConfig())
                .add("DeploymentStatus", deploymentStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StageName":
            return Optional.ofNullable(clazz.cast(stageName()));
        case "DeviceSelectionConfig":
            return Optional.ofNullable(clazz.cast(deviceSelectionConfig()));
        case "DeploymentConfig":
            return Optional.ofNullable(clazz.cast(deploymentConfig()));
        case "DeploymentStatus":
            return Optional.ofNullable(clazz.cast(deploymentStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StageName", STAGE_NAME_FIELD);
        map.put("DeviceSelectionConfig", DEVICE_SELECTION_CONFIG_FIELD);
        map.put("DeploymentConfig", DEPLOYMENT_CONFIG_FIELD);
        map.put("DeploymentStatus", DEPLOYMENT_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeploymentStageStatusSummary, T> g) {
        return obj -> g.apply((DeploymentStageStatusSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeploymentStageStatusSummary> {
        /**
         * <p>
         * The name of the stage.
         * </p>
         * 
         * @param stageName
         *        The name of the stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageName(String stageName);

        /**
         * <p>
         * Configuration of the devices in the stage.
         * </p>
         * 
         * @param deviceSelectionConfig
         *        Configuration of the devices in the stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceSelectionConfig(DeviceSelectionConfig deviceSelectionConfig);

        /**
         * <p>
         * Configuration of the devices in the stage.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeviceSelectionConfig.Builder} avoiding
         * the need to create one manually via {@link DeviceSelectionConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeviceSelectionConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #deviceSelectionConfig(DeviceSelectionConfig)}.
         * 
         * @param deviceSelectionConfig
         *        a consumer that will call methods on {@link DeviceSelectionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceSelectionConfig(DeviceSelectionConfig)
         */
        default Builder deviceSelectionConfig(Consumer<DeviceSelectionConfig.Builder> deviceSelectionConfig) {
            return deviceSelectionConfig(DeviceSelectionConfig.builder().applyMutation(deviceSelectionConfig).build());
        }

        /**
         * <p>
         * Configuration of the deployment details.
         * </p>
         * 
         * @param deploymentConfig
         *        Configuration of the deployment details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentConfig(EdgeDeploymentConfig deploymentConfig);

        /**
         * <p>
         * Configuration of the deployment details.
         * </p>
         * This is a convenience method that creates an instance of the {@link EdgeDeploymentConfig.Builder} avoiding
         * the need to create one manually via {@link EdgeDeploymentConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EdgeDeploymentConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #deploymentConfig(EdgeDeploymentConfig)}.
         * 
         * @param deploymentConfig
         *        a consumer that will call methods on {@link EdgeDeploymentConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentConfig(EdgeDeploymentConfig)
         */
        default Builder deploymentConfig(Consumer<EdgeDeploymentConfig.Builder> deploymentConfig) {
            return deploymentConfig(EdgeDeploymentConfig.builder().applyMutation(deploymentConfig).build());
        }

        /**
         * <p>
         * General status of the current state.
         * </p>
         * 
         * @param deploymentStatus
         *        General status of the current state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentStatus(EdgeDeploymentStatus deploymentStatus);

        /**
         * <p>
         * General status of the current state.
         * </p>
         * This is a convenience method that creates an instance of the {@link EdgeDeploymentStatus.Builder} avoiding
         * the need to create one manually via {@link EdgeDeploymentStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EdgeDeploymentStatus.Builder#build()} is called immediately and
         * its result is passed to {@link #deploymentStatus(EdgeDeploymentStatus)}.
         * 
         * @param deploymentStatus
         *        a consumer that will call methods on {@link EdgeDeploymentStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentStatus(EdgeDeploymentStatus)
         */
        default Builder deploymentStatus(Consumer<EdgeDeploymentStatus.Builder> deploymentStatus) {
            return deploymentStatus(EdgeDeploymentStatus.builder().applyMutation(deploymentStatus).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String stageName;

        private DeviceSelectionConfig deviceSelectionConfig;

        private EdgeDeploymentConfig deploymentConfig;

        private EdgeDeploymentStatus deploymentStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentStageStatusSummary model) {
            stageName(model.stageName);
            deviceSelectionConfig(model.deviceSelectionConfig);
            deploymentConfig(model.deploymentConfig);
            deploymentStatus(model.deploymentStatus);
        }

        public final String getStageName() {
            return stageName;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final DeviceSelectionConfig.Builder getDeviceSelectionConfig() {
            return deviceSelectionConfig != null ? deviceSelectionConfig.toBuilder() : null;
        }

        public final void setDeviceSelectionConfig(DeviceSelectionConfig.BuilderImpl deviceSelectionConfig) {
            this.deviceSelectionConfig = deviceSelectionConfig != null ? deviceSelectionConfig.build() : null;
        }

        @Override
        public final Builder deviceSelectionConfig(DeviceSelectionConfig deviceSelectionConfig) {
            this.deviceSelectionConfig = deviceSelectionConfig;
            return this;
        }

        public final EdgeDeploymentConfig.Builder getDeploymentConfig() {
            return deploymentConfig != null ? deploymentConfig.toBuilder() : null;
        }

        public final void setDeploymentConfig(EdgeDeploymentConfig.BuilderImpl deploymentConfig) {
            this.deploymentConfig = deploymentConfig != null ? deploymentConfig.build() : null;
        }

        @Override
        public final Builder deploymentConfig(EdgeDeploymentConfig deploymentConfig) {
            this.deploymentConfig = deploymentConfig;
            return this;
        }

        public final EdgeDeploymentStatus.Builder getDeploymentStatus() {
            return deploymentStatus != null ? deploymentStatus.toBuilder() : null;
        }

        public final void setDeploymentStatus(EdgeDeploymentStatus.BuilderImpl deploymentStatus) {
            this.deploymentStatus = deploymentStatus != null ? deploymentStatus.build() : null;
        }

        @Override
        public final Builder deploymentStatus(EdgeDeploymentStatus deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
            return this;
        }

        @Override
        public DeploymentStageStatusSummary build() {
            return new DeploymentStageStatusSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
