/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeImageVersionResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeImageVersionResponse.Builder, DescribeImageVersionResponse> {
    private static final SdkField<String> BASE_IMAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BaseImage").getter(getter(DescribeImageVersionResponse::baseImage)).setter(setter(Builder::baseImage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseImage").build()).build();

    private static final SdkField<String> CONTAINER_IMAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContainerImage").getter(getter(DescribeImageVersionResponse::containerImage))
            .setter(setter(Builder::containerImage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerImage").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeImageVersionResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(DescribeImageVersionResponse::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<String> IMAGE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageArn").getter(getter(DescribeImageVersionResponse::imageArn)).setter(setter(Builder::imageArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageArn").build()).build();

    private static final SdkField<String> IMAGE_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageVersionArn").getter(getter(DescribeImageVersionResponse::imageVersionArn))
            .setter(setter(Builder::imageVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageVersionArn").build()).build();

    private static final SdkField<String> IMAGE_VERSION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageVersionStatus").getter(getter(DescribeImageVersionResponse::imageVersionStatusAsString))
            .setter(setter(Builder::imageVersionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageVersionStatus").build())
            .build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(DescribeImageVersionResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<Integer> VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Version").getter(getter(DescribeImageVersionResponse::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final SdkField<String> VENDOR_GUIDANCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VendorGuidance").getter(getter(DescribeImageVersionResponse::vendorGuidanceAsString))
            .setter(setter(Builder::vendorGuidance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VendorGuidance").build()).build();

    private static final SdkField<String> JOB_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobType").getter(getter(DescribeImageVersionResponse::jobTypeAsString)).setter(setter(Builder::jobType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobType").build()).build();

    private static final SdkField<String> ML_FRAMEWORK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MLFramework").getter(getter(DescribeImageVersionResponse::mlFramework))
            .setter(setter(Builder::mlFramework))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MLFramework").build()).build();

    private static final SdkField<String> PROGRAMMING_LANG_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProgrammingLang").getter(getter(DescribeImageVersionResponse::programmingLang))
            .setter(setter(Builder::programmingLang))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgrammingLang").build()).build();

    private static final SdkField<String> PROCESSOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Processor").getter(getter(DescribeImageVersionResponse::processorAsString))
            .setter(setter(Builder::processor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Processor").build()).build();

    private static final SdkField<Boolean> HOROVOD_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Horovod").getter(getter(DescribeImageVersionResponse::horovod)).setter(setter(Builder::horovod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Horovod").build()).build();

    private static final SdkField<String> RELEASE_NOTES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReleaseNotes").getter(getter(DescribeImageVersionResponse::releaseNotes))
            .setter(setter(Builder::releaseNotes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReleaseNotes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASE_IMAGE_FIELD,
            CONTAINER_IMAGE_FIELD, CREATION_TIME_FIELD, FAILURE_REASON_FIELD, IMAGE_ARN_FIELD, IMAGE_VERSION_ARN_FIELD,
            IMAGE_VERSION_STATUS_FIELD, LAST_MODIFIED_TIME_FIELD, VERSION_FIELD, VENDOR_GUIDANCE_FIELD, JOB_TYPE_FIELD,
            ML_FRAMEWORK_FIELD, PROGRAMMING_LANG_FIELD, PROCESSOR_FIELD, HOROVOD_FIELD, RELEASE_NOTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String baseImage;

    private final String containerImage;

    private final Instant creationTime;

    private final String failureReason;

    private final String imageArn;

    private final String imageVersionArn;

    private final String imageVersionStatus;

    private final Instant lastModifiedTime;

    private final Integer version;

    private final String vendorGuidance;

    private final String jobType;

    private final String mlFramework;

    private final String programmingLang;

    private final String processor;

    private final Boolean horovod;

    private final String releaseNotes;

    private DescribeImageVersionResponse(BuilderImpl builder) {
        super(builder);
        this.baseImage = builder.baseImage;
        this.containerImage = builder.containerImage;
        this.creationTime = builder.creationTime;
        this.failureReason = builder.failureReason;
        this.imageArn = builder.imageArn;
        this.imageVersionArn = builder.imageVersionArn;
        this.imageVersionStatus = builder.imageVersionStatus;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.version = builder.version;
        this.vendorGuidance = builder.vendorGuidance;
        this.jobType = builder.jobType;
        this.mlFramework = builder.mlFramework;
        this.programmingLang = builder.programmingLang;
        this.processor = builder.processor;
        this.horovod = builder.horovod;
        this.releaseNotes = builder.releaseNotes;
    }

    /**
     * <p>
     * The registry path of the container image on which this image version is based.
     * </p>
     * 
     * @return The registry path of the container image on which this image version is based.
     */
    public final String baseImage() {
        return baseImage;
    }

    /**
     * <p>
     * The registry path of the container image that contains this image version.
     * </p>
     * 
     * @return The registry path of the container image that contains this image version.
     */
    public final String containerImage() {
        return containerImage;
    }

    /**
     * <p>
     * When the version was created.
     * </p>
     * 
     * @return When the version was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * When a create or delete operation fails, the reason for the failure.
     * </p>
     * 
     * @return When a create or delete operation fails, the reason for the failure.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The ARN of the image the version is based on.
     * </p>
     * 
     * @return The ARN of the image the version is based on.
     */
    public final String imageArn() {
        return imageArn;
    }

    /**
     * <p>
     * The ARN of the version.
     * </p>
     * 
     * @return The ARN of the version.
     */
    public final String imageVersionArn() {
        return imageVersionArn;
    }

    /**
     * <p>
     * The status of the version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #imageVersionStatus} will return {@link ImageVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #imageVersionStatusAsString}.
     * </p>
     * 
     * @return The status of the version.
     * @see ImageVersionStatus
     */
    public final ImageVersionStatus imageVersionStatus() {
        return ImageVersionStatus.fromValue(imageVersionStatus);
    }

    /**
     * <p>
     * The status of the version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #imageVersionStatus} will return {@link ImageVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #imageVersionStatusAsString}.
     * </p>
     * 
     * @return The status of the version.
     * @see ImageVersionStatus
     */
    public final String imageVersionStatusAsString() {
        return imageVersionStatus;
    }

    /**
     * <p>
     * When the version was last modified.
     * </p>
     * 
     * @return When the version was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The version number.
     * </p>
     * 
     * @return The version number.
     */
    public final Integer version() {
        return version;
    }

    /**
     * <p>
     * The stability of the image version specified by the maintainer.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NOT_PROVIDED</code>: The maintainers did not provide a status for image version stability.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STABLE</code>: The image version is stable.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TO_BE_ARCHIVED</code>: The image version is set to be archived. Custom image versions that are set to be
     * archived are automatically archived after three months.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ARCHIVED</code>: The image version is archived. Archived image versions are not searchable and are no
     * longer actively supported.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vendorGuidance}
     * will return {@link VendorGuidance#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #vendorGuidanceAsString}.
     * </p>
     * 
     * @return The stability of the image version specified by the maintainer.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NOT_PROVIDED</code>: The maintainers did not provide a status for image version stability.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STABLE</code>: The image version is stable.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TO_BE_ARCHIVED</code>: The image version is set to be archived. Custom image versions that are set
     *         to be archived are automatically archived after three months.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ARCHIVED</code>: The image version is archived. Archived image versions are not searchable and are
     *         no longer actively supported.
     *         </p>
     *         </li>
     * @see VendorGuidance
     */
    public final VendorGuidance vendorGuidance() {
        return VendorGuidance.fromValue(vendorGuidance);
    }

    /**
     * <p>
     * The stability of the image version specified by the maintainer.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NOT_PROVIDED</code>: The maintainers did not provide a status for image version stability.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STABLE</code>: The image version is stable.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TO_BE_ARCHIVED</code>: The image version is set to be archived. Custom image versions that are set to be
     * archived are automatically archived after three months.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ARCHIVED</code>: The image version is archived. Archived image versions are not searchable and are no
     * longer actively supported.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vendorGuidance}
     * will return {@link VendorGuidance#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #vendorGuidanceAsString}.
     * </p>
     * 
     * @return The stability of the image version specified by the maintainer.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NOT_PROVIDED</code>: The maintainers did not provide a status for image version stability.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STABLE</code>: The image version is stable.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TO_BE_ARCHIVED</code>: The image version is set to be archived. Custom image versions that are set
     *         to be archived are automatically archived after three months.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ARCHIVED</code>: The image version is archived. Archived image versions are not searchable and are
     *         no longer actively supported.
     *         </p>
     *         </li>
     * @see VendorGuidance
     */
    public final String vendorGuidanceAsString() {
        return vendorGuidance;
    }

    /**
     * <p>
     * Indicates SageMaker AI job type compatibility.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TRAINING</code>: The image version is compatible with SageMaker AI training jobs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INFERENCE</code>: The image version is compatible with SageMaker AI inference jobs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NOTEBOOK_KERNEL</code>: The image version is compatible with SageMaker AI notebook kernels.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobType} will
     * return {@link JobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobTypeAsString}.
     * </p>
     * 
     * @return Indicates SageMaker AI job type compatibility.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>TRAINING</code>: The image version is compatible with SageMaker AI training jobs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INFERENCE</code>: The image version is compatible with SageMaker AI inference jobs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NOTEBOOK_KERNEL</code>: The image version is compatible with SageMaker AI notebook kernels.
     *         </p>
     *         </li>
     * @see JobType
     */
    public final JobType jobType() {
        return JobType.fromValue(jobType);
    }

    /**
     * <p>
     * Indicates SageMaker AI job type compatibility.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TRAINING</code>: The image version is compatible with SageMaker AI training jobs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INFERENCE</code>: The image version is compatible with SageMaker AI inference jobs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NOTEBOOK_KERNEL</code>: The image version is compatible with SageMaker AI notebook kernels.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobType} will
     * return {@link JobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobTypeAsString}.
     * </p>
     * 
     * @return Indicates SageMaker AI job type compatibility.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>TRAINING</code>: The image version is compatible with SageMaker AI training jobs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INFERENCE</code>: The image version is compatible with SageMaker AI inference jobs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NOTEBOOK_KERNEL</code>: The image version is compatible with SageMaker AI notebook kernels.
     *         </p>
     *         </li>
     * @see JobType
     */
    public final String jobTypeAsString() {
        return jobType;
    }

    /**
     * <p>
     * The machine learning framework vended in the image version.
     * </p>
     * 
     * @return The machine learning framework vended in the image version.
     */
    public final String mlFramework() {
        return mlFramework;
    }

    /**
     * <p>
     * The supported programming language and its version.
     * </p>
     * 
     * @return The supported programming language and its version.
     */
    public final String programmingLang() {
        return programmingLang;
    }

    /**
     * <p>
     * Indicates CPU or GPU compatibility.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CPU</code>: The image version is compatible with CPU.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GPU</code>: The image version is compatible with GPU.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #processor} will
     * return {@link Processor#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #processorAsString}.
     * </p>
     * 
     * @return Indicates CPU or GPU compatibility.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CPU</code>: The image version is compatible with CPU.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GPU</code>: The image version is compatible with GPU.
     *         </p>
     *         </li>
     * @see Processor
     */
    public final Processor processor() {
        return Processor.fromValue(processor);
    }

    /**
     * <p>
     * Indicates CPU or GPU compatibility.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CPU</code>: The image version is compatible with CPU.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GPU</code>: The image version is compatible with GPU.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #processor} will
     * return {@link Processor#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #processorAsString}.
     * </p>
     * 
     * @return Indicates CPU or GPU compatibility.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CPU</code>: The image version is compatible with CPU.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GPU</code>: The image version is compatible with GPU.
     *         </p>
     *         </li>
     * @see Processor
     */
    public final String processorAsString() {
        return processor;
    }

    /**
     * <p>
     * Indicates Horovod compatibility.
     * </p>
     * 
     * @return Indicates Horovod compatibility.
     */
    public final Boolean horovod() {
        return horovod;
    }

    /**
     * <p>
     * The maintainer description of the image version.
     * </p>
     * 
     * @return The maintainer description of the image version.
     */
    public final String releaseNotes() {
        return releaseNotes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(baseImage());
        hashCode = 31 * hashCode + Objects.hashCode(containerImage());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(imageArn());
        hashCode = 31 * hashCode + Objects.hashCode(imageVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(imageVersionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(vendorGuidanceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(jobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(mlFramework());
        hashCode = 31 * hashCode + Objects.hashCode(programmingLang());
        hashCode = 31 * hashCode + Objects.hashCode(processorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(horovod());
        hashCode = 31 * hashCode + Objects.hashCode(releaseNotes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImageVersionResponse)) {
            return false;
        }
        DescribeImageVersionResponse other = (DescribeImageVersionResponse) obj;
        return Objects.equals(baseImage(), other.baseImage()) && Objects.equals(containerImage(), other.containerImage())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(failureReason(), other.failureReason())
                && Objects.equals(imageArn(), other.imageArn()) && Objects.equals(imageVersionArn(), other.imageVersionArn())
                && Objects.equals(imageVersionStatusAsString(), other.imageVersionStatusAsString())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(version(), other.version())
                && Objects.equals(vendorGuidanceAsString(), other.vendorGuidanceAsString())
                && Objects.equals(jobTypeAsString(), other.jobTypeAsString())
                && Objects.equals(mlFramework(), other.mlFramework())
                && Objects.equals(programmingLang(), other.programmingLang())
                && Objects.equals(processorAsString(), other.processorAsString()) && Objects.equals(horovod(), other.horovod())
                && Objects.equals(releaseNotes(), other.releaseNotes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeImageVersionResponse").add("BaseImage", baseImage())
                .add("ContainerImage", containerImage()).add("CreationTime", creationTime())
                .add("FailureReason", failureReason()).add("ImageArn", imageArn()).add("ImageVersionArn", imageVersionArn())
                .add("ImageVersionStatus", imageVersionStatusAsString()).add("LastModifiedTime", lastModifiedTime())
                .add("Version", version()).add("VendorGuidance", vendorGuidanceAsString()).add("JobType", jobTypeAsString())
                .add("MLFramework", mlFramework()).add("ProgrammingLang", programmingLang())
                .add("Processor", processorAsString()).add("Horovod", horovod()).add("ReleaseNotes", releaseNotes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BaseImage":
            return Optional.ofNullable(clazz.cast(baseImage()));
        case "ContainerImage":
            return Optional.ofNullable(clazz.cast(containerImage()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "ImageArn":
            return Optional.ofNullable(clazz.cast(imageArn()));
        case "ImageVersionArn":
            return Optional.ofNullable(clazz.cast(imageVersionArn()));
        case "ImageVersionStatus":
            return Optional.ofNullable(clazz.cast(imageVersionStatusAsString()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        case "VendorGuidance":
            return Optional.ofNullable(clazz.cast(vendorGuidanceAsString()));
        case "JobType":
            return Optional.ofNullable(clazz.cast(jobTypeAsString()));
        case "MLFramework":
            return Optional.ofNullable(clazz.cast(mlFramework()));
        case "ProgrammingLang":
            return Optional.ofNullable(clazz.cast(programmingLang()));
        case "Processor":
            return Optional.ofNullable(clazz.cast(processorAsString()));
        case "Horovod":
            return Optional.ofNullable(clazz.cast(horovod()));
        case "ReleaseNotes":
            return Optional.ofNullable(clazz.cast(releaseNotes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BaseImage", BASE_IMAGE_FIELD);
        map.put("ContainerImage", CONTAINER_IMAGE_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("FailureReason", FAILURE_REASON_FIELD);
        map.put("ImageArn", IMAGE_ARN_FIELD);
        map.put("ImageVersionArn", IMAGE_VERSION_ARN_FIELD);
        map.put("ImageVersionStatus", IMAGE_VERSION_STATUS_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("Version", VERSION_FIELD);
        map.put("VendorGuidance", VENDOR_GUIDANCE_FIELD);
        map.put("JobType", JOB_TYPE_FIELD);
        map.put("MLFramework", ML_FRAMEWORK_FIELD);
        map.put("ProgrammingLang", PROGRAMMING_LANG_FIELD);
        map.put("Processor", PROCESSOR_FIELD);
        map.put("Horovod", HOROVOD_FIELD);
        map.put("ReleaseNotes", RELEASE_NOTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeImageVersionResponse, T> g) {
        return obj -> g.apply((DescribeImageVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeImageVersionResponse> {
        /**
         * <p>
         * The registry path of the container image on which this image version is based.
         * </p>
         * 
         * @param baseImage
         *        The registry path of the container image on which this image version is based.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseImage(String baseImage);

        /**
         * <p>
         * The registry path of the container image that contains this image version.
         * </p>
         * 
         * @param containerImage
         *        The registry path of the container image that contains this image version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerImage(String containerImage);

        /**
         * <p>
         * When the version was created.
         * </p>
         * 
         * @param creationTime
         *        When the version was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * When a create or delete operation fails, the reason for the failure.
         * </p>
         * 
         * @param failureReason
         *        When a create or delete operation fails, the reason for the failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The ARN of the image the version is based on.
         * </p>
         * 
         * @param imageArn
         *        The ARN of the image the version is based on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageArn(String imageArn);

        /**
         * <p>
         * The ARN of the version.
         * </p>
         * 
         * @param imageVersionArn
         *        The ARN of the version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageVersionArn(String imageVersionArn);

        /**
         * <p>
         * The status of the version.
         * </p>
         * 
         * @param imageVersionStatus
         *        The status of the version.
         * @see ImageVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageVersionStatus
         */
        Builder imageVersionStatus(String imageVersionStatus);

        /**
         * <p>
         * The status of the version.
         * </p>
         * 
         * @param imageVersionStatus
         *        The status of the version.
         * @see ImageVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageVersionStatus
         */
        Builder imageVersionStatus(ImageVersionStatus imageVersionStatus);

        /**
         * <p>
         * When the version was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        When the version was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The version number.
         * </p>
         * 
         * @param version
         *        The version number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(Integer version);

        /**
         * <p>
         * The stability of the image version specified by the maintainer.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NOT_PROVIDED</code>: The maintainers did not provide a status for image version stability.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STABLE</code>: The image version is stable.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TO_BE_ARCHIVED</code>: The image version is set to be archived. Custom image versions that are set to
         * be archived are automatically archived after three months.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ARCHIVED</code>: The image version is archived. Archived image versions are not searchable and are no
         * longer actively supported.
         * </p>
         * </li>
         * </ul>
         * 
         * @param vendorGuidance
         *        The stability of the image version specified by the maintainer.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NOT_PROVIDED</code>: The maintainers did not provide a status for image version stability.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STABLE</code>: The image version is stable.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TO_BE_ARCHIVED</code>: The image version is set to be archived. Custom image versions that are
         *        set to be archived are automatically archived after three months.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ARCHIVED</code>: The image version is archived. Archived image versions are not searchable and
         *        are no longer actively supported.
         *        </p>
         *        </li>
         * @see VendorGuidance
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VendorGuidance
         */
        Builder vendorGuidance(String vendorGuidance);

        /**
         * <p>
         * The stability of the image version specified by the maintainer.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NOT_PROVIDED</code>: The maintainers did not provide a status for image version stability.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STABLE</code>: The image version is stable.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TO_BE_ARCHIVED</code>: The image version is set to be archived. Custom image versions that are set to
         * be archived are automatically archived after three months.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ARCHIVED</code>: The image version is archived. Archived image versions are not searchable and are no
         * longer actively supported.
         * </p>
         * </li>
         * </ul>
         * 
         * @param vendorGuidance
         *        The stability of the image version specified by the maintainer.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NOT_PROVIDED</code>: The maintainers did not provide a status for image version stability.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STABLE</code>: The image version is stable.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TO_BE_ARCHIVED</code>: The image version is set to be archived. Custom image versions that are
         *        set to be archived are automatically archived after three months.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ARCHIVED</code>: The image version is archived. Archived image versions are not searchable and
         *        are no longer actively supported.
         *        </p>
         *        </li>
         * @see VendorGuidance
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VendorGuidance
         */
        Builder vendorGuidance(VendorGuidance vendorGuidance);

        /**
         * <p>
         * Indicates SageMaker AI job type compatibility.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>TRAINING</code>: The image version is compatible with SageMaker AI training jobs.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INFERENCE</code>: The image version is compatible with SageMaker AI inference jobs.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NOTEBOOK_KERNEL</code>: The image version is compatible with SageMaker AI notebook kernels.
         * </p>
         * </li>
         * </ul>
         * 
         * @param jobType
         *        Indicates SageMaker AI job type compatibility.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>TRAINING</code>: The image version is compatible with SageMaker AI training jobs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INFERENCE</code>: The image version is compatible with SageMaker AI inference jobs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOTEBOOK_KERNEL</code>: The image version is compatible with SageMaker AI notebook kernels.
         *        </p>
         *        </li>
         * @see JobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobType
         */
        Builder jobType(String jobType);

        /**
         * <p>
         * Indicates SageMaker AI job type compatibility.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>TRAINING</code>: The image version is compatible with SageMaker AI training jobs.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INFERENCE</code>: The image version is compatible with SageMaker AI inference jobs.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NOTEBOOK_KERNEL</code>: The image version is compatible with SageMaker AI notebook kernels.
         * </p>
         * </li>
         * </ul>
         * 
         * @param jobType
         *        Indicates SageMaker AI job type compatibility.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>TRAINING</code>: The image version is compatible with SageMaker AI training jobs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INFERENCE</code>: The image version is compatible with SageMaker AI inference jobs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOTEBOOK_KERNEL</code>: The image version is compatible with SageMaker AI notebook kernels.
         *        </p>
         *        </li>
         * @see JobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobType
         */
        Builder jobType(JobType jobType);

        /**
         * <p>
         * The machine learning framework vended in the image version.
         * </p>
         * 
         * @param mlFramework
         *        The machine learning framework vended in the image version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mlFramework(String mlFramework);

        /**
         * <p>
         * The supported programming language and its version.
         * </p>
         * 
         * @param programmingLang
         *        The supported programming language and its version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programmingLang(String programmingLang);

        /**
         * <p>
         * Indicates CPU or GPU compatibility.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CPU</code>: The image version is compatible with CPU.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GPU</code>: The image version is compatible with GPU.
         * </p>
         * </li>
         * </ul>
         * 
         * @param processor
         *        Indicates CPU or GPU compatibility.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CPU</code>: The image version is compatible with CPU.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GPU</code>: The image version is compatible with GPU.
         *        </p>
         *        </li>
         * @see Processor
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Processor
         */
        Builder processor(String processor);

        /**
         * <p>
         * Indicates CPU or GPU compatibility.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CPU</code>: The image version is compatible with CPU.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GPU</code>: The image version is compatible with GPU.
         * </p>
         * </li>
         * </ul>
         * 
         * @param processor
         *        Indicates CPU or GPU compatibility.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CPU</code>: The image version is compatible with CPU.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GPU</code>: The image version is compatible with GPU.
         *        </p>
         *        </li>
         * @see Processor
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Processor
         */
        Builder processor(Processor processor);

        /**
         * <p>
         * Indicates Horovod compatibility.
         * </p>
         * 
         * @param horovod
         *        Indicates Horovod compatibility.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder horovod(Boolean horovod);

        /**
         * <p>
         * The maintainer description of the image version.
         * </p>
         * 
         * @param releaseNotes
         *        The maintainer description of the image version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder releaseNotes(String releaseNotes);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String baseImage;

        private String containerImage;

        private Instant creationTime;

        private String failureReason;

        private String imageArn;

        private String imageVersionArn;

        private String imageVersionStatus;

        private Instant lastModifiedTime;

        private Integer version;

        private String vendorGuidance;

        private String jobType;

        private String mlFramework;

        private String programmingLang;

        private String processor;

        private Boolean horovod;

        private String releaseNotes;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImageVersionResponse model) {
            super(model);
            baseImage(model.baseImage);
            containerImage(model.containerImage);
            creationTime(model.creationTime);
            failureReason(model.failureReason);
            imageArn(model.imageArn);
            imageVersionArn(model.imageVersionArn);
            imageVersionStatus(model.imageVersionStatus);
            lastModifiedTime(model.lastModifiedTime);
            version(model.version);
            vendorGuidance(model.vendorGuidance);
            jobType(model.jobType);
            mlFramework(model.mlFramework);
            programmingLang(model.programmingLang);
            processor(model.processor);
            horovod(model.horovod);
            releaseNotes(model.releaseNotes);
        }

        public final String getBaseImage() {
            return baseImage;
        }

        public final void setBaseImage(String baseImage) {
            this.baseImage = baseImage;
        }

        @Override
        public final Builder baseImage(String baseImage) {
            this.baseImage = baseImage;
            return this;
        }

        public final String getContainerImage() {
            return containerImage;
        }

        public final void setContainerImage(String containerImage) {
            this.containerImage = containerImage;
        }

        @Override
        public final Builder containerImage(String containerImage) {
            this.containerImage = containerImage;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getImageArn() {
            return imageArn;
        }

        public final void setImageArn(String imageArn) {
            this.imageArn = imageArn;
        }

        @Override
        public final Builder imageArn(String imageArn) {
            this.imageArn = imageArn;
            return this;
        }

        public final String getImageVersionArn() {
            return imageVersionArn;
        }

        public final void setImageVersionArn(String imageVersionArn) {
            this.imageVersionArn = imageVersionArn;
        }

        @Override
        public final Builder imageVersionArn(String imageVersionArn) {
            this.imageVersionArn = imageVersionArn;
            return this;
        }

        public final String getImageVersionStatus() {
            return imageVersionStatus;
        }

        public final void setImageVersionStatus(String imageVersionStatus) {
            this.imageVersionStatus = imageVersionStatus;
        }

        @Override
        public final Builder imageVersionStatus(String imageVersionStatus) {
            this.imageVersionStatus = imageVersionStatus;
            return this;
        }

        @Override
        public final Builder imageVersionStatus(ImageVersionStatus imageVersionStatus) {
            this.imageVersionStatus(imageVersionStatus == null ? null : imageVersionStatus.toString());
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Integer getVersion() {
            return version;
        }

        public final void setVersion(Integer version) {
            this.version = version;
        }

        @Override
        public final Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public final String getVendorGuidance() {
            return vendorGuidance;
        }

        public final void setVendorGuidance(String vendorGuidance) {
            this.vendorGuidance = vendorGuidance;
        }

        @Override
        public final Builder vendorGuidance(String vendorGuidance) {
            this.vendorGuidance = vendorGuidance;
            return this;
        }

        @Override
        public final Builder vendorGuidance(VendorGuidance vendorGuidance) {
            this.vendorGuidance(vendorGuidance == null ? null : vendorGuidance.toString());
            return this;
        }

        public final String getJobType() {
            return jobType;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(JobType jobType) {
            this.jobType(jobType == null ? null : jobType.toString());
            return this;
        }

        public final String getMlFramework() {
            return mlFramework;
        }

        public final void setMlFramework(String mlFramework) {
            this.mlFramework = mlFramework;
        }

        @Override
        public final Builder mlFramework(String mlFramework) {
            this.mlFramework = mlFramework;
            return this;
        }

        public final String getProgrammingLang() {
            return programmingLang;
        }

        public final void setProgrammingLang(String programmingLang) {
            this.programmingLang = programmingLang;
        }

        @Override
        public final Builder programmingLang(String programmingLang) {
            this.programmingLang = programmingLang;
            return this;
        }

        public final String getProcessor() {
            return processor;
        }

        public final void setProcessor(String processor) {
            this.processor = processor;
        }

        @Override
        public final Builder processor(String processor) {
            this.processor = processor;
            return this;
        }

        @Override
        public final Builder processor(Processor processor) {
            this.processor(processor == null ? null : processor.toString());
            return this;
        }

        public final Boolean getHorovod() {
            return horovod;
        }

        public final void setHorovod(Boolean horovod) {
            this.horovod = horovod;
        }

        @Override
        public final Builder horovod(Boolean horovod) {
            this.horovod = horovod;
            return this;
        }

        public final String getReleaseNotes() {
            return releaseNotes;
        }

        public final void setReleaseNotes(String releaseNotes) {
            this.releaseNotes = releaseNotes;
        }

        @Override
        public final Builder releaseNotes(String releaseNotes) {
            this.releaseNotes = releaseNotes;
            return this;
        }

        @Override
        public DescribeImageVersionResponse build() {
            return new DescribeImageVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
