/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeInferenceComponentResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeInferenceComponentResponse.Builder, DescribeInferenceComponentResponse> {
    private static final SdkField<String> INFERENCE_COMPONENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InferenceComponentName").getter(getter(DescribeInferenceComponentResponse::inferenceComponentName))
            .setter(setter(Builder::inferenceComponentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceComponentName").build())
            .build();

    private static final SdkField<String> INFERENCE_COMPONENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InferenceComponentArn").getter(getter(DescribeInferenceComponentResponse::inferenceComponentArn))
            .setter(setter(Builder::inferenceComponentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceComponentArn").build())
            .build();

    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointName").getter(getter(DescribeInferenceComponentResponse::endpointName))
            .setter(setter(Builder::endpointName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()).build();

    private static final SdkField<String> ENDPOINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointArn").getter(getter(DescribeInferenceComponentResponse::endpointArn))
            .setter(setter(Builder::endpointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointArn").build()).build();

    private static final SdkField<String> VARIANT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VariantName").getter(getter(DescribeInferenceComponentResponse::variantName))
            .setter(setter(Builder::variantName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VariantName").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(DescribeInferenceComponentResponse::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<InferenceComponentSpecificationSummary> SPECIFICATION_FIELD = SdkField
            .<InferenceComponentSpecificationSummary> builder(MarshallingType.SDK_POJO).memberName("Specification")
            .getter(getter(DescribeInferenceComponentResponse::specification)).setter(setter(Builder::specification))
            .constructor(InferenceComponentSpecificationSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Specification").build()).build();

    private static final SdkField<InferenceComponentRuntimeConfigSummary> RUNTIME_CONFIG_FIELD = SdkField
            .<InferenceComponentRuntimeConfigSummary> builder(MarshallingType.SDK_POJO).memberName("RuntimeConfig")
            .getter(getter(DescribeInferenceComponentResponse::runtimeConfig)).setter(setter(Builder::runtimeConfig))
            .constructor(InferenceComponentRuntimeConfigSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeConfig").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeInferenceComponentResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(DescribeInferenceComponentResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> INFERENCE_COMPONENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InferenceComponentStatus")
            .getter(getter(DescribeInferenceComponentResponse::inferenceComponentStatusAsString))
            .setter(setter(Builder::inferenceComponentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceComponentStatus").build())
            .build();

    private static final SdkField<InferenceComponentDeploymentConfig> LAST_DEPLOYMENT_CONFIG_FIELD = SdkField
            .<InferenceComponentDeploymentConfig> builder(MarshallingType.SDK_POJO).memberName("LastDeploymentConfig")
            .getter(getter(DescribeInferenceComponentResponse::lastDeploymentConfig))
            .setter(setter(Builder::lastDeploymentConfig)).constructor(InferenceComponentDeploymentConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastDeploymentConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            INFERENCE_COMPONENT_NAME_FIELD, INFERENCE_COMPONENT_ARN_FIELD, ENDPOINT_NAME_FIELD, ENDPOINT_ARN_FIELD,
            VARIANT_NAME_FIELD, FAILURE_REASON_FIELD, SPECIFICATION_FIELD, RUNTIME_CONFIG_FIELD, CREATION_TIME_FIELD,
            LAST_MODIFIED_TIME_FIELD, INFERENCE_COMPONENT_STATUS_FIELD, LAST_DEPLOYMENT_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String inferenceComponentName;

    private final String inferenceComponentArn;

    private final String endpointName;

    private final String endpointArn;

    private final String variantName;

    private final String failureReason;

    private final InferenceComponentSpecificationSummary specification;

    private final InferenceComponentRuntimeConfigSummary runtimeConfig;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private final String inferenceComponentStatus;

    private final InferenceComponentDeploymentConfig lastDeploymentConfig;

    private DescribeInferenceComponentResponse(BuilderImpl builder) {
        super(builder);
        this.inferenceComponentName = builder.inferenceComponentName;
        this.inferenceComponentArn = builder.inferenceComponentArn;
        this.endpointName = builder.endpointName;
        this.endpointArn = builder.endpointArn;
        this.variantName = builder.variantName;
        this.failureReason = builder.failureReason;
        this.specification = builder.specification;
        this.runtimeConfig = builder.runtimeConfig;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.inferenceComponentStatus = builder.inferenceComponentStatus;
        this.lastDeploymentConfig = builder.lastDeploymentConfig;
    }

    /**
     * <p>
     * The name of the inference component.
     * </p>
     * 
     * @return The name of the inference component.
     */
    public final String inferenceComponentName() {
        return inferenceComponentName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the inference component.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the inference component.
     */
    public final String inferenceComponentArn() {
        return inferenceComponentArn;
    }

    /**
     * <p>
     * The name of the endpoint that hosts the inference component.
     * </p>
     * 
     * @return The name of the endpoint that hosts the inference component.
     */
    public final String endpointName() {
        return endpointName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the endpoint that hosts the inference component.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the endpoint that hosts the inference component.
     */
    public final String endpointArn() {
        return endpointArn;
    }

    /**
     * <p>
     * The name of the production variant that hosts the inference component.
     * </p>
     * 
     * @return The name of the production variant that hosts the inference component.
     */
    public final String variantName() {
        return variantName;
    }

    /**
     * <p>
     * If the inference component status is <code>Failed</code>, the reason for the failure.
     * </p>
     * 
     * @return If the inference component status is <code>Failed</code>, the reason for the failure.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * Details about the resources that are deployed with this inference component.
     * </p>
     * 
     * @return Details about the resources that are deployed with this inference component.
     */
    public final InferenceComponentSpecificationSummary specification() {
        return specification;
    }

    /**
     * <p>
     * Details about the runtime settings for the model that is deployed with the inference component.
     * </p>
     * 
     * @return Details about the runtime settings for the model that is deployed with the inference component.
     */
    public final InferenceComponentRuntimeConfigSummary runtimeConfig() {
        return runtimeConfig;
    }

    /**
     * <p>
     * The time when the inference component was created.
     * </p>
     * 
     * @return The time when the inference component was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time when the inference component was last updated.
     * </p>
     * 
     * @return The time when the inference component was last updated.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The status of the inference component.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #inferenceComponentStatus} will return {@link InferenceComponentStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #inferenceComponentStatusAsString}.
     * </p>
     * 
     * @return The status of the inference component.
     * @see InferenceComponentStatus
     */
    public final InferenceComponentStatus inferenceComponentStatus() {
        return InferenceComponentStatus.fromValue(inferenceComponentStatus);
    }

    /**
     * <p>
     * The status of the inference component.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #inferenceComponentStatus} will return {@link InferenceComponentStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #inferenceComponentStatusAsString}.
     * </p>
     * 
     * @return The status of the inference component.
     * @see InferenceComponentStatus
     */
    public final String inferenceComponentStatusAsString() {
        return inferenceComponentStatus;
    }

    /**
     * <p>
     * The deployment and rollback settings that you assigned to the inference component.
     * </p>
     * 
     * @return The deployment and rollback settings that you assigned to the inference component.
     */
    public final InferenceComponentDeploymentConfig lastDeploymentConfig() {
        return lastDeploymentConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(inferenceComponentName());
        hashCode = 31 * hashCode + Objects.hashCode(inferenceComponentArn());
        hashCode = 31 * hashCode + Objects.hashCode(endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(endpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(variantName());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(specification());
        hashCode = 31 * hashCode + Objects.hashCode(runtimeConfig());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(inferenceComponentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastDeploymentConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInferenceComponentResponse)) {
            return false;
        }
        DescribeInferenceComponentResponse other = (DescribeInferenceComponentResponse) obj;
        return Objects.equals(inferenceComponentName(), other.inferenceComponentName())
                && Objects.equals(inferenceComponentArn(), other.inferenceComponentArn())
                && Objects.equals(endpointName(), other.endpointName()) && Objects.equals(endpointArn(), other.endpointArn())
                && Objects.equals(variantName(), other.variantName()) && Objects.equals(failureReason(), other.failureReason())
                && Objects.equals(specification(), other.specification())
                && Objects.equals(runtimeConfig(), other.runtimeConfig()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(inferenceComponentStatusAsString(), other.inferenceComponentStatusAsString())
                && Objects.equals(lastDeploymentConfig(), other.lastDeploymentConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeInferenceComponentResponse").add("InferenceComponentName", inferenceComponentName())
                .add("InferenceComponentArn", inferenceComponentArn()).add("EndpointName", endpointName())
                .add("EndpointArn", endpointArn()).add("VariantName", variantName()).add("FailureReason", failureReason())
                .add("Specification", specification()).add("RuntimeConfig", runtimeConfig()).add("CreationTime", creationTime())
                .add("LastModifiedTime", lastModifiedTime()).add("InferenceComponentStatus", inferenceComponentStatusAsString())
                .add("LastDeploymentConfig", lastDeploymentConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InferenceComponentName":
            return Optional.ofNullable(clazz.cast(inferenceComponentName()));
        case "InferenceComponentArn":
            return Optional.ofNullable(clazz.cast(inferenceComponentArn()));
        case "EndpointName":
            return Optional.ofNullable(clazz.cast(endpointName()));
        case "EndpointArn":
            return Optional.ofNullable(clazz.cast(endpointArn()));
        case "VariantName":
            return Optional.ofNullable(clazz.cast(variantName()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "Specification":
            return Optional.ofNullable(clazz.cast(specification()));
        case "RuntimeConfig":
            return Optional.ofNullable(clazz.cast(runtimeConfig()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "InferenceComponentStatus":
            return Optional.ofNullable(clazz.cast(inferenceComponentStatusAsString()));
        case "LastDeploymentConfig":
            return Optional.ofNullable(clazz.cast(lastDeploymentConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InferenceComponentName", INFERENCE_COMPONENT_NAME_FIELD);
        map.put("InferenceComponentArn", INFERENCE_COMPONENT_ARN_FIELD);
        map.put("EndpointName", ENDPOINT_NAME_FIELD);
        map.put("EndpointArn", ENDPOINT_ARN_FIELD);
        map.put("VariantName", VARIANT_NAME_FIELD);
        map.put("FailureReason", FAILURE_REASON_FIELD);
        map.put("Specification", SPECIFICATION_FIELD);
        map.put("RuntimeConfig", RUNTIME_CONFIG_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("InferenceComponentStatus", INFERENCE_COMPONENT_STATUS_FIELD);
        map.put("LastDeploymentConfig", LAST_DEPLOYMENT_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeInferenceComponentResponse, T> g) {
        return obj -> g.apply((DescribeInferenceComponentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeInferenceComponentResponse> {
        /**
         * <p>
         * The name of the inference component.
         * </p>
         * 
         * @param inferenceComponentName
         *        The name of the inference component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceComponentName(String inferenceComponentName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the inference component.
         * </p>
         * 
         * @param inferenceComponentArn
         *        The Amazon Resource Name (ARN) of the inference component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceComponentArn(String inferenceComponentArn);

        /**
         * <p>
         * The name of the endpoint that hosts the inference component.
         * </p>
         * 
         * @param endpointName
         *        The name of the endpoint that hosts the inference component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointName(String endpointName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the endpoint that hosts the inference component.
         * </p>
         * 
         * @param endpointArn
         *        The Amazon Resource Name (ARN) of the endpoint that hosts the inference component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointArn(String endpointArn);

        /**
         * <p>
         * The name of the production variant that hosts the inference component.
         * </p>
         * 
         * @param variantName
         *        The name of the production variant that hosts the inference component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variantName(String variantName);

        /**
         * <p>
         * If the inference component status is <code>Failed</code>, the reason for the failure.
         * </p>
         * 
         * @param failureReason
         *        If the inference component status is <code>Failed</code>, the reason for the failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * Details about the resources that are deployed with this inference component.
         * </p>
         * 
         * @param specification
         *        Details about the resources that are deployed with this inference component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder specification(InferenceComponentSpecificationSummary specification);

        /**
         * <p>
         * Details about the resources that are deployed with this inference component.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link InferenceComponentSpecificationSummary.Builder} avoiding the need to create one manually via
         * {@link InferenceComponentSpecificationSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InferenceComponentSpecificationSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #specification(InferenceComponentSpecificationSummary)}.
         * 
         * @param specification
         *        a consumer that will call methods on {@link InferenceComponentSpecificationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #specification(InferenceComponentSpecificationSummary)
         */
        default Builder specification(Consumer<InferenceComponentSpecificationSummary.Builder> specification) {
            return specification(InferenceComponentSpecificationSummary.builder().applyMutation(specification).build());
        }

        /**
         * <p>
         * Details about the runtime settings for the model that is deployed with the inference component.
         * </p>
         * 
         * @param runtimeConfig
         *        Details about the runtime settings for the model that is deployed with the inference component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runtimeConfig(InferenceComponentRuntimeConfigSummary runtimeConfig);

        /**
         * <p>
         * Details about the runtime settings for the model that is deployed with the inference component.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link InferenceComponentRuntimeConfigSummary.Builder} avoiding the need to create one manually via
         * {@link InferenceComponentRuntimeConfigSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InferenceComponentRuntimeConfigSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #runtimeConfig(InferenceComponentRuntimeConfigSummary)}.
         * 
         * @param runtimeConfig
         *        a consumer that will call methods on {@link InferenceComponentRuntimeConfigSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #runtimeConfig(InferenceComponentRuntimeConfigSummary)
         */
        default Builder runtimeConfig(Consumer<InferenceComponentRuntimeConfigSummary.Builder> runtimeConfig) {
            return runtimeConfig(InferenceComponentRuntimeConfigSummary.builder().applyMutation(runtimeConfig).build());
        }

        /**
         * <p>
         * The time when the inference component was created.
         * </p>
         * 
         * @param creationTime
         *        The time when the inference component was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time when the inference component was last updated.
         * </p>
         * 
         * @param lastModifiedTime
         *        The time when the inference component was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The status of the inference component.
         * </p>
         * 
         * @param inferenceComponentStatus
         *        The status of the inference component.
         * @see InferenceComponentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InferenceComponentStatus
         */
        Builder inferenceComponentStatus(String inferenceComponentStatus);

        /**
         * <p>
         * The status of the inference component.
         * </p>
         * 
         * @param inferenceComponentStatus
         *        The status of the inference component.
         * @see InferenceComponentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InferenceComponentStatus
         */
        Builder inferenceComponentStatus(InferenceComponentStatus inferenceComponentStatus);

        /**
         * <p>
         * The deployment and rollback settings that you assigned to the inference component.
         * </p>
         * 
         * @param lastDeploymentConfig
         *        The deployment and rollback settings that you assigned to the inference component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastDeploymentConfig(InferenceComponentDeploymentConfig lastDeploymentConfig);

        /**
         * <p>
         * The deployment and rollback settings that you assigned to the inference component.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link InferenceComponentDeploymentConfig.Builder} avoiding the need to create one manually via
         * {@link InferenceComponentDeploymentConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InferenceComponentDeploymentConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #lastDeploymentConfig(InferenceComponentDeploymentConfig)}.
         * 
         * @param lastDeploymentConfig
         *        a consumer that will call methods on {@link InferenceComponentDeploymentConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastDeploymentConfig(InferenceComponentDeploymentConfig)
         */
        default Builder lastDeploymentConfig(Consumer<InferenceComponentDeploymentConfig.Builder> lastDeploymentConfig) {
            return lastDeploymentConfig(InferenceComponentDeploymentConfig.builder().applyMutation(lastDeploymentConfig).build());
        }
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String inferenceComponentName;

        private String inferenceComponentArn;

        private String endpointName;

        private String endpointArn;

        private String variantName;

        private String failureReason;

        private InferenceComponentSpecificationSummary specification;

        private InferenceComponentRuntimeConfigSummary runtimeConfig;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private String inferenceComponentStatus;

        private InferenceComponentDeploymentConfig lastDeploymentConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInferenceComponentResponse model) {
            super(model);
            inferenceComponentName(model.inferenceComponentName);
            inferenceComponentArn(model.inferenceComponentArn);
            endpointName(model.endpointName);
            endpointArn(model.endpointArn);
            variantName(model.variantName);
            failureReason(model.failureReason);
            specification(model.specification);
            runtimeConfig(model.runtimeConfig);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
            inferenceComponentStatus(model.inferenceComponentStatus);
            lastDeploymentConfig(model.lastDeploymentConfig);
        }

        public final String getInferenceComponentName() {
            return inferenceComponentName;
        }

        public final void setInferenceComponentName(String inferenceComponentName) {
            this.inferenceComponentName = inferenceComponentName;
        }

        @Override
        public final Builder inferenceComponentName(String inferenceComponentName) {
            this.inferenceComponentName = inferenceComponentName;
            return this;
        }

        public final String getInferenceComponentArn() {
            return inferenceComponentArn;
        }

        public final void setInferenceComponentArn(String inferenceComponentArn) {
            this.inferenceComponentArn = inferenceComponentArn;
        }

        @Override
        public final Builder inferenceComponentArn(String inferenceComponentArn) {
            this.inferenceComponentArn = inferenceComponentArn;
            return this;
        }

        public final String getEndpointName() {
            return endpointName;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final String getEndpointArn() {
            return endpointArn;
        }

        public final void setEndpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
        }

        @Override
        public final Builder endpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
            return this;
        }

        public final String getVariantName() {
            return variantName;
        }

        public final void setVariantName(String variantName) {
            this.variantName = variantName;
        }

        @Override
        public final Builder variantName(String variantName) {
            this.variantName = variantName;
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final InferenceComponentSpecificationSummary.Builder getSpecification() {
            return specification != null ? specification.toBuilder() : null;
        }

        public final void setSpecification(InferenceComponentSpecificationSummary.BuilderImpl specification) {
            this.specification = specification != null ? specification.build() : null;
        }

        @Override
        public final Builder specification(InferenceComponentSpecificationSummary specification) {
            this.specification = specification;
            return this;
        }

        public final InferenceComponentRuntimeConfigSummary.Builder getRuntimeConfig() {
            return runtimeConfig != null ? runtimeConfig.toBuilder() : null;
        }

        public final void setRuntimeConfig(InferenceComponentRuntimeConfigSummary.BuilderImpl runtimeConfig) {
            this.runtimeConfig = runtimeConfig != null ? runtimeConfig.build() : null;
        }

        @Override
        public final Builder runtimeConfig(InferenceComponentRuntimeConfigSummary runtimeConfig) {
            this.runtimeConfig = runtimeConfig;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getInferenceComponentStatus() {
            return inferenceComponentStatus;
        }

        public final void setInferenceComponentStatus(String inferenceComponentStatus) {
            this.inferenceComponentStatus = inferenceComponentStatus;
        }

        @Override
        public final Builder inferenceComponentStatus(String inferenceComponentStatus) {
            this.inferenceComponentStatus = inferenceComponentStatus;
            return this;
        }

        @Override
        public final Builder inferenceComponentStatus(InferenceComponentStatus inferenceComponentStatus) {
            this.inferenceComponentStatus(inferenceComponentStatus == null ? null : inferenceComponentStatus.toString());
            return this;
        }

        public final InferenceComponentDeploymentConfig.Builder getLastDeploymentConfig() {
            return lastDeploymentConfig != null ? lastDeploymentConfig.toBuilder() : null;
        }

        public final void setLastDeploymentConfig(InferenceComponentDeploymentConfig.BuilderImpl lastDeploymentConfig) {
            this.lastDeploymentConfig = lastDeploymentConfig != null ? lastDeploymentConfig.build() : null;
        }

        @Override
        public final Builder lastDeploymentConfig(InferenceComponentDeploymentConfig lastDeploymentConfig) {
            this.lastDeploymentConfig = lastDeploymentConfig;
            return this;
        }

        @Override
        public DescribeInferenceComponentResponse build() {
            return new DescribeInferenceComponentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
