/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeInferenceExperimentResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeInferenceExperimentResponse.Builder, DescribeInferenceExperimentResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(DescribeInferenceExperimentResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DescribeInferenceExperimentResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(DescribeInferenceExperimentResponse::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<InferenceExperimentSchedule> SCHEDULE_FIELD = SdkField
            .<InferenceExperimentSchedule> builder(MarshallingType.SDK_POJO).memberName("Schedule")
            .getter(getter(DescribeInferenceExperimentResponse::schedule)).setter(setter(Builder::schedule))
            .constructor(InferenceExperimentSchedule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeInferenceExperimentResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusReason").getter(getter(DescribeInferenceExperimentResponse::statusReason))
            .setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DescribeInferenceExperimentResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeInferenceExperimentResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CompletionTime").getter(getter(DescribeInferenceExperimentResponse::completionTime))
            .setter(setter(Builder::completionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(DescribeInferenceExperimentResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(DescribeInferenceExperimentResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<EndpointMetadata> ENDPOINT_METADATA_FIELD = SdkField
            .<EndpointMetadata> builder(MarshallingType.SDK_POJO).memberName("EndpointMetadata")
            .getter(getter(DescribeInferenceExperimentResponse::endpointMetadata)).setter(setter(Builder::endpointMetadata))
            .constructor(EndpointMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointMetadata").build()).build();

    private static final SdkField<List<ModelVariantConfigSummary>> MODEL_VARIANTS_FIELD = SdkField
            .<List<ModelVariantConfigSummary>> builder(MarshallingType.LIST)
            .memberName("ModelVariants")
            .getter(getter(DescribeInferenceExperimentResponse::modelVariants))
            .setter(setter(Builder::modelVariants))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVariants").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ModelVariantConfigSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ModelVariantConfigSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<InferenceExperimentDataStorageConfig> DATA_STORAGE_CONFIG_FIELD = SdkField
            .<InferenceExperimentDataStorageConfig> builder(MarshallingType.SDK_POJO).memberName("DataStorageConfig")
            .getter(getter(DescribeInferenceExperimentResponse::dataStorageConfig)).setter(setter(Builder::dataStorageConfig))
            .constructor(InferenceExperimentDataStorageConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataStorageConfig").build()).build();

    private static final SdkField<ShadowModeConfig> SHADOW_MODE_CONFIG_FIELD = SdkField
            .<ShadowModeConfig> builder(MarshallingType.SDK_POJO).memberName("ShadowModeConfig")
            .getter(getter(DescribeInferenceExperimentResponse::shadowModeConfig)).setter(setter(Builder::shadowModeConfig))
            .constructor(ShadowModeConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShadowModeConfig").build()).build();

    private static final SdkField<String> KMS_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("KmsKey")
            .getter(getter(DescribeInferenceExperimentResponse::kmsKey)).setter(setter(Builder::kmsKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            TYPE_FIELD, SCHEDULE_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, DESCRIPTION_FIELD, CREATION_TIME_FIELD,
            COMPLETION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, ROLE_ARN_FIELD, ENDPOINT_METADATA_FIELD, MODEL_VARIANTS_FIELD,
            DATA_STORAGE_CONFIG_FIELD, SHADOW_MODE_CONFIG_FIELD, KMS_KEY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String name;

    private final String type;

    private final InferenceExperimentSchedule schedule;

    private final String status;

    private final String statusReason;

    private final String description;

    private final Instant creationTime;

    private final Instant completionTime;

    private final Instant lastModifiedTime;

    private final String roleArn;

    private final EndpointMetadata endpointMetadata;

    private final List<ModelVariantConfigSummary> modelVariants;

    private final InferenceExperimentDataStorageConfig dataStorageConfig;

    private final ShadowModeConfig shadowModeConfig;

    private final String kmsKey;

    private DescribeInferenceExperimentResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.type = builder.type;
        this.schedule = builder.schedule;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.description = builder.description;
        this.creationTime = builder.creationTime;
        this.completionTime = builder.completionTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.roleArn = builder.roleArn;
        this.endpointMetadata = builder.endpointMetadata;
        this.modelVariants = builder.modelVariants;
        this.dataStorageConfig = builder.dataStorageConfig;
        this.shadowModeConfig = builder.shadowModeConfig;
        this.kmsKey = builder.kmsKey;
    }

    /**
     * <p>
     * The ARN of the inference experiment being described.
     * </p>
     * 
     * @return The ARN of the inference experiment being described.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the inference experiment.
     * </p>
     * 
     * @return The name of the inference experiment.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of the inference experiment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link InferenceExperimentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the inference experiment.
     * @see InferenceExperimentType
     */
    public final InferenceExperimentType type() {
        return InferenceExperimentType.fromValue(type);
    }

    /**
     * <p>
     * The type of the inference experiment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link InferenceExperimentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the inference experiment.
     * @see InferenceExperimentType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The duration for which the inference experiment ran or will run.
     * </p>
     * 
     * @return The duration for which the inference experiment ran or will run.
     */
    public final InferenceExperimentSchedule schedule() {
        return schedule;
    }

    /**
     * <p>
     * The status of the inference experiment. The following are the possible statuses for an inference experiment:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Creating</code> - Amazon SageMaker is creating your experiment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Created</code> - Amazon SageMaker has finished the creation of your experiment and will begin the
     * experiment at the scheduled time.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Updating</code> - When you make changes to your experiment, your experiment shows as updating.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Starting</code> - Amazon SageMaker is beginning your experiment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Running</code> - Your experiment is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Stopping</code> - Amazon SageMaker is stopping your experiment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Completed</code> - Your experiment has completed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Cancelled</code> - When you conclude your experiment early using the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StopInferenceExperiment.html"
     * >StopInferenceExperiment</a> API, or if any operation fails with an unexpected error, it shows as cancelled.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link InferenceExperimentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the inference experiment. The following are the possible statuses for an inference
     *         experiment: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Creating</code> - Amazon SageMaker is creating your experiment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Created</code> - Amazon SageMaker has finished the creation of your experiment and will begin the
     *         experiment at the scheduled time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Updating</code> - When you make changes to your experiment, your experiment shows as updating.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Starting</code> - Amazon SageMaker is beginning your experiment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Running</code> - Your experiment is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Stopping</code> - Amazon SageMaker is stopping your experiment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Completed</code> - Your experiment has completed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Cancelled</code> - When you conclude your experiment early using the <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StopInferenceExperiment.html"
     *         >StopInferenceExperiment</a> API, or if any operation fails with an unexpected error, it shows as
     *         cancelled.
     *         </p>
     *         </li>
     * @see InferenceExperimentStatus
     */
    public final InferenceExperimentStatus status() {
        return InferenceExperimentStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the inference experiment. The following are the possible statuses for an inference experiment:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Creating</code> - Amazon SageMaker is creating your experiment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Created</code> - Amazon SageMaker has finished the creation of your experiment and will begin the
     * experiment at the scheduled time.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Updating</code> - When you make changes to your experiment, your experiment shows as updating.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Starting</code> - Amazon SageMaker is beginning your experiment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Running</code> - Your experiment is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Stopping</code> - Amazon SageMaker is stopping your experiment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Completed</code> - Your experiment has completed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Cancelled</code> - When you conclude your experiment early using the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StopInferenceExperiment.html"
     * >StopInferenceExperiment</a> API, or if any operation fails with an unexpected error, it shows as cancelled.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link InferenceExperimentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the inference experiment. The following are the possible statuses for an inference
     *         experiment: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Creating</code> - Amazon SageMaker is creating your experiment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Created</code> - Amazon SageMaker has finished the creation of your experiment and will begin the
     *         experiment at the scheduled time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Updating</code> - When you make changes to your experiment, your experiment shows as updating.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Starting</code> - Amazon SageMaker is beginning your experiment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Running</code> - Your experiment is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Stopping</code> - Amazon SageMaker is stopping your experiment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Completed</code> - Your experiment has completed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Cancelled</code> - When you conclude your experiment early using the <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StopInferenceExperiment.html"
     *         >StopInferenceExperiment</a> API, or if any operation fails with an unexpected error, it shows as
     *         cancelled.
     *         </p>
     *         </li>
     * @see InferenceExperimentStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The error message or client-specified <code>Reason</code> from the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StopInferenceExperiment.html"
     * >StopInferenceExperiment</a> API, that explains the status of the inference experiment.
     * </p>
     * 
     * @return The error message or client-specified <code>Reason</code> from the <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StopInferenceExperiment.html"
     *         >StopInferenceExperiment</a> API, that explains the status of the inference experiment.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The description of the inference experiment.
     * </p>
     * 
     * @return The description of the inference experiment.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The timestamp at which you created the inference experiment.
     * </p>
     * 
     * @return The timestamp at which you created the inference experiment.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The timestamp at which the inference experiment was completed.
     * </p>
     * 
     * @return The timestamp at which the inference experiment was completed.
     */
    public final Instant completionTime() {
        return completionTime;
    }

    /**
     * <p>
     * The timestamp at which you last modified the inference experiment.
     * </p>
     * 
     * @return The timestamp at which you last modified the inference experiment.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The ARN of the IAM role that Amazon SageMaker can assume to access model artifacts and container images, and
     * manage Amazon SageMaker Inference endpoints for model deployment.
     * </p>
     * 
     * @return The ARN of the IAM role that Amazon SageMaker can assume to access model artifacts and container images,
     *         and manage Amazon SageMaker Inference endpoints for model deployment.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The metadata of the endpoint on which the inference experiment ran.
     * </p>
     * 
     * @return The metadata of the endpoint on which the inference experiment ran.
     */
    public final EndpointMetadata endpointMetadata() {
        return endpointMetadata;
    }

    /**
     * For responses, this returns true if the service returned a value for the ModelVariants property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasModelVariants() {
        return modelVariants != null && !(modelVariants instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>ModelVariantConfigSummary</code> objects. There is one for each variant in the inference
     * experiment. Each <code>ModelVariantConfigSummary</code> object in the array describes the infrastructure
     * configuration for deploying the corresponding variant.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasModelVariants} method.
     * </p>
     * 
     * @return An array of <code>ModelVariantConfigSummary</code> objects. There is one for each variant in the
     *         inference experiment. Each <code>ModelVariantConfigSummary</code> object in the array describes the
     *         infrastructure configuration for deploying the corresponding variant.
     */
    public final List<ModelVariantConfigSummary> modelVariants() {
        return modelVariants;
    }

    /**
     * <p>
     * The Amazon S3 location and configuration for storing inference request and response data.
     * </p>
     * 
     * @return The Amazon S3 location and configuration for storing inference request and response data.
     */
    public final InferenceExperimentDataStorageConfig dataStorageConfig() {
        return dataStorageConfig;
    }

    /**
     * <p>
     * The configuration of <code>ShadowMode</code> inference experiment type, which shows the production variant that
     * takes all the inference requests, and the shadow variant to which Amazon SageMaker replicates a percentage of the
     * inference requests. For the shadow variant it also shows the percentage of requests that Amazon SageMaker
     * replicates.
     * </p>
     * 
     * @return The configuration of <code>ShadowMode</code> inference experiment type, which shows the production
     *         variant that takes all the inference requests, and the shadow variant to which Amazon SageMaker
     *         replicates a percentage of the inference requests. For the shadow variant it also shows the percentage of
     *         requests that Amazon SageMaker replicates.
     */
    public final ShadowModeConfig shadowModeConfig() {
        return shadowModeConfig;
    }

    /**
     * <p>
     * The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to
     * encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateInferenceExperiment.html"
     * >CreateInferenceExperiment</a>.
     * </p>
     * 
     * @return The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses
     *         to encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateInferenceExperiment.html"
     *         >CreateInferenceExperiment</a>.
     */
    public final String kmsKey() {
        return kmsKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(completionTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(endpointMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(hasModelVariants() ? modelVariants() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dataStorageConfig());
        hashCode = 31 * hashCode + Objects.hashCode(shadowModeConfig());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKey());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInferenceExperimentResponse)) {
            return false;
        }
        DescribeInferenceExperimentResponse other = (DescribeInferenceExperimentResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(schedule(), other.schedule())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason()) && Objects.equals(description(), other.description())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(completionTime(), other.completionTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(endpointMetadata(), other.endpointMetadata()) && hasModelVariants() == other.hasModelVariants()
                && Objects.equals(modelVariants(), other.modelVariants())
                && Objects.equals(dataStorageConfig(), other.dataStorageConfig())
                && Objects.equals(shadowModeConfig(), other.shadowModeConfig()) && Objects.equals(kmsKey(), other.kmsKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeInferenceExperimentResponse").add("Arn", arn()).add("Name", name())
                .add("Type", typeAsString()).add("Schedule", schedule()).add("Status", statusAsString())
                .add("StatusReason", statusReason()).add("Description", description()).add("CreationTime", creationTime())
                .add("CompletionTime", completionTime()).add("LastModifiedTime", lastModifiedTime()).add("RoleArn", roleArn())
                .add("EndpointMetadata", endpointMetadata()).add("ModelVariants", hasModelVariants() ? modelVariants() : null)
                .add("DataStorageConfig", dataStorageConfig()).add("ShadowModeConfig", shadowModeConfig())
                .add("KmsKey", kmsKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "CompletionTime":
            return Optional.ofNullable(clazz.cast(completionTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "EndpointMetadata":
            return Optional.ofNullable(clazz.cast(endpointMetadata()));
        case "ModelVariants":
            return Optional.ofNullable(clazz.cast(modelVariants()));
        case "DataStorageConfig":
            return Optional.ofNullable(clazz.cast(dataStorageConfig()));
        case "ShadowModeConfig":
            return Optional.ofNullable(clazz.cast(shadowModeConfig()));
        case "KmsKey":
            return Optional.ofNullable(clazz.cast(kmsKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Schedule", SCHEDULE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusReason", STATUS_REASON_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("CompletionTime", COMPLETION_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("EndpointMetadata", ENDPOINT_METADATA_FIELD);
        map.put("ModelVariants", MODEL_VARIANTS_FIELD);
        map.put("DataStorageConfig", DATA_STORAGE_CONFIG_FIELD);
        map.put("ShadowModeConfig", SHADOW_MODE_CONFIG_FIELD);
        map.put("KmsKey", KMS_KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeInferenceExperimentResponse, T> g) {
        return obj -> g.apply((DescribeInferenceExperimentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeInferenceExperimentResponse> {
        /**
         * <p>
         * The ARN of the inference experiment being described.
         * </p>
         * 
         * @param arn
         *        The ARN of the inference experiment being described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the inference experiment.
         * </p>
         * 
         * @param name
         *        The name of the inference experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of the inference experiment.
         * </p>
         * 
         * @param type
         *        The type of the inference experiment.
         * @see InferenceExperimentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InferenceExperimentType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the inference experiment.
         * </p>
         * 
         * @param type
         *        The type of the inference experiment.
         * @see InferenceExperimentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InferenceExperimentType
         */
        Builder type(InferenceExperimentType type);

        /**
         * <p>
         * The duration for which the inference experiment ran or will run.
         * </p>
         * 
         * @param schedule
         *        The duration for which the inference experiment ran or will run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(InferenceExperimentSchedule schedule);

        /**
         * <p>
         * The duration for which the inference experiment ran or will run.
         * </p>
         * This is a convenience method that creates an instance of the {@link InferenceExperimentSchedule.Builder}
         * avoiding the need to create one manually via {@link InferenceExperimentSchedule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InferenceExperimentSchedule.Builder#build()} is called
         * immediately and its result is passed to {@link #schedule(InferenceExperimentSchedule)}.
         * 
         * @param schedule
         *        a consumer that will call methods on {@link InferenceExperimentSchedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schedule(InferenceExperimentSchedule)
         */
        default Builder schedule(Consumer<InferenceExperimentSchedule.Builder> schedule) {
            return schedule(InferenceExperimentSchedule.builder().applyMutation(schedule).build());
        }

        /**
         * <p>
         * The status of the inference experiment. The following are the possible statuses for an inference experiment:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Creating</code> - Amazon SageMaker is creating your experiment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Created</code> - Amazon SageMaker has finished the creation of your experiment and will begin the
         * experiment at the scheduled time.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Updating</code> - When you make changes to your experiment, your experiment shows as updating.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Starting</code> - Amazon SageMaker is beginning your experiment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Running</code> - Your experiment is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Stopping</code> - Amazon SageMaker is stopping your experiment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Completed</code> - Your experiment has completed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Cancelled</code> - When you conclude your experiment early using the <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StopInferenceExperiment.html"
         * >StopInferenceExperiment</a> API, or if any operation fails with an unexpected error, it shows as cancelled.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the inference experiment. The following are the possible statuses for an inference
         *        experiment: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Creating</code> - Amazon SageMaker is creating your experiment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Created</code> - Amazon SageMaker has finished the creation of your experiment and will begin
         *        the experiment at the scheduled time.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Updating</code> - When you make changes to your experiment, your experiment shows as updating.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Starting</code> - Amazon SageMaker is beginning your experiment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Running</code> - Your experiment is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Stopping</code> - Amazon SageMaker is stopping your experiment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Completed</code> - Your experiment has completed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Cancelled</code> - When you conclude your experiment early using the <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StopInferenceExperiment.html"
         *        >StopInferenceExperiment</a> API, or if any operation fails with an unexpected error, it shows as
         *        cancelled.
         *        </p>
         *        </li>
         * @see InferenceExperimentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InferenceExperimentStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the inference experiment. The following are the possible statuses for an inference experiment:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Creating</code> - Amazon SageMaker is creating your experiment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Created</code> - Amazon SageMaker has finished the creation of your experiment and will begin the
         * experiment at the scheduled time.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Updating</code> - When you make changes to your experiment, your experiment shows as updating.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Starting</code> - Amazon SageMaker is beginning your experiment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Running</code> - Your experiment is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Stopping</code> - Amazon SageMaker is stopping your experiment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Completed</code> - Your experiment has completed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Cancelled</code> - When you conclude your experiment early using the <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StopInferenceExperiment.html"
         * >StopInferenceExperiment</a> API, or if any operation fails with an unexpected error, it shows as cancelled.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the inference experiment. The following are the possible statuses for an inference
         *        experiment: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Creating</code> - Amazon SageMaker is creating your experiment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Created</code> - Amazon SageMaker has finished the creation of your experiment and will begin
         *        the experiment at the scheduled time.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Updating</code> - When you make changes to your experiment, your experiment shows as updating.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Starting</code> - Amazon SageMaker is beginning your experiment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Running</code> - Your experiment is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Stopping</code> - Amazon SageMaker is stopping your experiment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Completed</code> - Your experiment has completed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Cancelled</code> - When you conclude your experiment early using the <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StopInferenceExperiment.html"
         *        >StopInferenceExperiment</a> API, or if any operation fails with an unexpected error, it shows as
         *        cancelled.
         *        </p>
         *        </li>
         * @see InferenceExperimentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InferenceExperimentStatus
         */
        Builder status(InferenceExperimentStatus status);

        /**
         * <p>
         * The error message or client-specified <code>Reason</code> from the <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StopInferenceExperiment.html"
         * >StopInferenceExperiment</a> API, that explains the status of the inference experiment.
         * </p>
         * 
         * @param statusReason
         *        The error message or client-specified <code>Reason</code> from the <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StopInferenceExperiment.html"
         *        >StopInferenceExperiment</a> API, that explains the status of the inference experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The description of the inference experiment.
         * </p>
         * 
         * @param description
         *        The description of the inference experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The timestamp at which you created the inference experiment.
         * </p>
         * 
         * @param creationTime
         *        The timestamp at which you created the inference experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The timestamp at which the inference experiment was completed.
         * </p>
         * 
         * @param completionTime
         *        The timestamp at which the inference experiment was completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completionTime(Instant completionTime);

        /**
         * <p>
         * The timestamp at which you last modified the inference experiment.
         * </p>
         * 
         * @param lastModifiedTime
         *        The timestamp at which you last modified the inference experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The ARN of the IAM role that Amazon SageMaker can assume to access model artifacts and container images, and
         * manage Amazon SageMaker Inference endpoints for model deployment.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the IAM role that Amazon SageMaker can assume to access model artifacts and container
         *        images, and manage Amazon SageMaker Inference endpoints for model deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The metadata of the endpoint on which the inference experiment ran.
         * </p>
         * 
         * @param endpointMetadata
         *        The metadata of the endpoint on which the inference experiment ran.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointMetadata(EndpointMetadata endpointMetadata);

        /**
         * <p>
         * The metadata of the endpoint on which the inference experiment ran.
         * </p>
         * This is a convenience method that creates an instance of the {@link EndpointMetadata.Builder} avoiding the
         * need to create one manually via {@link EndpointMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EndpointMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #endpointMetadata(EndpointMetadata)}.
         * 
         * @param endpointMetadata
         *        a consumer that will call methods on {@link EndpointMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpointMetadata(EndpointMetadata)
         */
        default Builder endpointMetadata(Consumer<EndpointMetadata.Builder> endpointMetadata) {
            return endpointMetadata(EndpointMetadata.builder().applyMutation(endpointMetadata).build());
        }

        /**
         * <p>
         * An array of <code>ModelVariantConfigSummary</code> objects. There is one for each variant in the inference
         * experiment. Each <code>ModelVariantConfigSummary</code> object in the array describes the infrastructure
         * configuration for deploying the corresponding variant.
         * </p>
         * 
         * @param modelVariants
         *        An array of <code>ModelVariantConfigSummary</code> objects. There is one for each variant in the
         *        inference experiment. Each <code>ModelVariantConfigSummary</code> object in the array describes the
         *        infrastructure configuration for deploying the corresponding variant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelVariants(Collection<ModelVariantConfigSummary> modelVariants);

        /**
         * <p>
         * An array of <code>ModelVariantConfigSummary</code> objects. There is one for each variant in the inference
         * experiment. Each <code>ModelVariantConfigSummary</code> object in the array describes the infrastructure
         * configuration for deploying the corresponding variant.
         * </p>
         * 
         * @param modelVariants
         *        An array of <code>ModelVariantConfigSummary</code> objects. There is one for each variant in the
         *        inference experiment. Each <code>ModelVariantConfigSummary</code> object in the array describes the
         *        infrastructure configuration for deploying the corresponding variant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelVariants(ModelVariantConfigSummary... modelVariants);

        /**
         * <p>
         * An array of <code>ModelVariantConfigSummary</code> objects. There is one for each variant in the inference
         * experiment. Each <code>ModelVariantConfigSummary</code> object in the array describes the infrastructure
         * configuration for deploying the corresponding variant.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.ModelVariantConfigSummary.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.ModelVariantConfigSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.ModelVariantConfigSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #modelVariants(List<ModelVariantConfigSummary>)}.
         * 
         * @param modelVariants
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.ModelVariantConfigSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelVariants(java.util.Collection<ModelVariantConfigSummary>)
         */
        Builder modelVariants(Consumer<ModelVariantConfigSummary.Builder>... modelVariants);

        /**
         * <p>
         * The Amazon S3 location and configuration for storing inference request and response data.
         * </p>
         * 
         * @param dataStorageConfig
         *        The Amazon S3 location and configuration for storing inference request and response data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataStorageConfig(InferenceExperimentDataStorageConfig dataStorageConfig);

        /**
         * <p>
         * The Amazon S3 location and configuration for storing inference request and response data.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link InferenceExperimentDataStorageConfig.Builder} avoiding the need to create one manually via
         * {@link InferenceExperimentDataStorageConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InferenceExperimentDataStorageConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #dataStorageConfig(InferenceExperimentDataStorageConfig)}.
         * 
         * @param dataStorageConfig
         *        a consumer that will call methods on {@link InferenceExperimentDataStorageConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataStorageConfig(InferenceExperimentDataStorageConfig)
         */
        default Builder dataStorageConfig(Consumer<InferenceExperimentDataStorageConfig.Builder> dataStorageConfig) {
            return dataStorageConfig(InferenceExperimentDataStorageConfig.builder().applyMutation(dataStorageConfig).build());
        }

        /**
         * <p>
         * The configuration of <code>ShadowMode</code> inference experiment type, which shows the production variant
         * that takes all the inference requests, and the shadow variant to which Amazon SageMaker replicates a
         * percentage of the inference requests. For the shadow variant it also shows the percentage of requests that
         * Amazon SageMaker replicates.
         * </p>
         * 
         * @param shadowModeConfig
         *        The configuration of <code>ShadowMode</code> inference experiment type, which shows the production
         *        variant that takes all the inference requests, and the shadow variant to which Amazon SageMaker
         *        replicates a percentage of the inference requests. For the shadow variant it also shows the percentage
         *        of requests that Amazon SageMaker replicates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shadowModeConfig(ShadowModeConfig shadowModeConfig);

        /**
         * <p>
         * The configuration of <code>ShadowMode</code> inference experiment type, which shows the production variant
         * that takes all the inference requests, and the shadow variant to which Amazon SageMaker replicates a
         * percentage of the inference requests. For the shadow variant it also shows the percentage of requests that
         * Amazon SageMaker replicates.
         * </p>
         * This is a convenience method that creates an instance of the {@link ShadowModeConfig.Builder} avoiding the
         * need to create one manually via {@link ShadowModeConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ShadowModeConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #shadowModeConfig(ShadowModeConfig)}.
         * 
         * @param shadowModeConfig
         *        a consumer that will call methods on {@link ShadowModeConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #shadowModeConfig(ShadowModeConfig)
         */
        default Builder shadowModeConfig(Consumer<ShadowModeConfig.Builder> shadowModeConfig) {
            return shadowModeConfig(ShadowModeConfig.builder().applyMutation(shadowModeConfig).build());
        }

        /**
         * <p>
         * The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to
         * encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateInferenceExperiment.html"
         * >CreateInferenceExperiment</a>.
         * </p>
         * 
         * @param kmsKey
         *        The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker
         *        uses to encrypt data on the storage volume attached to the ML compute instance that hosts the
         *        endpoint. For more information, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateInferenceExperiment.html"
         *        >CreateInferenceExperiment</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKey(String kmsKey);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String type;

        private InferenceExperimentSchedule schedule;

        private String status;

        private String statusReason;

        private String description;

        private Instant creationTime;

        private Instant completionTime;

        private Instant lastModifiedTime;

        private String roleArn;

        private EndpointMetadata endpointMetadata;

        private List<ModelVariantConfigSummary> modelVariants = DefaultSdkAutoConstructList.getInstance();

        private InferenceExperimentDataStorageConfig dataStorageConfig;

        private ShadowModeConfig shadowModeConfig;

        private String kmsKey;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInferenceExperimentResponse model) {
            super(model);
            arn(model.arn);
            name(model.name);
            type(model.type);
            schedule(model.schedule);
            status(model.status);
            statusReason(model.statusReason);
            description(model.description);
            creationTime(model.creationTime);
            completionTime(model.completionTime);
            lastModifiedTime(model.lastModifiedTime);
            roleArn(model.roleArn);
            endpointMetadata(model.endpointMetadata);
            modelVariants(model.modelVariants);
            dataStorageConfig(model.dataStorageConfig);
            shadowModeConfig(model.shadowModeConfig);
            kmsKey(model.kmsKey);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(InferenceExperimentType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final InferenceExperimentSchedule.Builder getSchedule() {
            return schedule != null ? schedule.toBuilder() : null;
        }

        public final void setSchedule(InferenceExperimentSchedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(InferenceExperimentSchedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(InferenceExperimentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getCompletionTime() {
            return completionTime;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        @Override
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final EndpointMetadata.Builder getEndpointMetadata() {
            return endpointMetadata != null ? endpointMetadata.toBuilder() : null;
        }

        public final void setEndpointMetadata(EndpointMetadata.BuilderImpl endpointMetadata) {
            this.endpointMetadata = endpointMetadata != null ? endpointMetadata.build() : null;
        }

        @Override
        public final Builder endpointMetadata(EndpointMetadata endpointMetadata) {
            this.endpointMetadata = endpointMetadata;
            return this;
        }

        public final List<ModelVariantConfigSummary.Builder> getModelVariants() {
            List<ModelVariantConfigSummary.Builder> result = ModelVariantConfigSummaryListCopier
                    .copyToBuilder(this.modelVariants);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModelVariants(Collection<ModelVariantConfigSummary.BuilderImpl> modelVariants) {
            this.modelVariants = ModelVariantConfigSummaryListCopier.copyFromBuilder(modelVariants);
        }

        @Override
        public final Builder modelVariants(Collection<ModelVariantConfigSummary> modelVariants) {
            this.modelVariants = ModelVariantConfigSummaryListCopier.copy(modelVariants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelVariants(ModelVariantConfigSummary... modelVariants) {
            modelVariants(Arrays.asList(modelVariants));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelVariants(Consumer<ModelVariantConfigSummary.Builder>... modelVariants) {
            modelVariants(Stream.of(modelVariants).map(c -> ModelVariantConfigSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final InferenceExperimentDataStorageConfig.Builder getDataStorageConfig() {
            return dataStorageConfig != null ? dataStorageConfig.toBuilder() : null;
        }

        public final void setDataStorageConfig(InferenceExperimentDataStorageConfig.BuilderImpl dataStorageConfig) {
            this.dataStorageConfig = dataStorageConfig != null ? dataStorageConfig.build() : null;
        }

        @Override
        public final Builder dataStorageConfig(InferenceExperimentDataStorageConfig dataStorageConfig) {
            this.dataStorageConfig = dataStorageConfig;
            return this;
        }

        public final ShadowModeConfig.Builder getShadowModeConfig() {
            return shadowModeConfig != null ? shadowModeConfig.toBuilder() : null;
        }

        public final void setShadowModeConfig(ShadowModeConfig.BuilderImpl shadowModeConfig) {
            this.shadowModeConfig = shadowModeConfig != null ? shadowModeConfig.build() : null;
        }

        @Override
        public final Builder shadowModeConfig(ShadowModeConfig shadowModeConfig) {
            this.shadowModeConfig = shadowModeConfig;
            return this;
        }

        public final String getKmsKey() {
            return kmsKey;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        @Override
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        @Override
        public DescribeInferenceExperimentResponse build() {
            return new DescribeInferenceExperimentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
