/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeStudioLifecycleConfigResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeStudioLifecycleConfigResponse.Builder, DescribeStudioLifecycleConfigResponse> {
    private static final SdkField<String> STUDIO_LIFECYCLE_CONFIG_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StudioLifecycleConfigArn")
            .getter(getter(DescribeStudioLifecycleConfigResponse::studioLifecycleConfigArn))
            .setter(setter(Builder::studioLifecycleConfigArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StudioLifecycleConfigArn").build())
            .build();

    private static final SdkField<String> STUDIO_LIFECYCLE_CONFIG_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StudioLifecycleConfigName")
            .getter(getter(DescribeStudioLifecycleConfigResponse::studioLifecycleConfigName))
            .setter(setter(Builder::studioLifecycleConfigName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StudioLifecycleConfigName").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeStudioLifecycleConfigResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(DescribeStudioLifecycleConfigResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> STUDIO_LIFECYCLE_CONFIG_CONTENT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StudioLifecycleConfigContent")
            .getter(getter(DescribeStudioLifecycleConfigResponse::studioLifecycleConfigContent))
            .setter(setter(Builder::studioLifecycleConfigContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StudioLifecycleConfigContent")
                    .build()).build();

    private static final SdkField<String> STUDIO_LIFECYCLE_CONFIG_APP_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StudioLifecycleConfigAppType")
            .getter(getter(DescribeStudioLifecycleConfigResponse::studioLifecycleConfigAppTypeAsString))
            .setter(setter(Builder::studioLifecycleConfigAppType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StudioLifecycleConfigAppType")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            STUDIO_LIFECYCLE_CONFIG_ARN_FIELD, STUDIO_LIFECYCLE_CONFIG_NAME_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD,
            STUDIO_LIFECYCLE_CONFIG_CONTENT_FIELD, STUDIO_LIFECYCLE_CONFIG_APP_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String studioLifecycleConfigArn;

    private final String studioLifecycleConfigName;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private final String studioLifecycleConfigContent;

    private final String studioLifecycleConfigAppType;

    private DescribeStudioLifecycleConfigResponse(BuilderImpl builder) {
        super(builder);
        this.studioLifecycleConfigArn = builder.studioLifecycleConfigArn;
        this.studioLifecycleConfigName = builder.studioLifecycleConfigName;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.studioLifecycleConfigContent = builder.studioLifecycleConfigContent;
        this.studioLifecycleConfigAppType = builder.studioLifecycleConfigAppType;
    }

    /**
     * <p>
     * The ARN of the Lifecycle Configuration to describe.
     * </p>
     * 
     * @return The ARN of the Lifecycle Configuration to describe.
     */
    public final String studioLifecycleConfigArn() {
        return studioLifecycleConfigArn;
    }

    /**
     * <p>
     * The name of the Amazon SageMaker AI Studio Lifecycle Configuration that is described.
     * </p>
     * 
     * @return The name of the Amazon SageMaker AI Studio Lifecycle Configuration that is described.
     */
    public final String studioLifecycleConfigName() {
        return studioLifecycleConfigName;
    }

    /**
     * <p>
     * The creation time of the Amazon SageMaker AI Studio Lifecycle Configuration.
     * </p>
     * 
     * @return The creation time of the Amazon SageMaker AI Studio Lifecycle Configuration.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * This value is equivalent to CreationTime because Amazon SageMaker AI Studio Lifecycle Configurations are
     * immutable.
     * </p>
     * 
     * @return This value is equivalent to CreationTime because Amazon SageMaker AI Studio Lifecycle Configurations are
     *         immutable.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The content of your Amazon SageMaker AI Studio Lifecycle Configuration script.
     * </p>
     * 
     * @return The content of your Amazon SageMaker AI Studio Lifecycle Configuration script.
     */
    public final String studioLifecycleConfigContent() {
        return studioLifecycleConfigContent;
    }

    /**
     * <p>
     * The App type that the Lifecycle Configuration is attached to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #studioLifecycleConfigAppType} will return {@link StudioLifecycleConfigAppType#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #studioLifecycleConfigAppTypeAsString}.
     * </p>
     * 
     * @return The App type that the Lifecycle Configuration is attached to.
     * @see StudioLifecycleConfigAppType
     */
    public final StudioLifecycleConfigAppType studioLifecycleConfigAppType() {
        return StudioLifecycleConfigAppType.fromValue(studioLifecycleConfigAppType);
    }

    /**
     * <p>
     * The App type that the Lifecycle Configuration is attached to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #studioLifecycleConfigAppType} will return {@link StudioLifecycleConfigAppType#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #studioLifecycleConfigAppTypeAsString}.
     * </p>
     * 
     * @return The App type that the Lifecycle Configuration is attached to.
     * @see StudioLifecycleConfigAppType
     */
    public final String studioLifecycleConfigAppTypeAsString() {
        return studioLifecycleConfigAppType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(studioLifecycleConfigArn());
        hashCode = 31 * hashCode + Objects.hashCode(studioLifecycleConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(studioLifecycleConfigContent());
        hashCode = 31 * hashCode + Objects.hashCode(studioLifecycleConfigAppTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStudioLifecycleConfigResponse)) {
            return false;
        }
        DescribeStudioLifecycleConfigResponse other = (DescribeStudioLifecycleConfigResponse) obj;
        return Objects.equals(studioLifecycleConfigArn(), other.studioLifecycleConfigArn())
                && Objects.equals(studioLifecycleConfigName(), other.studioLifecycleConfigName())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(studioLifecycleConfigContent(), other.studioLifecycleConfigContent())
                && Objects.equals(studioLifecycleConfigAppTypeAsString(), other.studioLifecycleConfigAppTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeStudioLifecycleConfigResponse")
                .add("StudioLifecycleConfigArn", studioLifecycleConfigArn())
                .add("StudioLifecycleConfigName", studioLifecycleConfigName()).add("CreationTime", creationTime())
                .add("LastModifiedTime", lastModifiedTime()).add("StudioLifecycleConfigContent", studioLifecycleConfigContent())
                .add("StudioLifecycleConfigAppType", studioLifecycleConfigAppTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StudioLifecycleConfigArn":
            return Optional.ofNullable(clazz.cast(studioLifecycleConfigArn()));
        case "StudioLifecycleConfigName":
            return Optional.ofNullable(clazz.cast(studioLifecycleConfigName()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "StudioLifecycleConfigContent":
            return Optional.ofNullable(clazz.cast(studioLifecycleConfigContent()));
        case "StudioLifecycleConfigAppType":
            return Optional.ofNullable(clazz.cast(studioLifecycleConfigAppTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StudioLifecycleConfigArn", STUDIO_LIFECYCLE_CONFIG_ARN_FIELD);
        map.put("StudioLifecycleConfigName", STUDIO_LIFECYCLE_CONFIG_NAME_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("StudioLifecycleConfigContent", STUDIO_LIFECYCLE_CONFIG_CONTENT_FIELD);
        map.put("StudioLifecycleConfigAppType", STUDIO_LIFECYCLE_CONFIG_APP_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeStudioLifecycleConfigResponse, T> g) {
        return obj -> g.apply((DescribeStudioLifecycleConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeStudioLifecycleConfigResponse> {
        /**
         * <p>
         * The ARN of the Lifecycle Configuration to describe.
         * </p>
         * 
         * @param studioLifecycleConfigArn
         *        The ARN of the Lifecycle Configuration to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder studioLifecycleConfigArn(String studioLifecycleConfigArn);

        /**
         * <p>
         * The name of the Amazon SageMaker AI Studio Lifecycle Configuration that is described.
         * </p>
         * 
         * @param studioLifecycleConfigName
         *        The name of the Amazon SageMaker AI Studio Lifecycle Configuration that is described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder studioLifecycleConfigName(String studioLifecycleConfigName);

        /**
         * <p>
         * The creation time of the Amazon SageMaker AI Studio Lifecycle Configuration.
         * </p>
         * 
         * @param creationTime
         *        The creation time of the Amazon SageMaker AI Studio Lifecycle Configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * This value is equivalent to CreationTime because Amazon SageMaker AI Studio Lifecycle Configurations are
         * immutable.
         * </p>
         * 
         * @param lastModifiedTime
         *        This value is equivalent to CreationTime because Amazon SageMaker AI Studio Lifecycle Configurations
         *        are immutable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The content of your Amazon SageMaker AI Studio Lifecycle Configuration script.
         * </p>
         * 
         * @param studioLifecycleConfigContent
         *        The content of your Amazon SageMaker AI Studio Lifecycle Configuration script.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder studioLifecycleConfigContent(String studioLifecycleConfigContent);

        /**
         * <p>
         * The App type that the Lifecycle Configuration is attached to.
         * </p>
         * 
         * @param studioLifecycleConfigAppType
         *        The App type that the Lifecycle Configuration is attached to.
         * @see StudioLifecycleConfigAppType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StudioLifecycleConfigAppType
         */
        Builder studioLifecycleConfigAppType(String studioLifecycleConfigAppType);

        /**
         * <p>
         * The App type that the Lifecycle Configuration is attached to.
         * </p>
         * 
         * @param studioLifecycleConfigAppType
         *        The App type that the Lifecycle Configuration is attached to.
         * @see StudioLifecycleConfigAppType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StudioLifecycleConfigAppType
         */
        Builder studioLifecycleConfigAppType(StudioLifecycleConfigAppType studioLifecycleConfigAppType);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String studioLifecycleConfigArn;

        private String studioLifecycleConfigName;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private String studioLifecycleConfigContent;

        private String studioLifecycleConfigAppType;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStudioLifecycleConfigResponse model) {
            super(model);
            studioLifecycleConfigArn(model.studioLifecycleConfigArn);
            studioLifecycleConfigName(model.studioLifecycleConfigName);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
            studioLifecycleConfigContent(model.studioLifecycleConfigContent);
            studioLifecycleConfigAppType(model.studioLifecycleConfigAppType);
        }

        public final String getStudioLifecycleConfigArn() {
            return studioLifecycleConfigArn;
        }

        public final void setStudioLifecycleConfigArn(String studioLifecycleConfigArn) {
            this.studioLifecycleConfigArn = studioLifecycleConfigArn;
        }

        @Override
        public final Builder studioLifecycleConfigArn(String studioLifecycleConfigArn) {
            this.studioLifecycleConfigArn = studioLifecycleConfigArn;
            return this;
        }

        public final String getStudioLifecycleConfigName() {
            return studioLifecycleConfigName;
        }

        public final void setStudioLifecycleConfigName(String studioLifecycleConfigName) {
            this.studioLifecycleConfigName = studioLifecycleConfigName;
        }

        @Override
        public final Builder studioLifecycleConfigName(String studioLifecycleConfigName) {
            this.studioLifecycleConfigName = studioLifecycleConfigName;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getStudioLifecycleConfigContent() {
            return studioLifecycleConfigContent;
        }

        public final void setStudioLifecycleConfigContent(String studioLifecycleConfigContent) {
            this.studioLifecycleConfigContent = studioLifecycleConfigContent;
        }

        @Override
        public final Builder studioLifecycleConfigContent(String studioLifecycleConfigContent) {
            this.studioLifecycleConfigContent = studioLifecycleConfigContent;
            return this;
        }

        public final String getStudioLifecycleConfigAppType() {
            return studioLifecycleConfigAppType;
        }

        public final void setStudioLifecycleConfigAppType(String studioLifecycleConfigAppType) {
            this.studioLifecycleConfigAppType = studioLifecycleConfigAppType;
        }

        @Override
        public final Builder studioLifecycleConfigAppType(String studioLifecycleConfigAppType) {
            this.studioLifecycleConfigAppType = studioLifecycleConfigAppType;
            return this;
        }

        @Override
        public final Builder studioLifecycleConfigAppType(StudioLifecycleConfigAppType studioLifecycleConfigAppType) {
            this.studioLifecycleConfigAppType(studioLifecycleConfigAppType == null ? null : studioLifecycleConfigAppType
                    .toString());
            return this;
        }

        @Override
        public DescribeStudioLifecycleConfigResponse build() {
            return new DescribeStudioLifecycleConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
