/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configurations and outcomes of an Amazon EMR step execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EMRStepMetadata implements SdkPojo, Serializable, ToCopyableBuilder<EMRStepMetadata.Builder, EMRStepMetadata> {
    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterId").getter(getter(EMRStepMetadata::clusterId)).setter(setter(Builder::clusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterId").build()).build();

    private static final SdkField<String> STEP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("StepId")
            .getter(getter(EMRStepMetadata::stepId)).setter(setter(Builder::stepId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepId").build()).build();

    private static final SdkField<String> STEP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StepName").getter(getter(EMRStepMetadata::stepName)).setter(setter(Builder::stepName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepName").build()).build();

    private static final SdkField<String> LOG_FILE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogFilePath").getter(getter(EMRStepMetadata::logFilePath)).setter(setter(Builder::logFilePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogFilePath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ID_FIELD,
            STEP_ID_FIELD, STEP_NAME_FIELD, LOG_FILE_PATH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String clusterId;

    private final String stepId;

    private final String stepName;

    private final String logFilePath;

    private EMRStepMetadata(BuilderImpl builder) {
        this.clusterId = builder.clusterId;
        this.stepId = builder.stepId;
        this.stepName = builder.stepName;
        this.logFilePath = builder.logFilePath;
    }

    /**
     * <p>
     * The identifier of the EMR cluster.
     * </p>
     * 
     * @return The identifier of the EMR cluster.
     */
    public final String clusterId() {
        return clusterId;
    }

    /**
     * <p>
     * The identifier of the EMR cluster step.
     * </p>
     * 
     * @return The identifier of the EMR cluster step.
     */
    public final String stepId() {
        return stepId;
    }

    /**
     * <p>
     * The name of the EMR cluster step.
     * </p>
     * 
     * @return The name of the EMR cluster step.
     */
    public final String stepName() {
        return stepName;
    }

    /**
     * <p>
     * The path to the log file where the cluster step's failure root cause is recorded.
     * </p>
     * 
     * @return The path to the log file where the cluster step's failure root cause is recorded.
     */
    public final String logFilePath() {
        return logFilePath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(stepId());
        hashCode = 31 * hashCode + Objects.hashCode(stepName());
        hashCode = 31 * hashCode + Objects.hashCode(logFilePath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EMRStepMetadata)) {
            return false;
        }
        EMRStepMetadata other = (EMRStepMetadata) obj;
        return Objects.equals(clusterId(), other.clusterId()) && Objects.equals(stepId(), other.stepId())
                && Objects.equals(stepName(), other.stepName()) && Objects.equals(logFilePath(), other.logFilePath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EMRStepMetadata").add("ClusterId", clusterId()).add("StepId", stepId())
                .add("StepName", stepName()).add("LogFilePath", logFilePath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterId":
            return Optional.ofNullable(clazz.cast(clusterId()));
        case "StepId":
            return Optional.ofNullable(clazz.cast(stepId()));
        case "StepName":
            return Optional.ofNullable(clazz.cast(stepName()));
        case "LogFilePath":
            return Optional.ofNullable(clazz.cast(logFilePath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClusterId", CLUSTER_ID_FIELD);
        map.put("StepId", STEP_ID_FIELD);
        map.put("StepName", STEP_NAME_FIELD);
        map.put("LogFilePath", LOG_FILE_PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EMRStepMetadata, T> g) {
        return obj -> g.apply((EMRStepMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EMRStepMetadata> {
        /**
         * <p>
         * The identifier of the EMR cluster.
         * </p>
         * 
         * @param clusterId
         *        The identifier of the EMR cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterId(String clusterId);

        /**
         * <p>
         * The identifier of the EMR cluster step.
         * </p>
         * 
         * @param stepId
         *        The identifier of the EMR cluster step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepId(String stepId);

        /**
         * <p>
         * The name of the EMR cluster step.
         * </p>
         * 
         * @param stepName
         *        The name of the EMR cluster step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepName(String stepName);

        /**
         * <p>
         * The path to the log file where the cluster step's failure root cause is recorded.
         * </p>
         * 
         * @param logFilePath
         *        The path to the log file where the cluster step's failure root cause is recorded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logFilePath(String logFilePath);
    }

    static final class BuilderImpl implements Builder {
        private String clusterId;

        private String stepId;

        private String stepName;

        private String logFilePath;

        private BuilderImpl() {
        }

        private BuilderImpl(EMRStepMetadata model) {
            clusterId(model.clusterId);
            stepId(model.stepId);
            stepName(model.stepName);
            logFilePath(model.logFilePath);
        }

        public final String getClusterId() {
            return clusterId;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final String getStepId() {
            return stepId;
        }

        public final void setStepId(String stepId) {
            this.stepId = stepId;
        }

        @Override
        public final Builder stepId(String stepId) {
            this.stepId = stepId;
            return this;
        }

        public final String getStepName() {
            return stepName;
        }

        public final void setStepName(String stepName) {
            this.stepName = stepName;
        }

        @Override
        public final Builder stepName(String stepName) {
            this.stepName = stepName;
            return this;
        }

        public final String getLogFilePath() {
            return logFilePath;
        }

        public final void setLogFilePath(String logFilePath) {
            this.logFilePath = logFilePath;
        }

        @Override
        public final Builder logFilePath(String logFilePath) {
            this.logFilePath = logFilePath;
            return this;
        }

        @Override
        public EMRStepMetadata build() {
            return new EMRStepMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
